{strip}
    {if !$width}{assign var="width" value="40"}{/if}
    {if !$height}{assign var="height" value="40"}{/if}
    {if !$fill}{assign var="fill" value="#000000"}{/if}

    {if $svgId == "export"}
        <svg viewBox="0 0 512.002 512.002" width="20px" height="20px">
            <polygon style="fill:#fff;" points="351.384,16.284 347.589,16.284 347.589,122.034 464.784,122.034 	"/>
            <polygon style="fill:#fff;" points="326.576,303.218 326.576,205.512 186.309,205.512 186.309,141.13 44.669,255.999
            186.309,370.87 186.309,303.218 	"/>
            <path fill="currentColor" d="M467.334,202.728c-8.994,0-16.284,7.29-16.284,16.284v260.42H105.829V326.566l70.225,56.953
            c2.957,2.399,6.592,3.636,10.259,3.636c2.379,0,4.773-0.521,7.002-1.584c5.668-2.702,9.279-8.42,9.279-14.7v-51.368h123.983
            c8.994,0,16.284-7.29,16.284-16.284v-97.706c0-8.994-7.29-16.284-16.284-16.284H202.593v-48.1c0-6.279-3.61-12-9.279-14.7
            c-5.665-2.702-12.384-1.902-17.263,2.052L34.412,243.353c-3.812,3.091-6.027,7.738-6.027,12.648c0,4.91,2.215,9.555,6.027,12.648
            l38.847,31.505v195.564c0,8.994,7.29,16.284,16.284,16.284h377.789c8.994,0,16.284-7.29,16.284-16.284V219.012
            C483.618,210.018,476.327,202.728,467.334,202.728z M170.027,175.302v30.208c0,8.994,7.29,16.284,16.284,16.284h123.983v65.138
            H186.311c-8.994,0-16.284,7.29-16.284,16.284v33.48l-99.503-80.697L170.027,175.302z"/>
            <path fill="currentColor" d="M89.545,138.318c8.994,0,16.284-7.29,16.284-16.284V32.568h225.476v89.466
            c0,8.994,7.29,16.284,16.284,16.284h117.194c6.689,0,12.698-4.092,15.151-10.316c2.452-6.224,0.848-13.315-4.045-17.878
            L362.491,4.376c-0.124-0.116-0.259-0.217-0.386-0.327c-0.192-0.168-0.383-0.335-0.583-0.493c-0.2-0.16-0.405-0.309-0.612-0.458
            c-0.217-0.156-0.432-0.311-0.656-0.458c-0.199-0.129-0.402-0.248-0.606-0.368c-0.246-0.147-0.493-0.29-0.747-0.423
            c-0.191-0.099-0.386-0.187-0.58-0.28c-0.275-0.13-0.55-0.261-0.835-0.375c-0.189-0.077-0.383-0.14-0.575-0.21
            c-0.295-0.106-0.588-0.213-0.889-0.303c-0.207-0.062-0.417-0.107-0.625-0.161c-0.292-0.073-0.58-0.153-0.878-0.21
            c-0.267-0.052-0.537-0.085-0.806-0.124c-0.246-0.034-0.489-0.081-0.738-0.104C352.448,0.029,351.918,0,351.384,0h-3.794H89.545
            c-8.994,0-16.284,7.29-16.284,16.284v105.75C73.261,131.028,80.551,138.318,89.545,138.318z M363.873,105.75V50.197l59.572,55.553
            H363.873z"/>
        </svg>
    {/if}
    {if $svgId == "print"}
        <svg width="20px" height="20px" viewBox="0 0 248.059 248.059">
            <path fill="currentColor" d="M230.559,62.498h-27.785V17.133c0-4.143-3.358-7.5-7.5-7.5H52.785c-4.142,0-7.5,3.357-7.5,7.5v45.365H17.5
            c-9.649,0-17.5,7.85-17.5,17.5v96.225c0,9.649,7.851,17.5,17.5,17.5h27.785v37.203c0,4.143,3.358,7.5,7.5,7.5h142.488
            c4.142,0,7.5-3.357,7.5-7.5v-37.203h27.785c9.649,0,17.5-7.851,17.5-17.5V79.998C248.059,70.349,240.208,62.498,230.559,62.498z
            M60.285,24.633h127.488v37.865H60.285V24.633z M187.773,223.426H60.285v-74.404h127.488V223.426z M233.059,176.223
            c0,1.355-1.145,2.5-2.5,2.5h-27.785v-37.201c0-4.143-3.358-7.5-7.5-7.5H52.785c-4.142,0-7.5,3.357-7.5,7.5v37.201H17.5
            c-1.355,0-2.5-1.145-2.5-2.5V79.998c0-1.356,1.145-2.5,2.5-2.5h35.285h142.488h35.285c1.355,0,2.5,1.144,2.5,2.5V176.223z"/>
            <circle fill="currentColor" cx="195.273" cy="105.76" r="10.668"/>
            <path fill="currentColor" d="M158.151,163.822H89.907c-4.142,0-7.5,3.357-7.5,7.5c0,4.143,3.358,7.5,7.5,7.5h68.244c4.142,0,7.5-3.357,7.5-7.5
            C165.651,167.18,162.294,163.822,158.151,163.822z"/>
            <path fill="currentColor" d="M158.151,193.623H89.907c-4.142,0-7.5,3.357-7.5,7.5c0,4.143,3.358,7.5,7.5,7.5h68.244c4.142,0,7.5-3.357,7.5-7.5
            C165.651,196.98,162.294,193.623,158.151,193.623z"/>
        </svg>
    {/if}
    {if $svgId == "eye"}
        <svg width="20px" height="20px" viewBox="0 0 512 512">
            <path fill="currentColor" d="m496.4,243.1c-63.9-78.7-149.3-122.1-240.4-122.1-91.1,0-176.5,43.4-240.4,122.1-6.1,7.5-6.1,18.2 0,25.7 63.9,78.8 149.3,122.2 240.4,122.2 91.1,0 176.5-43.4 240.4-122.1 6.1-7.5 6.1-18.3 0-25.8zm-240.4,79.8c-36.9,0-66.9-30-66.9-66.9 0-36.9 30-66.9 66.9-66.9 36.9,0 66.9,30 66.9,66.9 0,36.9-30,66.9-66.9,66.9zm-197.8-66.9c37.8-42.2 82.9-71.1 131.5-84.9-25.2,19.7-41.5,50.4-41.5,84.9 0,34.4 16.2,65.1 41.5,84.9-48.6-13.8-93.6-42.7-131.5-84.9zm264.1,84.9c25.2-19.7 41.5-50.4 41.5-84.9 0-34.4-16.2-65.1-41.5-84.9 48.6,13.8 93.7,42.7 131.5,84.9-37.9,42.2-82.9,71.1-131.5,84.9z"/>
        </svg>
    {/if}
    {if $svgId == "prev"}
        <svg viewBox="0 0 492 492" width="20px" height="20px">
            <path fill="currentColor" d="M464.344,207.418l0.768,0.168H135.888l103.496-103.724c5.068-5.064,7.848-11.924,7.848-19.124
            c0-7.2-2.78-14.012-7.848-19.088L223.28,49.538c-5.064-5.064-11.812-7.864-19.008-7.864c-7.2,0-13.952,2.78-19.016,7.844
            L7.844,226.914C2.76,231.998-0.02,238.77,0,245.974c-0.02,7.244,2.76,14.02,7.844,19.096l177.412,177.412
            c5.064,5.06,11.812,7.844,19.016,7.844c7.196,0,13.944-2.788,19.008-7.844l16.104-16.112c5.068-5.056,7.848-11.808,7.848-19.008
            c0-7.196-2.78-13.592-7.848-18.652L134.72,284.406h329.992c14.828,0,27.288-12.78,27.288-27.6v-22.788
            C492,219.198,479.172,207.418,464.344,207.418z"/>
        </svg>
    {/if}
    {if $svgId == "next"}
        <svg viewBox="0 0 492.004 492.004" width="20px" height="20px">
            <path fill="currentColor" d="M484.14,226.886L306.46,49.202c-5.072-5.072-11.832-7.856-19.04-7.856c-7.216,0-13.972,2.788-19.044,7.856l-16.132,16.136
            c-5.068,5.064-7.86,11.828-7.86,19.04c0,7.208,2.792,14.2,7.86,19.264L355.9,207.526H26.58C11.732,207.526,0,219.15,0,234.002
            v22.812c0,14.852,11.732,27.648,26.58,27.648h330.496L252.248,388.926c-5.068,5.072-7.86,11.652-7.86,18.864
            c0,7.204,2.792,13.88,7.86,18.948l16.132,16.084c5.072,5.072,11.828,7.836,19.044,7.836c7.208,0,13.968-2.8,19.04-7.872
            l177.68-177.68c5.084-5.088,7.88-11.88,7.86-19.1C492.02,238.762,489.228,231.966,484.14,226.886z"/>
        </svg>
    {/if}
    {if $svgId == "left_catalog"}
        <svg width="20px" height="20px" viewBox="0 0 16 14" xmlns="http://www.w3.org/2000/svg">
            <path d="M.81.453h2.804v2.805H.81V.453zm0 5.184h2.804v2.805H.81V5.637zm0 5.184h2.804v2.804H.81v-2.804zM4.86.453h10.33v2.805H4.86V.453zm0 5.184h10.33v2.805H4.86V5.637zm0 5.184h10.33v2.804H4.86v-2.804z" fill="currentColor" fill-rule="evenodd"/>
        </svg>
    {/if}
    {if $svgId == "date"}
        <svg viewBox="0 0 512 512" width="20px" height="20px">
            <path fill="currentColor" d="M452,40h-24V0h-40v40H124V0H84v40H60C26.916,40,0,66.916,0,100v352c0,33.084,26.916,60,60,60h392
            c33.084,0,60-26.916,60-60V100C512,66.916,485.084,40,452,40z M472,452c0,11.028-8.972,20-20,20H60c-11.028,0-20-8.972-20-20V188
            h432V452z M472,148H40v-48c0-11.028,8.972-20,20-20h24v40h40V80h264v40h40V80h24c11.028,0,20,8.972,20,20V148z"/>
            <rect fill="currentColor" x="76" y="230" width="40" height="40"/>
            <rect fill="currentColor" x="156" y="230" width="40" height="40"/>
            <rect fill="currentColor" x="236" y="230" width="40" height="40"/>
            <rect fill="currentColor" x="316" y="230" width="40" height="40"/>
            <rect fill="currentColor" x="396" y="230" width="40" height="40"/>
            <rect fill="currentColor" x="76" y="310" width="40" height="40"/>
            <rect fill="currentColor" x="156" y="310" width="40" height="40"/>
            <rect fill="currentColor" x="236" y="310" width="40" height="40"/>
            <rect fill="currentColor" x="316" y="310" width="40" height="40"/>
            <rect fill="currentColor" x="76" y="390" width="40" height="40"/>
            <rect fill="currentColor" x="156" y="390" width="40" height="40"/>
            <rect fill="currentColor" x="236" y="390" width="40" height="40"/>
            <rect fill="currentColor" x="316" y="390" width="40" height="40"/>
            <rect fill="currentColor" x="396" y="310" width="40" height="40"/>
        </svg>
    {/if}
    {if $svgId == "return"}
        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="20px" height="20px" viewBox="0 0 459 459">
            <path d="M178.5,140.25v-102L0,216.75l178.5,178.5V290.7c127.5,0,216.75,40.8,280.5,130.05C433.5,293.25,357,165.75,178.5,140.25z" fill="currentColor"/>
        </svg>
    {/if}
    {if $svgId == "winner"}
<svg viewBox="0 0 443.664 443.664" width="30px" height="30px">
    <path style="fill:#00ADEE;" d="M186.324,326.341l-64.8,112c-2.4,4-7.2,5.2-10.8,2.8c-2.4-1.2-3.6-3.6-4-5.6l0,0l-8.8-58l-54.8,21.6
	c-4,1.6-8.8-0.4-10.4-4.4c-0.8-2.4-0.8-5.2,0.8-7.2l64.4-111.6c2.4-4,7.2-5.2,10.8-2.8c0.4,0.4,0.8,0.4,1.2,0.8l0,0
	c0.8,0.8,1.6,1.2,2.8,1.6c0.8,0.4,2,0.4,3.2,0.4l0,0h36.8c3.2,0,5.6,1.6,6.8,4l0,0l16.4,29.2c0,0,0,0.4,0.4,0.4l0,0
	c0,0.4,0,0.4,0,0.4l0,0l0,0c0,0,0,0,0,0.4c0.8,1.2,1.2,2,2.4,2.8c0.8,0.8,2,1.2,3.2,1.6c4.4,1.2,6.8,5.6,5.6,10
	C186.724,325.541,186.724,325.941,186.324,326.341 M346.324,277.541l64,111.2c2.4,4,0.8,8.8-2.8,10.8c-2,1.2-4.8,1.2-6.8,0.4l0,0
	l-54.8-21.6l-8.4,58.4c-0.8,4.4-4.8,7.6-9.2,6.8c-2.8-0.4-4.8-2-6-4.4l-65.2-112.4c-2.4-4-0.8-8.8,2.8-10.8c1.2-0.8,2.4-0.8,3.6-1.2
	l0,0c1.6,0,2.8-0.4,4.4-1.2c1.2-0.8,2.4-2,3.2-3.2l18.4-31.6c1.6-2.8,4.4-4,7.6-4l33.2,0.4c0.4,0,0.4,0,0.8,0h0.4
	c0.8,0,1.6,0,2.4-0.4c0.8,0,1.2-0.4,2-0.8c4-2,8.8-0.8,10.8,3.2C346.324,277.141,346.324,277.141,346.324,277.541z"/>
    <path style="fill:#F1BC0A;" d="M220.724,20.741l32-18.4c8.4-4.8,18.8-2,23.6,6.4c0.4,0.4,0.4,0.8,0.8,1.2l16.4,29.2h36.8
	c9.6,0,17.2,7.6,17.2,17.2v0.4l0,0l-0.4,34.4l31.6,18.4c8.4,4.8,11.2,15.2,6.4,23.6c0,0.4-0.4,0.4-0.4,0.8l-17.2,28.8l18.4,32
	c4.8,8.4,2,18.8-6.4,23.6c-0.4,0.4-0.8,0.4-1.2,0.8l-29.2,16.4v36.8c0,9.6-7.6,17.2-17.2,17.2h-0.4l0,0l-34.4-0.4l-19.2,31.2
	c-4.8,8.4-15.2,11.2-23.6,6.4c-0.4-0.4-0.4-0.8-0.8-0.8l-28.8-17.2l-32,18.4c-8.4,4.8-18.8,2-23.6-6.4c-0.4-0.4-0.4-0.8-0.8-1.2
	l-16.4-29.2h-36.8c-9.6,0-17.2-7.6-17.2-17.2v-0.4l0,0l0.4-34.4l-31.6-18.4c-8.4-4.8-11.2-15.2-6.4-23.6c0-0.4,0.4-0.4,0.4-0.8
	l17.2-28.8l-18.4-32c-4.8-8.4-2-18.8,6.4-23.6c0.4-0.4,0.8-0.4,1.2-0.8l29.2-16.4v-36.8c0-9.6,7.6-17.2,17.2-17.2h0.4l0,0l34.4,0.4
	l18.4-31.6c4.8-8.4,15.2-11.2,23.6-6.4c0.4,0,0.4,0.4,0.8,0.4L220.724,20.741z"/>
    <g>
        <path style="fill:#F2A31E;" d="M384.724,194.741l-18.4-32l17.2-28.8c0-0.4,0.4-0.4,0.4-0.8c4.8-8.4,2-18.8-6.4-23.6l-31.6-18.4
		l0.4-34.4l0,0v-0.4c0-9.6-7.6-17.2-17.2-17.2h-36.8l-16.4-29.2c0-0.4-0.4-0.8-0.8-1.2c-4.4-7.6-14-10.8-22-7.2c3.2,1.6,6,4,8,7.2
		c0.4,0.4,0.4,0.8,0.8,1.2l16.4,29.2h36.8c9.6,0,17.2,7.6,17.2,17.2v0.4l0,0l-0.4,34.4l31.6,18.4c8.4,4.8,11.2,15.2,6.4,23.6
		c0,0.4-0.4,0.4-0.4,0.8l-17.2,28.8l18.4,32c4.8,8.4,2,18.8-6.4,23.6c-0.4,0.4-0.8,0.4-1.2,0.8l-29.2,16.4v36.8
		c0,8.8-6.8,16-15.2,16.8h12l0,0h0.4c9.6,0,17.2-7.6,17.2-17.2v-36.8l29.2-16.4c0.4,0,0.8-0.4,1.2-0.8
		C386.724,213.541,389.524,203.141,384.724,194.741z"/>
        <path style="fill:#F2A31E;" d="M282.324,288.341l-18.4,31.6c-2,3.2-4.8,5.6-8,7.2c8,3.6,17.2,0.8,21.6-7.2l18.4-31.6H282.324z"/>
        <path style="fill:#F2A31E;" d="M294.724,99.141c-16.8-16.8-40-27.2-65.6-27.2s-48.8,10.4-65.6,27.2s-27.2,40-27.2,65.6
		s10.4,48.8,27.2,65.6s40,27.2,65.6,27.2s48.8-10.4,65.6-27.2c16.8-16.8,27.2-40,27.2-65.6S311.524,115.941,294.724,99.141
		 M229.124,55.941c30,0,57.2,12,77.2,32c19.6,19.6,32,46.8,32,77.2c0,30-12,57.2-32,77.2c-19.6,19.6-46.8,32-77.2,32
		c-30,0-57.2-12-77.2-32c-19.6-19.6-32-46.8-32-77.2c0-30,12-57.2,32-77.2S199.124,55.941,229.124,55.941z"/>
        <path style="fill:#F2A31E;" d="M236.724,113.141l9.6,29.6h31.2c4.4,0,8,3.6,8,8c0,2.8-1.2,5.2-3.2,6.4l0,0l-25.2,18l9.6,29.6
		c1.2,4.4-0.8,8.8-5.2,10.4c-2.8,0.8-5.6,0.4-7.6-1.6l-24.4-18l-25.6,18.4c-3.6,2.8-8.8,2-11.2-1.6c-1.6-2-2-4.8-1.2-7.2l0,0
		l9.6-29.6l-25.2-18c-3.6-2.8-4.4-7.6-2-11.2c1.6-2.4,4.4-3.6,7.2-3.2h30.4l9.6-29.6c1.2-4.4,6-6.4,10-5.2
		C234.324,108.741,235.924,110.741,236.724,113.141"/>
    </g>
    <path style="fill:#FCF8CD;" d="M288.324,99.141c-16.8-16.8-40-27.2-65.6-27.2s-48.8,10.4-65.6,27.2s-27.2,40-27.2,65.6
	s10.4,48.8,27.2,65.6s40,27.2,65.6,27.2s48.8-10.4,65.6-27.2c16.8-16.8,27.2-40,27.2-65.6S305.124,115.941,288.324,99.141
	 M222.724,55.941c30,0,57.2,12,77.2,32c19.6,19.6,32,46.8,32,77.2c0,30-12,57.2-32,77.2c-19.6,19.6-46.8,32-77.2,32
	c-30,0-57.2-12-77.2-32c-19.6-20.4-31.6-47.6-31.6-77.6s12-57.2,32-77.2C165.524,67.941,192.724,55.941,222.724,55.941z"/>
    <path style="fill:#FCF8CF;" d="M230.324,113.141l9.6,29.6h31.2c4.4,0,8,3.6,8,8c0,2.8-1.2,5.2-3.2,6.4l0,0l-25.2,18l9.6,29.6
	c1.2,4.4-0.8,8.8-5.2,10.4c-2.8,0.8-5.6,0.4-7.6-1.6l-24.4-18l-25.6,18.4c-3.6,2.8-8.8,2-11.2-1.6c-1.6-2-2-4.8-1.2-7.2l0,0
	l9.6-29.6l-25.2-18c-3.6-2.8-4.4-7.6-2-11.2c1.6-2.4,4.4-3.6,7.2-3.2h30.4l9.6-29.6c1.2-4.4,6-6.4,10-5.2
	C227.924,108.741,229.524,110.741,230.324,113.141"/>
</svg>
    {/if}

    {if $svgId == "add"}
    <svg xmlns="http://www.w3.org/2000/svg" width="22px" height="22px" viewBox="0 0 400 400">
        <path d="M199.995,0C89.716,0,0,89.72,0,200c0,110.279,89.716,200,199.995,200C310.277,400,400,310.279,400,200
                C400,89.72,310.277,0,199.995,0z M199.995,373.77C104.182,373.77,26.23,295.816,26.23,200c0-95.817,77.951-173.77,173.765-173.77
                c95.817,0,173.772,77.953,173.772,173.77C373.769,295.816,295.812,373.77,199.995,373.77z" fill="currentColor"/>
        <path d="M279.478,186.884h-66.363V120.52c0-7.243-5.872-13.115-13.115-13.115s-13.115,5.873-13.115,13.115v66.368h-66.361
                c-7.242,0-13.115,5.873-13.115,13.115c0,7.243,5.873,13.115,13.115,13.115h66.358v66.362c0,7.242,5.872,13.114,13.115,13.114
                c7.242,0,13.115-5.872,13.115-13.114v-66.365h66.367c7.241,0,13.114-5.873,13.114-13.115
                C292.593,192.757,286.72,186.884,279.478,186.884z" fill="currentColor"/>
    </svg>
    {/if}
    {if $svgId == "mobile_menu"}
        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="20px" height="20px" viewBox="0 0 459 459">
            <path d="M0,382.5h459v-51H0V382.5z M0,255h459v-51H0V255z M0,76.5v51h459v-51H0z" fill="currentColor"/>
        </svg>
    {/if}
    {if $svgId == "mobile_menu2"}
        <svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
        viewBox="0 0 20 20" enable-background="new 0 0 20 20" xml:space="preserve" fill="currentColor">
        <rect x="6.4" y="0" fill="none" width="13.6" height="11.1"/>
        <rect y="8.9" width="10.6" height="2.2"/>
        <rect x="14.8" y="2.6" width="1.5" height="7.4"/>
        <rect x="11.6" y="5.6" width="7.4" height="1.5"/>
        <rect y="14.4" width="20" height="2.2"/>
        <rect y="3.3" width="6.4" height="2.2"/>
        </svg>
    {/if}
    {if $svgId == "order_list"}
    <svg width="20px" height="20px" viewBox="-27 0 512 512" >
        <path fill="currentColor" d="m188 492c0 11.046875-8.953125 20-20 20h-88c-44.113281 0-80-35.886719-80-80v-352c0-44.113281 35.886719-80 80-80h245.890625c44.109375 0 80 35.886719 80 80v191c0 11.046875-8.957031 20-20 20-11.046875 0-20-8.953125-20-20v-191c0-22.054688-17.945313-40-40-40h-245.890625c-22.054688 0-40 17.945312-40 40v352c0 22.054688 17.945312 40 40 40h88c11.046875 0 20 8.953125 20 20zm117.890625-372h-206c-11.046875 0-20 8.953125-20 20s8.953125 20 20 20h206c11.042969 0 20-8.953125 20-20s-8.957031-20-20-20zm20 100c0-11.046875-8.957031-20-20-20h-206c-11.046875 0-20 8.953125-20 20s8.953125 20 20 20h206c11.042969 0 20-8.953125 20-20zm-226 60c-11.046875 0-20 8.953125-20 20s8.953125 20 20 20h105.109375c11.046875 0 20-8.953125 20-20s-8.953125-20-20-20zm355.472656 146.496094c-.703125 1.003906-3.113281 4.414062-4.609375 6.300781-6.699218 8.425781-22.378906 28.148437-44.195312 45.558594-27.972656 22.324219-56.757813 33.644531-85.558594 33.644531s-57.585938-11.320312-85.558594-33.644531c-21.816406-17.410157-37.496094-37.136719-44.191406-45.558594-1.5-1.886719-3.910156-5.300781-4.613281-6.300781-4.847657-6.898438-4.847657-16.097656 0-22.996094.703125-1 3.113281-4.414062 4.613281-6.300781 6.695312-8.421875 22.375-28.144531 44.191406-45.554688 27.972656-22.324219 56.757813-33.644531 85.558594-33.644531s57.585938 11.320312 85.558594 33.644531c21.816406 17.410157 37.496094 37.136719 44.191406 45.558594 1.5 1.886719 3.910156 5.300781 4.613281 6.300781 4.847657 6.898438 4.847657 16.09375 0 22.992188zm-41.71875-11.496094c-31.800781-37.832031-62.9375-57-92.644531-57-29.703125 0-60.84375 19.164062-92.644531 57 31.800781 37.832031 62.9375 57 92.644531 57s60.84375-19.164062 92.644531-57zm-91.644531-38c-20.988281 0-38 17.011719-38 38s17.011719 38 38 38 38-17.011719 38-38-17.011719-38-38-38zm0 0"/>
    </svg>
    {/if}
    {if $svgId == "check"}
        <svg class="check_svg" width="20px" height="20px"viewBox="0 0 512 512">
            <path fill="currentColor" d="M497.36,69.995c-7.532-7.545-19.753-7.558-27.285-0.032L238.582,300.845l-83.522-90.713
            c-7.217-7.834-19.419-8.342-27.266-1.126c-7.841,7.217-8.343,19.425-1.126,27.266l97.126,105.481
            c3.557,3.866,8.535,6.111,13.784,6.22c0.141,0.006,0.277,0.006,0.412,0.006c5.101,0,10.008-2.026,13.623-5.628L497.322,97.286
            C504.873,89.761,504.886,77.54,497.36,69.995z"/>
            <path fill="currentColor" d="M492.703,236.703c-10.658,0-19.296,8.638-19.296,19.297c0,119.883-97.524,217.407-217.407,217.407
            c-119.876,0-217.407-97.524-217.407-217.407c0-119.876,97.531-217.407,217.407-217.407c10.658,0,19.297-8.638,19.297-19.296
            C275.297,8.638,266.658,0,256,0C114.84,0,0,114.84,0,256c0,141.154,114.84,256,256,256c141.154,0,256-114.846,256-256
            C512,245.342,503.362,236.703,492.703,236.703z"/>
        </svg>
    {/if}
{if $svgId == "exchange"}
<svg width="20px" height="20px" viewBox="-5 0 459 459.648">
    <path fill="currentColor" d="m416.324219 293.824219c0 26.507812-21.492188 48-48 48h-313.375l63.199219-63.199219-22.625-22.625-90.511719 90.511719c-6.246094 6.25-6.246094 16.375 0 22.625l90.511719 90.511719 22.625-22.625-63.199219-63.199219h313.375c44.160156-.054688 79.945312-35.839844 80-80v-64h-32zm0 0"/>
    <path fill="currentColor" d="m32.324219 165.824219c0-26.511719 21.488281-48 48-48h313.375l-63.199219 63.199219 22.625 22.625 90.511719-90.511719c6.246093-6.25 6.246093-16.375 0-22.625l-90.511719-90.511719-22.625 22.625 63.199219 63.199219h-313.375c-44.160157.050781-79.949219 35.839843-80 80v64h32zm0 0"/>
</svg>
{/if}
    {if $svgId == "checked"}
        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 26 26"  width="20px" height="20px">
            <path d="m.3,14c-0.2-0.2-0.3-0.5-0.3-0.7s0.1-0.5 0.3-0.7l1.4-1.4c0.4-0.4 1-0.4 1.4,0l.1,.1 5.5,5.9c0.2,0.2 0.5,0.2 0.7,0l13.4-13.9h0.1v-8.88178e-16c0.4-0.4 1-0.4 1.4,0l1.4,1.4c0.4,0.4 0.4,1 0,1.4l0,0-16,16.6c-0.2,0.2-0.4,0.3-0.7,0.3-0.3,0-0.5-0.1-0.7-0.3l-7.8-8.4-.2-.3z" fill="currentColor"/>
        </svg>
    {/if}
    {if $svgId == "email"}
        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="20px" height="20px" viewBox="0 0 512 512">
            <path d="M448,64H64C28.656,64,0,92.656,0,128v256c0,35.344,28.656,64,64,64h384c35.344,0,64-28.656,64-64V128   C512,92.656,483.344,64,448,64z M342.656,234.781l135.469-116.094c0.938,3,1.875,6,1.875,9.313v256   c0,2.219-0.844,4.188-1.281,6.281L342.656,234.781z M448,96c2.125,0,4,0.813,6,1.219L256,266.938L58,97.219   C60,96.813,61.875,96,64,96H448z M33.266,390.25C32.828,388.156,32,386.219,32,384V128c0-3.313,0.953-6.313,1.891-9.313   L169.313,234.75L33.266,390.25z M64,416c-3.234,0-6.172-0.938-9.125-1.844l138.75-158.563l51.969,44.531   C248.578,302.719,252.297,304,256,304s7.422-1.281,10.406-3.875l51.969-44.531l138.75,158.563C454.188,415.062,451.25,416,448,416   H64z" fill="currentColor"/>
        </svg>
    {/if}
    {if $svgId == "phone"}
        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="20px" height="20px" viewBox="0 0 612 612">
            <path d="M559.959,383.188l-99.145-50.93c-24.27-12.508-55.653-8.243-75.772,10.251l-11.571,10.595     c-11.226,10.328-28.726,12.719-42.323,5.681c-33.813-17.404-60.856-44.446-78.279-78.183c-7.133-13.847-4.857-30.83,5.718-42.305     l10.615-11.551c11.379-12.374,17.633-28.439,17.633-45.211c0-10.557-2.563-21.114-7.401-30.524l-50.987-99.067     C211.942,19.928,179.333,0,143.359,0c-21.152,0-41.195,6.771-57.949,19.565L55.27,42.553     c-47.334,36.07-66.785,98.36-48.444,154.989c61.085,188.382,209.132,340.311,396.021,406.426     c15.09,5.336,30.868,8.032,46.876,8.032c37.428,0,73.918-15.204,100.139-41.769l34.521-34.903     c17.824-18.016,27.616-41.846,27.616-67.109C611.999,432.244,592.051,399.674,559.959,383.188z M543.531,495.051l-34.501,34.903     c-22.147,22.414-57.223,30.504-87.058,19.947C251.817,489.734,117.024,351.384,61.409,179.871     c-10.844-33.526,0.65-70.38,28.668-91.743l30.16-23.007c6.675-5.087,14.669-7.784,23.122-7.784     c14.382,0,27.444,7.975,34.042,20.846l50.968,99.067c0.688,1.339,1.052,2.792,1.052,4.303c0,3.06-1.377,5.183-2.543,6.445     l-10.595,11.532c-26.737,29.07-32.532,72.197-14.42,107.33c22.874,44.407,58.522,79.98,102.988,102.892     c34.521,17.786,78.853,11.801,107.406-14.401l11.59-10.633c1.874-1.722,6.731-3.52,10.748-1.473l99.144,50.93     c12.891,6.617,20.885,19.66,20.885,34.043C554.604,478.297,550.665,487.821,543.531,495.051z" fill="currentColor"/>
        </svg>

    {/if}
    {if $svgId == "tag"}
        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 294.08 294.08" width="20px" height="20px">
            <path d="M274.939,0H170.532c-5.22,0-10.441,1.74-13.921,5.22L5.22,156.611C1.74,160.091,0,165.311,0,170.532    c0,5.22,1.74,10.441,5.22,13.921L109.627,288.86c3.48,3.48,8.701,5.22,13.921,5.22c3.48,0,8.701-1.74,13.921-5.22L288.86,137.469    c3.48-3.48,5.22-8.701,5.22-13.921V19.141C294.08,8.701,285.38,0,274.939,0z M274.939,127.029L123.548,278.419h-1.74    L15.66,172.272c0-1.74,0-3.48,0-3.48l153.13-153.13v3.48h104.407c1.74,0,1.74,0,1.74,1.74L274.939,127.029L274.939,127.029z" fill="currentColor"/>
            <path d="m212.295,55.684c-6.96,6.96-6.96,17.401 0,24.362 3.48,3.48 6.96,5.22 12.181,5.22 5.22,0 8.701-1.74 12.181-5.22 6.96-6.96 6.96-17.401 0-24.362-6.961-6.961-17.402-6.961-24.362,0z" fill="currentColor"/>
        </svg>
    {/if}
    {if $svgId == "magic"}
        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="20px" height="20px" viewBox="0 0 467.374 467.374">
            <path d="M459.657,82.222c0-5.136-1.704-9.419-5.133-12.843l-56.531-56.531c-3.425-3.427-7.706-5.14-12.847-5.14    c-5.144,0-9.421,1.713-12.847,5.14L5.14,380.005C1.709,383.434,0,387.719,0,392.858c0,5.141,1.709,9.418,5.14,12.847    l56.529,56.527c3.431,3.429,7.708,5.141,12.85,5.141c5.137,0,9.419-1.704,12.847-5.141l367.162-367.16    C457.953,91.642,459.657,87.364,459.657,82.222z M332.038,165.877l-30.546-30.55l83.651-83.654l30.546,30.549L332.038,165.877z" fill="currentColor"/>
            <polygon points="65.384,73.087 73.948,45.109 101.925,36.545 73.948,27.979 65.384,0.001 56.818,27.979 28.84,36.545     56.818,45.109   " fill="currentColor"/>
            <polygon points="139.61,108.494 156.743,164.455 173.876,108.494 229.835,91.361 173.876,74.23 156.743,18.269 139.61,74.23     83.651,91.361   " fill="currentColor"/>
            <polygon points="439.392,210.7 430.829,182.723 422.267,210.7 394.287,219.265 422.267,227.83 430.829,255.805 439.392,227.83     467.374,219.265   " fill="currentColor"/>
            <polygon points="248.106,73.087 256.672,45.109 284.648,36.545 256.672,27.979 248.106,0.001 239.544,27.979 211.564,36.545     239.544,45.109   " fill="currentColor"/>
        </svg>
    {/if}
    {if $svgId == "infinity"}
        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="20px" height="20px" viewBox="0 0 150.223 150.223">
            <path d="M115.885,38.631c-21.312,0-35.416,17.425-47.859,32.802c-10.631,13.136-20.67,25.54-32.897,25.54    c-12.709,0-20.512-13.062-20.512-22.426c0-8.682,8.56-21.299,21.976-21.299c13.018,0,19.8,10.419,20.142,10.953    c2.109,3.413,6.587,4.487,10.017,2.395c3.447-2.1,4.539-6.597,2.438-10.044c-0.446-0.73-11.167-17.92-32.597-17.92    C15.029,38.632,0,57.562,0,74.548c0,17.521,14.427,37.043,35.128,37.043c19.199,0,31.94-15.74,44.259-30.963    c11.396-14.078,22.161-27.379,36.498-27.379c8.53,0,14.135,2.894,17.131,8.84c2.596,5.16,2.594,10.999,2.592,13.022    c0,1.16-0.613,6.978-3.451,12.217c-3.236,5.968-7.83,8.746-14.469,8.746c-13.369,0-20.592-8.69-23.312-11.963    c-0.707-0.852-1.216-1.465-1.896-2.047c-3.062-2.623-7.678-2.271-10.306,0.795c-2.534,2.957-2.29,7.353,0.478,10.014    c0.132,0.15,0.291,0.347,0.48,0.576c3.545,4.266,14.324,17.24,34.553,17.24c24.586,0,32.537-23.973,32.537-35.678    c0.002-7.455-1.394-14.013-4.154-19.496C142.193,47.815,133.809,38.631,115.885,38.631z" fill="currentColor"/>
        </svg>
    {/if}
    {if $svgId == "sorts"}
        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 512 512" width="20px" height="20px">
            <path class="left_s" d="m496.1,138.3l-120.4-120.4c-7.9-7.9-20.6-7.9-28.5-7.10543e-15l-120.3,120.4c-7.9,7.9-7.9,20.6 0,28.5 7.9,7.9 20.6,7.9 28.5,0l85.7-85.7v352.8c0,11.3 9.1,20.4 20.4,20.4 11.3,0 20.4-9.1 20.4-20.4v-352.8l85.7,85.7c7.9,7.9 20.6,7.9 28.5,0 7.9-7.8 7.9-20.6 5.68434e-14-28.5z" fill="currentColor"/>
            <path class="right_s" d="m287.1,347.2c-7.9-7.9-20.6-7.9-28.5,0l-85.7,85.7v-352.8c0-11.3-9.1-20.4-20.4-20.4-11.3,0-20.4,9.1-20.4,20.4v352.8l-85.7-85.7c-7.9-7.9-20.6-7.9-28.5,0-7.9,7.9-7.9,20.6 0,28.5l120.4,120.4c7.9,7.9 20.6,7.9 28.5,0l120.4-120.4c7.8-7.9 7.8-20.7-0.1-28.5l0,0z" fill="currentColor"/>
        </svg>
    {/if}
    {if $svgId == "sorts2"}
        <svg viewBox="0 0 512 512" width="20px" height="20px">
            <path class="left_s" d="M267.998,125.671L177.997,5.669c-5.654-7.559-18.34-7.559-23.994,0L64.002,125.671
            c-7.399,9.844-0.355,23.994,11.997,23.994h45.001v285.003c0,8.291,6.709,15,15,15H196c8.291,0,14.8-6.709,14.8-15V149.665h45.2
            C268.363,149.665,275.389,135.505,267.998,125.671z"/>
            <path class="right_s" d="M436.003,362.005h-45.201V77.001c0-8.291-6.509-15-14.8-15h-60.001c-8.291,0-15,6.709-15,15v285.003h-45.001
            c-12.353,0-19.396,14.15-11.997,23.994L334.005,506c5.989,8.006,18.014,7.994,23.994,0L448,385.999
            C455.391,376.165,448.365,362.005,436.003,362.005z"/>
        </svg>
    {/if}
    {if $svgId == "sorting"}
        <svg viewBox="0 0 401.998 401.998" width="20px" height="20px">
            <path class="left_s" d="M73.092,164.452h255.813c4.949,0,9.233-1.807,12.848-5.424c3.613-3.616,5.427-7.898,5.427-12.847
            c0-4.949-1.813-9.229-5.427-12.85L213.846,5.424C210.232,1.812,205.951,0,200.999,0s-9.233,1.812-12.85,5.424L60.242,133.331
            c-3.617,3.617-5.424,7.901-5.424,12.85c0,4.948,1.807,9.231,5.424,12.847C63.863,162.645,68.144,164.452,73.092,164.452z"/>
            <path class="right_s" d="M328.905,237.549H73.092c-4.952,0-9.233,1.808-12.85,5.421c-3.617,3.617-5.424,7.898-5.424,12.847
            c0,4.949,1.807,9.233,5.424,12.848L188.149,396.57c3.621,3.617,7.902,5.428,12.85,5.428s9.233-1.811,12.847-5.428l127.907-127.906
            c3.613-3.614,5.427-7.898,5.427-12.848c0-4.948-1.813-9.229-5.427-12.847C338.139,239.353,333.854,237.549,328.905,237.549z"/>
        </svg>
    {/if}
    {if $svgId == "plus"}
        <svg class="plus" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 24 24"  width="20px" height="20px">
            <path d="m23,10h-8.5c-0.3,0-0.5-0.2-0.5-0.5v-8.5c0-0.6-0.4-1-1-1h-2c-0.6,0-1,0.4-1,1v8.5c0,0.3-0.2,0.5-0.5,0.5h-8.5c-0.6,0-1,0.4-1,1v2c0,0.6 0.4,1 1,1h8.5c0.3,0 0.5,0.2 0.5,0.5v8.5c0,0.6 0.4,1 1,1h2c0.6,0 1-0.4 1-1v-8.5c0-0.3 0.2-0.5 0.5-0.5h8.5c0.6,0 1-0.4 1-1v-2c0-0.6-0.4-1-1-1z" fill="currentColor"/>
        </svg>
    {/if}
    {if $svgId == "minus"}
        <svg class="minus" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 24 24"  width="20px" height="20px">
            <path d="M24,11c0-0.6-0.4-1-1-1H1c-0.6,0-1,0.4-1,1v2c0,0.6,0.4,1,1,1h22c0.6,0,1-0.4,1-1V11z" fill="currentColor"/>
        </svg>
    {/if}
    {if $svgId == "drag_vertical"}
        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 32 32"  width="20px" height="20px">
            <polygon points="18,20 18,26 22,26 16,32 10,26 14,26 14,20    " fill="currentColor"/>
            <polygon points="14,12 14,6 10,6 16,0 22,6 18,6 18,12    " fill="currentColor"/>
        </svg>
    {/if}

    {if $svgId == "notify"}
        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 454.136 454.136" width="20px" height="20px">
            <path d="M391.024,321.948c-27.089-27.089-42.308-63.83-42.308-102.14v-35.833c0-57-39.206-104.837-92.121-118.031V29.526    C256.595,13.22,243.375,0,227.068,0s-29.526,13.22-29.526,29.526v36.417c-52.915,13.195-92.121,61.031-92.121,118.031v35.833    c0,38.31-15.219,75.05-42.308,102.14c-11.907,11.907-15.469,29.814-9.025,45.372c6.444,15.557,21.625,25.701,38.464,25.701h73.4    c0,33.754,27.363,61.116,61.116,61.116s61.116-27.363,61.116-61.116h73.4c16.839,0,32.02-10.143,38.464-25.701    C406.493,351.762,402.931,333.855,391.024,321.948z M227.068,424.137c-17.158,0-31.116-13.959-31.116-31.116h62.232    C258.184,410.178,244.226,424.137,227.068,424.137z M372.332,355.839c-1.807,4.363-6.026,7.181-10.748,7.181H92.552    c-4.722,0-8.941-2.819-10.748-7.181s-0.817-9.339,2.522-12.678c32.949-32.949,51.094-76.757,51.094-123.353v-35.833    c0-50.535,41.113-91.648,91.648-91.648c50.535,0,91.648,41.113,91.648,91.648v35.833c0,46.596,18.146,90.404,51.095,123.353    C373.15,346.5,374.139,351.476,372.332,355.839z" fill="currentColor"/>
        </svg>
    {/if}
    {if $svgId == "exit"}
        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 310 310" width="20px" height="20px">
            <path id="XMLID_16_" d="M221.742,46.906c-7.28-3.954-16.387-1.259-20.341,6.021c-3.955,7.279-1.259,16.386,6.02,20.341   C242.937,92.561,265,129.626,265,170c0,60.654-49.346,110-110,110S45,230.654,45,170c0-40.198,21.921-77.186,57.208-96.531   c7.265-3.982,9.925-13.1,5.943-20.364c-3.983-7.264-13.101-9.925-20.364-5.943C42.891,71.775,15,118.844,15,170   c0,77.196,62.804,140,140,140s140-62.804,140-140C295,118.62,266.929,71.453,221.742,46.906z" fill="currentColor"/>
            <path id="XMLID_17_" d="M155,130c8.284,0,15-6.716,15-15V15c0-8.284-6.716-15-15-15c-8.284,0-15,6.716-15,15v100   C140,123.284,146.716,130,155,130z" fill="currentColor"/>
        </svg>
    {/if}
    {if $svgId == "help_icon"}
    <svg viewBox="0 0 510 510"  width="20px" height="20px">
        <path fill="currentColor" d="M255,0C114.75,0,0,114.75,0,255s114.75,255,255,255s255-114.75,255-255S395.25,0,255,0z M280.5,433.5h-51v-51h51V433.5z
        M334.05,237.15L311.1,260.1c-20.399,17.851-30.6,33.15-30.6,71.4h-51v-12.75c0-28.05,10.2-53.55,30.6-71.4L290.7,214.2
        c10.2-7.65,15.3-20.4,15.3-35.7c0-28.05-22.95-51-51-51s-51,22.95-51,51h-51c0-56.1,45.9-102,102-102c56.1,0,102,45.9,102,102
        C357,201.45,346.8,221.85,334.05,237.15z"/>
    </svg>
    {/if}

{if $svgId == "warn_icon"}
<svg viewBox="0 0 310.285 310.285" width="20px" height="20px">
    <path fill="currentColor" d="M264.845,45.441C235.542,16.139,196.583,0,155.142,0C113.702,0,74.743,16.139,45.44,45.441
    C16.138,74.743,0,113.703,0,155.144c0,41.439,16.138,80.399,45.44,109.701c29.303,29.303,68.262,45.44,109.702,45.44
    c41.44,0,80.399-16.138,109.702-45.44c29.303-29.302,45.44-68.262,45.44-109.701C310.285,113.703,294.147,74.743,264.845,45.441z
    M132.172,49.336c2.399-2.483,5.637-3.873,9.119-3.873h28.04c3.482,0,6.72,1.403,9.114,3.888c2.395,2.485,3.643,5.804,3.514,9.284
    l-4.634,104.895c-0.263,7.102-6.26,12.933-13.368,12.933h-17.627c-7.112,0-13.099-5.839-13.345-12.945L128.64,58.594
    C128.519,55.114,129.773,51.821,132.172,49.336z M155.478,268.78c-16.266,0-28.532-12.844-28.532-29.876
    c0-17.223,12.122-30.211,28.196-30.211c16.602,0,28.196,12.423,28.196,30.211C183.339,256.495,171.882,268.78,155.478,268.78z"/>
</svg>
{/if}

{if $svgId == "info_icon"}
<svg viewBox="0 0 23.625 23.625" width="20px" height="20px">
    <path fill="currentColor" d="M11.812,0C5.289,0,0,5.289,0,11.812s5.289,11.813,11.812,11.813s11.813-5.29,11.813-11.813
    S18.335,0,11.812,0z M14.271,18.307c-0.608,0.24-1.092,0.422-1.455,0.548c-0.362,0.126-0.783,0.189-1.262,0.189
    c-0.736,0-1.309-0.18-1.717-0.539s-0.611-0.814-0.611-1.367c0-0.215,0.015-0.435,0.045-0.659c0.031-0.224,0.08-0.476,0.147-0.759
    l0.761-2.688c0.067-0.258,0.125-0.503,0.171-0.731c0.046-0.23,0.068-0.441,0.068-0.633c0-0.342-0.071-0.582-0.212-0.717
    c-0.143-0.135-0.412-0.201-0.813-0.201c-0.196,0-0.398,0.029-0.605,0.09c-0.205,0.063-0.383,0.12-0.529,0.176l0.201-0.828
    c0.498-0.203,0.975-0.377,1.43-0.521c0.455-0.146,0.885-0.218,1.29-0.218c0.731,0,1.295,0.178,1.692,0.53
    c0.395,0.353,0.594,0.812,0.594,1.376c0,0.117-0.014,0.323-0.041,0.617c-0.027,0.295-0.078,0.564-0.152,0.811l-0.757,2.68
    c-0.062,0.215-0.117,0.461-0.167,0.736c-0.049,0.275-0.073,0.485-0.073,0.626c0,0.356,0.079,0.599,0.239,0.728
    c0.158,0.129,0.435,0.194,0.827,0.194c0.185,0,0.392-0.033,0.626-0.097c0.232-0.064,0.4-0.121,0.506-0.17L14.271,18.307z
    M14.137,7.429c-0.353,0.328-0.778,0.492-1.275,0.492c-0.496,0-0.924-0.164-1.28-0.492c-0.354-0.328-0.533-0.727-0.533-1.193
    c0-0.465,0.18-0.865,0.533-1.196c0.356-0.332,0.784-0.497,1.28-0.497c0.497,0,0.923,0.165,1.275,0.497
    c0.353,0.331,0.53,0.731,0.53,1.196C14.667,6.703,14.49,7.101,14.137,7.429z"/>
</svg>
{/if}
    {if $svgId == "video_icon"}
<svg xmlns="http://www.w3.org/2000/svg" width="20px" height="20px" viewBox="0 0 697.515 697.515">
    <path d="M139.605,87.558l23.403-29.722L103.11,10.689C89.412-0.095,74.485-2.895,62.149,3.122     C49.833,9.081,42.757,22.514,42.757,39.977v617.562c0,17.443,7.076,30.895,19.392,36.873c4.276,2.081,8.873,3.103,13.603,3.103     c8.93,0,18.409-3.613,27.357-10.67l54.601-43.004l-23.403-29.722l-53.712,42.266V41.111L139.605,87.558z M635.271,310.484     L254.464,10.689C245.477,3.595,236.301,0,227.201,0c-16.479,0-33.09,12.354-33.09,39.977v617.562     c0,27.603,16.611,39.976,33.09,39.976c9.1,0,18.276-3.595,27.263-10.689l380.807-299.794     c12.373-9.743,19.486-23.688,19.486-38.274S647.644,320.228,635.271,310.484z M231.95,160.284l228.563,179.922     c3.254,2.573,5.052,5.6,5.052,8.551c0,2.952-1.798,5.979-5.052,8.551L231.95,537.212V160.284z M611.868,357.29L231.95,656.385     v-71.023l251.967-198.349c12.373-9.744,19.468-23.688,19.468-38.274c0-14.587-7.095-28.53-19.468-38.274L231.95,112.115V41.111     l379.918,299.095c3.254,2.573,5.051,5.6,5.051,8.551C616.918,351.69,615.103,354.736,611.868,357.29z" fill="currentColor"/>
</svg>
    {/if}
    {if $svgId == "delete"}
        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 47.971 47.971" width="20px" height="20px">
            <path d="M28.228,23.986L47.092,5.122c1.172-1.171,1.172-3.071,0-4.242c-1.172-1.172-3.07-1.172-4.242,0L23.986,19.744L5.121,0.88   c-1.172-1.172-3.07-1.172-4.242,0c-1.172,1.171-1.172,3.071,0,4.242l18.865,18.864L0.879,42.85c-1.172,1.171-1.172,3.071,0,4.242   C1.465,47.677,2.233,47.97,3,47.97s1.535-0.293,2.121-0.879l18.865-18.864L42.85,47.091c0.586,0.586,1.354,0.879,2.121,0.879   s1.535-0.293,2.121-0.879c1.172-1.171,1.172-3.071,0-4.242L28.228,23.986z" fill="currentColor"/>
        </svg>
    {/if}
    {if $svgId == "trash"}
<svg width="20px" height="20px" viewBox="0 0 512 512">
    <polygon points="353.574,176.526 313.496,175.056 304.807,412.34 344.885,413.804" fill="currentColor"/>
    <rect x="235.948" y="175.791" width="40.104" height="237.285" fill="currentColor"/>
    <polygon points="207.186,412.334 198.497,175.049 158.419,176.52 167.109,413.804" fill="currentColor"/>
    <path d="M17.379,76.867v40.104h41.789L92.32,493.706C93.229,504.059,101.899,512,112.292,512h286.74
    c10.394,0,19.07-7.947,19.972-18.301l33.153-376.728h42.464V76.867H17.379z M380.665,471.896H130.654L99.426,116.971h312.474
    L380.665,471.896z" fill="currentColor"/>
    <path d="M321.504,0H190.496c-18.428,0-33.42,14.992-33.42,33.42v63.499h40.104V40.104h117.64v56.815h40.104V33.42
    C354.924,14.992,339.932,0,321.504,0z" fill="currentColor"/>
</svg>
    {/if}
    {if $svgId == "icon_featured"}
        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"
             width="20px" height="20px" viewBox="0 0 37.286 37.287">
            <path d="M36.683,16.339l-7.567,7.377l1.786,10.417c0.128,0.75-0.182,1.509-0.797,1.957c-0.348,0.253-0.762,0.382-1.176,0.382
        c-0.318,0-0.638-0.076-0.931-0.23l-9.355-4.918l-9.355,4.918c-0.674,0.355-1.49,0.295-2.107-0.15
        c-0.615-0.448-0.924-1.206-0.795-1.957l1.787-10.417L0.604,16.34c-0.547-0.531-0.741-1.326-0.508-2.05
        c0.236-0.724,0.861-1.251,1.615-1.361l10.459-1.521l4.68-9.478c0.335-0.684,1.031-1.116,1.792-1.116
        c0.763,0,1.456,0.432,1.793,1.115l4.68,9.478l10.461,1.521c0.752,0.109,1.379,0.637,1.611,1.361
        C37.425,15.013,37.226,15.808,36.683,16.339z" fill="currentColor"/>
        </svg>
    {/if}

    {if $svgId == "icon_copy"}
        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="20px" height="20px" viewBox="0 0 498.018 498.018">

            <path id="XMLID_66_" d="M293.502,452.25c-134.851,0-78.123,0-216.938,0V141.781h33.23v-45.76H68.128
		c-20.125,0-36.49,16.363-36.49,36.479v329.03c0,20.149,16.332,36.488,36.481,36.488c49.845,0,143.392,0,233.828,0
		c20.149,0,36.479-16.332,36.479-36.488c0-3.421,0-6.5,0-9.733h-44.925V452.25z" fill="currentColor"/>
            <path id="XMLID_63_" d="M460.099,68.342L398.033,6.265C393.979,2.213,388.589,0,382.884,0H196.081
		c-20.125,0-36.49,16.364-36.49,36.488V365.51c0,20.15,16.332,36.49,36.49,36.49c49.836,0,143.384,0,233.819,0
		c20.148,0,36.48-16.332,36.48-36.49c0-211.645,0-64.928,0-282.02C466.38,77.768,464.153,72.385,460.099,68.342z M421.455,356.238
		c-134.859,0-78.124,0-216.945,0V45.769h150.856v40.136c0,14.305,11.631,25.944,25.936,25.944h40.153V356.238z" fill="currentColor"/>
        </svg>
    {/if}
    {if $svgId == "icon_desktop"}
        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 460 460" width="20px" height="20px">
            <path d="M0,67.5v285h460v-285H0z M30,97.5h400v225H30V97.5z M130,362.5l-20,20v10h240v-10l-20-20H130z" fill="currentColor"/>
        </svg>
    {/if}
    {if $svgId == "icon_tooltips"}
<svg width="20px" height="20px" viewBox="0 0 438.533 438.533" >
    <path fill="currentColor" d="M409.133,109.203c-19.608-33.592-46.205-60.189-79.798-79.796C295.736,9.801,259.058,0,219.273,0
    c-39.781,0-76.47,9.801-110.063,29.407c-33.595,19.604-60.192,46.201-79.8,79.796C9.801,142.8,0,179.489,0,219.267
    c0,39.78,9.804,76.463,29.407,110.062c19.607,33.592,46.204,60.189,79.799,79.798c33.597,19.605,70.283,29.407,110.063,29.407
    s76.47-9.802,110.065-29.407c33.593-19.602,60.189-46.206,79.795-79.798c19.603-33.596,29.403-70.284,29.403-110.062
    C438.533,179.485,428.732,142.795,409.133,109.203z M255.82,356.309c0,2.662-0.862,4.853-2.573,6.563
    c-1.704,1.711-3.895,2.567-6.557,2.567h-54.823c-2.664,0-4.854-0.856-6.567-2.567c-1.714-1.711-2.57-3.901-2.57-6.563v-54.823
    c0-2.662,0.855-4.853,2.57-6.563c1.713-1.708,3.903-2.563,6.567-2.563h54.823c2.662,0,4.853,0.855,6.557,2.563
    c1.711,1.711,2.573,3.901,2.573,6.563V356.309z M325.338,187.574c-2.382,7.043-5.044,12.804-7.994,17.275
    c-2.949,4.473-7.187,9.042-12.709,13.703c-5.51,4.663-9.891,7.996-13.135,9.998c-3.23,1.995-7.898,4.713-13.982,8.135
    c-6.283,3.613-11.465,8.326-15.555,14.134c-4.093,5.804-6.139,10.513-6.139,14.126c0,2.67-0.862,4.859-2.574,6.571
    c-1.707,1.711-3.897,2.566-6.56,2.566h-54.82c-2.664,0-4.854-0.855-6.567-2.566c-1.715-1.712-2.568-3.901-2.568-6.571v-10.279
    c0-12.752,4.993-24.701,14.987-35.832c9.994-11.136,20.986-19.368,32.979-24.698c9.13-4.186,15.604-8.47,19.41-12.847
    c3.812-4.377,5.715-10.188,5.715-17.417c0-6.283-3.572-11.897-10.711-16.849c-7.139-4.947-15.27-7.421-24.409-7.421
    c-9.9,0-18.082,2.285-24.555,6.855c-6.283,4.565-14.465,13.322-24.554,26.263c-1.713,2.286-4.093,3.431-7.139,3.431
    c-2.284,0-4.093-0.57-5.424-1.709L121.35,145.89c-4.377-3.427-5.138-7.422-2.286-11.991
    c24.366-40.542,59.672-60.813,105.922-60.813c16.563,0,32.744,3.903,48.541,11.708c15.796,7.801,28.979,18.842,39.546,33.119
    c10.554,14.272,15.845,29.787,15.845,46.537C328.904,172.824,327.71,180.529,325.338,187.574z"/>
</svg>
    {/if}
    {if $svgId == "techsupport"}
        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 235.129 235.129" width="20px" height="20px">
            <path d="M212.027,84.433l-3.954,0.003c-10.912-40.466-48.044-69.228-90.549-69.228c-42.253,0-79.347,28.769-90.44,69.236  l-3.987-0.003C10.361,84.441,0,94.802,0,107.538v25.941c0,12.734,10.361,23.094,23.097,23.094h2.874  c3.697,29.087,28.603,51.648,58.681,51.648h5.515c2.926,6.87,9.744,11.699,17.669,11.699h19.455  c10.585,0,19.197-8.611,19.197-19.195c0-10.586-8.612-19.199-19.197-19.199h-19.455c-7.923,0-14.739,4.828-17.666,11.695h-5.519  c-24.347,0-44.154-19.805-44.154-44.148V92.785c7.758-36.299,40.035-62.576,77.027-62.576c37.237,0,69.551,26.267,77.108,62.548  v56.31c0,4.142,3.358,7.5,7.5,7.5h9.9c12.735,0,23.096-10.36,23.096-23.095V107.53C235.129,94.795,224.768,84.433,212.027,84.433z   M107.836,196.526h19.455c2.314,0,4.197,1.884,4.197,4.199c0,2.314-1.883,4.195-4.197,4.195h-19.455  c-2.313,0-4.195-1.882-4.195-4.195C103.641,198.41,105.522,196.526,107.836,196.526z M15,133.479v-25.941  c0-4.464,3.632-8.097,8.09-8.097l2.407,0.002v42.129h-2.4C18.632,141.573,15,137.942,15,133.479z M220.129,133.471  c0,4.463-3.632,8.095-8.096,8.095h-2.4V99.435l2.4-0.002c4.464,0,8.096,3.632,8.096,8.097V133.471z" fill="currentColor"/>
        </svg>
    {/if}
    {if $svgId == "logout"}
        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="20px" height="20px" viewBox="0 0 459 459">
            <g id="exit-to-app">
                <path d="M181.05,321.3l35.7,35.7l127.5-127.5L216.75,102l-35.7,35.7l66.3,66.3H0v51h247.35L181.05,321.3z M408,0H51    C22.95,0,0,22.95,0,51v102h51V51h357v357H51V306H0v102c0,28.05,22.95,51,51,51h357c28.05,0,51-22.95,51-51V51    C459,22.95,436.05,0,408,0z" fill="currentColor"/>
            </g>
        </svg>
    {/if}
    {if $svgId == "left_orders"}
        <svg width="20px" height="20px" viewBox="0 0 510 510">
            <g id="shopping-cart">
                <path d="M153,408c-28.05,0-51,22.95-51,51s22.95,51,51,51s51-22.95,51-51S181.05,408,153,408z M0,0v51h51l91.8,193.8L107.1,306    c-2.55,7.65-5.1,17.85-5.1,25.5c0,28.05,22.95,51,51,51h306v-51H163.2c-2.55,0-5.1-2.55-5.1-5.1v-2.551l22.95-43.35h188.7    c20.4,0,35.7-10.2,43.35-25.5L504.9,89.25c5.1-5.1,5.1-7.65,5.1-12.75c0-15.3-10.2-25.5-25.5-25.5H107.1L84.15,0H0z M408,408    c-28.05,0-51,22.95-51,51s22.95,51,51,51s51-22.95,51-51S436.05,408,408,408z" fill="currentColor"/>
            </g>
        </svg>
    {/if}
    {if $svgId == "left_users"}
        <svg width="20" height="20" viewBox="0 0 24 19" xmlns="http://www.w3.org/2000/svg">
            <g fill="currentColor" fill-rule="evenodd">
                <path d="M3.753 13.301c1.21-.803 2.554-1.285 3.852-1.714.187-.061.374-.143.56-.206l.037-.023a5.39 5.39 0 0 0 .748-.31 1.14 1.14 0 0 0 .04-.123C7.922 9.363 7.194 6.949 7.194 4.882c0-1.755.55-3.054 1.59-3.845C8.336.808 7.792.722 7.21.722c-1.556 0-2.816.62-2.816 2.85 0 1.481.556 3.296 1.384 4.35a2.822 2.822 0 0 1-.032.25c-.05.227-.13.481-.342.607-.237.141-.5.231-.76.321-1.076.363-2.191.681-3.146 1.317-.498.328-.834.977-1.019 1.534-.192.58-.27 1.146-.257 1.929h2.935c.186-.392.384-.44.596-.579zM22.398 10.438c-.956-.634-2.071-.964-3.148-1.327a4.062 4.062 0 0 1-.76-.326c-.213-.126-.291-.384-.341-.609a2.949 2.949 0 0 1-.04-.363c.779-1.069 1.298-2.811 1.298-4.241 0-2.23-1.26-2.852-2.816-2.852-.591 0-1.14.092-1.592.325 1.03.792 1.577 2.088 1.577 3.837 0 2.011-.676 4.329-1.703 5.901a1.285 1.285 0 0 0 .073.271c.225.124.494.224.796.329l.45.15c1.333.443 2.71.978 3.951 1.803.203.131.392.152.57.544h2.96c.012-.783-.067-1.348-.258-1.929-.185-.555-.521-1.185-1.017-1.513z"/><path d="M19.626 14.044c-1.275-.846-2.76-1.29-4.193-1.774-.348-.12-.699-.25-1.016-.439-.284-.167-.39-.51-.454-.811a4.095 4.095 0 0 1-.057-.485c1.042-1.424 1.731-3.747 1.731-5.653 0-2.974-1.68-3.803-3.753-3.803-2.073 0-3.753.829-3.753 3.803 0 1.973.741 4.394 1.845 5.8-.01.11-.023.222-.043.333-.066.301-.172.64-.454.809-.317.187-.67.307-1.015.427-1.436.483-2.92.91-4.194 1.756-.664.436-1.113 1.277-1.36 2.022-.255.769-.36 1.76-.344 2.54h18.763c.015-.78-.09-1.771-.344-2.542-.248-.743-.697-1.546-1.359-1.983z"/>
            </g>
        </svg>
    {/if}
    {if $svgId == "left_modules"}
        <svg width="20" height="20" viewBox="0 0 535.5 535.5">
            <path fill="currentColor" d="M471.75,255H433.5V153c0-28.05-22.95-51-51-51h-102V63.75C280.5,28.05,252.45,0,216.75,0S153,28.05,153,63.75V102H51
            c-28.05,0-51,22.95-51,51v96.9h38.25c38.25,0,68.85,30.6,68.85,68.85S76.5,387.6,38.25,387.6H0v96.9c0,28.05,22.95,51,51,51h96.9
            v-38.25c0-38.25,30.6-68.85,68.85-68.85s68.85,30.6,68.85,68.85v38.25h96.9c28.05,0,51-22.95,51-51v-102h38.25
            c35.7,0,63.75-28.05,63.75-63.75S507.45,255,471.75,255z"/>
        </svg>
    {/if}
    {if $svgId == "left_faq_title"}
    <svg width="20px" height="20px" viewBox="0 0 98.27 98.27">
        <path fill="currentColor" d="M49.135,0C21.998,0,0,21.999,0,49.135S21.998,98.27,49.135,98.27c27.136,0,49.134-21.999,49.134-49.135S76.27,0,49.135,0z
        M53.234,82.086c-1.539,1.521-3.684,2.293-6.369,2.293c-2.746,0-4.918-0.754-6.456-2.241c-1.545-1.495-2.328-3.604-2.328-6.269
        c0-2.754,0.769-4.887,2.284-6.336c1.51-1.44,3.696-2.172,6.5-2.172c2.714,0,4.861,0.746,6.386,2.219
        c1.528,1.479,2.304,3.596,2.304,6.289C55.555,78.472,54.773,80.564,53.234,82.086z M68.424,40.295
        c-1.572,2.511-4.566,5.354-8.9,8.45c-2.817,2.083-4.627,3.684-5.355,4.74c-0.686,0.995-1.034,2.346-1.034,4.014v1.98
        c0,0.828-0.672,1.5-1.5,1.5H41.045c-0.828,0-1.5-0.672-1.5-1.5v-2.621c0-3.041,0.663-5.732,1.972-8
        c1.296-2.244,3.665-4.638,7.043-7.116c3.135-2.239,5.209-4.06,6.183-5.422c0.923-1.297,1.392-2.768,1.392-4.369
        c0-1.742-0.615-3.024-1.881-3.92c-1.329-0.941-3.246-1.419-5.698-1.419c-4.252,0-9.173,1.366-14.624,4.061
        c-0.739,0.366-1.639,0.064-2.008-0.676l-4.316-8.67c-0.36-0.725-0.082-1.604,0.63-1.988c6.689-3.614,13.864-5.447,21.325-5.447
        c6.421,0,11.613,1.578,15.434,4.69c3.864,3.15,5.825,7.402,5.825,12.639C70.82,34.697,70.014,37.749,68.424,40.295z"/>
    </svg>
    {/if}
    {if $svgId == "left_pages"}
        <svg width="20" height="20" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
            <g fill="currentColor" fill-rule="evenodd"><path d="M17.88.496H1.843C.888.496.11 1.231.11 2.136v15.241c0 .905.778 1.641 1.733 1.641H17.88c.956 0 1.734-.736 1.734-1.64V2.134c0-.904-.778-1.639-1.734-1.639zm0 17.334H1.843a.466.466 0 0 1-.477-.453V5.373h16.992v12.004c0 .25-.214.453-.478.453z"/><path d="M11.65 3.529a.65.65 0 0 0 .444-.175.586.586 0 0 0 .184-.42.587.587 0 0 0-.184-.42.653.653 0 0 0-.888 0 .586.586 0 0 0-.184.42c0 .157.068.31.184.42a.65.65 0 0 0 .444.175zM7.487 9.312h4.75c.347 0 .628-.266.628-.594 0-.328-.281-.594-.628-.594h-4.75c-.347 0-.628.266-.628.594 0 .328.281.594.628.594zM15.206 10.792H4.518c-.347 0-.628.266-.628.594 0 .328.281.594.628.594h10.688c.347 0 .628-.266.628-.594 0-.328-.28-.594-.628-.594zM15.206 13.753H4.518c-.347 0-.628.266-.628.594 0 .328.281.594.628.594h10.688c.347 0 .628-.266.628-.594 0-.328-.28-.594-.628-.594z"/></g>
        </svg>
    {/if}
    {if $svgId == "left_blog"}
        <svg width="20" height="20" viewBox="0 0 19 19" xmlns="http://www.w3.org/2000/svg">
            <defs>
                <path id="a" d="M.01.118v14.683h14.672V.118H.011z"/>
            </defs>
            <g fill="currentColor" ><g transform="translate(.435 3.495)"><path d="M0 9.907V14.8h4.894l9.788-9.788L9.788.118 0 9.907zm4.27 3.388H3.013v-1.506H1.506V10.53l1.07-1.07 2.765 2.764-1.07 1.07zm5.895-11.176c.172 0 .258.086.258.259a.272.272 0 0 1-.082.2L3.965 8.954a.274.274 0 0 1-.2.082c-.173 0-.26-.087-.26-.259 0-.078.028-.145.083-.2l6.377-6.376a.272.272 0 0 1 .2-.082z" fill="currentColor" /></g><path d="M17.823 3.671L15.058.92a1.46 1.46 0 0 0-1.07-.447 1.4 1.4 0 0 0-1.06.447l-1.952 1.94 4.895 4.895L17.824 5.8c.29-.29.435-.643.435-1.059 0-.407-.146-.765-.436-1.07z" fill="currentColor"/></g>
        </svg>
    {/if}
    {if $svgId == "sertificat"}
        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="20px" height="20px" viewBox="0 0 426.48 426.48">
            <path d="M113.345,100.813h106.666c5.521,0,10-4.479,10-10c0-5.523-4.479-10-10-10H113.345c-5.523,0-10,4.477-10,10    C103.345,96.336,107.822,100.813,113.345,100.813z" fill="currentColor"/>
            <path d="M113.345,150.146h145.334c5.521,0,10-4.477,10-10c0-5.522-4.479-10-10-10H113.345c-5.523,0-10,4.478-10,10    C103.345,145.67,107.822,150.146,113.345,150.146z" fill="currentColor"/>
            <path d="M72.769,30h226.486v156.773c3.947,1.141,7.336,2.849,10.107,4.403c4.688-2.63,11.135-5.714,19.092-5.714    c0.27,0,0.533,0.023,0.801,0.03V30c0-16.568-13.432-30-30-30H72.769c-16.568,0-30,13.432-30,30v334.293c0,16.568,13.432,30,30,30    h181.666v-30H72.769V30z" fill="currentColor"/>
            <path d="M375.425,260.988c-2.232-1.988-4.768-4.242-5.322-5.954c-0.607-1.872,0.1-5.155,0.779-8.332    c1.07-4.979,2.283-10.621-0.797-14.853c-3.105-4.271-8.883-4.856-13.979-5.373c-3.057-0.312-6.52-0.661-8.066-1.789    c-1.512-1.1-2.895-4.254-4.115-7.036c-2.074-4.725-4.422-10.079-9.51-11.73c-0.936-0.304-1.932-0.458-2.959-0.458    c-3.895,0-7.633,2.17-11.246,4.27c-2.852,1.656-5.801,3.368-7.846,3.368c-2.047,0-4.994-1.712-7.848-3.368    c-3.613-2.1-7.352-4.27-11.246-4.27c-1.027,0-2.021,0.154-2.959,0.458c-5.086,1.651-7.438,7.006-9.512,11.73    c-1.221,2.782-2.604,5.938-4.113,7.036c-1.551,1.128-5.014,1.479-8.066,1.789c-5.096,0.517-10.873,1.103-13.98,5.373    c-3.08,4.23-1.867,9.873-0.797,14.853c0.682,3.177,1.389,6.461,0.779,8.333c-0.555,1.711-3.088,3.965-5.322,5.953    c-3.885,3.456-8.287,7.373-8.287,12.809c0,5.435,4.402,9.352,8.287,12.808c2.234,1.987,4.768,4.241,5.324,5.954    c0.606,1.871-0.098,5.156-0.781,8.332c-1.07,4.979-2.283,10.621,0.797,14.853c3.107,4.271,8.885,4.856,13.98,5.374    c3.055,0.311,6.518,0.66,8.066,1.788c1.512,1.101,2.895,4.254,4.115,7.037c2.072,4.724,4.424,10.077,9.51,11.729    c0.938,0.305,1.934,0.457,2.961,0.457c3.893,0,7.631-2.17,11.244-4.269c2.852-1.656,5.801-3.369,7.848-3.369    c2.045,0,4.994,1.712,7.846,3.369c3.613,2.099,7.352,4.269,11.246,4.269c1.027,0,2.023-0.154,2.961-0.457    c5.084-1.652,7.434-7.007,9.506-11.73c1.223-2.782,2.605-5.938,4.117-7.036c1.549-1.128,5.012-1.479,8.066-1.789    c5.098-0.517,10.873-1.103,13.979-5.373c3.08-4.231,1.867-9.874,0.797-14.853c-0.682-3.176-1.389-6.461-0.777-8.332    c0.555-1.713,3.088-3.967,5.32-5.955c3.887-3.455,8.287-7.372,8.287-12.807C383.712,268.361,379.31,264.444,375.425,260.988z     M312.362,299.766c-14.344,0-25.971-11.627-25.971-25.971c0-14.343,11.627-25.97,25.971-25.97    c14.342,0,25.969,11.627,25.969,25.97C338.331,288.139,326.704,299.766,312.362,299.766z" fill="currentColor"/>
            <path d="M336.765,348.909c-1.697,0.552-3.484,0.831-5.311,0.831c-5.945,0-11.004-2.938-15.068-5.299    c-1.152-0.67-2.945-1.71-4.023-2.18c-1.08,0.47-2.871,1.511-4.025,2.18c-4.062,2.359-9.123,5.299-15.064,5.299l0,0    c-1.828,0-3.615-0.279-5.314-0.83c-5.02-1.63-8.229-5.049-10.521-8.729v82.188c0,1.631,0.965,3.106,2.457,3.763    c1.49,0.655,3.23,0.365,4.434-0.737l28.037-25.781l28.035,25.781c0.771,0.712,1.77,1.085,2.783,1.085    c0.557,0,1.119-0.114,1.648-0.348c1.494-0.655,2.457-2.132,2.457-3.763v-82.228C344.989,343.809,341.741,347.295,336.765,348.909z    " fill="currentColor"/>
        </svg>
    {/if}
    {if $svgId == "left_comments"}
        <svg width="20" height="20" viewBox="0 0 23 19" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">

            <g fill="none" ><g >
                    <path d="M13.23 11.997c1.356-.572 2.425-1.35 3.21-2.334.783-.983 1.175-2.056 1.175-3.215 0-1.159-.392-2.23-1.176-3.215C15.655 2.25 14.586 1.471 13.23.9 11.875.328 10.401.043 8.808.043 7.215.043 5.74.328 4.385.9 3.03 1.47 1.96 2.25 1.176 3.233.392 4.218 0 5.29 0 6.448c0 .993.296 1.927.889 2.803.592.876 1.405 1.614 2.44 2.214-.085.201-.17.384-.257.551a3.167 3.167 0 0 1-.314.482c-.12.154-.214.275-.28.362-.067.088-.176.211-.326.37-.15.158-.246.262-.288.312 0-.008-.017.01-.05.056s-.052.067-.057.063c-.003-.004-.02.017-.05.062l-.043.07-.032.062a.278.278 0 0 0-.024.075.535.535 0 0 0-.006.08c0 .03.003.057.012.082a.418.418 0 0 0 .143.263c.08.067.166.1.257.1h.038c.417-.059.775-.126 1.075-.2a10.511 10.511 0 0 0 3.479-1.602c.75.133 1.484.2 2.202.2 1.592 0 3.067-.285 4.422-.856zm-7-1.045l-.55.388c-.233.158-.492.322-.776.488l.438-1.051-1.214-.7c-.8-.468-1.421-1.018-1.864-1.651-.441-.635-.662-1.294-.662-1.978 0-.85.327-1.647.982-2.39.654-.742 1.536-1.33 2.646-1.764 1.109-.433 2.302-.65 3.578-.65 1.276 0 2.468.217 3.578.65 1.109.435 1.991 1.022 2.646 1.765.655.742.982 1.538.982 2.39 0 .85-.327 1.647-.982 2.389-.655.742-1.537 1.33-2.646 1.764-1.11.434-2.302.65-3.578.65a10.87 10.87 0 0 1-1.914-.175l-.663-.125z" fill="currentColor"/></g>
                <path d="M22.121 13.118c.593-.872.888-1.808.888-2.809 0-1.025-.312-1.985-.938-2.877-.625-.893-1.476-1.635-2.552-2.227a6.418 6.418 0 0 1-.55 5.08c-.559 1-1.36 1.884-2.403 2.652-.967.7-2.068 1.238-3.303 1.614a13.228 13.228 0 0 1-3.866.562c-.25 0-.617-.016-1.1-.05 1.676 1.102 3.645 1.652 5.905 1.652.718 0 1.451-.067 2.202-.2a10.518 10.518 0 0 0 3.478 1.601c.3.075.659.142 1.076.2.1.009.192-.02.275-.087a.462.462 0 0 0 .163-.275c-.004-.05 0-.078.012-.081.012-.004.01-.032-.006-.081l-.025-.076-.03-.062a.591.591 0 0 0-.045-.069.55.55 0 0 0-.05-.063 1.38 1.38 0 0 1-.056-.062 8.891 8.891 0 0 0-.337-.369 4.982 4.982 0 0 1-.326-.369l-.281-.363a3.17 3.17 0 0 1-.313-.482 6.657 6.657 0 0 1-.257-.55c1.034-.6 1.847-1.337 2.44-2.209z" fill="currentColor"/>
            </g>
        </svg>
    {/if}
    {if $svgId == "left_auto"}
        <svg width="20" height="20" viewBox="0 0 23 20" xmlns="http://www.w3.org/2000/svg">
            <g fill="currentColor" fill-rule="evenodd"><path d="M7.436 2.26v13.689l3.89-3.89 1.159 1.16-5.883 5.884L.719 13.22l1.16-1.16 3.888 3.889V2.259zM15.937 16.937V3.247l-3.889 3.89-1.16-1.16L16.773.094l5.883 5.883-1.16 1.16-3.889-3.89v13.69z"/></g>
        </svg>
    {/if}
    {if $svgId == "left_stats"}
        <svg width="20" height="20" viewBox="0 0 21 20" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
            <defs><path id="a" d="M.005 0v2.045h20.04V0H.005z"/></defs>
            <g fill="none" fill-rule="evenodd">
                <g transform="translate(.595 17.066)">
                    <path d="M19.022 0h-18a1.023 1.023 0 1 0 0 2.045h18a1.023 1.023 0 0 0 0-2.045z" fill="currentColor" />
                </g>
                <path d="M2.674 15.566H5.88c.358 0 .648-.29.648-.647V6.055a.648.648 0 0 0-.648-.647H2.674a.648.648 0 0 0-.647.647v8.864c0 .357.29.647.647.647zM9.015 15.566h3.205c.358 0 .647-.29.647-.647V1.624a.648.648 0 0 0-.647-.648H9.015a.648.648 0 0 0-.647.648v13.295c0 .357.29.647.647.647zM15.356 15.566h3.205c.357 0 .647-.29.647-.647v-7.16a.648.648 0 0 0-.647-.647h-3.205a.648.648 0 0 0-.647.648v7.159c0 .357.29.647.647.647z" fill="currentColor"/></g>
        </svg>
    {/if}
    {if $svgId == "left_seo"}
        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 489.25 489.25" width="20px" height="20px">
            <path d="M240.25,216.55c-4-1.1-8.1-1.7-12.4-1.7c-25.7,0-46.6,20.9-46.6,46.6c0,25.7,20.9,46.6,46.6,46.6s46.6-20.9,46.6-46.6    c0-4.3-0.6-8.5-1.7-12.4l129.8-129.8l21,2.8l65.7-65.7l-49.7-6.6l-6.6-49.7l-65.7,65.7l2.8,21L240.25,216.55z" fill="currentColor"/>
            <path d="M232.85,171.95l38.4-38.4c-47.1-16-101.4-5.2-138.9,32.4c-52.7,52.7-52.7,138.3,0,191s138.3,52.7,191,0    c37.6-37.6,48.4-91.8,32.4-139l-38.4,38.4c1.4,24.6-7.3,49.7-26.1,68.5c-35,35-91.8,35-126.8,0s-35-91.8,0-126.8    C183.25,179.25,208.25,170.55,232.85,171.95z" fill="currentColor"/>
            <path d="M388.85,184.95c31.5,66.2,19.8,147.7-35,202.5c-69.6,69.6-182.4,69.6-252,0s-69.6-182.4,0-252    c54.8-54.8,136.3-66.4,202.5-35l36.7-36.7c-87-49.9-200-37.7-274.3,36.6c-89,89-89,233.2,0,322.1c89,89,233.2,89,322.1,0    c74.3-74.3,86.5-187.3,36.6-274.3L388.85,184.95z" fill="currentColor"/>
        </svg>
    {/if}
    {if $svgId == "left_topvisor_title"}
        <svg width="20" height="20" viewBox="0 0 21 21" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
            <g fill="none"><path d="M10.453 9.471a1.89 1.89 0 0 0-2.39 1.82 1.89 1.89 0 0 0 1.888 1.887 1.89 1.89 0 0 0 1.819-2.39l5.258-5.259.851.114 2.662-2.662-2.013-.267L18.26.7l-2.662 2.662.114.85-5.259 5.26z" fill="currentColor"/><g transform="translate(.72 2.033)"><path d="M9.434 5.631l1.555-1.555a5.464 5.464 0 0 0-5.627 1.312 5.475 5.475 0 0 0 0 7.739 5.475 5.475 0 0 0 7.738 0 5.471 5.471 0 0 0 1.313-5.632l-1.556 1.556a3.634 3.634 0 1 1-6.195-2.362A3.615 3.615 0 0 1 9.434 5.63z" fill="currentColor" /><path d="M15.754 6.158a7.216 7.216 0 0 1-1.418 8.204 7.218 7.218 0 0 1-10.21 0 7.219 7.219 0 0 1 0-10.21 7.223 7.223 0 0 1 8.204-1.417l1.487-1.487C10.292-.774 5.714-.28 2.704 2.73-.9 6.336-.9 12.179 2.704 15.78c3.606 3.605 9.448 3.605 13.05 0 3.01-3.011 3.504-7.59 1.483-11.114l-1.483 1.491z" fill="currentColor" /></g></g></svg>
    {/if}
    {if $svgId == "left_design"}
        <svg width="20" height="20" viewBox="0 0 22 21" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
            <g fill="none" ><g transform="translate(.595 15.37)"><path fill="currentColor" d="M0 2.625h6.454v2.151H4.733v.86h11.186v-.86h-1.721v-2.15h6.453V.041H0v2.583"/></g><path d="M9.896 4.775c.507-.5 1.232-1.163 2.035-1.838H.595v11.615h20.652V2.937h-3.845c-.204.342-.451.718-.748 1.138-.161.228-.333.462-.514.7h3.455v8h-11.1c-.604.496-1.463.916-2.637.916-.454 0-.935-.065-1.429-.193a.919.919 0 0 1-.67-.723H2.595v-8h7.3z" fill="currentColor"/><g fill="currentColor"><path d="M10.64 9.232L8.79 7.38c-.589.906-.578 1.454-.308 1.843a1.295 1.295 0 0 0-1.028-.304c-1.25.188-1.445 1.695-1.445 1.695A2.473 2.473 0 0 1 4.63 12.57c-.042.02-.031.085.014.096 2.341.608 3.535-.592 4.051-1.4.277-.433.385-.97.202-1.45l-.008-.02a1.407 1.407 0 0 0-.18-.322c.393.332.955.392 1.93-.241M9.307 6.68l2.033 2.035c.354-.29.749-.65 1.196-1.097 2.356-2.356 5.212-6.166 4.622-6.755-.589-.59-4.399 2.265-6.756 4.622-.447.447-.805.842-1.095 1.196"/></g></g></svg>
    {/if}
    {if $svgId == "left_settings"}
        <svg width="20" height="20" viewBox="0 0 19 20" xmlns="http://www.w3.org/2000/svg">
            <path d="M9.72 13.252c.579 0 1.12-.149 1.626-.446a3.364 3.364 0 0 0 1.202-1.191A3.095 3.095 0 0 0 12.994 10c0-.58-.149-1.121-.446-1.626a3.336 3.336 0 0 0-1.202-1.203 3.153 3.153 0 0 0-1.626-.445c-.58 0-1.118.148-1.615.445a3.364 3.364 0 0 0-1.192 1.203A3.153 3.153 0 0 0 6.468 10c0 .58.148 1.117.445 1.615.297.497.694.894 1.192 1.191a3.095 3.095 0 0 0 1.615.446zm6.927-2.339l1.937 1.515c.09.074.141.17.156.29a.525.525 0 0 1-.067.333l-1.87 3.208a.407.407 0 0 1-.234.2.493.493 0 0 1-.323-.022l-2.294-.913c-.594.43-1.122.735-1.582.913l-.334 2.428a.566.566 0 0 1-.167.29.403.403 0 0 1-.278.11H7.849a.403.403 0 0 1-.279-.11.453.453 0 0 1-.145-.29l-.356-2.428c-.624-.252-1.143-.557-1.56-.913l-2.315.913c-.238.104-.424.045-.557-.178L.766 13.05a.525.525 0 0 1-.067-.334.433.433 0 0 1 .156-.29l1.96-1.514A6.964 6.964 0 0 1 2.77 10c0-.4.015-.705.045-.913L.855 7.572a.433.433 0 0 1-.156-.29.525.525 0 0 1 .067-.333l1.87-3.208c.134-.223.32-.282.558-.178l2.316.913a7.19 7.19 0 0 1 1.56-.913l.355-2.428a.453.453 0 0 1 .145-.29.403.403 0 0 1 .279-.11h3.742c.103 0 .196.036.278.11.082.075.137.171.167.29l.334 2.428c.58.223 1.106.527 1.582.913l2.294-.913a.493.493 0 0 1 .323-.022c.096.03.174.096.234.2l1.87 3.208c.06.103.082.215.067.334a.433.433 0 0 1-.156.29l-1.937 1.514c.03.208.044.512.044.913 0 .4-.015.705-.044.913z" fill="currentColor" />
        </svg>
    {/if}
    {if $svgId == "refresh_icon"}
        <svg class="refresh_icon" width="20px" height="20px" viewBox="0 0 612.035 612.035">
            <path d="M323.128,56.236l5.646-9.57l40.17-40.169C271.247-13.921,165.482,13.786,89.65,89.646    C-16.421,195.717-28.355,360.261,53.875,479.49L10.98,522.386l137.7,19.667l-19.667-137.7L94.045,439.32    c-60.978-96.724-49.322-226.078,34.94-310.34C182.229,75.737,253.471,51.479,323.128,56.236z" fill="currentColor"/>
            <path d="M581.392,69.979l-137.7-19.667l19.668,137.7l38.25-38.25c78.726,98.31,72.521,242.186-18.583,333.317    c-61.116,61.117-145.989,84.039-224.882,68.739l-45.65,45.649c105.654,33.799,226.05,8.791,309.895-75.054    c112.858-112.858,119.146-291.979,18.805-412.209L581.392,69.979z" fill="currentColor"/>
        </svg>
    {/if}
    {if $svgId == "user_icon"}
        <svg width="20px" height="20px" viewBox="0 0 43.028 43.028">
            <path fill="currentColor" d="M39.561,33.971l-0.145,0.174c-4.774,5.728-11.133,8.884-17.902,8.884c-6.77,0-13.128-3.155-17.903-8.884l-0.144-0.174
            l0.034-0.223c0.922-6.014,4.064-10.845,8.847-13.606l0.34-0.196l0.271,0.284c2.259,2.37,5.297,3.674,8.554,3.674
            s6.295-1.305,8.554-3.674l0.271-0.284l0.34,0.196c4.783,2.761,7.925,7.592,8.848,13.606L39.561,33.971z M21.514,21.489
            c5.924,0,10.744-4.82,10.744-10.744C32.258,4.821,27.438,0,21.514,0S10.77,4.821,10.77,10.744S15.59,21.489,21.514,21.489z"/>
        </svg>
    {/if}
    {if $svgId == "pass_icon"}
        <svg viewBox="0 0 380 380" width="20px" height="20px">
            <path fill="currentColor" id="XMLID_31_" d="M290,170H125V95c0-35.841,29.159-65,65-65c35.841,0,65,29.159,65,65v30c0,8.284,6.716,15,15,15
            s15-6.716,15-15V95c0-52.383-42.617-95-95-95c-52.383,0-95,42.617-95,95v75h-5c-13.807,0-25,11.193-25,25v160
            c0,13.807,11.193,25,25,25h200c13.807,0,25-11.193,25-25V195C315,181.193,303.807,170,290,170z M160,255c0-16.569,13.431-30,30-30
            c16.568,0,30,13.431,30,30c0,11.103-6.035,20.789-15,25.977V325h-30v-44.023C166.035,275.789,160,266.103,160,255z"/>
        </svg>
    {/if}

    {if $svgId == "tag_social"}
<svg viewBox="0 0 511.999 511.999" width="20px" height="20px">
    <path style="fill:#6F7A80;" d="M383.36,432.794c-4.434,0-8.926-1.12-13.04-3.477L65.249,254.542L370.32,79.772
        c12.497-7.161,28.479-2.912,35.695,9.491c7.216,12.401,2.933,28.259-9.565,35.419L169.77,254.542l226.679,129.864
        c12.498,7.16,16.781,23.017,9.565,35.419C401.174,428.144,392.391,432.794,383.36,432.794z"/>
    <path style="fill:#FCB63E;" d="M418.671,7.836c-45.025,0-81.651,36.302-81.651,80.923c0,44.623,36.628,80.923,81.651,80.923
        c45.02,0,81.648-36.3,81.648-80.923C500.32,44.138,463.692,7.836,418.671,7.836z"/>
    <path style="fill:#48587C;" d="M418.671,342.315c-45.025,0-81.651,36.303-81.651,80.923c0,44.623,36.628,80.923,81.651,80.923
        c45.02,0,81.648-36.3,81.648-80.923C500.32,378.619,463.692,342.315,418.671,342.315z"/>
    <path style="fill:#00D6C1;" d="M93.332,173.619c-45.024,0-81.652,36.303-81.652,80.923c0,44.623,36.629,80.923,81.652,80.923
        c45.022,0,81.648-36.3,81.648-80.923C174.979,209.922,138.353,173.619,93.332,173.619z"/>
    <path style="opacity:0.1;enable-background:new    ;" d="M380.906,88.759c0-37.087,25.313-68.405,59.709-77.932
        c-6.987-1.934-14.341-2.992-21.943-2.992c-45.025,0-81.651,36.302-81.651,80.923c0,44.623,36.628,80.923,81.651,80.923
        c7.602,0,14.956-1.057,21.942-2.992C406.217,157.164,380.906,125.848,380.906,88.759z"/>
    <path style="opacity:0.1;enable-background:new    ;" d="M380.906,423.239c0-37.087,25.313-68.405,59.709-77.931
        c-6.987-1.936-14.34-2.993-21.942-2.993c-45.025,0-81.651,36.303-81.651,80.923c0,44.623,36.628,80.923,81.651,80.923
        c7.602,0,14.956-1.057,21.942-2.992C406.217,491.644,380.906,460.328,380.906,423.239z"/>
    <path style="opacity:0.1;enable-background:new    ;" d="M55.565,254.542c0-37.087,25.314-68.405,59.71-77.931
        c-6.988-1.935-14.341-2.993-21.943-2.993c-45.024,0-81.652,36.303-81.652,80.923c0,44.623,36.629,80.923,81.652,80.923
        c7.602,0,14.956-1.057,21.943-2.992C80.879,322.948,55.565,291.632,55.565,254.542z"/>
    <g>
        <path style="fill:#FFFFFF;" d="M418.671,146.173c-4.328,0-7.837-3.508-7.837-7.837c0-4.329,3.509-7.837,7.837-7.837
            c23.415,0,42.465-18.725,42.465-41.739c0-4.329,3.509-7.837,7.837-7.837c4.328,0,7.837,3.508,7.837,7.837
            C476.809,120.417,450.729,146.173,418.671,146.173z"/>
        <path style="fill:#FFFFFF;" d="M418.671,480.652c-4.328,0-7.837-3.508-7.837-7.837s3.509-7.837,7.837-7.837
            c23.415,0,42.465-18.725,42.465-41.739c0-4.329,3.509-7.837,7.837-7.837c4.328,0,7.837,3.508,7.837,7.837
            C476.809,454.897,450.729,480.652,418.671,480.652z"/>
        <path style="fill:#FFFFFF;" d="M93.332,311.956c-4.328,0-7.837-3.508-7.837-7.837c0-4.329,3.509-7.837,7.837-7.837
            c23.415,0,42.465-18.725,42.465-41.739c0-4.329,3.509-7.837,7.837-7.837c4.328,0,7.837,3.508,7.837,7.837
            C151.469,286.201,125.389,311.956,93.332,311.956z"/>
    </g>
    <path d="M418.671,334.478c-21.834,0-41.858,7.806-57.408,20.739L185.536,254.542l173.695-99.509
        c15.819,13.973,36.641,22.486,59.44,22.486c49.342,0,89.485-39.817,89.485-88.76S468.013,0,418.671,0
        c-49.344,0-89.488,39.817-89.488,88.76c0,1.829,0.074,3.639,0.184,5.442l-171.934,98.499
        c-16.268-16.586-38.986-26.918-64.101-26.918c-49.344,0-89.489,39.817-89.489,88.76s40.145,88.76,89.489,88.76
        c25.116,0,47.833-10.332,64.101-26.918l172.149,98.624c-0.253,2.712-0.399,5.453-0.399,8.23c0,48.943,40.144,88.76,89.488,88.76
        c49.342,0,89.485-39.817,89.485-88.76C508.156,374.296,468.013,334.478,418.671,334.478z M418.671,15.672
        c40.7,0,73.812,32.787,73.812,73.086s-33.112,73.086-73.812,73.086c-40.702,0-73.815-32.787-73.815-73.086
        S377.969,15.672,418.671,15.672z M331.971,110.773c3.103,12.016,8.702,23.044,16.188,32.541l-166.77,95.542
        c-2.233-12.36-7.027-23.849-13.857-33.878L331.971,110.773z M93.332,327.63c-40.702,0-73.816-32.787-73.816-73.086
        s33.114-73.086,73.816-73.086c40.7,0,73.812,32.787,73.812,73.086C167.142,294.843,134.032,327.63,93.332,327.63z M167.531,304.108
        c6.831-10.029,11.626-21.519,13.857-33.879l168.364,96.457c-7.754,9.281-13.621,20.155-17.07,32.037L167.531,304.108z
         M418.671,496.325c-40.702,0-73.815-32.787-73.815-73.086s33.113-73.086,73.815-73.086c40.7,0,73.812,32.787,73.812,73.086
        C492.483,463.539,459.371,496.325,418.671,496.325z"/>
</svg>
    {/if}
    {if $svgId == "tag_email"}
    <svg viewBox="0 0 512 512" width="20px" height="20px">
        <path style="fill:#D18624;" d="M452.174,398.658c0,33.959-26.993,61.489-60.291,61.489H60.291C26.992,460.147,0,432.618,0,398.658
        V175.762c0-33.959,26.992-61.487,60.291-61.487h331.593c33.298,0,60.291,27.528,60.291,61.487L452.174,398.658L452.174,398.658z"/>
        <path style="fill:#EA9924;" d="M252.29,246.916c-7.345-6.933-16.774-10.402-26.202-10.402c-9.428,0-18.858,3.469-26.204,10.402
        L7.562,428.477c10.291,18.884,30.041,31.671,52.729,31.671h331.593c22.688,0,42.439-12.785,52.728-31.671L252.29,246.916z"/>
        <path style="opacity:0.2;fill:#FFFFFF;enable-background:new    ;" d="M391.884,114.275H352.22
        c33.298,0,60.289,27.528,60.289,61.487v222.897c0,33.959-26.991,61.489-60.289,61.489h39.663c33.298,0,60.291-27.53,60.291-61.489
        V175.762C452.174,141.803,425.181,114.275,391.884,114.275z"/>
        <path style="fill:#FCB63E;" d="M391.884,114.275H60.291c-20.32,0-38.279,10.261-49.199,25.97l188.792,178.23
        c7.346,6.935,16.776,10.4,26.204,10.4c9.428,0,18.857-3.465,26.202-10.4l188.794-178.23
        C430.163,124.537,412.204,114.275,391.884,114.275z"/>
        <path style="opacity:0.1;enable-background:new    ;" d="M39.957,398.658V175.762c0-33.959,26.991-61.487,60.29-61.487H60.291
        C26.992,114.275,0,141.803,0,175.762v222.897c0,33.959,26.992,61.489,60.291,61.489h39.956
        C66.948,460.147,39.957,432.618,39.957,398.658z"/>
    </svg>
    {/if}

    {if $svgId == "tag_search"}
    <svg viewBox="0 0 512 512" width="20px" height="20px">
    <polygon style="fill:#384463;" points="290.511,267.647 267.717,290.583 341.705,365.028 364.502,342.093 "/>
    <path style="fill:#46D8BA;" d="M501.016,456.65c12.586,12.663,12.586,33.192,0,45.855l0,0c-12.586,12.66-32.988,12.66-45.571,0
        L347.211,393.604c-12.586-12.662-12.586-33.191,0-45.853l0,0c12.584-12.662,32.985-12.662,45.571,0L501.016,456.65z"/>
    <path style="opacity:0.2;fill:#FFFFFF;enable-background:new    ;" d="M501.016,456.65L392.782,347.751
        c-12.586-12.662-32.987-12.662-45.571,0c-2.495,2.51-4.487,5.332-5.992,8.337c12.053-6.019,27.067-3.986,37.109,6.117
        l108.234,108.899c10.091,10.152,12.083,25.359,5.992,37.515c3.053-1.525,5.918-3.557,8.463-6.115
        C513.602,489.841,513.602,469.313,501.016,456.65z"/>
    <path style="fill:#48587C;" d="M279.188,40.389c70.994,60.67,79.718,167.704,19.483,239.067
        c-60.233,71.365-166.614,80.036-237.607,19.364C-9.931,238.152-18.653,131.117,41.581,59.753
        C101.814-11.613,208.195-20.283,279.188,40.389z"/>
    <path style="opacity:0.2;fill:#FFFFFF;enable-background:new    ;" d="M279.188,40.389C208.195-20.283,101.814-11.613,41.581,59.753
        c-1.781,2.11-3.491,4.254-5.147,6.426c61.366-62.366,161.149-67.516,228.8-9.702c68.869,58.853,79.135,161.335,24.702,232.565
        c3.008-3.059,5.924-6.253,8.735-9.587C358.906,208.093,350.183,101.058,279.188,40.389z"/>
    <path style="opacity:0.1;enable-background:new    ;" d="M50.928,289.534c65.831,66.238,172.565,66.238,238.395,0
        c1.946-1.957,3.825-3.956,5.652-5.986c-66.228,57.174-166.101,54.202-228.832-8.916C2.283,210.38,0.375,107.402,60.414,40.83
        c-3.245,2.805-6.41,5.75-9.486,8.844C-14.903,115.91-14.903,223.299,50.928,289.534z"/>
    <path style="fill:#CAD0D1;" d="M49.521,169.235c-0.203-66.501,53.735-120.44,120.236-120.236
        c66.5,0.202,120.771,54.475,120.974,120.974c0.203,66.501-53.735,120.44-120.235,120.236
        C103.995,290.006,49.724,235.735,49.521,169.235z"/>
    <path style="opacity:0.1;enable-background:new    ;" d="M192.896,267.617c-66.5-0.205-120.771-54.477-120.975-120.975
        c-0.084-27.324,8.979-52.523,24.292-72.721c-28.49,21.989-46.811,56.508-46.692,95.314c0.203,66.499,54.475,120.77,120.975,120.974
        c39.177,0.119,73.989-18.556,95.943-47.517C246.105,258.388,220.592,267.7,192.896,267.617z"/>
    <path style="fill:#48587C;" d="M385.58,324.428c8.479,8.531,8.479,22.36,0,30.892l-32.747,32.951
        c-8.48,8.527-22.225,8.527-30.702-0.001l0,0c-8.479-8.531-8.479-22.361,0-30.891l32.749-32.949
        C363.357,315.896,377.104,315.896,385.58,324.428L385.58,324.428z"/>
    <path style="fill:#FFFFFF;" d="M255.669,157.373c-3.676,0-7.001-2.522-7.867-6.257c-3.389-14.598-10.763-27.93-21.325-38.558
        c-15.03-15.122-35.042-23.447-56.35-23.447c-4.465,0-8.084-3.621-8.084-8.084s3.62-8.084,8.084-8.084
        c25.646,0,49.731,10.023,67.818,28.22c12.684,12.761,21.537,28.771,25.608,46.299c1.009,4.349-1.698,8.692-6.048,9.703
        C256.89,157.304,256.275,157.373,255.669,157.373z"/>
</svg>
    {/if}

    {if $svgId == "tag_referral"}
    <svg viewBox="0 0 512 512" width="20px" height="20px">
        <path style="fill:#48587C;" d="M257.312,376.588l-105.112,104.48c-28.98,28.805-76.132,28.805-105.114,0l-17.517-17.413
        c-28.978-28.804-28.978-75.676,0-104.479l105.114-104.481c28.978-28.806,76.131-28.806,105.112,0l17.52,17.414
        c14.038,13.954,21.769,32.504,21.769,52.239C279.084,344.082,271.352,362.635,257.312,376.588z M64.608,394.001
        c-9.66,9.603-9.66,25.225,0,34.827l17.519,17.412c9.66,9.602,25.377,9.602,35.038,0l105.112-104.479
        c4.68-4.651,7.257-10.837,7.257-17.414c0-6.578-2.577-12.76-7.255-17.41l-17.522-17.416c-9.658-9.603-25.374-9.603-35.035,0
        L64.608,394.001z"/>
        <path style="opacity:0.1;enable-background:new    ;" d="M173.096,460.175c-14.039,13.955-32.704,21.639-52.556,21.639
        c-19.854,0-38.518-7.684-52.557-21.641L50.465,442.76c-14.041-13.954-21.77-32.504-21.77-52.239
        c0-18.511,6.805-35.984,19.234-49.595L29.606,359.14c-14.037,13.953-21.769,32.507-21.769,52.241
        c0,19.735,7.729,38.286,21.77,52.239l17.517,17.412c14.039,13.957,32.703,21.641,52.557,21.641c19.852,0,38.517-7.684,52.556-21.639
        L173.096,460.175z"/>
        <path id="SVGCleanerId_0" style="fill:#48587C;" d="M482.428,152.825L377.316,257.307c-14.038,13.955-32.704,21.639-52.556,21.639
        c-19.854,0-38.518-7.684-52.557-21.641l-17.517-17.412c-14.041-13.954-21.77-32.504-21.77-52.239
        c0-19.734,7.732-38.288,21.77-52.241l105.112-104.48c28.978-28.805,76.132-28.805,105.112,0l17.52,17.413
        C511.409,77.15,511.409,124.021,482.428,152.825z M289.722,170.239c-4.68,4.651-7.256,10.837-7.256,17.414
        c0,6.578,2.577,12.76,7.256,17.411l17.52,17.414c4.68,4.652,10.901,7.214,17.519,7.214c6.617,0,12.84-2.562,17.519-7.212
        l105.113-104.48c9.66-9.604,9.66-25.226-0.001-34.829L429.873,65.76c-9.66-9.603-25.376-9.603-35.038-0.001L289.722,170.239z"/>
        <g>
            <path id="SVGCleanerId_0_1_" style="fill:#48587C;" d="M482.428,152.825L377.316,257.307
        c-14.038,13.955-32.704,21.639-52.556,21.639c-19.854,0-38.518-7.684-52.557-21.641l-17.517-17.412
        c-14.041-13.954-21.77-32.504-21.77-52.239c0-19.734,7.732-38.288,21.77-52.241l105.112-104.48
        c28.978-28.805,76.132-28.805,105.112,0l17.52,17.413C511.409,77.15,511.409,124.021,482.428,152.825z M289.722,170.239
        c-4.68,4.651-7.256,10.837-7.256,17.414c0,6.578,2.577,12.76,7.256,17.411l17.52,17.414c4.68,4.652,10.901,7.214,17.519,7.214
        c6.617,0,12.84-2.562,17.519-7.212l105.113-104.48c9.66-9.604,9.66-25.226-0.001-34.829L429.873,65.76
        c-9.66-9.603-25.376-9.603-35.038-0.001L289.722,170.239z"/>
        </g>
        <path style="opacity:0.1;enable-background:new    ;" d="M398.251,236.285c-14.012,13.983-32.662,21.703-52.514,21.741
        c-19.854,0.04-38.534-7.608-52.599-21.537l-17.551-17.378c-14.067-13.925-21.834-32.461-21.873-52.196
        c-0.037-18.511,6.734-35.997,19.137-49.633l-18.288,18.249c-14.011,13.981-21.707,32.55-21.668,52.284
        c0.039,19.735,7.804,38.27,21.873,52.196l17.55,17.378c14.066,13.93,32.745,21.576,52.599,21.537
        c19.852-0.039,38.502-7.759,52.514-21.741L398.251,236.285z"/>
        <path style="fill:#789DB0;" d="M349.285,194.618L194.247,348.727c-9.677,9.616-25.362,9.616-35.038,0
        c-9.676-9.617-9.676-25.21,0-34.827L314.25,159.792c9.675-9.617,25.361-9.617,35.035,0
        C358.962,169.409,358.962,185.002,349.285,194.618z"/>
        <path style="opacity:0.2;fill:#FFFFFF;enable-background:new    ;" d="M349.285,159.792c-9.675-9.617-25.361-9.617-35.035,0
        l-32.625,32.763c9.674-9.617,25.362-9.617,35.034,0c8.896,8.841,9.591,22.718,2.132,32.374l30.494-30.31
        C358.962,185.002,358.962,169.409,349.285,159.792z"/>
        <path style="opacity:0.1;enable-background:new    ;" d="M192.204,316.313c-9.676-9.617-9.676-25.21,0-34.827L159.209,313.9
        c-9.676,9.617-9.676,25.21,0,34.827c9.676,9.616,25.361,9.616,35.038,0l30.346-30.163
        C214.885,325.831,201.043,325.098,192.204,316.313z"/>
        <path d="M487.953,42.787l-17.519-17.413C454.94,9.973,434.313,1.492,412.354,1.492c-21.961,0-42.587,8.481-58.081,23.882
        l-105.112,104.48c-15.53,15.436-24.083,35.962-24.083,57.799c0,14.064,3.573,27.571,10.25,39.534l-8.308,8.258
        c-12.031-6.639-25.623-10.192-39.783-10.192c-21.96,0-42.586,8.482-58.08,23.883L24.046,353.618
        C8.539,369.03-0.001,389.557,0,411.415c0,21.858,8.539,42.385,24.045,57.797l17.518,17.413
        c15.495,15.401,36.121,23.882,58.081,23.882s42.587-8.481,58.081-23.882l105.111-104.48c15.53-15.435,24.084-35.962,24.084-57.8
        c0-15.801-4.507-30.9-12.871-43.894l6.538-6.498c13.075,8.335,28.271,12.827,44.173,12.827c21.938,0,42.565-8.494,58.081-23.918
        l105.113-104.481C503.46,142.971,512,122.444,512,100.586S503.46,58.2,487.953,42.787z M354.811,154.234
        c-6.158-6.121-14.34-9.492-23.043-9.492c-1.965,0-3.902,0.181-5.798,0.518l74.389-73.943c3.194-3.174,7.453-4.923,11.993-4.923
        c4.54,0,8.801,1.748,11.994,4.924l17.518,17.412c3.182,3.162,4.934,7.373,4.934,11.855c0,4.484-1.752,8.695-4.933,11.858
        l-82.402,81.906c3.197-5.096,4.915-10.986,4.915-17.144C364.381,168.525,360.982,160.366,354.811,154.234z M319.774,165.349
        c3.201-3.182,7.461-4.934,11.992-4.934c4.534,0,8.793,1.752,11.994,4.934c3.189,3.17,4.944,7.38,4.944,11.856
        c0,4.475-1.756,8.684-4.944,11.854L188.723,343.168c-3.203,3.182-7.462,4.934-11.995,4.934c-4.533,0-8.793-1.752-11.994-4.934
        c-3.188-3.169-4.944-7.38-4.944-11.855c0-4.476,1.756-8.686,4.944-11.855L319.774,165.349z M153.685,354.285
        c6.158,6.12,14.341,9.491,23.043,9.491c6.166,0,12.069-1.7,17.178-4.865l-82.266,81.772c-3.194,3.174-7.453,4.923-11.994,4.923
        c-4.541,0-8.8-1.748-11.994-4.923l-17.518-17.411c-3.182-3.163-4.933-7.374-4.933-11.856c0-4.483,1.751-8.694,4.933-11.855
        l74.512-74.062c-0.344,1.901-0.528,3.844-0.528,5.816C144.115,339.994,147.513,348.151,153.685,354.285z M271.247,324.347
        c0,17.633-6.91,34.211-19.459,46.683l-105.111,104.48c-12.539,12.462-29.24,19.325-47.032,19.325
        c-17.79,0-34.494-6.863-47.032-19.325l-17.518-17.413c-12.524-12.449-19.422-29.027-19.422-46.682
        c-0.001-17.655,6.897-34.233,19.422-46.682l105.114-104.482c12.537-12.462,29.239-19.325,47.03-19.325
        c9.875,0,19.405,2.134,28.081,6.151l-27.591,27.424c-0.164-0.002-0.326-0.019-0.49-0.019c-8.708,0-16.892,3.367-23.043,9.48
        L59.083,388.443c-6.163,6.126-9.557,14.285-9.557,22.971c0,8.687,3.394,16.846,9.557,22.972l17.519,17.412
        c6.15,6.114,14.334,9.48,23.043,9.48s16.894-3.367,23.043-9.48l105.11-104.478c6.171-6.132,9.57-14.291,9.57-22.973
        c0-2.288-0.252-4.537-0.715-6.725l25.983-25.828C268.255,301.611,271.247,312.751,271.247,324.347z M476.904,147.267
        L371.791,251.749c-12.56,12.484-29.262,19.36-47.032,19.36c-11.66,0-22.859-2.964-32.73-8.528l25.928-25.771
        c2.212,0.467,4.487,0.721,6.803,0.721c8.702,0,16.885-3.37,23.043-9.491l105.114-104.481c6.163-6.127,9.557-14.286,9.556-22.973
        c0-8.686-3.395-16.845-9.558-22.971l-17.518-17.412c-6.151-6.114-14.335-9.48-23.044-9.48s-16.892,3.367-23.043,9.479
        l-105.113,104.48c-6.17,6.133-9.568,14.291-9.568,22.972c0,0.153,0.016,0.301,0.018,0.452l-27.657,27.491
        c-4.073-8.637-6.237-18.122-6.237-27.944c0-17.632,6.91-34.211,19.458-46.683l105.112-104.48
        c12.538-12.462,29.239-19.325,47.032-19.325c17.79,0,34.493,6.863,47.031,19.325l17.52,17.413
        c12.523,12.45,19.422,29.028,19.422,46.683S489.428,134.817,476.904,147.267z"/>
    </svg>
    {/if}

    {if $svgId == "tag_unknown"}
    <svg viewBox="0 0 512 512" width="20px" height="20px">
        <path style="fill:#48587C;" d="M255.999,0C152.373,0,68.365,83.663,68.365,186.864c0,38.948,11.969,75.108,32.441,105.043
        l124.317,202.354l-0.067-0.156l0.092,0.156C231.51,505.237,243.271,512,255.999,512s24.49-6.763,30.853-17.739l124.153-202.084
        c20.583-29.986,32.629-66.245,32.629-105.312C443.634,83.663,359.626,0,255.999,0z M255.999,249.86
        c-34.935,0-63.255-28.204-63.255-62.996c0-34.791,28.321-62.996,63.255-62.996s63.255,28.204,63.255,62.996
        S290.935,249.86,255.999,249.86z"/>
        <g style="opacity:0.2;">
            <path style="fill:#FFFFFF;" d="M232.249,13.01c110.01,0,199.511,89.133,199.511,198.692c0,21.867-3.559,43.295-10.455,63.62
        c14.241-26.332,22.331-56.451,22.331-88.456C443.634,83.663,359.626,0,255.999,0c-35.505,0-68.702,9.824-97.012,26.886
        C181.679,17.935,206.395,13.01,232.249,13.01z"/>
        </g>
        <g style="opacity:0.1;">
            <path id="SVGCleanerId_0" d="M267.9,500.546l-0.107-0.184l0.079,0.184L120.581,260.798
        c-24.253-35.466-38.432-78.309-38.432-124.454c0-7.642,0.388-15.194,1.147-22.638c-9.61,22.469-14.931,47.193-14.931,73.156
        c0,38.948,11.969,75.108,32.441,105.043L225.123,494.26l-0.067-0.156l0.092,0.156c6.362,10.978,18.123,17.74,30.852,17.74
        c6.077,0,11.929-1.557,17.084-4.365C271.136,505.48,269.39,503.115,267.9,500.546z"/>
            <g>
                <path id="SVGCleanerId_0_1_" d="M267.9,500.546l-0.107-0.184l0.079,0.184L120.581,260.798
        c-24.253-35.466-38.432-78.309-38.432-124.454c0-7.642,0.388-15.194,1.147-22.638c-9.61,22.469-14.931,47.193-14.931,73.156
        c0,38.948,11.969,75.108,32.441,105.043L225.123,494.26l-0.067-0.156l0.092,0.156c6.362,10.978,18.123,17.74,30.852,17.74
        c6.077,0,11.929-1.557,17.084-4.365C271.136,505.48,269.39,503.115,267.9,500.546z"/>
            </g>
        </g>
        <path style="fill:#46D8BA;" d="M255.999,80.423c-59.026,0-106.882,47.657-106.882,106.442s47.855,106.442,106.882,106.442
        s106.879-47.657,106.879-106.442S315.026,80.423,255.999,80.423z M255.999,242.764c-31,0-56.131-25.027-56.131-55.9
        c0-30.872,25.131-55.9,56.131-55.9s56.131,25.028,56.131,55.9C312.13,217.737,287,242.764,255.999,242.764z"/>
    </svg>
    {/if}
    {if $svgId == "modules_icon"}
    <svg viewBox="0 0 512 512" width="60px" height="60px">
        <path style="fill:#FEC9A3;" d="M507.661,503.322V399.907c0-11.325-5.528-21.938-14.805-28.438l-65.25-45.681
            c-4.374-3.063-9.589-4.703-14.935-4.703h-52.536l0.868,148.48c0.321,15.473,10.431,29.028,25.166,33.757H507.661z"/>
        <path style="fill:#FABD91;" d="M455.593,503.322h-60.746c-19.17,0-34.712-15.542-34.712-34.712v-34.712h60.746L455.593,503.322z"/>
        <path style="fill:#88B337;" d="M229.966,60.746c-5.979,0.009-11.889,1.258-17.356,3.662V0H56.407
            C27.648,0,4.339,23.309,4.339,52.068v156.203h64.408c-9.633-21.938,0.338-47.538,22.285-57.17
            c21.938-9.633,47.538,0.338,57.17,22.285c4.886,11.116,4.886,23.778,0,34.894h64.408v-64.408
            c21.938,9.633,47.538-0.338,57.17-22.285s-0.338-47.538-22.285-57.17C241.976,61.978,236.006,60.737,229.966,60.746z"/>
        <path style="fill:#E8594A;" d="M420.881,52.068C420.881,23.309,397.572,0,368.814,0H212.61v64.408
            c21.938-9.633,47.538,0.338,57.17,22.285c9.633,21.938-0.338,47.538-22.285,57.17c-11.116,4.886-23.778,4.886-34.894,0v64.408
            h64.408c-9.633,21.938,0.338,47.538,22.285,57.17c21.938,9.633,47.538-0.338,57.17-22.285c4.886-11.116,4.886-23.778,0-34.894
            h64.417V52.068z"/>
        <path style="fill:#D65245;" d="M420.881,57.023C371.278,126.03,281.73,165.228,212.61,186.325v21.947h64.408
            c-9.633,21.938,0.338,47.538,22.285,57.17c21.938,9.633,47.538-0.338,57.17-22.285c4.886-11.116,4.886-23.778,0-34.894h64.408
            V57.023z"/>
        <path style="fill:#FDB62F;" d="M195.254,277.695c5.979,0.009,11.889,1.258,17.356,3.662v-73.086h-64.408
            c9.633-21.938-0.338-47.538-22.285-57.17c-21.947-9.633-47.538,0.338-57.17,22.285c-4.886,11.116-4.886,23.778,0,34.894H4.339
            v156.203c0,28.759,23.309,52.068,52.068,52.068H212.61v-55.73c-21.938,9.633-47.538-0.338-57.17-22.285
            c-9.633-21.938,0.338-47.538,22.285-57.17C183.244,278.927,189.214,277.686,195.254,277.695z"/>
        <path style="fill:#FFA719;" d="M4.339,364.475c0,28.759,23.309,52.068,52.068,52.068H212.61v-55.73
            c-21.834,9.615-47.33-0.286-56.945-22.12c-2.23-5.068-3.471-10.526-3.645-16.063c-46.523,20.749-96.751,31.918-147.682,32.846
            V364.475z"/>
        <path style="fill:#4398D1;" d="M443.574,389.641l-54.906-146.658l-60.303,22.71c16.809,17.122,16.549,44.631-0.573,61.431
            c-17.122,16.801-44.631,16.549-61.431-0.573c-8.556-8.721-13.052-20.636-12.375-32.837l-60.295,22.71l25.687,68.634
            c-5.962-0.338-11.932,0.573-17.529,2.673c-22.407,8.695-33.514,33.905-24.819,56.311c8.548,22.016,33.098,33.202,55.322,25.183
            c5.597-2.109,10.7-5.372,14.969-9.563L266.9,512l146.241-55.079C440.094,446.716,453.71,416.62,443.574,389.641z"/>
        <path style="fill:#3E8FC9;" d="M415.258,314.012c-59.878,89.557-172.127,120.832-237.872,131.601
            c9.225,21.947,34.495,32.256,56.441,23.031c5.025-2.109,9.607-5.163,13.494-8.982L266.9,512l146.241-55.079
            c26.945-10.205,40.552-40.283,30.434-67.254L415.258,314.012z"/>
        <path style="fill:#80A834;" d="M229.966,60.746c-5.979,0.009-11.889,1.258-17.356,3.662V51.816
            C147.63,111.633,59.592,144.67,4.339,160.768v47.503h64.408c-9.633-21.938,0.338-47.538,22.285-57.17
            c21.938-9.633,47.538,0.338,57.17,22.285c4.886,11.116,4.886,23.778,0,34.894h64.408v-64.408
            c21.938,9.633,47.538-0.338,57.17-22.285s-0.338-47.538-22.285-57.17C241.976,61.978,236.006,60.737,229.966,60.746z"/>
        <path style="fill:#FEC9A3;" d="M403.682,390.665c-8.305-8.47-21.903-8.609-30.373-0.304c-8.47,8.305-8.609,21.903-0.304,30.373
            c0.104,0.104,0.2,0.208,0.304,0.304l30.217,30.217c0,28.759,23.309,52.068,52.068,52.068l0,0h52.068v-8.678L403.682,390.665z"/>
        </svg>
    {/if}
{/strip}
