{if !$width}{assign var="width" value="40"}{/if}
{if !$height}{assign var="height" value="40"}{/if}
{if !$fill}{assign var="fill" value="#000000"}{/if}
{strip}
{if $svgId == "search_icon"}
    <svg viewBox="0 0 512 512" width="30px" height="30px">
        <path fill="currentColor" d="M495,466.2L377.2,348.4c29.2-35.6,46.8-81.2,46.8-130.9C424,103.5,331.5,11,217.5,11C103.4,11,11,103.5,11,217.5   S103.4,424,217.5,424c49.7,0,95.2-17.5,130.8-46.7L466.1,495c8,8,20.9,8,28.9,0C503,487.1,503,474.1,495,466.2z M217.5,382.9   C126.2,382.9,52,308.7,52,217.5S126.2,52,217.5,52C308.7,52,383,126.3,383,217.5S308.7,382.9,217.5,382.9z"/>
    </svg>
{/if}
{if $svgId == "exit_icon"}
<svg viewBox="0 -10 490.66667 490" width="30px" height="30px">
    <path fill="currentColor" d="m474.667969 251h-309.335938c-8.832031 0-16-7.167969-16-16s7.167969-16 16-16h309.335938c8.832031 0 16 7.167969 16 16s-7.167969 16-16 16zm0 0"/>
    <path fill="currentColor" d="m250.667969 336.332031c-4.097657 0-8.191407-1.554687-11.308594-4.691406l-85.332031-85.332031c-6.25-6.253906-6.25-16.386719 0-22.636719l85.332031-85.332031c6.25-6.25 16.382813-6.25 22.636719 0 6.25 6.25 6.25 16.382812 0 22.632812l-74.027344 74.027344 74.027344 74.027344c6.25 6.25 6.25 16.382812 0 22.632812-3.136719 3.117188-7.234375 4.671875-11.328125 4.671875zm0 0"/>
    <path fill="currentColor" d="m234.667969 469.667969c-129.386719 0-234.667969-105.28125-234.667969-234.667969s105.28125-234.667969 234.667969-234.667969c97.085937 0 182.804687 58.410157 218.410156 148.824219 3.242187 8.210938-.8125 17.492188-9.023437 20.753906-8.214844 3.203125-17.496094-.789062-20.757813-9.042968-30.742187-78.082032-104.789063-128.535157-188.628906-128.535157-111.746094 0-202.667969 90.925781-202.667969 202.667969s90.921875 202.667969 202.667969 202.667969c83.839843 0 157.886719-50.453125 188.628906-128.511719 3.242187-8.257812 12.523437-12.246094 20.757813-9.046875 8.210937 3.242187 12.265624 12.542969 9.023437 20.757813-35.605469 90.390624-121.324219 148.800781-218.410156 148.800781zm0 0"/>
</svg>
{/if}
{if $svgId == "currency_icon"}
    <svg width="20px" height="20px" viewBox="0 0 47 47">
        <path fill="currentColor" d="M20.71,15.82c0.233-2.532,1.131-4.87,2.518-6.847C22.1,3.848,17.527,0,12.07,0C5.77,0,0.643,5.127,0.643,11.429
        c0,5.484,3.884,10.075,9.046,11.174C12.286,19.064,16.201,16.563,20.71,15.82z M7.499,14.149c0-0.416,0.319-0.737,0.736-0.737
        h2.345v-0.548l-0.321-0.548H8.234c-0.417,0-0.736-0.321-0.736-0.737s0.319-0.737,0.736-0.737h1.153l-2.494-4.1
        c-0.132-0.227-0.264-0.51-0.264-0.775c0-1.039,0.964-1.379,1.624-1.379c0.794,0,1.153,0.624,1.286,0.888l2.532,4.819l2.53-4.819
        c0.135-0.264,0.492-0.888,1.284-0.888c0.662,0,1.625,0.341,1.625,1.379c0,0.265-0.132,0.548-0.263,0.774l-2.495,4.101h1.152
        c0.415,0,0.736,0.321,0.736,0.737s-0.321,0.737-0.736,0.737h-2.021l-0.321,0.548v0.548h2.343c0.415,0,0.736,0.321,0.736,0.737
        s-0.321,0.737-0.736,0.737h-2.343v1.87c0,0.907-0.549,1.512-1.491,1.512c-0.945,0-1.492-0.605-1.492-1.512v-1.87H8.234
        C7.817,14.886,7.499,14.565,7.499,14.149z"/>
        <path fill="currentColor" d="M34.929,5.714c-5.769,0-10.541,4.302-11.309,9.864c2.181,0.016,4.259,0.447,6.175,1.207
        c0.127-0.292,0.389-0.475,0.797-0.475h0.396c-0.396-0.567-0.566-1.285-0.566-2.022c0-2.342,2.078-3.986,4.742-3.986
        c3.31,0,4.914,1.776,4.914,3.25c0,0.851-0.586,1.323-1.418,1.323c-1.662,0-0.643-2.305-3.193-2.305
        c-1.114,0-2.172,0.662-2.172,1.889c0,0.643,0.32,1.285,0.623,1.852h2.06c0.774,0,1.172,0.284,1.172,0.907
        s-0.397,0.906-1.172,0.906h-1.494c0.058,0.152,0.097,0.284,0.097,0.454c0,0.305-0.076,0.607-0.194,0.902
        c0.618,0.51,1.188,1.076,1.729,1.667c0.524,0.106,0.991,0.228,1.545,0.228c0.319,0,1.098-0.208,1.397-0.208
        c0.698,0,1.096,0.529,1.096,1.208c0,1.066-0.954,1.529-1.937,1.593c0.652,1.095,1.195,2.259,1.596,3.49
        c3.861-1.835,6.545-5.763,6.545-10.317C46.356,10.841,41.229,5.714,34.929,5.714z"/>
        <path fill="currentColor" d="M24.257,34.076v4.676c1.415-0.094,2.905-0.755,2.905-2.314C27.162,34.831,25.529,34.359,24.257,34.076z"/>
        <path fill="currentColor" d="M20.193,28.479c0,1.183,0.875,1.865,2.645,2.221v-4.229C21.23,26.52,20.193,27.463,20.193,28.479z"/>
        <path fill="currentColor" d="M23.5,18.429c-7.877,0-14.287,6.409-14.287,14.286S15.623,47,23.5,47c7.877,0,14.288-6.407,14.288-14.285
        S31.377,18.429,23.5,18.429z M24.257,41.162v1.465c0,0.402-0.31,0.803-0.711,0.803c-0.401,0-0.708-0.4-0.708-0.803v-1.465
        c-3.99-0.094-5.976-2.48-5.976-4.348c0-0.942,0.566-1.486,1.464-1.486c2.645,0,0.589,3.26,4.512,3.425v-4.937
        c-3.498-0.637-5.62-2.172-5.62-4.795c0-3.211,2.668-4.865,5.62-4.959v-1.258c0-0.403,0.307-0.804,0.708-0.804
        c0.401,0,0.711,0.401,0.711,0.804v1.258c1.839,0.049,5.618,1.203,5.618,3.52c0,0.921-0.686,1.462-1.488,1.462
        c-1.535,0-1.514-2.524-4.129-2.573v4.487c3.118,0.662,5.879,1.582,5.879,5.222C30.137,39.344,27.773,40.951,24.257,41.162z"/>
    </svg>
{/if}
{if $svgId == "home_icon"}
    <svg viewBox="0 0 486.988 486.988" width="20px" height="20px">
        <path fill="currentColor" d="M16.822,284.968h39.667v158.667c0,9.35,7.65,17,17,17h116.167c9.35,0,17-7.65,17-17V327.468h70.833v116.167
        c0,9.35,7.65,17,17,17h110.5c9.35,0,17-7.65,17-17V284.968h48.167c6.8,0,13.033-4.25,15.583-10.483
        c2.55-6.233,1.133-13.6-3.683-18.417L260.489,31.385c-6.517-6.517-17.283-6.8-23.8-0.283L5.206,255.785
        c-5.1,4.817-6.517,12.183-3.967,18.7C3.789,281.001,10.022,284.968,16.822,284.968z M248.022,67.368l181.333,183.6h-24.367
        c-9.35,0-17,7.65-17,17v158.667h-76.5V310.468c0-9.35-7.65-17-17-17H189.656c-9.35,0-17,7.65-17,17v116.167H90.489V267.968
        c0-9.35-7.65-17-17-17H58.756L248.022,67.368z"/>
    </svg>
{/if}
{if $svgId == "money_icon"}
<svg viewBox="0 0 611.996 611.996" height="20px" width="20px">
    <path fill="currentColor" d="M588.63,113.193L213.812,33.871c-15.858-3.355-31.576,6.876-34.931,22.734l-7.121,45.762l432.477,91.519l7.121-45.762
    C614.713,132.272,604.488,116.549,588.63,113.193z"/>
    <path fill="currentColor" d="M431.009,203.591c-4.378-15.766-20.854-25.085-36.615-20.714L323.24,202.63l-167.742-35.5l-18.448,87.165L21.786,286.287
    c-15.76,4.372-25.079,20.848-20.708,36.609l64.958,234.078c4.378,15.76,20.855,25.085,36.615,20.708l372.608-103.403
    c15.76-4.378,25.079-20.848,20.708-36.615l-11.15-40.184l41.789,8.835c15.858,3.361,31.576-6.87,34.931-22.728l26.439-124.937
    L437.45,226.797L431.009,203.591z M474.04,322.559l9.215-43.552c1.384-6.521,7.85-10.727,14.37-9.35l43.552,9.221
    c6.527,1.384,10.733,7.843,9.356,14.37l-9.215,43.552c-1.384,6.521-7.849,10.733-14.37,9.35l-43.552-9.215
    C476.863,335.546,472.656,329.08,474.04,322.559z M28.27,309.646l103.115-28.606l243.299-67.517l26.181-7.274
    c0.478-0.129,0.955-0.19,1.421-0.19c2.1,0,4.611,1.378,5.345,4.017l3.074,11.07l9.631,34.704L37.148,362.186l-12.705-45.768
    C23.647,313.546,25.399,310.442,28.27,309.646z M472.601,444.141c0.49,1.776-0.024,3.245-0.545,4.164
    c-0.514,0.918-1.506,2.119-3.282,2.608L96.173,554.316c-0.471,0.129-0.955,0.196-1.421,0.196c-2.1,0-4.611-1.384-5.345-4.023
    L51.519,413.955l383.188-106.342l23.371,84.208L472.601,444.141z"/>
    <path fill="currentColor" d="M156.379,453.484c-1.788-6.429-8.499-10.225-14.928-8.443l-43.515,12.08c-6.423,1.782-10.225,8.499-8.437,14.928
    l12.074,43.509c1.788,6.429,8.499,10.225,14.928,8.437l43.515-12.074c6.429-1.782,10.225-8.499,8.443-14.928L156.379,453.484z"/>
</svg>
{/if}
{if $svgId == "delivery_icon"}
<svg viewBox="0 0 512 512" height="20px" width="20px">
    <path fill="currentColor" d="M386.689,304.403c-35.587,0-64.538,28.951-64.538,64.538s28.951,64.538,64.538,64.538
    c35.593,0,64.538-28.951,64.538-64.538S422.276,304.403,386.689,304.403z M386.689,401.21c-17.796,0-32.269-14.473-32.269-32.269
    c0-17.796,14.473-32.269,32.269-32.269c17.796,0,32.269,14.473,32.269,32.269C418.958,386.738,404.485,401.21,386.689,401.21z"/>
    <path fill="currentColor" d="M166.185,304.403c-35.587,0-64.538,28.951-64.538,64.538s28.951,64.538,64.538,64.538s64.538-28.951,64.538-64.538
    S201.772,304.403,166.185,304.403z M166.185,401.21c-17.796,0-32.269-14.473-32.269-32.269c0-17.796,14.473-32.269,32.269-32.269
    c17.791,0,32.269,14.473,32.269,32.269C198.454,386.738,183.981,401.21,166.185,401.21z"/>
    <path fill="currentColor" d="M430.15,119.675c-2.743-5.448-8.32-8.885-14.419-8.885h-84.975v32.269h75.025l43.934,87.384l28.838-14.5L430.15,119.675z"
    />
    <rect fill="currentColor" x="216.202" y="353.345" width="122.084" height="32.269"/>
    <path fill="currentColor" d="M117.781,353.345H61.849c-8.912,0-16.134,7.223-16.134,16.134c0,8.912,7.223,16.134,16.134,16.134h55.933
    c8.912,0,16.134-7.223,16.134-16.134C133.916,360.567,126.693,353.345,117.781,353.345z"/>
    <path fill="currentColor" d="M508.612,254.709l-31.736-40.874c-3.049-3.937-7.755-6.239-12.741-6.239H346.891V94.655
    c0-8.912-7.223-16.134-16.134-16.134H61.849c-8.912,0-16.134,7.223-16.134,16.134s7.223,16.134,16.134,16.134h252.773v112.941
    c0,8.912,7.223,16.134,16.134,16.134h125.478l23.497,30.268v83.211h-44.639c-8.912,0-16.134,7.223-16.134,16.134
    c0,8.912,7.223,16.134,16.134,16.134h60.773c8.912,0,16.134-7.223,16.135-16.134V264.605
    C512,261.023,510.806,257.538,508.612,254.709z"/>
    <path fill="currentColor" d="M116.706,271.597H42.487c-8.912,0-16.134,7.223-16.134,16.134c0,8.912,7.223,16.134,16.134,16.134h74.218
    c8.912,0,16.134-7.223,16.134-16.134C132.84,278.82,125.617,271.597,116.706,271.597z"/>
    <path fill="currentColor" d="M153.815,208.134H16.134C7.223,208.134,0,215.357,0,224.269s7.223,16.134,16.134,16.134h137.681
    c8.912,0,16.134-7.223,16.134-16.134S162.727,208.134,153.815,208.134z"/>
    <path fill="currentColor" d="M180.168,144.672H42.487c-8.912,0-16.134,7.223-16.134,16.134c0,8.912,7.223,16.134,16.134,16.134h137.681
    c8.912,0,16.134-7.223,16.134-16.134C196.303,151.895,189.08,144.672,180.168,144.672z"/>
</svg>
{/if}
{if $svgId == "description_icon"}
<svg viewBox="0 0 26.738 26.738" height="20px" width="20px">
    <path fill="currentColor" d="M16.466,5.957H6.211V4.233h10.255V5.957z M20.492,4.233h-2.546v1.724h2.546V4.233z M6.211,9.26
    h14.281V7.536H6.211V9.26z M13.024,10.84v1.724h7.467V10.84H13.024z M11.58,10.84H6.211v1.724h5.368
    C11.579,12.564,11.579,10.84,11.58,10.84z M6.211,15.867h14.281v-1.724H6.211V15.867z M14.299,17.446H6.211v1.724h8.087
    C14.298,19.17,14.298,17.446,14.299,17.446z M15.708,17.446v1.724h4.783v-1.724H15.708z M6.211,22.474h14.281V20.75H6.211V22.474z
    M24.621,3.167v20.404c0,1.746-1.244,3.167-2.773,3.167H4.889c-1.529,0-2.773-1.421-2.773-3.167V3.167C2.116,1.421,3.36,0,4.889,0
    h16.959C23.377,0,24.621,1.421,24.621,3.167z M22.97,3.167c0-0.821-0.513-1.515-1.121-1.515H4.889
    c-0.608,0-1.121,0.694-1.121,1.515v20.404c0,0.821,0.513,1.515,1.121,1.515h16.959c0.608,0,1.121-0.694,1.121-1.515V3.167z"/>
</svg>
{/if}
{if $svgId == "features_icon"}
<svg width="20px" height="20px" viewBox="0 0 428.703 428.703">
    <path fill="currentColor" d="M45.292,56.132C20.316,56.132,0,76.449,0,101.424c0,24.976,20.316,45.295,45.292,45.295
    c24.974,0,45.292-20.319,45.292-45.295C90.584,76.45,70.266,56.132,45.292,56.132z M45.292,124.872
    c-12.927,0-23.444-10.52-23.444-23.447c0-12.927,10.518-23.443,23.444-23.443c12.926,0,23.444,10.517,23.444,23.443
    C68.737,114.352,58.219,124.872,45.292,124.872z"/>
    <path fill="currentColor" d="M127.252,118.775h284.102c9.584,0,17.35-7.77,17.35-17.35c0-9.582-7.766-17.35-17.35-17.35H127.252
    c-9.579,0-17.35,7.768-17.35,17.35C109.903,111.005,117.673,118.775,127.252,118.775z"/>
    <path fill="currentColor" d="M45.292,169.06C20.316,169.06,0,189.376,0,214.352c0,24.976,20.316,45.292,45.292,45.292
    c24.974,0,45.292-20.316,45.292-45.292C90.584,189.376,70.266,169.06,45.292,169.06z M45.292,237.796
    c-12.927,0-23.444-10.518-23.444-23.444s10.518-23.443,23.444-23.443c12.926,0,23.444,10.517,23.444,23.443
    C68.737,227.28,58.219,237.796,45.292,237.796z"/>
    <path fill="currentColor" d="M411.354,197.001H127.252c-9.579,0-17.35,7.769-17.35,17.35s7.771,17.351,17.35,17.351h284.102
    c9.584,0,17.35-7.77,17.35-17.351S420.938,197.001,411.354,197.001z"/>
    <path fill="currentColor" d="M45.292,281.984C20.316,281.984,0,302.305,0,327.279c0,24.976,20.316,45.292,45.292,45.292
    c24.974,0,45.292-20.316,45.292-45.292C90.584,302.305,70.266,281.984,45.292,281.984z M45.292,350.724
    c-12.927,0-23.444-10.517-23.444-23.444c0-12.927,10.518-23.446,23.444-23.446c12.926,0,23.444,10.52,23.444,23.446
    C68.736,340.207,58.219,350.724,45.292,350.724z"/>
    <path fill="currentColor" d="M411.354,309.928H127.252c-9.579,0-17.35,7.77-17.35,17.351s7.771,17.351,17.35,17.351h284.102
    c9.584,0,17.35-7.77,17.35-17.351S420.938,309.928,411.354,309.928z"/>
</svg>
{/if}
{if $svgId == "no_image"}
    <svg width="26px" height="26px" viewBox="0 0 455 455">
        <path d="M360.967,130.599c-4.06-0.818-8.018,1.8-8.841,5.86c-0.823,4.06,1.801,8.018,5.86,8.841
        c1.147,0.232,2.013,1.286,2.013,2.45v160c0,1.355-1.145,2.5-2.5,2.5H179.676c-4.142,0-7.5,3.357-7.5,7.5s3.358,7.5,7.5,7.5H357.5
        c9.649,0,17.5-7.851,17.5-17.5v-160C375,139.46,369.099,132.247,360.967,130.599z" fill="currentColor"/>
        <path d="M274.824,130.25H97.5c-9.649,0-17.5,7.851-17.5,17.5v160c0,8.063,5.48,15.046,13.326,16.982
        c0.604,0.149,1.208,0.221,1.803,0.221c3.369,0,6.432-2.287,7.276-5.705c0.992-4.021-1.463-8.086-5.484-9.078
        c-0.955-0.235-1.92-1.143-1.92-2.42v-160c0-1.355,1.145-2.5,2.5-2.5h177.324c4.142,0,7.5-3.357,7.5-7.5
        S278.966,130.25,274.824,130.25z" fill="currentColor"/>
        <path d="M235.363,170.798c-2.655-0.363-5.3-0.548-7.863-0.548c-31.706,0-57.5,25.794-57.5,57.5c0,2.563,0.185,5.209,0.548,7.863
        c0.515,3.759,3.731,6.483,7.421,6.483c0.339,0,0.682-0.023,1.027-0.07c4.104-0.562,6.975-4.345,6.413-8.448
        c-0.271-1.982-0.409-3.943-0.409-5.828c0-23.435,19.065-42.5,42.5-42.5c1.884,0,3.845,0.138,5.828,0.409
        c4.108,0.564,7.886-2.309,8.448-6.413C242.338,175.143,239.467,171.359,235.363,170.798z" fill="currentColor"/>
        <path d="M219.127,284.636c2.789,0.407,5.605,0.614,8.373,0.614c31.706,0,57.5-25.794,57.5-57.5c0-2.77-0.207-5.587-0.613-8.373
        c-0.599-4.099-4.408-6.934-8.505-6.337c-4.099,0.599-6.936,4.406-6.337,8.505c0.303,2.071,0.456,4.158,0.456,6.205
        c0,23.435-19.065,42.5-42.5,42.5c-2.044,0-4.132-0.153-6.205-0.456c-4.099-0.6-7.907,2.238-8.505,6.337
        S215.028,284.037,219.127,284.636z" fill="currentColor"/>
        <path d="M318.5,203.25c9.098,0,16.5-7.402,16.5-16.5c0-8.318-6.227-15.355-14.484-16.37c-2.293-0.277-4.585,0.509-6.218,2.142
        l-10.027,10.027c-1.633,1.632-2.422,3.926-2.141,6.217C303.145,197.023,310.183,203.25,318.5,203.25z" fill="currentColor"/>
        <path d="M117.5,114.75h30c4.142,0,7.5-3.357,7.5-7.5s-3.358-7.5-7.5-7.5h-30c-4.142,0-7.5,3.357-7.5,7.5
        S113.358,114.75,117.5,114.75z" fill="currentColor"/>
        <path d="M388.367,66.633C345.397,23.664,288.268,0,227.5,0S109.603,23.664,66.633,66.633C23.664,109.603,0,166.732,0,227.5
        s23.664,117.897,66.633,160.867C109.603,431.336,166.732,455,227.5,455s117.897-23.664,160.867-66.633
        C431.336,345.397,455,288.268,455,227.5S431.336,109.603,388.367,66.633z M15,227.5C15,110.327,110.327,15,227.5,15
        c55.894,0,106.807,21.703,144.783,57.11L72.11,372.283C36.703,334.307,15,283.395,15,227.5z M227.5,440
        c-55.894,0-106.807-21.703-144.783-57.11L382.89,82.717C418.297,120.693,440,171.606,440,227.5C440,344.673,344.673,440,227.5,440z
        " fill="currentColor"/>
    </svg>
{/if}
{if $svgId == "note_icon"}
    <svg viewBox="0 0 512 512" width="30px" height="30px">
        <path fill="currentColor" d="M352.459,220c0-11.046-8.954-20-20-20h-206c-11.046,0-20,8.954-20,20s8.954,20,20,20h206
        C343.505,240,352.459,231.046,352.459,220z"/>
        <path fill="currentColor" d="M126.459,280c-11.046,0-20,8.954-20,20c0,11.046,8.954,20,20,20H251.57c11.046,0,20-8.954,20-20c0-11.046-8.954-20-20-20
        H126.459z"/>
        <path fill="currentColor" d="M173.459,472H106.57c-22.056,0-40-17.944-40-40V80c0-22.056,17.944-40,40-40h245.889c22.056,0,40,17.944,40,40v123
        c0,11.046,8.954,20,20,20c11.046,0,20-8.954,20-20V80c0-44.112-35.888-80-80-80H106.57c-44.112,0-80,35.888-80,80v352
        c0,44.112,35.888,80,80,80h66.889c11.046,0,20-8.954,20-20C193.459,480.954,184.505,472,173.459,472z"/>
        <path fill="currentColor" d="M467.884,289.572c-23.394-23.394-61.458-23.395-84.837-0.016l-109.803,109.56c-2.332,2.327-4.052,5.193-5.01,8.345
        l-23.913,78.725c-2.12,6.98-0.273,14.559,4.821,19.78c3.816,3.911,9,6.034,14.317,6.034c1.779,0,3.575-0.238,5.338-0.727
        l80.725-22.361c3.322-0.92,6.35-2.683,8.79-5.119l109.573-109.367C491.279,351.032,491.279,312.968,467.884,289.572z
        M333.776,451.768l-40.612,11.25l11.885-39.129l74.089-73.925l28.29,28.29L333.776,451.768z M439.615,346.13l-3.875,3.867
        l-28.285-28.285l3.862-3.854c7.798-7.798,20.486-7.798,28.284,0C447.399,325.656,447.399,338.344,439.615,346.13z"/>
        <path fill="currentColor" d="M332.459,120h-206c-11.046,0-20,8.954-20,20s8.954,20,20,20h206c11.046,0,20-8.954,20-20S343.505,120,332.459,120z"/>
    </svg>
{/if}
{if $svgId == "comment_icon"}
    <svg width="30px" height="30px" viewBox="0 0 511.62 511.619">
        <path fill="currentColor" d="M301.923,327.602c30.93-13.038,55.34-30.785,73.228-53.248c17.891-22.458,26.837-46.915,26.837-73.372
        c0-26.458-8.946-50.914-26.837-73.376c-17.888-22.459-42.298-40.208-73.228-53.249c-30.93-13.039-64.571-19.556-100.928-19.556
        c-36.354,0-69.995,6.521-100.927,19.56C69.14,87.4,44.729,105.149,26.84,127.609C8.947,150.068,0,174.523,0,200.982
        c0,22.648,6.764,43.975,20.276,63.957c13.512,19.985,32.071,36.833,55.671,50.535c-1.902,4.572-3.853,8.754-5.852,12.566
        c-2,3.806-4.377,7.467-7.139,10.991c-2.76,3.525-4.899,6.283-6.423,8.275c-1.523,1.998-3.997,4.809-7.424,8.422
        c-3.428,3.617-5.618,5.996-6.567,7.135c0-0.191-0.383,0.24-1.143,1.287c-0.763,1.047-1.191,1.52-1.287,1.431
        c-0.094-0.103-0.476,0.373-1.141,1.42c-0.666,1.048-1,1.571-1,1.571l-0.715,1.423c-0.284,0.568-0.476,1.137-0.57,1.712
        c-0.096,0.567-0.144,1.19-0.144,1.854s0.094,1.28,0.286,1.854c0.383,2.471,1.477,4.466,3.284,5.996
        c1.809,1.52,3.757,2.279,5.854,2.279h0.857c9.515-1.332,17.701-2.854,24.552-4.569c29.312-7.614,55.771-19.797,79.372-36.545
        c17.128,3.046,33.88,4.568,50.248,4.568C237.349,347.156,270.994,340.641,301.923,327.602z M142.184,303.767l-12.564,8.846
        c-5.33,3.614-11.227,7.331-17.7,11.14l9.995-23.986l-27.694-15.988c-18.276-10.656-32.454-23.219-42.542-37.685
        c-10.089-14.465-15.131-29.502-15.131-45.111c0-19.417,7.474-37.594,22.414-54.534c14.938-16.94,35.067-30.358,60.382-40.259
        c25.313-9.895,52.532-14.847,81.653-14.847c29.121,0,56.342,4.952,81.654,14.847c25.313,9.9,45.442,23.319,60.388,40.259
        c14.94,16.939,22.408,35.116,22.408,54.534c0,19.414-7.468,37.59-22.408,54.53c-14.945,16.945-35.074,30.36-60.388,40.256
        c-25.312,9.897-52.53,14.846-81.654,14.846c-14.272,0-28.833-1.335-43.681-3.997L142.184,303.767z"/>
        <path fill="currentColor" d="M491.347,338.156c13.518-19.896,20.272-41.255,20.272-64.098c0-23.411-7.139-45.303-21.409-65.666
        c-14.277-20.362-33.694-37.305-58.245-50.819c4.374,14.274,6.563,28.739,6.563,43.398c0,25.503-6.368,49.676-19.129,72.519
        c-12.752,22.836-31.025,43.01-54.816,60.524c-22.08,15.988-47.205,28.261-75.377,36.829
        c-28.164,8.562-57.573,12.848-88.218,12.848c-5.708,0-14.084-0.377-25.122-1.137c38.256,25.119,83.177,37.685,134.756,37.685
        c16.371,0,33.119-1.526,50.251-4.571c23.6,16.755,50.06,28.931,79.37,36.549c6.852,1.718,15.037,3.237,24.554,4.568
        c2.283,0.195,4.381-0.476,6.283-1.995c1.903-1.526,3.142-3.614,3.71-6.276c-0.089-1.143,0-1.77,0.287-1.861
        c0.281-0.09,0.233-0.712-0.144-1.852c-0.376-1.144-0.568-1.715-0.568-1.715l-0.712-1.424c-0.198-0.376-0.52-0.903-0.999-1.567
        c-0.476-0.66-0.855-1.14-1.143-1.427c-0.28-0.284-0.705-0.763-1.28-1.424c-0.568-0.66-0.951-1.092-1.143-1.283
        c-0.951-1.143-3.139-3.521-6.564-7.139c-3.429-3.613-5.899-6.42-7.422-8.418c-1.523-1.999-3.665-4.757-6.424-8.282
        c-2.758-3.518-5.14-7.183-7.139-10.991c-1.998-3.806-3.949-7.995-5.852-12.56C459.281,374.855,477.843,358.059,491.347,338.156z"
        />
    </svg>
{/if}
{if $svgId == "user_icon"}
    <svg width="20px" height="20px" viewBox="0 0 43.028 43.028">
        <path fill="currentColor" d="M39.561,33.971l-0.145,0.174c-4.774,5.728-11.133,8.884-17.902,8.884c-6.77,0-13.128-3.155-17.903-8.884l-0.144-0.174
        l0.034-0.223c0.922-6.014,4.064-10.845,8.847-13.606l0.34-0.196l0.271,0.284c2.259,2.37,5.297,3.674,8.554,3.674
        s6.295-1.305,8.554-3.674l0.271-0.284l0.34,0.196c4.783,2.761,7.925,7.592,8.848,13.606L39.561,33.971z M21.514,21.489
        c5.924,0,10.744-4.82,10.744-10.744C32.258,4.821,27.438,0,21.514,0S10.77,4.821,10.77,10.744S15.59,21.489,21.514,21.489z"/>
    </svg>
{/if}
{if $svgId == "login_icon"}
    <svg height="20px" viewBox="0 -10 490.66667 490" width="20px">
        <path fill="currentColor" d="m325.332031 251h-309.332031c-8.832031 0-16-7.167969-16-16s7.167969-16 16-16h309.332031c8.832031 0 16 7.167969 16 16s-7.167969 16-16 16zm0 0"/>
        <path fill="currentColor" d="m240 336.332031c-4.097656 0-8.191406-1.554687-11.308594-4.691406-6.25-6.25-6.25-16.382813 0-22.636719l74.027344-74.023437-74.027344-74.027344c-6.25-6.25-6.25-16.386719 0-22.636719 6.253906-6.25 16.386719-6.25 22.636719 0l85.332031 85.335938c6.25 6.25 6.25 16.382812 0 22.632812l-85.332031 85.332032c-3.136719 3.160156-7.230469 4.714843-11.328125 4.714843zm0 0"/>
        <path fill="currentColor" d="m256 469.667969c-97.089844 0-182.804688-58.410157-218.410156-148.824219-3.242188-8.191406.808594-17.492188 9.023437-20.734375 8.191407-3.199219 17.515625.789063 20.757813 9.046875 30.742187 78.058594 104.789062 128.511719 188.628906 128.511719 111.742188 0 202.667969-90.925781 202.667969-202.667969s-90.925781-202.667969-202.667969-202.667969c-83.839844 0-157.886719 50.453125-188.628906 128.511719-3.265625 8.257812-12.566406 12.246094-20.757813 9.046875-8.214843-3.242187-12.265625-12.542969-9.023437-20.734375 35.605468-90.414062 121.320312-148.824219 218.410156-148.824219 129.386719 0 234.667969 105.28125 234.667969 234.667969s-105.28125 234.667969-234.667969 234.667969zm0 0"/>
    </svg>
{/if}
{if $svgId == "support_icon"}
    <svg viewBox="0 0 235.129 235.129" width="20px" height="20px">
        <path fill="currentColor" d="M212.027,84.433l-3.954,0.003c-10.912-40.466-48.044-69.228-90.549-69.228c-42.253,0-79.347,28.769-90.44,69.236
        l-3.987-0.003C10.361,84.441,0,94.802,0,107.538v25.941c0,12.734,10.361,23.094,23.097,23.094h2.874
        c3.697,29.087,28.603,51.648,58.681,51.648h5.515c2.926,6.87,9.744,11.699,17.669,11.699h19.455
        c10.585,0,19.197-8.611,19.197-19.195c0-10.586-8.612-19.199-19.197-19.199h-19.455c-7.923,0-14.739,4.828-17.666,11.695h-5.519
        c-24.347,0-44.154-19.805-44.154-44.148V92.785c7.758-36.299,40.035-62.576,77.027-62.576c37.237,0,69.551,26.267,77.108,62.548
        v56.31c0,4.142,3.358,7.5,7.5,7.5h9.9c12.735,0,23.096-10.36,23.096-23.095V107.53C235.129,94.795,224.768,84.433,212.027,84.433z
         M107.836,196.526h19.455c2.314,0,4.197,1.884,4.197,4.199c0,2.314-1.883,4.195-4.197,4.195h-19.455
        c-2.313,0-4.195-1.882-4.195-4.195C103.641,198.41,105.522,196.526,107.836,196.526z M15,133.479v-25.941
        c0-4.464,3.632-8.097,8.09-8.097l2.407,0.002v42.129h-2.4C18.632,141.573,15,137.942,15,133.479z M220.129,133.471
        c0,4.463-3.632,8.095-8.096,8.095h-2.4V99.435l2.4-0.002c4.464,0,8.096,3.632,8.096,8.097V133.471z"/>
    </svg>
{/if}
{if $svgId == "sort_icon"}
    <svg  preserveAspectRatio="xMidYMid meet" height="20px" width="20px" viewBox="0 0 11 17" class="sorting_icon">
        <title>Sorting</title>
        <g>
        <polygon class="sorting_icon--left" fill="currentColor" points="4.1,17.3 -0.7,12.5 0.7,11.1 2.1,12.5 2.1,0 4.1,0"></polygon>
        <polygon class="sorting_icon--right" fill="currentColor" points="8.3,16.8 6.3,16.8 6.3,-0.6 11.2,4.3 9.7,5.7 8.3,4.3"></polygon>
        </g>
    </svg>
{/if}
{if $svgId == "comment-user_icon"}
    <svg viewBox="0 0 53 53" width="30px" height="30px">
        <path style="fill:#E7ECED;" d="M18.613,41.552l-7.907,4.313c-0.464,0.253-0.881,0.564-1.269,0.903C14.047,50.655,19.998,53,26.5,53
        c6.454,0,12.367-2.31,16.964-6.144c-0.424-0.358-0.884-0.68-1.394-0.934l-8.467-4.233c-1.094-0.547-1.785-1.665-1.785-2.888v-3.322
        c0.238-0.271,0.51-0.619,0.801-1.03c1.154-1.63,2.027-3.423,2.632-5.304c1.086-0.335,1.886-1.338,1.886-2.53v-3.546
        c0-0.78-0.347-1.477-0.886-1.965v-5.126c0,0,1.053-7.977-9.75-7.977s-9.75,7.977-9.75,7.977v5.126
        c-0.54,0.488-0.886,1.185-0.886,1.965v3.546c0,0.934,0.491,1.756,1.226,2.231c0.886,3.857,3.206,6.633,3.206,6.633v3.24
        C20.296,39.899,19.65,40.986,18.613,41.552z"/>
        <path style="fill:#556080;" d="M26.953,0.004C12.32-0.246,0.254,11.414,0.004,26.047C-0.138,34.344,3.56,41.801,9.448,46.76
        c0.385-0.336,0.798-0.644,1.257-0.894l7.907-4.313c1.037-0.566,1.683-1.653,1.683-2.835v-3.24c0,0-2.321-2.776-3.206-6.633
        c-0.734-0.475-1.226-1.296-1.226-2.231v-3.546c0-0.78,0.347-1.477,0.886-1.965v-5.126c0,0-1.053-7.977,9.75-7.977
        s9.75,7.977,9.75,7.977v5.126c0.54,0.488,0.886,1.185,0.886,1.965v3.546c0,1.192-0.8,2.195-1.886,2.53
        c-0.605,1.881-1.478,3.674-2.632,5.304c-0.291,0.411-0.563,0.759-0.801,1.03V38.8c0,1.223,0.691,2.342,1.785,2.888l8.467,4.233
        c0.508,0.254,0.967,0.575,1.39,0.932c5.71-4.762,9.399-11.882,9.536-19.9C53.246,12.32,41.587,0.254,26.953,0.004z"/>
    </svg>
{/if}
{if $svgId == "comment-admin_icon"}
    <svg viewBox="0 0 58.27 58.27" width="30px" height="30px">
        <path style="fill:#ECF0F1;" d="M18.613,41.696l-7.907,4.313c-0.464,0.253-0.881,0.564-1.269,0.903
        c4.611,3.886,10.562,6.231,17.064,6.231c6.454,0,12.367-2.31,16.964-6.144c-0.424-0.358-0.884-0.68-1.394-0.934l-8.467-4.233
        c-1.094-0.547-1.785-1.665-1.785-2.888v-3.322c0.238-0.271,0.51-0.619,0.801-1.03c1.154-1.63,2.027-3.423,2.632-5.304
        c1.086-0.335,1.886-1.338,1.886-2.53v-3.546c0-0.78-0.347-1.477-0.886-1.965v-5.126c0,0,1.053-7.977-9.75-7.977
        s-9.75,7.977-9.75,7.977v5.126c-0.54,0.488-0.886,1.185-0.886,1.965v3.546c0,0.934,0.491,1.756,1.226,2.231
        c0.886,3.857,3.206,6.633,3.206,6.633v3.24C20.296,40.043,19.65,41.13,18.613,41.696z"/>
        <path style="fill:#556080;" d="M26.953,0.148C12.32-0.102,0.254,11.558,0.004,26.191c-0.142,8.297,3.556,15.754,9.444,20.713
        c0.385-0.336,0.798-0.644,1.257-0.894l7.907-4.313c1.037-0.566,1.683-1.653,1.683-2.835v-3.24c0,0-2.321-2.776-3.206-6.633
        c-0.734-0.475-1.226-1.296-1.226-2.231v-3.546c0-0.78,0.347-1.477,0.886-1.965v-5.126c0,0-1.053-7.977,9.75-7.977
        s9.75,7.977,9.75,7.977v5.126c0.54,0.488,0.886,1.185,0.886,1.965v3.546c0,1.192-0.8,2.195-1.886,2.53
        c-0.605,1.881-1.478,3.674-2.632,5.304c-0.291,0.411-0.563,0.759-0.801,1.03v3.322c0,1.223,0.691,2.342,1.785,2.888l8.467,4.233
        c0.508,0.254,0.967,0.575,1.39,0.932c5.71-4.762,9.399-11.882,9.536-19.9C53.246,12.464,41.587,0.398,26.953,0.148z"/>
        <polygon style="fill:#EDDCC7;" points="36.836,48.633 36.828,48.64 34.84,55.93 39.487,51.283 		"/>
        <path style="fill:#D75A4A;" d="M56.086,34.684l-1.247-1.247c-0.775-0.775-2.032-0.775-2.807,0l-3.582,3.582L51.1,39.67
        L56.086,34.684z"/>

        <rect x="42.094" y="35.939" transform="matrix(0.7071 0.7071 -0.7071 0.7071 44.0976 -18.1587)" style="fill:#F29C21;" width="3.749" height="16.424"/>
        <polygon style="fill:#D6C4B1;" points="42.485,54.297 42.493,54.29 39.487,51.283 34.84,55.93 34.707,56.418 		"/>
        <path style="fill:#A34740;" d="M54.107,42.676l3.582-3.582c0.775-0.775,0.775-2.032,0-2.807l-1.602-1.602L51.1,39.67
        L54.107,42.676z"/>

        <rect x="44.671" y="38.768" transform="matrix(-0.7071 -0.7071 0.7071 -0.7071 46.6666 113.2895)" style="fill:#E18C25;" width="4.251" height="16.424"/>
        <path style="fill:#5E5E5E;" d="M34,58.126c-0.256,0-0.512-0.098-0.707-0.293c-0.391-0.391-0.391-1.023,0-1.414l2.207-2.207
        c0.391-0.391,1.023-0.391,1.414,0s0.391,1.023,0,1.414l-2.207,2.207C34.512,58.028,34.256,58.126,34,58.126z"/>
    </svg>
{/if}
{if $svgId == "cart_icon"}
    <svg viewBox="0 0 495.401 495.401" width="30px" height="30px">
        <path d="M185.049,381.529c-22.852,0-41.379,18.517-41.379,41.36c0,22.861,18.527,41.379,41.379,41.379    c22.843,0,41.37-18.518,41.37-41.379C226.419,400.048,207.892,381.529,185.049,381.529z" fill="currentColor"/>
        <path d="M365.622,381.529c-22.861,0-41.379,18.517-41.379,41.36c0,22.861,18.518,41.379,41.379,41.379    c22.844,0,41.38-18.518,41.38-41.379C407.002,400.048,388.466,381.529,365.622,381.529z" fill="currentColor"/>
        <path d="M469.558,154.735l-229.192-0.019c-11.46,0-20.75,9.29-20.75,20.75s9.29,20.75,20.75,20.75    l202.778-0.01l-12.864,43.533l-206.164,0.044c-10.631,0-19.25,8.619-19.25,19.25c0,10.632,8.619,19.25,19.25,19.25l194.768,0.076    l-12.093,40.715H174.455L159.04,196.188L144.321,76.471c-1.198-9.473-8.066-17.251-17.319-19.611l-98-25    C16.56,28.684,3.901,36.199,0.727,48.641s4.339,25.102,16.781,28.275l82.667,21.089l32.192,241.591c0,0,1.095,28.183,26.69,28.183    h256.81c21.518,0,25.678-22.438,25.678-22.438l50.896-151.159C492.441,194.162,507.532,154.735,469.558,154.735z" fill="currentColor"/>
    </svg>
{/if}
{if $svgId == "remove_icon"}
    <svg class="remove_icon" width="20" height="20" viewBox="0 0 20 20">
        <path fill="currentColor" d="M15.833 5.346l-1.179-1.179-4.654 4.654-4.654-4.654-1.179 1.179 4.654 4.654-4.654 4.654 1.179 1.179 4.654-4.654 4.654 4.654 1.179-1.179-4.654-4.654z"></path>
    </svg>
{/if}
{if $svgId == "arrow_up_icon"}
    <svg viewBox="0 0 32 32" width="20px" height="20px">
        <path fill="currentColor" d="M26.704,10.192l-9.999-9.899  c-0.397-0.393-1.03-0.378-1.428,0l-9.999,9.9c-0.394,0.391-0.394,1.024,0,1.414c0.395,0.391,1.034,0.391,1.429,0l8.275-8.192V31  c0,0.552,0.452,1,1.01,1s1.01-0.448,1.01-1V3.414l8.275,8.192c0.394,0.391,1.034,0.391,1.428,0  C27.099,11.216,27.099,10.583,26.704,10.192z"/>
    </svg>
{/if}
{if $svgId == "reset_icon"}
    <svg height="20px" width="20px" viewBox="0 0 24 24">
        <path fill="currentColor" d="M 15.324219 4.445313 C 13.496094 3.640625 11.433594 3.515625 9.515625 4.121094 C 5.871094 5.269531 3.507813 8.726563 3.753906 12.53125 L 1.265625 12.695313 C 0.945313 7.738281 4.027344 3.238281 8.765625 1.742188 C 11.539063 0.867188 14.546875 1.171875 17.097656 2.550781 L 19.484375 0 L 20.121094 7.074219 L 12.628906 7.324219 Z M 15.230469 22.257813 C 14.179688 22.585938 13.089844 22.753906 12.007813 22.753906 C 10.242188 22.753906 8.488281 22.296875 6.90625 21.445313 L 4.515625 24 L 3.882813 16.925781 L 11.371094 16.675781 L 8.679688 19.554688 C 10.5 20.355469 12.5625 20.484375 14.480469 19.878906 C 18.125 18.726563 20.492188 15.265625 20.246094 11.46875 L 22.730469 11.304688 C 23.058594 16.253906 19.972656 20.757813 15.230469 22.257813 Z "/>
    </svg>
{/if}
{if $svgId == "delete_icon"}
    <svg viewBox="0 0 268.476 268.476" width="20px" height="20px">
        <path fill="currentColor" d="M63.119,250.254c0,0,3.999,18.222,24.583,18.222h93.072
        c20.583,0,24.582-18.222,24.582-18.222l18.374-178.66H44.746L63.119,250.254z M170.035,98.442c0-4.943,4.006-8.949,8.949-8.949
        c4.943,0,8.95,4.006,8.95,8.949l-8.95,134.238c0,4.943-4.007,8.949-8.949,8.949c-4.942,0-8.949-4.007-8.949-8.949L170.035,98.442z
        M125.289,98.442c0-4.943,4.007-8.949,8.949-8.949c4.943,0,8.949,4.006,8.949,8.949v134.238c0,4.943-4.006,8.949-8.949,8.949
        c-4.943,0-8.949-4.007-8.949-8.949V98.442z M89.492,89.492c4.943,0,8.949,4.006,8.949,8.949l8.95,134.238
        c0,4.943-4.007,8.949-8.95,8.949c-4.942,0-8.949-4.007-8.949-8.949L80.543,98.442C80.543,93.499,84.55,89.492,89.492,89.492z
        M218.36,35.811h-39.376V17.899C178.984,4.322,174.593,0,161.086,0L107.39,0C95.001,0,89.492,6.001,89.492,17.899v17.913H50.116
        c-7.914,0-14.319,6.007-14.319,13.43c0,7.424,6.405,13.431,14.319,13.431H218.36c7.914,0,14.319-6.007,14.319-13.431
        C232.679,41.819,226.274,35.811,218.36,35.811z M161.086,35.811h-53.695l0.001-17.913h53.695V35.811z"/>
    </svg>
{/if}
{if $svgId == "success_icon"}
    <svg width="28px" height="28px" viewBox="0 0 510 510" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
        <path fill="currentColor" d="M150.45,206.55l-35.7,35.7L229.5,357l255-255l-35.7-35.7L229.5,285.6L150.45,206.55z M459,255c0,112.2-91.8,204-204,204 S51,367.2,51,255S142.8,51,255,51c20.4,0,38.25,2.55,56.1,7.65l40.801-40.8C321.3,7.65,288.15,0,255,0C114.75,0,0,114.75,0,255 s114.75,255,255,255s255-114.75,255-255H459z"></path>
    </svg>
{/if}
{if $svgId == "arrow_right"}
    <svg class="arrow_right" width="24" height="24" viewBox="0 0 24 24">
        <path fill="currentColor" d="M16.462 12l-9.805-10.188c-0.368-0.371-0.368-0.971 0-1.344 0.368-0.371 0.962-0.371 1.33 0l10.751 10.858c0.368 0.372 0.368 0.973 0 1.344l-10.751 10.858c-0.368 0.372-0.962 0.371-1.33 0-0.368-0.369-0.368-0.971 0-1.344l9.805-10.184z"></path>
    </svg>
{/if}
{if $svgId == "arrow_right2"}
    <svg width="24" height="24" viewBox="0 0 16 16">
        <path fill="currentColor" d="M2 13h2l5-5-5-5h-2l5 5z"></path>
        <path fill="currentColor" d="M7 13h2l5-5-5-5h-2l5 5z"></path>
    </svg>
{/if}
{if $svgId == "arrow_right3"}
<svg width="24px" height="24px" viewBox="0 0 512 512" >
    <path fill="currentColor" d="m256 512c-68.378906 0-132.667969-26.628906-181.019531-74.980469-48.351563-48.351562-74.980469-112.640625-74.980469-181.019531s26.628906-132.667969 74.980469-181.019531c48.351562-48.351563 112.640625-74.980469 181.019531-74.980469s132.667969 26.628906 181.019531 74.980469c48.351563 48.351562 74.980469 112.640625 74.980469 181.019531s-26.628906 132.667969-74.980469 181.019531c-48.351562 48.351563-112.640625 74.980469-181.019531 74.980469zm0-472c-119.101562 0-216 96.898438-216 216s96.898438 216 216 216 216-96.898438 216-216-96.898438-216-216-216zm104.285156 216-138.285156-138.285156-28.285156 28.285156 110 110-110 110 28.285156 28.285156zm0 0"/>
</svg>
{/if}
{if $svgId == "menu_icon"}
    <svg class="menu_icon" width="16px" height="12px" viewBox="0 0 16 12">
        <g>
            <rect fill="currentColor" class="bar" x="1" y="10" width="16" height="2"></rect>
            <rect fill="currentColor" class="bar" x="1" y="5" width="16" height="2"></rect>
            <rect fill="currentColor" class="bar" x="1" y="0" width="16" height="2"></rect>
        </g>
    </svg>
{/if}
{if $svgId == "catalog_icon"}
    <svg class="catalog_icon" viewBox="0 0 448 512" width="20px" height="20px">
        <path fill="currentColor" d="M288 48v32c0 6.627-5.373 12-12 12H12C5.373 92 0 86.627 0 80V48c0-6.627 5.373-12 12-12h264c6.627 0 12 5.373 12 12zM12 220h424c6.627 0 12-5.373 12-12v-32c0-6.627-5.373-12-12-12H12c-6.627 0-12 5.373-12 12v32c0 6.627 5.373 12 12 12zm0 256h424c6.627 0 12-5.373 12-12v-32c0-6.627-5.373-12-12-12H12c-6.627 0-12 5.373-12 12v32c0 6.627 5.373 12 12 12zm264-184H12c-6.627 0-12 5.373-12 12v32c0 6.627 5.373 12 12 12h264c6.627 0 12-5.373 12-12v-32c0-6.627-5.373-12-12-12z" class=""></path>
    </svg>
{/if}
{if $svgId == "subscribe_image"}
<svg width="24px" height="24px" viewBox="0 0 24 24" >
    <path fill="currentColor" d="m8.75 17.612v4.638c0 .324.208.611.516.713.077.025.156.037.234.037.234 0 .46-.11.604-.306l2.713-3.692z"/>
    <path fill="currentColor" d="m23.685.139c-.23-.163-.532-.185-.782-.054l-22.5 11.75c-.266.139-.423.423-.401.722.023.3.222.556.505.653l6.255 2.138 13.321-11.39-10.308 12.419 10.483 3.583c.078.026.16.04.242.04.136 0 .271-.037.39-.109.19-.116.319-.311.352-.53l2.75-18.5c.041-.28-.077-.558-.307-.722z"/>
</svg>
{/if}

{if $svgId == "phone_icon"}
<svg width="20px" height="20px" viewBox="0 0 459 459">
    <path fill="currentColor" d="M433.5,318.75c-30.6,0-61.2-5.1-91.8-15.3c-7.65-2.55-17.851,0-25.5,5.1L260.1,364.65
    c-71.399-35.7-130.05-96.9-168.3-168.3l56.1-56.1c7.65-7.65,10.2-17.85,5.1-25.5c-7.65-28.05-12.75-58.65-12.75-89.25
    c0-15.3-10.2-25.5-25.5-25.5H25.5C10.2,0,0,10.2,0,25.5C0,265.2,193.8,459,433.5,459c15.3,0,25.5-10.2,25.5-25.5v-89.25
    C459,328.95,448.8,318.75,433.5,318.75z M408,229.5h51C459,102,357,0,229.5,0v51C328.95,51,408,130.05,408,229.5z M306,229.5h51
    c0-71.4-56.1-127.5-127.5-127.5v51C272.85,153,306,186.15,306,229.5z"/>
</svg>
{/if}
{if $svgId == "email_icon"}
<svg viewBox="0 0 97.02 97.02" width="26px" height="26px">
    <path fill="currentColor" d="M85.26,12.766H11.34C5.04,12.766,0,17.812,0,24.12v49.2c0,5.887,5.04,10.933,11.34,10.933h74.34
    c6.3,0,11.34-5.046,11.34-11.354V24.12C96.6,17.812,91.56,12.766,85.26,12.766z M81.06,21.176L48.3,48.51L16.8,21.176H81.06z
    M85.26,75.844H11.34c-1.68,0-2.94-1.262-2.94-2.944V24.961l36.96,32.38c0.84,0.841,1.68,0.841,2.94,0.841
    c0.84,0,2.1-0.421,2.52-0.841L88.2,26.223V72.9C88.2,74.582,86.94,75.844,85.26,75.844z"/>
</svg>
{/if}
{if $svgId == "time_icon"}
	<svg width="26px" height="26px" viewBox="0 0 723.266 723.267">
        <path fill="currentColor" d="M361.104,404.382c12.771,0,24.138-5.546,32.168-14.221h63.635c16.383,0,29.66-13.3,29.66-29.683
        c0-16.372-13.288-29.683-29.66-29.683H393.25c-6.788-7.363-16.038-12.288-26.496-13.645l-56.697-79.811
        c-9.503-13.346-28.038-16.487-41.384-6.983c-13.346,9.48-16.487,28.015-7.006,41.383l56.559,79.615
        c-0.621,2.957-0.978,5.982-0.978,9.124C317.258,384.742,336.897,404.382,361.104,404.382z"/>
        <path fill="currentColor" d="M440.19,65.65l7.007,6.523c6.868,6.408,10.814,15.486,10.814,24.874c0,9.388-3.935,18.443-10.814,24.851l-22.804,21.25
        c88.555,26.013,154.928,104.132,163.096,198.945h-26.657c-10.906,0-19.777,8.859-19.777,19.777c0,10.941,8.883,19.8,19.777,19.8
        h26.75c-8.859,102.44-85.713,185.496-185.082,204.215v-42.834c0-5.648-3.359-10.769-8.525-13.035
        c-5.212-2.243-11.24-1.196-15.383,2.646l-89.049,82.997c-2.865,2.692-4.51,6.455-4.51,10.412c0,3.936,1.645,7.697,4.51,10.39
        l89.049,82.997c4.143,3.843,10.171,4.89,15.383,2.623c5.166-2.266,8.525-7.386,8.525-13.012v-42.938
        c0.333-0.022,0.644,0.104,0.978,0.069c149.301-21.031,264.156-149.231,264.156-304.32
        C667.633,219.841,571.083,100.867,440.19,65.65z"/>
        <path fill="currentColor" d="M265.255,626.223c0-9.389,3.935-18.443,10.815-24.852l22.803-21.25c-88.554-26.013-154.927-104.132-163.096-198.945
        h26.657c10.907,0,19.777-8.858,19.777-19.777c0-10.941-8.871-19.777-19.777-19.777h-26.749
        c8.859-102.464,85.712-185.519,185.082-204.238v42.833c0,5.649,3.36,10.769,8.525,13.035c5.212,2.244,11.241,1.196,15.371-2.646
        l89.049-82.998c2.876-2.692,4.51-6.455,4.51-10.412c0-3.935-1.645-7.697-4.51-10.389L344.664,3.81
        c-4.142-3.854-10.171-4.89-15.371-2.623c-5.166,2.267-8.525,7.386-8.525,13.012v42.937c-0.333,0.023-0.644-0.115-0.978-0.069
        C170.488,78.11,55.633,206.311,55.633,361.399c0,142.018,96.539,260.992,227.443,296.22l-7.006-6.512
        C269.19,644.688,265.255,635.61,265.255,626.223z"/>
    </svg>
{/if}
{if $svgId == "location_icon"}
    <svg viewBox="0 0 46.412 46.412" width="26px" height="26px">
        <path fill="currentColor" d="M39.652,16.446C39.652,7.363,32.289,0,23.206,0C14.124,0,6.761,7.363,6.761,16.446c0,1.775,0.285,3.484,0.806,5.086h0
        c0,0,1.384,6.212,15.536,24.742c8.103-10.611,12.018-17.178,13.885-20.857C38.67,22.836,39.652,19.756,39.652,16.446z
         M23.024,27.044c-5.752,0-10.416-4.663-10.416-10.416c0-5.752,4.664-10.415,10.416-10.415s10.416,4.663,10.416,10.415
        C33.439,22.381,28.776,27.044,23.024,27.044z"/>
        <path d="M23.206,46.412c-0.036-0.047-0.07-0.092-0.105-0.139c-0.036,0.047-0.07,0.091-0.106,0.139H23.206z"/>
    </svg>
{/if}
{if $svgId == "visacard_icon"}
    <svg width="26px" height="26px" viewBox="0 0 309.2 100">
        <path fill="#dfdfdf" d="M134.5 98.4h-25.2L125 1.8h25.2l-15.7 96.6zm151.6 0h23.1L289 1.8h-20.2c-9.4 0-11.6 7.2-11.6 7.2l-37.5 89.4h26.2l5.3-14.4h32l2.9 14.4zm-27.7-34.1l13.2-36.2 7.4 36.2h-20.6zM221.7 25l3.6-20.8S214.2 0 202.7 0c-12.5 0-42.1 5.4-42.1 32 0 25 34.8 25.2 34.8 38.4 0 13.1-31.2 10.7-41.5 2.5l-3.7 21.7s11.2 5.4 28.4 5.4 43.1-8.9 43.1-33.1c0-25.1-35.1-27.5-35.1-38.3s24.3-9.5 35.1-3.6z"></path>
        <path fill="#D89B5A" d="M61.8 54.6l-8.6-44.4s-1-8.9-12.2-8.9H.5L0 3.1s19.4 4 38.1 19.1C56 36.7 61.8 54.6 61.8 54.6z"></path>
        <path fill="#dfdfdf" d="M88.3 1.8l-24 66.4-2.8-14.3-.1-.3c-1.6-4.2-8-19-23.2-31.3-3.6-3-7.3-5.4-10.8-7.6l21.7 83.6h26.2l40-96.6-27 .1z"></path>
    </svg>
{/if}
{if $svgId == "yandex_money_icon"}
    <svg width="26px" height="26px" viewBox="0 0 512 512">
        <path fill="#F4C944" d="M60.9 254.2c0-28.2 1.8-47.7 61.8-91.8C172.1 125.4 331 0 331 0v210.1h120.1V512H98c-19.4 0-37.1-17.7-37.1-37.1V254.2z"></path>
        <path fill="#CFAA4A" d="M331 210.1v121.8L108.6 482l280.7-90V210.1H331z"></path>
        <path fill="#0D0F0F" d="M228.6 203c12.4-15.9 31.8-21.2 42.4-12.4 10.6 8.8 8.8 28.2-5.3 44.1-12.4 15.9-31.8 21.2-42.4 12.4-8.8-8.8-7-28.2 5.3-44.1"></path>
    </svg>
{/if}
{if $svgId == "mastercard_icon"}
    <svg width="26px" height="26px" viewBox="0 0 167.1 100">
        <path fill="#D99D53" d="M151.5 47.4c-2.4 0-4.2 2.9-4.2 6.9 0 2.7.9 4 2.8 4 2.5 0 4.3-2.9 4.3-7-.1-2.4-1.1-3.9-2.9-3.9zm-32 9.6c0 1.3.8 2.1 2 2.1 2.2 0 3.8-2.1 3.9-5.2-.4-.1-.8-.1-1.2-.1-3.1.1-4.7 1.2-4.7 3.2z"></path>
        <path fill="#D99D53" d="M117.1 0C102.2 0 88 6.7 78.5 18.3h10.1c1.4 1.7 2.6 3.5 3.8 5.3H74.7c-1 1.7-2 3.5-2.9 5.3h23.5c.8 1.7 1.5 3.5 2.1 5.3H69.7c-.6 1.7-1.1 3.5-1.5 5.3h30.6l.6 3c.1.9.3 1.8.3 2.8 2-4.9 5.9-8 10.9-8 2.4 0 5.2 1 6 1.3l-.9 5.5c-1.9-1-3.3-1.4-4.9-1.4-4 0-6.9 3.9-6.9 9.5 0 3.9 1.9 6.2 5.1 6.2 1.3 0 2.8-.4 4.6-1.3l-.9 5.8c-2 .6-3.3.8-4.8.8-4.1 0-7.1-2.1-8.6-5.6-.4 2.7-1.1 5.5-2 8H69.7c.6 1.8 1.3 3.6 2.1 5.3h23.5c-.8 1.8-1.8 3.6-2.9 5.3H74.7c1.1 1.8 2.4 3.6 3.8 5.3h10.1c-1.6 1.9-3.2 3.7-5.1 5.3 9.2 8.4 21.1 13 33.6 12.9 27.6 0 50-22.4 50-50 0-27.8-22.4-50.2-50-50.2zm12.2 63.2h-4.5l.1-2.2c-1.4 1.7-3.2 2.5-5.7 2.5-2.9 0-5-2.3-5-5.6 0-5 3.5-8 9.5-8 .6 0 1.4.1 2.2.2.2-.7.2-1 .2-1.3 0-1.4-.9-1.9-3.5-1.9-2 0-3.9.3-5.7.9l.8-4.6c2.7-.8 4.5-1.1 6.5-1.1 4.7 0 7.1 2.1 7.1 6 0 1-.2 2.4-.4 4.1-.4 3-1.4 9.4-1.6 11zm7.3 0h-5.4l.3-1.4c.9-6.4 2.2-12.9 2.8-19.2h5c0 1-.2 2.1-.3 3.1 1.7-2.4 2.9-3.7 5.2-3.3-.7 1.1-1.6 3.4-2.1 6-3.1-.3-3.6 2.2-5.5 14.8zm16.3 0l.3-1.9c-1.5 1.6-3 2.3-5 2.3-3.9 0-6.6-3.4-6.6-8.6 0-6.9 4-12.6 8.8-12.6 2.1 0 3.7.8 5.2 2.8l1.2-7.3h5.4L158 63.2h-5.1z"></path>
        <path fill="#BE5249" d="M78.9 46.8c-1.7 0-2.9 1.3-3.5 3.7h5.9c.2-.5.7-3.7-2.4-3.7zM34 57c0 1.3.8 2.1 2 2.1 2.2 0 3.8-2.1 3.9-5.2-.4-.1-.8-.1-1.2-.1-3.1.1-4.7 1.2-4.7 3.2z"></path>
        <path fill="#BE5249" d="M98.4 52.6c0-2.7.5-5.2 1.3-7.4v-.5l-.1-.7c-.1-.6-.1-1.1-.2-1.6-.7 1.1-1.6 3.4-2.1 6-3-.3-3.5 2.2-5.5 14.8h-5.4l.3-1.4c.9-6.4 2.2-12.9 2.8-19.2h5c.1 1-.2 2.1-.3 3.1 1.7-2.4 2.9-3.7 5.2-3.3v-.3c0-.3-.1-.5-.1-.8l-.3-1.8v-.2H68.3c.4-1.8.9-3.6 1.4-5.3h27.7c-.1-.2-.1-.4-.2-.6-.5-1.4-1-2.8-1.7-4.1l-.3-.6H71.8c.8-1.8 1.8-3.6 2.9-5.3h17.7c-.3-.5-.6-.9-.9-1.4l-.3-.4c-.8-1.2-1.7-2.3-2.6-3.5H78.5c1.6-1.9 3.2-3.7 5-5.3C74.3 4.6 62.4 0 50 0 22.4 0 0 22.4 0 50s22.4 50 50 50c12.9 0 24.7-4.9 33.6-13l.1-.1c.5-.5 1-.9 1.5-1.4l.5-.5c.4-.4.7-.7 1-1.1l.5-.6c.4-.4.8-.8 1.1-1.3l.3-.4H78.5c-1.4-1.7-2.6-3.5-3.8-5.3h17.7c.1-.1.2-.3.3-.4.5-.8.9-1.5 1.3-2.3.4-.7.7-1.3 1-2l.1-.3c.1-.1.1-.3.2-.4H71.8c-.8-1.7-1.5-3.5-2.1-5.3h27.7c.1-.2.2-.5.2-.7l.2-.6c.2-.6.3-1.1.5-1.7l.1-.5c.2-.8.4-1.5.5-2.3.1-.7.3-1.5.4-2.2-.6-1.4-.9-3.2-.9-5zM21.1 63.2l3.1-19.5-7 19.5h-3.7L13 43.8 9.9 63.2H4.8L9 37.8h7.8l.2 15.7 5.3-15.7h8.4l-4.2 25.4h-5.4zm18.2 0l.1-2.2c-1.4 1.7-3.2 2.5-5.7 2.5-2.9 0-5-2.3-5-5.6 0-5 3.5-8 9.5-8 .6 0 1.4.1 2.2.2.2-.7.2-1 .2-1.3 0-1.4-.9-1.9-3.5-1.9-2 0-3.9.3-5.7.9.1-.4.8-4.6.8-4.6 2.7-.8 4.5-1.1 6.5-1.1 4.7 0 7.1 2.1 7.1 6 0 1-.2 2.4-.4 4.1-.5 3-1.5 9.4-1.6 10.9l-4.5.1zm15.9-12.3c2.7 1.2 3.8 2.9 3.8 5.7 0 4.7-2.6 6.9-8.4 6.9-3.3-.1-4.4-.3-5.6-.6l.8-4.8c1.7.6 3.2.8 4.9.8 2.2 0 3.1-.6 3.1-1.9 0-.9-.3-1.2-2.5-2.3-2.9-1.3-4.1-3.1-4.1-5.7 0-3.8 2.1-7 8.2-7 1.2 0 3.4.2 4.8.4l-.8 4.8c-1.3-.2-2.6-.3-3.9-.3-1.8 0-2.6.6-2.6 1.7-.2 1 .1 1.3 2.3 2.3zm14.4-3.4h-2.8c-.6 3.9-1.5 8.8-1.5 9.5 0 1.1.6 1.5 1.9 1.5.6 0 1.1-.1 1.5-.2l-.7 4.6c-1.5.5-2.6.7-3.9.7-2.8 0-4.3-1.6-4.3-4.5 0-.9.4-3.3.8-5.5.3-1.9 2.3-14.1 2.3-14.1h5.4l-.6 3.1h2.8c-.1 0-.9 4.9-.9 4.9zm10.2 11.4c1.9 0 3.7-.4 5.6-1.3l-.9 5.1c-1.9.6-3.7.8-5.5.8-6 0-9.2-3.2-9.2-9.2 0-7 4-12.2 9.4-12.2 4.4 0 7.3 2.9 7.3 7.5 0 1.5-.2 3-.7 5.1H75.1c-.4 2.9 1.5 4.2 4.7 4.2z"></path>
    </svg>
{/if}
{if $svgId == "kiwi_icon"}
    <svg width="26px" height="26px" viewBox="0 0 512 512">
        <path fill="#D88B4C" d="M398.7 343.1c-4.8-1.8-5.3 3.9-4.1 7.6 2.7 8.7 6.3 15.3 9 16.7 2.6 1.6 5.6-2 3.7-10.7-.8-3.8-3.7-11.6-8.6-13.6zm-38.1 16.2l-.2-.1c-.2 0-.3-.1-.4-.1-.2-.1-.3-.1-.5-.2h-.3l-.8-.2c-2.9-.6-6 0-8.6 1.6-5.7 3.9-6.6 12.6-1.9 19.6 2.1 3 5 5.3 8.5 6.6.1 0 .2.1.3.1.2.1.3.1.4.1.1 0 .2.1.3.1.3.1.5.2.7.2 3 .6 6.1.2 8.6-1.6 5.7-3.9 6.6-12.6 1.9-19.6-1.8-3-4.6-5.3-8-6.5zm135.2 137.4c-13.9-28.3-38.6-49.1-65.3-65-9.3-5.5-19.7-9.4-28.9-12.4-21-6.8-41.3-8.3-65-12.4-19.2-3.3-34.4-11.2-50.8-22.3-8.5-5.8-15.4-13.8-21.2-22.2-1.1-1.7-6.5-8.3-6-10.6 0 0-3.8 15.2 3.7 36.4-68.8-3.1-129.2-41.3-156.9-87.5-50.9-85.2-33-188.4 34.9-234 67.8-45.6 171.2-13.4 226.6 68.8 34.8 51.7 43.6 111.8 28.8 160.6l-.4 1.1c-29.4-21.4-56.3-10.5-56.3-10.5 29.5-3 52.8 20.5 52.8 20.5 3.4 3 6.7 6.4 9.7 10.1.7.9 1.4 1.8 2 2.8 7.7 10.5 12.5 22.1 14.6 33.9 58.5-74.3 68.2-177.1 16.4-257C368.8-4.6 228.1-30.6 120.6 39.1 13.1 108.8-20.6 247.7 45.5 349.5c54.2 83.7 181.4 109.3 254.3 86.2 27.6-8.6 122-16.9 187.7 60.7 0 0 5.7 6.5 8.8 13.9 0 0 .9 2.6 3.4 1.3.5-.3 2.3-2.4-3.9-14.9z"></path>
    </svg>
{/if}
{if $svgId == "sberbank_icon"}
    <svg width="26px" height="26px" viewBox="0 0 512 512">
        <path fill="#46694A" d="M469.8 105.2c-3.1-4.6-6.3-9.2-9.7-13.7-1.5-2-3-3.9-4.6-5.8l-2.5-3.1-297.4 171.1-144.3-83c-2.9 9.3-5.2 18.7-7 28.2l151.2 87 314.3-180.7z"></path>
        <path fill="#46694A" d="M385.1 25.1c-9.6-5.6-19.6-10.7-29.9-15L155.5 124.9 66.7 73.8c-6.3 7-12.3 14.3-17.8 21.9l106.7 61.4 229.5-132z"></path>
        <path fill="#46694A" d="M433.5 61.7c-7.1-6.8-14.6-13.3-22.5-19.3l-255.4 147-121.9-70.2c-4.6 8.1-8.8 16.5-12.5 25l134.4 77.3L433.5 61.7z"></path>
        <path fill="#46694A" d="M34.9 375c30.8 52.8 79.5 92.8 137.2 112.9 10 3.5 20.4 6.4 30.9 8.6 14.9 3.2 30.2 5 45.8 5.4h14.3c44.7-1.3 88.2-14.2 126.4-37.4 29.5-18.1 55-41.9 75-70.1 32.2-45.2 48.8-99.6 47.4-155.1-1.1-38.3-10.7-75.9-28.1-110L155.5 318.1.5 228.9c-1.4 21.2-.2 42.6 3.7 63.5 5.4 29.1 15.7 57.1 30.7 82.6z"></path>
    </svg>
{/if}
{if $svgId == "filter_icon"}
    <svg height="20px" width="20px" viewBox="0 0 19 20">
        <g id="Icons" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd" stroke-linecap="round" stroke-linejoin="round">
            <g transform="translate(-219.000000, -314.000000)" stroke="currentColor">
                <g id="ic_filter" transform="translate(216.000000, 312.000000)">
                    <g id="filter">
                        <g transform="translate(4.000000, 3.000000)" stroke-width="2">
                            <polygon id="Path-7" points="0 0 17 0 11 8 11 18 6 14 6 8"></polygon>
                        </g>
                    </g>
                </g>
            </g>
        </g>
    </svg>
{/if}
{if $svgId == "star_icon"}
    <svg viewBox="0 0 297 297" height="20px" width="20px">
        <path fill="currentColor" d="M296.519,114.329c-1.142-3.512-4.15-6.088-7.795-6.674l-89.94-14.441l-41.528-81.074c-1.684-3.287-5.064-5.352-8.755-5.352
        c-3.691,0-7.071,2.064-8.755,5.352L98.217,93.214l-89.94,14.441c-3.645,0.586-6.653,3.162-7.795,6.674
        c-1.141,3.51-0.22,7.363,2.385,9.979l64.272,64.55l-14.056,90.001c-0.569,3.648,0.95,7.306,3.937,9.476
        c2.986,2.17,6.937,2.485,10.229,0.816l81.252-41.18l81.252,41.18c1.405,0.713,2.929,1.063,4.446,1.063
        c2.04,0,4.069-0.635,5.782-1.879c2.986-2.17,4.506-5.827,3.937-9.476l-14.056-89.999l64.273-64.552
        C296.739,121.692,297.659,117.839,296.519,114.329z M212.404,178.509c-2.211,2.221-3.232,5.362-2.748,8.459l11.862,75.954
        l-68.571-34.753c-2.795-1.416-6.098-1.416-8.893,0l-68.571,34.753l11.862-75.956c0.484-3.097-0.537-6.238-2.748-8.459l-54.24-54.474
        l75.902-12.188c3.095-0.497,5.767-2.438,7.195-5.228L148.5,38.198l35.046,68.421c1.429,2.79,4.101,4.731,7.195,5.228l75.902,12.188
        L212.404,178.509z"/>
    </svg>
{/if}
{if $svgId == "404_icon"}
<svg viewBox="0 0 511.999 511.999" width="120px" height="120px">
    <path fill="currentColor" d="M140.61,273.063h-5.956v-22.69c0-11.623-10.593-19.433-26.358-19.433s-26.357,7.81-26.357,19.433v22.69H65.571
    l25.677-100.707c1.101-2.746,1.194-5.749,1.186-8.392l-0.001-0.284c0-15.632-22.966-20.737-30.881-20.737
    c-10.132,0-18.414,5.148-22.723,14.123c-0.199,0.415-0.359,0.847-0.481,1.29C0,298.98,0,300.981,0,302.305
    c0,12.096,8.537,20.876,20.297,20.876H33.97c4.2,0,7.604-3.405,7.604-7.604c0-4.199-3.404-7.604-7.604-7.604H20.297
    c-3.184,0-4.887-1.694-5.072-5.04c1.954-8.608,23.256-87.252,37.593-139.831c1.785-3.288,4.721-4.954,8.734-4.954
    c5.289,0,14.355,3.338,15.673,5.732l0.001,0.128c0.001,0.584,0.006,2.084-0.132,2.756c-0.178,0.397-0.321,0.809-0.43,1.231
    L48.417,278.788c-0.58,2.275-0.076,4.69,1.365,6.544c1.44,1.854,3.656,2.938,6.004,2.938h33.757c4.2,0,7.604-3.405,7.604-7.604
    v-30.294c0-2.528,5.766-4.225,11.149-4.225c5.481,0,11.15,1.581,11.15,4.225v30.294c0,4.199,3.404,7.604,7.604,7.604h13.56
    c2.252,0,4.226,4.671,4.226,9.996c0,5.013-3.022,9.171-4.382,9.708H127.05c-4.2,0-7.604,3.405-7.604,7.604v34.045
    c0,1.954-4.872,4.225-11.15,4.225c-6.467,0-11.149-2.523-11.149-4.225v-34.045c0-4.199-3.404-7.604-7.604-7.604H59.318
    c-4.2,0-7.604,3.405-7.604,7.604c0,4.199,3.404,7.604,7.604,7.604h22.621v26.441c0,11.26,11.086,19.433,26.357,19.433
    c15.52,0,26.358-7.991,26.358-19.433v-26.441h5.956c9.192,0,19.434-10.232,19.434-24.916
    C160.043,283.663,151.87,273.063,140.61,273.063z"/>
    <path fill="currentColor" d="M492.566,273.063h-5.956v-22.69c0-11.623-10.593-19.433-26.358-19.433s-26.357,7.81-26.357,19.433v22.69h-16.368
    l25.679-100.708c1.1-2.745,1.193-5.75,1.185-8.393l-0.001-0.281c0-15.632-22.966-20.737-30.881-20.737
    c-10.132,0-18.415,5.148-22.724,14.123c-0.199,0.415-0.359,0.847-0.481,1.29c0,0-4.869,17.852-11.125,40.898
    c0,0.001,0,0.002-0.001,0.003l-7.879,29.071c-19.345,71.527-19.345,72.449-19.345,73.978c0,12.096,8.537,20.876,20.298,20.876
    h61.64v26.441c0,11.26,11.085,19.433,26.357,19.433c15.52,0,26.358-7.991,26.358-19.433v-26.441h5.956
    c9.192,0,19.434-10.232,19.434-24.915C512,283.663,503.826,273.063,492.566,273.063z M492.41,307.974h-13.404
    c-4.2,0-7.604,3.405-7.604,7.604v34.045c0,1.954-4.872,4.225-11.15,4.225c-6.467,0-11.149-2.523-11.149-4.225v-34.045
    c0-4.199-3.404-7.604-7.604-7.604h-69.244c-3.183,0-4.887-1.694-5.073-5.037c0.677-2.966,4.201-16.655,18.801-70.634l7.877-29.064
    c5.504-20.276,9.934-36.53,10.916-40.133c1.785-3.288,4.721-4.954,8.735-4.954c5.289,0,14.354,3.338,15.673,5.732l0.001,0.124
    c0.001,0.585,0.006,2.09-0.133,2.762c-0.177,0.396-0.32,0.808-0.429,1.23l-28.249,110.79c-0.58,2.275-0.076,4.69,1.365,6.544
    c1.44,1.854,3.656,2.938,6.004,2.938H441.5c4.2,0,7.604-3.405,7.604-7.604v-30.294c0-2.528,5.766-4.225,11.149-4.225
    c5.481,0,11.15,1.581,11.15,4.225v30.294c0,4.199,3.404,7.604,7.604,7.604h13.56c2.252,0,4.226,4.671,4.226,9.996
    C496.792,303.281,493.769,307.437,492.41,307.974z"/>
    <path fill="currentColor" d="M330.892,206.939c-2.512-3.363-7.279-4.051-10.642-1.536c-3.362,2.515-4.05,7.281-1.535,10.643
    c10.168,13.597,15.542,29.786,15.542,46.818c0,43.149-35.104,78.252-78.252,78.252c-43.15,0-78.253-35.104-78.253-78.252
    c0-43.149,35.104-78.253,78.253-78.253c17.152,0,33.434,5.444,47.083,15.744c3.353,2.53,8.122,1.863,10.651-1.49
    c2.529-3.352,1.862-8.12-1.49-10.65c-16.311-12.307-35.76-18.812-56.245-18.812c-51.534,0-93.461,41.927-93.461,93.461
    s41.927,93.46,93.461,93.46c51.534,0,93.46-41.926,93.46-93.46C349.464,242.523,343.042,223.185,330.892,206.939z"/>
    <path fill="currentColor" d="M296.624,292.726l-29.863-29.863L296.624,233c2.968-2.969,2.968-7.783-0.002-10.753c-2.971-2.97-7.784-2.97-10.754,0
    l-29.863,29.863l-29.863-29.863c-2.971-2.97-7.784-2.97-10.754,0c-2.97,2.97-2.97,7.784,0,10.753l29.863,29.863l-29.863,29.863
    c-2.97,2.97-2.97,7.784,0,10.753c1.485,1.484,3.432,2.227,5.378,2.227c1.946,0,3.892-0.742,5.377-2.227l29.863-29.863
    l29.863,29.863c1.485,1.484,3.432,2.227,5.377,2.227s3.892-0.742,5.378-2.227C299.593,300.51,299.593,295.695,296.624,292.726z"/>
</svg>
{/if}

{if $svgId == "time_read_icon"}
<svg viewBox="0 0 512.001 512.001" width="24px" height="24px">
    <path fill="currentColor" d="M481.999,273.586v-47.58c0-8.284-6.716-15-15-15c-30.988,0-59.878,2.615-87.173,7.955
    c-15.911-15.365-35.308-26.513-56.313-32.606c22.904-19.277,37.486-48.14,37.486-80.349c0-58.449-47.103-106-105-106
    c-57.897,0-105,47.551-105,106c0,32.209,14.582,61.072,37.487,80.348c-21.005,6.094-40.402,17.242-56.313,32.606
    c-27.295-5.339-56.185-7.955-87.173-7.955c-8.284,0-15,6.716-15,15v47.58c-17.459,6.192-30,22.865-30,42.42v30
    c0,19.555,12.541,36.228,30,42.42v47.58c0,8.284,6.716,15,15,15c78.429,0,142.832,18.583,202.68,58.481
    c5.015,3.342,11.621,3.35,16.641,0c59.848-39.898,124.25-58.481,202.68-58.481c8.284,0,15-6.716,15-15v-47.58
    c17.459-6.192,30-22.865,30-42.42v-30C511.999,296.451,499.458,279.778,481.999,273.586z M180.999,106.006
    c0-41.907,33.645-76,75-76s75,34.093,75,76c0,41.355-33.645,75-75,75C214.644,181.006,180.999,147.361,180.999,106.006z
    M44.999,361.006c-8.271,0-15-6.729-15-15v-30c0-8.271,6.729-15,15-15s15,6.729,15,15v30
    C59.999,354.277,53.27,361.006,44.999,361.006z M240.999,470.091c-54.453-31.141-112.886-46.88-181-48.869v-32.796
    c17.459-6.192,30-22.865,30-42.42v-30c0-19.555-12.541-36.228-30-42.42v-32.368c70.481,2.023,127.134,18.62,181,52.916V470.091z
    M255.999,268.145c-27.686-17.469-56.504-30.77-87.268-40.117c16.904-10.986,36.803-17.022,57.268-17.022h60
    c20.465,0,40.364,6.036,57.268,17.022C312.503,237.375,283.684,250.676,255.999,268.145z M451.999,421.222
    c-68.113,1.989-126.548,17.732-181,48.871V294.146c53.867-34.299,110.516-50.906,181-52.928v32.368
    c-17.459,6.192-30,22.865-30,42.42v30c0,19.555,12.541,36.228,30,42.42V421.222z M481.999,346.006c0,8.271-6.729,15-15,15
    s-15-6.729-15-15v-30c0-8.271,6.729-15,15-15s15,6.729,15,15V346.006z"/>
</svg>
{/if}
{if $svgId == "update_date_icon"}
<svg viewBox="0 0 511.999 511.999" width="24px" height="24px">
    <path fill="currentColor" d="M456.936,31.872c-8.279,0-14.892,6.712-14.892,14.992v22.962C403.459,31.214,351.447,5.824,293.604,0.88
    c-70.479-6.025-139.5,19.11-189.352,68.962c-5.855,5.855-5.855,15.346,0,21.201c5.854,5.855,15.346,5.855,21.201,0
    c43.584-43.584,103.942-65.557,165.597-60.288c51.401,4.394,98.931,27.799,134.233,65.161h-32.291
    c-8.279,0-14.992,6.612-14.992,14.892c0,8.279,6.712,14.992,14.992,14.992h63.758c8.475,0.095,15.177-6.795,15.177-14.992V46.864
    C471.927,38.585,465.215,31.872,456.936,31.872z"/>
    <path fill="currentColor" d="M219.059,443.58c-59.023-15.815-108.057-57.273-134.526-113.743C62.155,282.1,58.404,228.381,73.278,178.537L89.422,206.5
    c4.142,7.174,13.312,9.626,20.479,5.487c7.17-4.14,9.627-13.309,5.487-20.479l-31.971-55.375
    c-0.004-0.007-0.008-0.012-0.012-0.019c-4.077-7.016-13.193-9.668-20.467-5.468L7.563,162.616
    c-7.17,4.14-9.627,13.309-5.487,20.479c4.14,7.171,13.309,9.627,20.479,5.487l20.001-11.548
    C27.971,231.872,32.91,290.35,57.384,342.562c30.231,64.494,86.331,111.869,153.914,129.979c7.997,2.144,16.218-2.604,18.361-10.6
    C231.802,453.943,227.057,445.723,219.059,443.58z"/>
    <path fill="currentColor" d="M503.756,177.087c-2.144-7.997-10.363-12.742-18.362-10.6c-7.998,2.143-12.743,10.363-10.6,18.361
    c16.14,60.235,4.671,124.507-31.463,176.335c-29.554,42.387-73.161,71.937-122.546,83.871l16.107-27.898
    c4.14-7.17,1.683-16.339-5.487-20.479c-7.171-4.14-16.34-1.683-20.479,5.487l-31.971,55.375c-0.003,0.006-0.006,0.012-0.009,0.017
    c-4.1,7.146-1.68,16.318,5.496,20.462l55.375,31.971c7.172,4.14,16.341,1.681,20.479-5.487c4.14-7.17,1.683-16.339-5.487-20.479
    l-19.978-11.535c52.521-14.224,99.884-46.525,133.095-94.158C509.131,319.233,522.189,245.882,503.756,177.087z"/>
    <path fill="currentColor" d="M332.017,224.809h-44.975v-44.975c0-8.279-6.712-14.992-14.992-14.992c-8.279,0-14.992,6.712-14.992,14.992v59.967
    c0,8.279,6.712,14.992,14.992,14.992h59.967c8.279,0,14.992-6.712,14.992-14.992C347.009,231.521,340.297,224.809,332.017,224.809
    z"/>
    <path fill="currentColor" d="M272.05,104.876c-74.398,0-134.925,60.527-134.925,134.925s60.527,134.925,134.925,134.925
    s134.925-60.527,134.925-134.925S346.448,104.876,272.05,104.876z M272.05,344.742c-57.865,0-104.942-47.077-104.942-104.942
    c0-57.865,47.077-104.942,104.942-104.942s104.942,47.077,104.942,104.942C376.992,297.665,329.915,344.742,272.05,344.742z"/>
</svg>
{/if}
{if $svgId == "calendar_icon"}
<svg viewBox="0 0 512 512" width="24px" height="24px">
    <path fill="currentColor" d="M105,182H75c-8.284,0-15,6.716-15,15s6.716,15,15,15h30c8.284,0,15-6.716,15-15S113.284,182,105,182z"/>
    <path fill="currentColor" d="M195,182h-30c-8.284,0-15,6.716-15,15s6.716,15,15,15h30c8.284,0,15-6.716,15-15S203.284,182,195,182z"/>
    <path fill="currentColor" d="M287,182h-31c-8.284,0-15,6.716-15,15s6.716,15,15,15h31c8.284,0,15-6.716,15-15S295.284,182,287,182z"/>
    <path fill="currentColor" d="M377,182h-30c-8.284,0-15,6.716-15,15s6.716,15,15,15h30c8.284,0,15-6.716,15-15S385.284,182,377,182z"/>
    <path fill="currentColor" d="M105,242H75c-8.284,0-15,6.716-15,15s6.716,15,15,15h30c8.284,0,15-6.716,15-15S113.284,242,105,242z"/>
    <path fill="currentColor" d="M195,242h-30c-8.284,0-15,6.716-15,15s6.716,15,15,15h30c8.284,0,15-6.716,15-15S203.284,242,195,242z"/>
    <path fill="currentColor" d="M287,242h-31c-8.284,0-15,6.716-15,15s6.716,15,15,15h31c8.284,0,15-6.716,15-15S295.284,242,287,242z"/>
    <path fill="currentColor" d="M105,302H75c-8.284,0-15,6.716-15,15s6.716,15,15,15h30c8.284,0,15-6.716,15-15S113.284,302,105,302z"/>
    <path fill="currentColor" d="M195,302h-30c-8.284,0-15,6.716-15,15s6.716,15,15,15h30c8.284,0,15-6.716,15-15S203.284,302,195,302z"/>
    <path fill="currentColor" d="M105,362H75c-8.284,0-15,6.716-15,15s6.716,15,15,15h30c8.284,0,15-6.716,15-15S113.284,362,105,362z"/>
    <path fill="currentColor" d="M195,362h-30c-8.284,0-15,6.716-15,15s6.716,15,15,15h30c8.284,0,15-6.716,15-15S203.284,362,195,362z"/>
    <path fill="currentColor" d="M437,362h-45v-45c0-8.284-6.716-15-15-15s-15,6.716-15,15v60c0,8.284,6.716,15,15,15h60c8.284,0,15-6.716,15-15
    S445.284,362,437,362z"/>
    <path fill="currentColor" d="M452,264.806V75c0-24.813-20.187-45-45-45h-30V15c0-8.284-6.716-15-15-15s-15,6.716-15,15v15h-60V15
    c0-8.284-6.716-15-15-15s-15,6.716-15,15v15h-62V15c0-8.284-6.716-15-15-15s-15,6.716-15,15v15h-60V15c0-8.284-6.716-15-15-15
    S75,6.716,75,15v15H45C20.187,30,0,50.187,0,75v362c0,8.284,6.716,15,15,15h249.806c24.247,36.154,65.487,60,112.194,60
    c74.439,0,135-60.561,135-135C512,330.292,488.154,289.053,452,264.806z M30,75c0-8.271,6.729-15,15-15h30v15
    c0,8.284,6.716,15,15,15s15-6.716,15-15V60h60v15c0,8.284,6.716,15,15,15s15-6.716,15-15V60h62v15c0,8.284,6.716,15,15,15
    s15-6.716,15-15V60h60v15c0,8.284,6.716,15,15,15s15-6.716,15-15V60h30c8.271,0,15,6.729,15,15v47H30V75z M249.722,422H30V152h392
    v97.722c-14.082-4.994-29.228-7.722-45-7.722c-74.439,0-135,60.561-135,135C242,392.772,244.728,407.918,249.722,422z M377,482
    c-57.897,0-105-47.103-105-105c0-57.897,47.103-105,105-105c57.897,0,105,47.103,105,105C482,434.897,434.897,482,377,482z"/>
</svg>
{/if}
{if $svgId == "chat_icon"}
<svg viewBox="0 0 511.999 511.999" width="24px" height="24px">
    <path fill="currentColor" d="M467,75.993h-45v-15c0-24.813-20.187-45-45-45H45c-24.813,0-45,20.187-45,45v240c0,24.813,20.187,45,45,45h45v75
    c0,13.384,16.222,19.992,25.606,10.606l25.607-25.606h169.574l85.606,85.606c9.389,9.393,25.606,2.8,25.606-10.606v-75h45
    c24.813,0,45-20.187,45-45v-240C512,96.18,491.813,75.993,467,75.993z M120,384.78v-53.787c0-8.284-6.716-15-15-15H45
    c-8.271,0-15-6.729-15-15v-240c0-8.271,6.729-15,15-15h332c8.271,0,15,6.729,15,15v240c0,8.271-6.729,15-15,15H195
    c-3.979,0-7.793,1.581-10.606,4.394L120,384.78z M482,360.993c0,8.271-6.729,15-15,15h-60c-8.284,0-15,6.716-15,15v53.787
    l-64.394-64.393c-2.813-2.813-6.628-4.394-10.606-4.394H171.213l30-30H377c24.813,0,45-20.187,45-45v-195h45
    c8.271,0,15,6.729,15,15V360.993z"/>
    <path fill="currentColor" d="M287,105.993H75c-8.284,0-15,6.716-15,15s6.716,15,15,15h212c8.284,0,15-6.716,15-15S295.284,105.993,287,105.993z"/>
    <path fill="currentColor" d="M347,165.993H75c-8.284,0-15,6.716-15,15s6.716,15,15,15h272c8.284,0,15-6.716,15-15S355.284,165.993,347,165.993z"/>
    <path fill="currentColor" d="M227,225.993H75c-8.284,0-15,6.716-15,15s6.716,15,15,15h152c8.284,0,15-6.716,15-15S235.284,225.993,227,225.993z"/>
</svg>
{/if}
{if $svgId == "avatar_icon"}
<svg viewBox="-42 0 512 512.001" width="24px" height="24px">
    <path fill="currentColor" d="m210.351562 246.632812c33.882813 0 63.21875-12.152343 87.195313-36.128906 23.96875-23.972656 36.125-53.304687 36.125-87.191406 0-33.875-12.152344-63.210938-36.128906-87.191406-23.976563-23.96875-53.3125-36.121094-87.191407-36.121094-33.886718 0-63.21875 12.152344-87.191406 36.125s-36.128906 53.308594-36.128906 87.1875c0 33.886719 12.15625 63.222656 36.128906 87.195312 23.980469 23.96875 53.316406 36.125 87.191406 36.125zm-65.972656-189.292968c18.394532-18.394532 39.972656-27.335938 65.972656-27.335938 25.996094 0 47.578126 8.941406 65.976563 27.335938 18.394531 18.398437 27.339844 39.980468 27.339844 65.972656 0 26-8.945313 47.578125-27.339844 65.976562-18.398437 18.398438-39.980469 27.339844-65.976563 27.339844-25.992187 0-47.570312-8.945312-65.972656-27.339844-18.398437-18.394531-27.34375-39.976562-27.34375-65.976562 0-25.992188 8.945313-47.574219 27.34375-65.972656zm0 0"/>
    <path fill="currentColor" d="m426.128906 393.703125c-.691406-9.976563-2.089844-20.859375-4.148437-32.351563-2.078125-11.578124-4.753907-22.523437-7.957031-32.527343-3.3125-10.339844-7.808594-20.550781-13.375-30.335938-5.769532-10.15625-12.550782-19-20.160157-26.277343-7.957031-7.613282-17.699219-13.734376-28.964843-18.199219-11.226563-4.441407-23.667969-6.691407-36.976563-6.691407-5.226563 0-10.28125 2.144532-20.042969 8.5-6.007812 3.917969-13.035156 8.449219-20.878906 13.460938-6.707031 4.273438-15.792969 8.277344-27.015625 11.902344-10.949219 3.542968-22.066406 5.339844-33.042969 5.339844-10.96875 0-22.085937-1.796876-33.042968-5.339844-11.210938-3.621094-20.300782-7.625-26.996094-11.898438-7.769532-4.964844-14.800782-9.496094-20.898438-13.46875-9.753906-6.355468-14.808594-8.5-20.035156-8.5-13.3125 0-25.75 2.253906-36.972656 6.699219-11.257813 4.457031-21.003906 10.578125-28.96875 18.199219-7.609375 7.28125-14.390625 16.121094-20.15625 26.273437-5.558594 9.785157-10.058594 19.992188-13.371094 30.339844-3.199219 10.003906-5.875 20.945313-7.953125 32.523437-2.0625 11.476563-3.457031 22.363282-4.148437 32.363282-.679688 9.777344-1.023438 19.953125-1.023438 30.234375 0 26.726562 8.496094 48.363281 25.25 64.320312 16.546875 15.746094 38.4375 23.730469 65.066406 23.730469h246.53125c26.621094 0 48.511719-7.984375 65.0625-23.730469 16.757813-15.945312 25.253906-37.589843 25.253906-64.324219-.003906-10.316406-.351562-20.492187-1.035156-30.242187zm-44.90625 72.828125c-10.933594 10.40625-25.449218 15.464844-44.378906 15.464844h-246.527344c-18.933594 0-33.449218-5.058594-44.378906-15.460938-10.722656-10.207031-15.933594-24.140625-15.933594-42.585937 0-9.59375.316406-19.066407.949219-28.160157.617187-8.921874 1.878906-18.722656 3.75-29.136718 1.847656-10.285156 4.199219-19.9375 6.996094-28.675782 2.683593-8.378906 6.34375-16.675781 10.882812-24.667968 4.332031-7.617188 9.316407-14.152344 14.816407-19.417969 5.144531-4.925781 11.628906-8.957031 19.269531-11.980469 7.066406-2.796875 15.007812-4.328125 23.628906-4.558594 1.050781.558594 2.921875 1.625 5.953125 3.601563 6.167969 4.019531 13.277344 8.605469 21.136719 13.625 8.859375 5.648437 20.273437 10.75 33.910156 15.152344 13.941406 4.507812 28.160156 6.796875 42.273437 6.796875 14.113282 0 28.335938-2.289063 42.269532-6.792969 13.648437-4.410156 25.058594-9.507813 33.929687-15.164063 8.042969-5.140624 14.953125-9.59375 21.121094-13.617187 3.03125-1.972656 4.902344-3.042969 5.953125-3.601563 8.625.230469 16.566406 1.761719 23.636719 4.558594 7.636719 3.023438 14.121093 7.058594 19.265625 11.980469 5.5 5.261719 10.484375 11.796875 14.816406 19.421875 4.542969 7.988281 8.207031 16.289062 10.886719 24.660156 2.800781 8.75 5.15625 18.398438 7 28.675782 1.867187 10.433593 3.132812 20.238281 3.75 29.144531v.007812c.636719 9.058594.957031 18.527344.960937 28.148438-.003906 18.449219-5.214844 32.378906-15.9375 42.582031zm0 0"/>
</svg>
{/if}
{if $svgId == "tag_icon"}
<svg width="24px" height="24px" viewBox="0 0 542.183 542.183">
    <path fill="currentColor" d="M432.544,310.636c0-9.897-3.521-18.559-10.564-25.984L217.844,80.8c-7.232-7.238-16.939-13.374-29.121-18.416
    c-12.181-5.043-23.319-7.565-33.407-7.565H36.545c-9.896,0-18.464,3.619-25.694,10.848C3.616,72.9,0,81.466,0,91.365v118.771
    c0,10.088,2.519,21.219,7.564,33.404c5.046,12.185,11.187,21.792,18.417,28.837L230.12,476.799
    c7.043,7.043,15.608,10.564,25.694,10.564c9.898,0,18.562-3.521,25.984-10.564l140.186-140.47
    C429.023,329.284,432.544,320.725,432.544,310.636z M117.204,172.02c-7.139,7.138-15.752,10.709-25.841,10.709
    c-10.085,0-18.698-3.571-25.837-10.709c-7.139-7.139-10.705-15.749-10.705-25.837c0-10.089,3.566-18.702,10.705-25.837
    c7.139-7.139,15.752-10.71,25.837-10.71c10.089,0,18.702,3.571,25.841,10.71c7.135,7.135,10.707,15.749,10.707,25.837
    C127.91,156.271,124.339,164.881,117.204,172.02z"/>
    <path fill="currentColor" d="M531.612,284.655L327.473,80.804c-7.23-7.238-16.939-13.374-29.122-18.417c-12.177-5.042-23.313-7.564-33.402-7.564
    h-63.953c10.088,0,21.222,2.522,33.402,7.564c12.185,5.046,21.892,11.182,29.125,18.417l204.137,203.851
    c7.046,7.423,10.571,16.084,10.571,25.981c0,10.089-3.525,18.647-10.571,25.693L333.469,470.519
    c5.718,5.9,10.759,10.182,15.133,12.847c4.38,2.666,9.996,3.998,16.844,3.998c9.903,0,18.565-3.521,25.98-10.564l140.186-140.47
    c7.046-7.046,10.571-15.604,10.571-25.693C542.179,300.739,538.658,292.078,531.612,284.655z"/>
</svg>
{/if}
{if $svgId == "okaycms"}
<svg width="18.450455mm" height="25.698715mm" viewBox="0 0 18.450455 25.698715">
    <g transform="translate(-117.77477,-106.50183)">
    <path
    style="fill:currentColor;fill-opacity:1;stroke:none;stroke-width:2.00000024px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1"
    d="M 0,0 V 17.433594 L 14.246094,31.679688 C 17.880109,29.230289 21.976891,27.4117 26.378906,26.378906 Z M 69.734375,0 43.355469,26.378906 c 4.403981,1.032983 8.498797,2.850589 12.132812,5.300782 L 69.734375,17.433594 Z M 34.869141,27.394531 c -9.777978,0 -18.560847,4.01315 -24.8808598,10.453125 H 59.742188 C 53.424178,31.408059 44.645153,27.394531 34.869141,27.394531 Z M 8.125,39.847656 C 5.1089748,43.447467 2.8114094,47.670558 1.4414062,52.300781 H 68.292969 c -1.368,-4.630223 -3.667607,-8.853314 -6.683594,-12.453125 z M 0.921875,54.300781 C 0.3258435,56.857405 0,59.518727 0,62.261719 c 0,19.316598 15.551144,34.867187 34.869141,34.867187 19.315993,0 34.865234,-15.550589 34.865234,-34.867187 0,-2.742992 -0.32975,-5.404125 -0.925781,-7.960938 H 55.8125 c 0.937965,2.474003 1.470703,5.15033 1.470703,7.960938 0,12.417789 -9.996047,22.414062 -22.414062,22.414062 -12.417978,0 -22.414063,-9.996273 -22.414063,-22.414062 0,-2.810608 0.528794,-5.486708 1.466797,-7.960938 z"
    transform="matrix(0.26458333,0,0,0.26458333,117.77477,106.50183)"/>
    </g>
</svg>
{/if}
{if $svgId == "user_orders_icon"}
<svg viewBox="0 0 512 512" width="30px" height="30px">
    <path fill="currentColor" d="M251.328,196.704c-6.24-6.24-16.384-6.272-22.656-0.032L176,249.376l-20.672-20.704c-6.24-6.24-16.384-6.24-22.624,0
    s-6.24,16.384,0,22.624l32,32c3.104,3.136,7.2,4.704,11.296,4.704s8.192-1.568,11.328-4.672l64-64
    C257.568,213.088,257.568,202.944,251.328,196.704z"/>
    <path fill="currentColor" d="M251.328,324.704c-6.24-6.24-16.384-6.272-22.656-0.032L176,377.376l-20.672-20.672c-6.24-6.24-16.384-6.24-22.624,0
    s-6.24,16.384,0,22.624l32,32c3.104,3.104,7.2,4.672,11.296,4.672s8.192-1.568,11.328-4.672l64-64
    C257.568,341.088,257.568,330.944,251.328,324.704z"/>
    <path fill="currentColor" d="M368,224h-64c-8.832,0-16,7.168-16,16c0,8.832,7.168,16,16,16h64c8.832,0,16-7.168,16-16C384,231.168,376.832,224,368,224
    z"/>
    <path fill="currentColor" d="M368,352h-64c-8.832,0-16,7.168-16,16c0,8.832,7.168,16,16,16h64c8.832,0,16-7.168,16-16C384,359.168,376.832,352,368,352
    z"/>
    <path fill="currentColor" d="M416,64h-64V48c0-8.832-7.168-16-16-16h-34.72C294.656,13.376,276.864,0,256,0s-38.656,13.376-45.28,32H176
    c-8.832,0-16,7.168-16,16v16H96c-17.632,0-32,14.368-32,32v384c0,17.632,14.368,32,32,32h320c17.632,0,32-14.368,32-32V96
    C448,78.368,433.632,64,416,64z M192,64h32c8.832,0,16-7.168,16-16c0-8.832,7.168-16,16-16c8.832,0,16,7.168,16,16
    c0,8.832,7.168,16,16,16h32v32H192V64z M416,480H96V96h64v16c0,8.832,7.168,16,16,16h160c8.832,0,16-7.168,16-16V96h64V480z"/>
</svg>
{/if}
{if $svgId == "user_comments_icon"}
<svg viewBox="0 0 512 512" width="30px" height="30px">
    <path fill="currentColor" d="M352,0H64C28.704,0,0,28.704,0,64v192c0,35.296,28.704,64,64,64v80c0,6.24,3.648,11.936,9.312,14.528
    C75.456,415.52,77.728,416,80,416c3.744,0,7.456-1.312,10.4-3.872L197.92,320H352c35.296,0,64-28.704,64-64V64
    C416,28.704,387.296,0,352,0z M384,256c0,17.632-14.368,32-32,32H192c-3.808,0-7.52,1.344-10.4,3.872L96,365.216V304
    c0-8.832-7.168-16-16-16H64c-17.632,0-32-14.368-32-32V64c0-17.632,14.368-32,32-32h288c17.632,0,32,14.368,32,32V256z"/>
    <path fill="currentColor" d="M469.216,99.744c-8.384-2.88-17.44,1.536-20.352,9.92c-2.88,8.352,1.536,17.44,9.92,20.352
    C471.456,134.368,480,146.432,480,160v192c0,17.632-14.368,32-32,32h-16c-8.832,0-16,7.168-16,16v61.216l-85.6-73.344
    c-2.88-2.528-6.592-3.872-10.4-3.872H178.24c-8.832,0-16,7.168-16,16c0,8.832,7.136,16,16,16h135.84l107.52,92.128
    c2.944,2.56,6.656,3.872,10.4,3.872c2.272,0,4.544-0.48,6.688-1.472C444.352,507.936,448,502.24,448,496v-80
    c35.296,0,64-28.704,64-64V160C512,132.8,494.816,108.576,469.216,99.744z"/>
    <path fill="currentColor" d="M304,96H112c-8.832,0-16,7.168-16,16c0,8.832,7.168,16,16,16h192c8.832,0,16-7.168,16-16C320,103.168,312.832,96,304,96z"/>
    <path fill="currentColor" d="M240,160H112c-8.832,0-16,7.168-16,16c0,8.832,7.168,16,16,16h128c8.832,0,16-7.168,16-16
    C256,167.168,248.832,160,240,160z"/>
</svg>
{/if}
{if $svgId == "user_account_icon"}
<svg viewBox="0 0 512 512" width="30px" height="30px">
    <path fill="currentColor" d="M416,64h-64V48c0-8.832-7.168-16-16-16h-34.752C294.656,13.376,276.864,0,256,0s-38.656,13.376-45.248,32H176
    c-8.832,0-16,7.168-16,16v16H96c-17.952,0-32,14.048-32,32v384c0,17.952,14.048,32,32,32h320c17.952,0,32-14.048,32-32V96
    C448,78.048,433.952,64,416,64z M192,64h32c8.832,0,16-7.168,16-16c0-8.832,7.2-16,16-16s16,7.168,16,16c0,8.832,7.168,16,16,16
    h32v32H192V64z M416,480H96V96h64v16c0,8.832,7.168,16,16,16h160c8.832,0,16-7.168,16-16V96h64V480z"/>
    <path fill="currentColor" d="M256,192c-35.296,0-64,28.704-64,64s28.704,64,64,64s64-28.704,64-64C320,220.704,291.296,192,256,192z M256,288
    c-17.664,0-32-14.368-32-32c0-17.632,14.336-32,32-32s32,14.368,32,32S273.664,288,256,288z"/>
    <path fill="currentColor" d="M376.48,386.432c-74.336-46.272-166.624-46.272-240.96,0c-4.672,2.912-7.52,8.032-7.52,13.568v32c0,8.832,7.168,16,16,16
    h224c8.832,0,16-7.168,16-16v-32C384,394.464,381.152,389.344,376.48,386.432z M352,416H160v-6.88
    c59.936-33.792,132.064-33.792,192,0V416z"/>
</svg>
{/if}
{if $svgId == "user_heart_icon"}
<svg width="30px" height="30px" viewBox="0 0 24 24">
    <path fill="currentColor" d="m11.466 22.776c.141.144.333.224.534.224s.393-.08.534-.224l9.594-9.721c2.491-2.523 2.491-6.63 0-9.154-1.21-1.226-2.819-1.901-4.532-1.901s-3.321.675-4.531 1.9l-1.065 1.08-1.065-1.079c-1.21-1.226-2.819-1.901-4.531-1.901-1.713 0-3.322.675-4.532 1.901-2.491 2.524-2.491 6.631 0 9.153zm-8.527-17.822c.926-.937 2.157-1.454 3.464-1.454 1.308 0 2.538.517 3.463 1.455l1.599 1.62c.281.285.786.285 1.067 0l1.599-1.621c.928-.937 2.158-1.454 3.465-1.454 1.308 0 2.538.517 3.464 1.454 1.917 1.943 1.917 5.104 0 7.048l-9.06 9.181-9.061-9.182c-1.917-1.942-1.917-5.104 0-7.047z"/>
</svg>
{/if}
{if $svgId == "user_broused_icon"}
<svg viewBox="0 0 512 512"  width="30px" height="30px">
    <path fill="currentColor" d="M416,64h-64V48c0-8.832-7.168-16-16-16h-34.752C294.656,13.376,276.864,0,256,0s-38.656,13.376-45.248,32H176
    c-8.832,0-16,7.168-16,16v16H96c-17.952,0-32,14.048-32,32v384c0,17.952,14.048,32,32,32h320c17.952,0,32-14.048,32-32V96
    C448,78.048,433.952,64,416,64z M192,64h32c8.832,0,16-7.168,16-16c0-8.832,7.2-16,16-16s16,7.168,16,16c0,8.832,7.168,16,16,16
    h32v32H192V64z M416,480H96V96h64v16c0,8.832,7.168,16,16,16h160c8.832,0,16-7.168,16-16V96h64V480z"/>
    <path fill="currentColor" d="M272,416H144c-8.832,0-16,7.168-16,16c0,8.832,7.168,16,16,16h128c8.832,0,16-7.168,16-16
    C288,423.168,280.832,416,272,416z"/>
    <path fill="currentColor" d="M368,352H144c-8.832,0-16,7.168-16,16c0,8.832,7.168,16,16,16h224c8.832,0,16-7.168,16-16
    C384,359.168,376.832,352,368,352z"/>
    <path fill="currentColor" d="M256,160c-44.128,0-80,35.904-80,80s35.872,80,80,80s80-35.904,80-80S300.128,160,256,160z M256,288
    c-26.464,0-48-21.536-48-48c0-20.832,13.408-38.432,32-45.056V240c0,8.832,7.168,16,16,16h45.056
    C294.432,274.592,276.832,288,256,288z M272,224v-29.056c13.568,4.832,24.224,15.488,29.056,29.056H272z"/>
</svg>
{/if}
{if $svgId == "sale_icon"}
    <svg viewBox="0 0 384.075 384.075" width="20px" height="20px">
        <path fill="currentColor" d="M371.689,217.786c-4.664-9.448-9.48-19.216-9.48-25.752s4.816-16.304,9.464-25.744c8-16.248,17.072-34.664,9.608-52.656
c-7.72-18.608-27.6-25.288-45.144-31.176c-9.184-3.08-19.592-6.576-23.784-10.76c-4.168-4.168-7.664-14.576-10.744-23.752
c-5.88-17.544-12.552-37.432-31.168-45.152c-18-7.464-36.408,1.608-52.648,9.6c-9.448,4.656-19.216,9.464-25.768,9.464
c-6.536,0-16.304-4.808-25.744-9.456c-16.24-8-34.672-17.064-52.656-9.608c-18.608,7.72-25.28,27.608-31.168,45.152
c-3.088,9.176-6.576,19.584-10.76,23.76c-4.168,4.184-14.584,7.672-23.768,10.76c-17.536,5.888-37.424,12.568-45.152,31.168
c-7.464,18,1.616,36.408,9.624,52.664c4.656,9.448,9.472,19.208,9.472,25.744s-4.816,16.304-9.464,25.752
c-7.984,16.24-17.056,34.648-9.592,52.64c7.72,18.616,27.6,25.296,45.152,31.184c9.176,3.08,19.584,6.576,23.76,10.744
c4.176,4.184,7.672,14.592,10.76,23.776c5.88,17.544,12.56,37.424,31.168,45.144c4.72,1.952,9.464,2.776,14.184,2.776
c13.304,0,26.48-6.488,38.464-12.384c9.44-4.656,19.2-9.464,25.744-9.464s16.312,4.816,25.76,9.464
c16.248,8,34.664,17.064,52.632,9.608c18.608-7.712,25.288-27.6,31.176-45.144c3.088-9.184,6.584-19.592,10.768-23.776
c4.176-4.176,14.584-7.664,23.76-10.752c17.544-5.888,37.432-12.56,45.152-31.168C388.761,252.45,379.689,234.034,371.689,217.786
z M342.961,231.922c4.504,9.144,10.672,21.656,8.76,26.256c-2.144,5.168-15.8,9.752-25.768,13.096
c-13.136,4.408-26.712,8.968-36.2,18.464c-9.504,9.496-14.064,23.08-18.472,36.208c-3.352,9.976-7.936,23.632-13.104,25.768
c-4.648,1.928-17.12-4.264-26.24-8.752c-12.736-6.272-25.896-12.76-39.896-12.76c-13.992,0-27.16,6.488-39.88,12.752
c-9.136,4.504-21.608,10.688-26.256,8.76c-5.16-2.136-9.744-15.792-13.088-25.76c-4.408-13.136-8.968-26.72-18.472-36.224
c-9.496-9.488-23.064-14.04-36.192-18.456c-9.968-3.344-23.632-7.936-25.776-13.112c-1.912-4.6,4.256-17.112,8.76-26.248
c6.272-12.728,12.76-25.896,12.76-39.888s-6.496-27.16-12.768-39.888c-4.504-9.136-10.672-21.656-8.776-26.24
c2.152-5.168,15.808-9.76,25.784-13.104c13.136-4.416,26.72-8.976,36.208-18.472c9.496-9.488,14.048-23.064,18.464-36.2
c3.344-9.976,7.936-23.64,13.096-25.776c0.592-0.248,1.312-0.352,2.136-0.352c5.624,0,16.16,5.184,24.128,9.112
c12.736,6.272,25.896,12.752,39.88,12.752c13.992,0,27.168-6.488,39.896-12.752c9.144-4.496,21.624-10.672,26.248-8.752
c5.168,2.144,9.752,15.8,13.096,25.776c4.408,13.136,8.96,26.712,18.456,36.208c9.504,9.496,23.08,14.056,36.216,18.464
c9.968,3.344,23.624,7.936,25.768,13.104c1.912,4.6-4.248,17.12-8.76,26.256c-6.264,12.728-12.752,25.896-12.752,39.88
C330.209,206.026,336.697,219.194,342.961,231.922z"/>
        <path fill="currentColor" d="M265.825,118.202c-6.248-6.248-16.384-6.248-22.632,0.008L118.257,243.25c-6.24,6.248-6.24,16.384,0.008,22.624
c3.128,3.128,7.216,4.68,11.312,4.68c4.096,0,8.192-1.56,11.32-4.688l124.936-125.04
C272.073,134.57,272.073,124.442,265.825,118.202z"/>
        <path fill="currentColor" d="M135.953,101.706c-23.744,0-43.064,19.32-43.064,43.064c0,23.752,19.32,43.072,43.064,43.072
c23.744,0,43.056-19.32,43.056-43.072C179.009,121.026,159.697,101.706,135.953,101.706z M135.953,155.842
c-6.096,0-11.064-4.968-11.064-11.072s4.96-11.064,11.064-11.064c6.096,0,11.056,4.968,11.056,11.064
C147.009,150.874,142.049,155.842,135.953,155.842z"/>
        <path fill="currentColor" d="M248.129,196.226c-23.744,0-43.056,19.328-43.056,43.08c0,23.744,19.312,43.056,43.056,43.056
c23.744,0,43.064-19.32,43.064-43.056C291.193,215.546,271.873,196.226,248.129,196.226z M248.129,250.362
c-6.096,0-11.056-4.96-11.056-11.056c0-6.112,4.96-11.08,11.056-11.08c6.104,0,11.064,4.968,11.064,11.08
C259.193,245.402,254.225,250.362,248.129,250.362z"/>
    </svg>
{/if}
{/strip}