SET time_zone = '+00:00';
SET NAMES utf8mb4;

DROP TABLE IF EXISTS `ok_advantages`;
CREATE TABLE `ok_advantages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `filename` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `text` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` int(11) DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `ok_advantages` (`id`, `filename`, `text`, `position`) VALUES
(1,	'advantage1_icon_1.jpg',	'Доставка по всей стране',	2),
(2,	'advantage2_icon_1.jpg',	'100% гарантия качества',	0),
(3,	'advantage3_icon_1.jpg',	'14 дней на возврат товара',	1),
(4,	'advantage4_icon_1.jpg',	'Самовывоз из магазина',	3);

DROP TABLE IF EXISTS `ok_authors`;
CREATE TABLE `ok_authors` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `position_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `meta_title` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `meta_keywords` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `meta_description` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_modify` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `position` int(11) NOT NULL DEFAULT 0,
  `visible` tinyint(1) NOT NULL DEFAULT 0,
  `socials` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `url` (`url`(100)),
  KEY `name` (`name`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `ok_authors` (`id`, `name`, `position_name`, `url`, `meta_title`, `meta_keywords`, `meta_description`, `description`, `image`, `last_modify`, `position`, `visible`, `socials`) VALUES
(1,	'Виталий Владов',	'Chief Executive Officer',	'vitalij-vladov',	'Виталий Владов',	'Виталий Владов',	'Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.',	'<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.</p>',	'vladovvitaliy.png',	'2020-06-03 09:14:54',	1,	1,	'[{\"url\":\"https:\\/\\/www.facebook.com\\/kniazdiit\"},{\"url\":\"https:\\/\\/www.instagram.com\\/lavvod\\/\"}]'),
(2,	'Александр Вавилин',	'Developer',	'vavilin-aleksandr',	'Александр Вавилин',	'Александр Вавилин',	'Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim a',	'<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis.</p>',	'vavilinalex.png',	'2020-06-03 10:56:56',	4,	1,	'[{\"url\":\"https:\\/\\/okay-cms.com\"}]'),
(3,	'Марина Баранец',	'Manager',	'baranets-marina',	'Баранец Марина',	'Баранец Марина',	'Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. \r\n Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas.',	'<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.</p>\r\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas.</p>',	'baranecmarina.png',	'2020-06-03 13:22:28',	2,	1,	'[]'),
(4,	'Олег Янчук',	'Developer',	'oleg-yanchuk',	'Олег Янчук',	'Олег Янчук',	'Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim a',	'<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat.</p>',	'yanchukoleg.png',	'2020-06-03 13:23:00',	3,	1,	'[{\"url\":\"https:\\/\\/www.facebook.com\\/profile.php?id=100012618646846&ref=bookmarks\"}]');

DROP TABLE IF EXISTS `ok_blog`;
CREATE TABLE `ok_blog` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `author_id` int(11) DEFAULT NULL,
  `name` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `meta_title` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `meta_keywords` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `meta_description` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `annotation` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `visible` tinyint(1) NOT NULL DEFAULT 0,
  `show_table_content` tinyint(1) NOT NULL DEFAULT 0,
  `date` timestamp NULL DEFAULT NULL,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `last_modify` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `main_category_id` int(11) DEFAULT NULL,
  `read_time` int(11) DEFAULT NULL,
  `updated_date` date DEFAULT NULL,
  `rating` float(3,1) DEFAULT 0.0,
  `votes` int(11) DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `enabled` (`visible`),
  KEY `url` (`url`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `ok_blog` (`id`, `author_id`, `name`, `url`, `meta_title`, `meta_keywords`, `meta_description`, `annotation`, `description`, `visible`, `show_table_content`, `date`, `image`, `last_modify`, `main_category_id`, `read_time`, `updated_date`, `rating`, `votes`) VALUES
(1,	3,	'Основные изменения в OkayCMS 2.0',	'osnovnye-izmeneniya-v-okaycms-20',	'Основные изменения в OkayCMS 2.0',	'Основные изменения в OkayCMS 2.0',	'1.        Административная панель.        Абсолютно новый дизайн, структура и верстка согласно современным подходам. Теперь админ-панель более дружелюбная, понятная и удобная для пользователя. Предусмотрено место для размещения нового функционала, доработок и модулей. Главный козырь новой админки &ndash; ее адаптивность. Вносить корректировки, обрабатывать заказы, отвечать на запросы теперь удобно с любого устройства.    \r\n   2.        Техническая поддержка OkayCMS.        В админ-панель внедрен функционал ',	'<p>1. Административная панель. Абсолютно новый дизайн, структура и верстка согласно современным подходам. Теперь админ-панель более дружелюбная, понятная и удобная для пользователя. Предусмотрено место для размещения нового функционала, доработок и модулей. Главный козырь новой админки &ndash; ее адаптивность. Вносить корректировки, обрабатывать заказы, отвечать на запросы теперь удобно с любого устройства.</p>',	'<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span style=\"color: #000000;\"><span lang=\"ru-RU\">1. </span></span><span style=\"color: #4f81bd;\"><span style=\"font-family: Cambria,serif;\"><span style=\"font-size: medium;\"><strong><span style=\"color: #000000;\">Административная панель. </span></strong></span></span></span><span style=\"color: #000000;\"><span lang=\"ru-RU\">Абсолютно новый дизайн, структура и верстка согласно современным подходам. Теперь админ-панель более дружелюбная, понятная и удобная для пользователя. Предусмотрено место для размещения нового функционала, доработок и модулей. Главный козырь новой админки &ndash; ее адаптивность. Вносить корректировки, обрабатывать заказы, отвечать на запросы теперь удобно с любого устройства. </span></span></p>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span style=\"color: #000000;\"><span lang=\"ru-RU\">2. </span></span><span style=\"color: #4f81bd;\"><span style=\"font-family: Cambria,serif;\"><span style=\"font-size: medium;\"><strong><span style=\"color: #000000;\">Техническая поддержка OkayCMS. </span></strong></span></span></span><span style=\"color: #000000;\"><span lang=\"ru-RU\">В админ-панель внедрен функционал для связи с техподдержкой </span></span><span style=\"color: #000000;\"><span lang=\"en-US\">OkayCMS</span></span><span style=\"color: #000000;\"><span lang=\"ru-RU\">. Теперь вам не нужно звонить, писать на почту или скайп. Задать вопросы, получить консультацию, помощь в установке </span></span><span style=\"color: #000000;\"><span lang=\"en-US\">CMS</span></span><span style=\"color: #000000;\"><span lang=\"ru-RU\">, шаблона или дополнения можно прямо из административной панели, отправив запрос в техподдержку. Это поможет нам быстрее отвечать на ваши вопросы, а история переписок по всем темам всегда будут храниться в одном месте - у вас в админке. <a href=\"https://okay-cms.com/support\">Подробнее о техподдержке</a>. </span></span></p>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span style=\"color: #000000;\"><span lang=\"ru-RU\">В 2.0 пользователь лицензионной </span><span lang=\"en-US\">OkayCMS</span> <span lang=\"en-US\">Pro</span><span lang=\"ru-RU\"> получит 10 часов бесплатной техподдержки, пользователь </span><span lang=\"en-US\">OkayCMS</span> <span lang=\"en-US\">Lite</span><span lang=\"ru-RU\"> &ndash; 30 минут с возможностью докупить часы техподдержки. </span></span></p>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span style=\"color: #000000;\"><span lang=\"ru-RU\">3. </span></span><span style=\"color: #4f81bd;\"><span style=\"font-family: Cambria,serif;\"><span style=\"font-size: medium;\"><strong><span style=\"color: #000000;\">Мультиязычнсть сайта. </span></strong></span></span></span><span style=\"color: #000000;\"><span lang=\"ru-RU\">Переделана мультиязычность клиентской части и добавлена мультиязычность админ-панели. Теперь переводы статических фраз хранятся не в базе данных, а в файлах. Для клиентской части это упрощает установку новых тем и возможность переключения между ними. Для обеих частей (как админки, так и клиентской) это облегчает перевод сайта на другие языки. Теперь сделать сайт для клиента полностью на иностранном языке не составляет проблемы. Для этого необходимо перевести фразы всего в двух файлах. На момент релиза в </span></span><span style=\"color: #000000;\"><span lang=\"en-US\">OkayCMS</span></span><span style=\"color: #000000;\"><span lang=\"ru-RU\"> 2.0 добавлено два языка для административной панели - русский и английский, но в ближайшее время их количество увеличится.</span></span></p>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span style=\"color: #000000;\"><span lang=\"ru-RU\">4. </span></span><span style=\"color: #4f81bd;\"><span style=\"font-family: Cambria,serif;\"><span style=\"font-size: medium;\"><strong><span style=\"color: #000000;\">Новый дефолтный шаблон.</span></strong></span></span></span><span style=\"color: #000000;\"><span lang=\"ru-RU\"> Код шаблона теперь чище и приятнее для разработчиков, детальнее прокомментирован. Сам шаблон теперь позволяет добавлять большое количество категорий.</span></span></p>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span style=\"color: #000000;\"><span lang=\"ru-RU\">5. </span></span><span style=\"color: #4f81bd;\"><span style=\"font-family: Cambria,serif;\"><span style=\"font-size: medium;\"><strong><span style=\"color: #000000;\">PHP 7.</span></strong></span></span></span><span style=\"color: #000000;\"><span lang=\"ru-RU\"> Полная поддержка PHP 7, которая позволит позволит сайтам на OkayCMS работать быстрее.</span></span></p>',	1,	0,	'2017-05-13 21:00:00',	'okaycms2.0.jpg',	'2020-06-03 09:31:33',	1,	0,	NULL,	0.0,	0),
(2,	4,	'Как работает техподдержка OkayCMS 2.0',	'kak-rabotaet-tehpodderzhka-okaycms-20',	'Как работает техподдержка OkayCMS 2.0',	'Как работает техподдержка OkayCMS 2.0',	'Приобретая лицензию OkayCMS Pro 2.0, вы получаете 10 часов комплексной поддержки и консультаций по работе с OkayCMS. Предлагаем более подробно ознакомиться с видами консультаций и регламентом работы службы поддержки.  \r\n  Специалисты технической поддержки выполняют следующие работы:  \r\n \r\n \r\n  дают консультации о системных требованиях для оптимальной работы системы;  \r\n \r\n \r\n  дают консультации по работе c OkayCMS для администратора магазина;  \r\n \r\n \r\n  предоставляют консультации по внедрению дополнительног',	'<p>Приобретая лицензию OkayCMS Pro 2.0, вы получаете 10 часов комплексной поддержки и консультаций по работе с OkayCMS. Предлагаем более подробно ознакомиться с видами консультаций и регламентом работы службы поддержки.</p>',	'<p><span lang=\"ru-RU\">Приобретая лицензию OkayCMS Pro 2.0, вы получаете 10 часов комплексной поддержки и консультаций по работе с OkayCMS. Предлагаем более подробно ознакомиться с видами консультаций и регламентом работы службы поддержки.</span></p>\r\n<h2 class=\"western\"><span lang=\"ru-RU\">Специалисты технической поддержки выполняют следующие работы:</span></h2>\r\n<ul>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">дают консультации о системных требованиях для оптимальной работы системы;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">дают консультации&nbsp;по работе c OkayCMS для администратора магазина;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">предоставляют консультации по внедрению дополнительного функционала в OkayCMS;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">оказывают помощь в установке OkayCMS на хостинг;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">проводят установку шаблонов и дополнений из</span><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">&nbsp;</span></span></span></span><a href=\"https://okay-cms.com/catalog/dopolneniya\"><span style=\"color: #38c0f3;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">MarketPlace OkayCMS</span></span></span></span></a><span lang=\"ru-RU\">;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">проводят обновление OkayCMS до последней актуальной версии.</span></p>\r\n</li>\r\n</ul>\r\n<h2 class=\"western\"><span lang=\"ru-RU\">Регламент работы:</span></h2>\r\n<ol>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">В административной панели вашего сайта на OkayCMS в разделе \"Техническая поддержка\" создайте новое обращение.</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">Подробно опишите проблему и сформулируйте название обращения. После этого подайте обращение на рассмотрение.&nbsp;</span><strong><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">Внимание! Одно обращение в службу поддержки должно содержать одну проблему, не пишите несколько проблем в одном обращении.</span></span></span></span></strong></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">Следите за </span><span lang=\"en-US\">E</span><span lang=\"ru-RU\">mail-уведомлениями о прогрессе решения вашего вопроса в течении одного рабочего дня. Ответ так же будет отображен в админ-панели вашего сайта.</span></p>\r\n</li>\r\n</ol>\r\n<h2 class=\"western\"><span lang=\"ru-RU\">Что может повлиять на время решения вашего запроса?</span></h2>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">Для ускорения реакции на ваше обращение мы советуем следовать простым правилам:</span></p>\r\n<ul>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">подробно описывайте проблему, шаги к ее воспроизведению;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">укажите реквизиты доступа в административную часть вашего сайта;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">укажите актуальные доступы к FTP и СУБД (PHPMyAdmin), если для решения проблемы необходимо вмешательство в исходный код;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">предоставьте информацию о версии продукта.</span></p>\r\n</li>\r\n</ul>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">Дополнительно службой поддержки может быть затребована информация о настройках ПО, а также информация для доступа к серверу по FTP, SSH или административной панели хостинг-провайдера.</span></p>\r\n<h2 class=\"western\"><span lang=\"ru-RU\">Обработка обращения прекращается в случае:</span></h2>\r\n<ul>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">если пользователь не может дать затребованную агентом поддержки информацию для решения вопроса;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">клиент не может предоставить доступы к сайту (FTP, SSH, панель управления хостингом и т. д.);</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">проблема не может быть воспроизведена;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">обращение содержит несколько связанных между собой проблем;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">хостинг не соответствует системным требованиям;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">вопрос задан неконкретно или диалог ведется в неконструктивной форме;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">вопрос выходит за рамки технической поддержки;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">если в течение 30 календарных дней ответ от пользователя не был получен, обращение считается обработанным автоматически.</span></p>\r\n</li>\r\n</ul>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"color: #767679;\">&nbsp;</span></p>\r\n<h2 class=\"western\"><span lang=\"ru-RU\">Услуги, которые не покрывает поддержка OkayCMS*:</span></h2>\r\n<ul>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">перенос данных с других систем;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">разработка дополнительного функционала;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">услуги по веб-разработке. Для этого обратитесь к нашим партнерам;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">web-дизайн;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">поддержка посторонних решений;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">работы по настройке сервера.&nbsp;</span></p>\r\n</li>\r\n</ul>\r\n<h2 class=\"western\"><span lang=\"ru-RU\">Если часы техподдержки закончились?</span></h2>\r\n<ol>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">Перейдите на сайт </span><span lang=\"en-US\">okay</span><span lang=\"ru-RU\">-</span><span lang=\"en-US\">cms</span><span lang=\"ru-RU\">.</span><span lang=\"en-US\">com</span><span lang=\"ru-RU\">/</span><span lang=\"en-US\">support</span><span lang=\"ru-RU\"> в раздел Техническая поддержка.</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">Приобретите необходимое количество часов техподдержки.</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">Ожидайте обновления техподдержки в админ-панели своего сайта.</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">После обновления отправьте свой запрос в техподдержку.</span></p>\r\n</li>\r\n</ol>',	1,	0,	'2017-05-12 22:00:00',	'background-bags-bows-1050244.jpg',	'2020-06-03 13:23:39',	1,	15,	NULL,	0.0,	0),
(3,	2,	'Как установить OkayCMS 2.0 на сайт',	'kak-ustanovit-okaycms-20-na-sajt',	'Как установить OkayCMS 2.0 на сайт',	'Как установить OkayCMS 2.0 на сайт',	'Шаг 1.    Файлы    для установки OkayCMS  \r\n    \r\n \r\n \r\n  Зайдите на официальный сайт OkayCMS.   \r\n \r\n \r\n  Кликните по кнопке          Скачать CMS в шапке сайта. \r\n \r\n \r\n  Сохраните файл к себе на компьютер. Сохраненный файл-архив имеет вид OkayCMS_1.0.1.zip (цифры в названии файла после слова OkayCMS могут отличаться, это зависит от скачиваемой вами версии).  \r\n \r\n \r\n  Разархивируйте файл OkayCMS_1.0.1.zip. (Кликните правой кнопкой мыши на файле и выберите пункт Извлечь в OkayCMS_1.0.1.)           \r\n \r\n \r\n',	'<p>Шаг 1. Файлы для установки OkayCMS Зайдите на официальный сайт OkayCMS. Кликните по кнопке Скачать CMS в шапке сайта. Сохраните файл к себе на компьютер. Сохраненный файл-архив имеет вид OkayCMS_1.0.1.zip (цифры в названии файла после слова OkayCMS могут отличаться, это зависит от скачиваемой вами версии).</p>',	'<h2 class=\"western\"><strong>Шаг 1. </strong><strong><span lang=\"ru-RU\">Файлы</span></strong><strong> для установки OkayCMS</strong></h2>\r\n<p lang=\"ru-RU\" style=\"margin-bottom: 0.35cm; line-height: 115%;\"><br /><br /></p>\r\n<ol>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">Зайдите на официальный сайт OkayCMS. </span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">Кликните по кнопке</span><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">&nbsp;</span></span></span></span>Скачать CMS в шапке сайта.</p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">Сохраните файл к себе на компьютер. Сохраненный файл-архив имеет вид OkayCMS_1.0.1.zip (цифры в названии файла после слова OkayCMS могут отличаться, это зависит от скачиваемой вами версии).</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">Разархивируйте файл OkayCMS_1.0.1.zip. (Кликните правой кнопкой мыши на файле и выберите пункт Извлечь в OkayCMS_1.0.1.)</span><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">&nbsp;</span></span></span></span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">После распаковки архива появится папка OkayCMS_1.0.1, внутри которой будут 2 файла:&nbsp;install.php&nbsp;и&nbsp;okaycms.zip. Эти файлы необходимо загрузить на сервер вашего хостинг-провайдера в корень вашего сайта.</span></p>\r\n</li>\r\n</ol>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">ВНИМАНИЕ! В корень сайта необходимо поместить 2 файла, которые были извлечены из архива OkayCMS_1.0.1.zip, а не сам архив.</span></p>\r\n<h2 class=\"western\"><strong>Шаг 2. Создание базы данных</strong></h2>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"color: #767679;\">&nbsp;</span></p>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"font-family: Times New Roman,serif;\"><span style=\"font-size: medium;\"><span lang=\"ru-RU\">ВНИМАНИЕ! Далее вы будете работать с панелью управления хостинга. Существует большое количество хостинг-провайдеров. Однако</span><span lang=\"ru-RU\">&nbsp;</span><span lang=\"ru-RU\">принцип проводимых действий везде одинаковый.</span></span></span></p>\r\n<p lang=\"ru-RU\" style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><br /><br /></p>\r\n<ol>\r\n<li>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"font-family: Times New Roman,serif;\"><span style=\"font-size: medium;\"><span lang=\"ru-RU\">Зайдите в панель управления вашего хостинга и выберите пункт</span><span lang=\"ru-RU\">&nbsp;</span><span lang=\"ru-RU\">Базы данных.</span></span></span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"font-family: Times New Roman,serif;\"><span style=\"font-size: medium;\"><span lang=\"ru-RU\">Найдите и кликните</span><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">&nbsp;</span></span></span></span><strong><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">Создать базу данных</span></span></span></span></strong><span lang=\"ru-RU\">. В появившемся окне введите</span><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">&nbsp;</span></span></span></span><strong><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">имя базы данных, используя английскую раскладку</span></span></span></span></strong><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">&nbsp;</span></span></span></span><span lang=\"ru-RU\">клавиатуры. Запишите его, оно вам пригодится далее.</span></span></span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"font-family: Times New Roman,serif;\"><span style=\"font-size: medium;\"><span lang=\"ru-RU\">Выберите кодировку</span><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">&nbsp;</span></span></span></span><strong><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">utf8_general_ci</span></span></span></span></strong><span lang=\"ru-RU\">. (Иногда вместо слова Кодировка может быть слово Сравнение)</span></span></span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"font-family: Times New Roman,serif;\"><span style=\"font-size: medium;\"><span lang=\"ru-RU\">Введите имя пользователя, если оно не сгенерировалось автоматически. Так же запишите это имя, оно будет использоваться далее. </span></span></span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"font-family: Times New Roman,serif;\"><span style=\"font-size: medium;\"><span lang=\"ru-RU\">Кликните кнопку</span><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">&nbsp;</span></span></span></span><strong><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">Создать.</span></span></span></span></strong></span></span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"font-family: Times New Roman,serif;\"><span style=\"font-size: medium;\"><span lang=\"ru-RU\">Появится сообщение: база данных успешно создана.</span></span></span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"font-family: Times New Roman,serif;\"><span style=\"font-size: medium;\"><span lang=\"ru-RU\">Для доступа используйте логин ****** и пароль *******</span></span></span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"font-family: Times New Roman,serif;\"><span style=\"font-size: medium;\"><span lang=\"ru-RU\">Запишите пароль к базе данных.</span></span></span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"font-family: Times New Roman,serif;\"><span style=\"font-size: medium;\"><span lang=\"ru-RU\">Возможно, на некоторых хостингах пароль вам придется придумать самостоятельно.</span></span></span></p>\r\n</li>\r\n</ol>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\">&nbsp;</p>\r\n<h2 class=\"western\"><strong>Шаг 3. Загрузка дистрибутива на хостинг</strong></h2>\r\n<p lang=\"ru-RU\" style=\"margin-bottom: 0.35cm; line-height: 115%;\"><br /><br /></p>\r\n<ol>\r\n<li>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"font-family: Times New Roman,serif;\"><span style=\"font-size: medium;\"><span lang=\"ru-RU\">Для загрузки файлов на хостинг понадобится FTP-менеджер, например</span><span lang=\"ru-RU\">&nbsp;</span><span lang=\"ru-RU\">FileZilla,</span><span lang=\"ru-RU\">&nbsp;</span><span lang=\"ru-RU\">Total Commander. </span></span></span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"font-family: Times New Roman,serif;\"><span style=\"font-size: medium;\"><span lang=\"ru-RU\">Запустите FTP-менеджер FileZilla. Для соединения с сервером введите данные, предоставленные вашим хостинг-провайдером и нажмите кнопку Соединение</span></span></span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"font-family: Times New Roman,serif;\"><span style=\"font-size: medium;\"><span lang=\"ru-RU\">В одной из двух частей окна вашего файл-менеджера найдите папку OkayCMS, которую вы создали в Шаге1, зайдите в нее и закачайте файлы</span><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">&nbsp;</span></span></span></span><strong><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">install.php</span></span></span></span></strong><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">&nbsp;</span></span></span></span><span lang=\"ru-RU\">и</span><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">&nbsp;</span></span></span></span><strong><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">okaycms_source.zip</span></span></span></span></strong><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">&nbsp;</span></span></span></span><span lang=\"ru-RU\">на сервер в корень сайта. (Кликните правой кнопкой мыши на файле и выберите</span><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">&nbsp;</span></span></span></span><strong><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">Закачать на сервер</span></span></span></span></strong><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">&nbsp;</span></span></span></span><span lang=\"ru-RU\">или просто перетащите файлы мышкой с левой в другую часть окна).</span></span></span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"font-family: Times New Roman,serif;\"><span style=\"font-size: medium;\"><span lang=\"ru-RU\">На этом работа с FTP-менеджером FileZilla закончена.</span></span></span></p>\r\n</li>\r\n</ol>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"color: #767679;\">&nbsp;</span></p>\r\n<h2 class=\"western\"><a name=\"_GoBack\"></a><strong><span lang=\"ru-RU\">Шаг 4. Завершающий этап установки</span></strong></h2>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">Далее читайте Инструкцию в <a href=\"https://okay-cms.com/article/kak-ustanovit-okaycms-na-sajt\">блоге OkayCMS</a>.</span></p>',	1,	1,	'2017-05-13 21:00:00',	'install_okaycms.png',	'2020-06-03 09:27:26',	2,	0,	NULL,	0.0,	0),
(4,	3,	'Город Нью-Йорк (New York City)',	'gorod-nyu-jork-new-york-city',	'Город Нью-Йорк (New York City)',	'Город Нью-Йорк (New York City)',	'Почти год мы работали над улучшением OkayCMS. Куда еще лучше? спроосите вы, а вот мы нашли. Технологии все время развиваются, и мы не хотим отставать. Наша цель вести свою систему к простоте и функциональности, своевременно удовлетворять запросы пользователей. Поэтому обновление принесло в OkayCMS новые полезные штуки и унесло неиспользуемый функционал и какие-то недочеты, которые в том числе и вы нам помогали искать. Что же в итоге получилось, узнаете из текста. ',	'<p>Нью-Йорк &mdash; пожалуй, самый известный город в мире, в котором сосредоточены финансовые учреждения, многочисленные исторические и культурные достопримечательности, музеи, магазины, театры и многое другое. Это шумный и яркий город небоскребов и свободы, который многим знаком по обилию кинофильмов и фото, где действие разворачивается на его улицах. Здесь столько возможностей, сколько можно вообразить. От Таймс-сквер до самого темного уголка Бронкса &mdash; царство крайностей. От русского анклава в Бруклине на Брайтон-Бич до филиала Южной Америки в Квинсе &mdash; сообщества из любой страны мира.</p>',	'<p><strong>Нью-Йорк</strong> &mdash; пожалуй, самый известный город в мире, в котором сосредоточены финансовые учреждения, многочисленные исторические и культурные достопримечательности, музеи, магазины, театры и многое другое. Это шумный и яркий город небоскребов и свободы, который многим знаком по обилию кинофильмов и фото, где действие разворачивается на его улицах. Здесь столько возможностей, сколько можно вообразить. От Таймс-сквер до самого темного уголка Бронкса &mdash; царство крайностей. От русского анклава в Бруклине на Брайтон-Бич до филиала Южной Америки в Квинсе &mdash; сообщества из любой страны мира.</p>\r\n<p class=\"video\" style=\"text-align: center;\"><iframe src=\"https://www.youtube.com/embed/TmDKbUrSYxQ\" width=\"560\" height=\"315\" frameborder=\"0\" allowfullscreen=\"allowfullscreen\"></iframe></p>\r\n<h3 style=\"text-align: center;\">Основные моменты</h3>\r\n<p>Две главные достопримечательности, давно ставшие символами Нью-Йорка &ndash; это его легендарные небоскребы (например, Эмпайр Стейт Билдинг) и Статуя Свободы. Величественные здания можно осмотреть и при пешей прогулке, а вот до другого объекта можно добраться только на пароме с Нижнего Манхеттена.</p>\r\n<div class=\"table\">\r\n<div class=\"table__row\">\r\n<div class=\"table__cell\">Практически все самые известные достопримечательности сосредоточены на Манхеттене. Здесь находятся известные на весь мир Уолт-стрит, где кипит финансовая жизнь всей Америки, Бродвей с многочисленными театрами, Центральный вокзал, самая дорогая улица &ndash; Пятая Авеню с шикарными магазинами и ресторанами, Рокфеллер-центр, около которого каждое Рождество устанавливают огромную ель, Музейная миля со всемирно известными музеями. Но самым посещаемым местом является Таймс Сквер. Здесь всегда многолюдно и в разгар рабочего дня, и ночью, когда включается впечатляющая неоновая подсветка.</div>\r\n<div class=\"table__cell\"><img src=\"../files/uploads/architecture-buildings-car-1634275.jpg\" width=\"800\" height=\"533\" /></div>\r\n</div>\r\n</div>\r\n<p>Непременно стоит заглянуть и в другие районы города. Хотя бы для того, чтобы почувствовать их атмосферу, в каждом из них можно найти много интересного. Так, например, Бронксе имеется зоопарк и ботанический сад.</p>\r\n<p>В каждом округе Нью-Йорка есть свои парки и скверы, но самым известным, несомненно, является огромный Центральный парк в сердце Манхеттена. Это искусственно созданный уголок природы посреди серого бетонного мегаполиса.</p>\r\n<p>Нью-Йорк уже давно приобрел славу одного из самых дорогих городов в мире. Поэтому проживание, еда, покупки и передвижение по городу обойдется в немалую сумму. Но все же здесь стоит побывать хотя бы раз в жизни. Кто-то влюбляется в Нью-Йорк с первого взгляда, кто-то начинает ненавидеть этот мегаполис с безумным ритмом жизни. В любом случае равнодушно относиться к этому городу невозможно.</p>\r\n<h3 style=\"text-align: center;\">Достопримечательности Нью-Йорка</h3>\r\n<div class=\"table\">\r\n<div class=\"table__row\">\r\n<div class=\"table__cell table__cell--col-3\">\r\n<figure><img src=\"../files/uploads/okay_mankhetten.jpg\" alt=\"Манхеттен\" width=\"380\" height=\"380\" />\r\n<figcaption>Манхэттен &ndash; самый маленький и при этом наиболее популярный среди туристов район...</figcaption>\r\n</figure>\r\n</div>\r\n<div class=\"table__cell table__cell--col-3\">\r\n<figure><img src=\"../files/uploads/okay_statuya_svobody.JPG\" alt=\"Статуя Свободы\" width=\"380\" height=\"380\" />\r\n<figcaption>Статуя Свободы &mdash; одна из самых знаменитых скульптур в мире, это символ Нью-Йорка ...</figcaption>\r\n</figure>\r\n</div>\r\n<div class=\"table__cell table__cell--col-3\">\r\n<figure><img src=\"../files/uploads/okay_bruklin.jpg\" alt=\"Бруклин\" width=\"380\" height=\"380\" />\r\n<figcaption>Бруклин &mdash; второй по популярности район в Нью-Йорке после Манхэттена, в котором проживает 2,5...</figcaption>\r\n</figure>\r\n</div>\r\n<div class=\"table__cell table__cell--col-3\">\r\n<figure><img src=\"../files/uploads/okay_pyatoe_avenyu.jpg\" alt=\"Пятая авеню\" width=\"380\" height=\"380\" />\r\n<figcaption>Пятая авеню &mdash; улица в самом центре Манхеттен, которая также представляет собой яркий символ...</figcaption>\r\n</figure>\r\n</div>\r\n<div class=\"table__cell table__cell--col-3\">\r\n<figure><img src=\"../files/uploads/okay_broadway.jpg\" alt=\"Бродвей\" width=\"380\" height=\"380\" />\r\n<figcaption>Бродвей &ndash; это не только главная улица Нью-Йорка, а возможно и всех Соединенных Штатов, это еще и...</figcaption>\r\n</figure>\r\n</div>\r\n<div class=\"table__cell table__cell--col-3\">\r\n<figure><img src=\"../files/uploads/okay_uoll_strit.jpg\" alt=\"Уолл Стрит\" width=\"380\" height=\"380\" />\r\n<figcaption>Уолл-стрит &mdash; небольшая узкая улица в нижней части Манхэттена, ведущая от Бродвея к побережью...</figcaption>\r\n</figure>\r\n</div>\r\n</div>\r\n</div>\r\n<h3 style=\"text-align: center;\">Музеи Нью-Йорка</h3>\r\n<div class=\"table\">\r\n<div class=\"table__row\">\r\n<div class=\"table__cell\"><img src=\"../files/uploads/okay_museum.jpg\" alt=\"Музеи нью Йорка\" width=\"1024\" height=\"500\" /></div>\r\n<div class=\"table__cell\">\r\n<p>Пожалуй, вся оставшаяся жизнь ушла бы у вас на посещение 120 музеев Нью-Йорка. Ниже приводится далеко не полный их перечень.</p>\r\n<ol>\r\n<li>Художественный музей Метрополитен.</li>\r\n<li>Музей современного искусства.</li>\r\n<li>Музей Гуггенхайма.</li>\r\n<li>Музей американского искусства Уитни.</li>\r\n<li>Американский музей естествознания.</li>\r\n<li>Музей города Нью-Йорка.</li>\r\n<li>Национальный музей американских индейцев.</li>\r\n</ol>\r\n</div>\r\n</div>\r\n</div>\r\n<h3 style=\"text-align: center;\">Остров Манхэттен</h3>\r\n<p>Этот остров длиной 21 км и шириной 3 км содержит почти все, что бы вам хотелось посмотреть. Четыре других городских района: Бруклин, Куинс, Стейтен-Айленд и Бронкс (все большей частью жилые) &mdash; по-своему неповторимы, но для местных жителей и приезжих Нью-Йорк &mdash; это Манхэттен.</p>\r\n<p><strong>Мидтаун.</strong> Вполне возможно, что ваша гостиница окажется в Мидтауне, откуда легко добраться пешком до любого лежащего окрест места. Нью-Йорк отличает еще то, что он замечательно подходит для пеших прогулок по своим широким тротуарам. В любом случае начинать надо от центра.</p>\r\n<p><strong>Рокфеллеровский центр</strong>. Это скопление вознесшихся вверх башен из индианского известняка между Пятой и Шестой авеню, от 48-й до 51-й улицы составляет сердцевину Нью-Йорка. Джон Д. Рокфеллер-младший арендовал данный участок земли у Колумбийского университета в 1928 г., чтобы спасти его от дурной славы притона для питейных заведений в пору действия сухого закона. Они вскоре исчезли, уступив место первым небоскребам, где размещались правления компаний и центр радиовещания, которые соединялись с подземным залом, где находилось свыше 200 магазинов и ресторанов.</p>\r\n<p><strong>Пятая авеню</strong>. Этот проспект, по меньшей мере отрезок между 34-й улицей и Центральным парком, стал олицетворением роскоши, которой можно вкусить или полюбоваться. Если ваши средства не позволяют остановиться в гостинице &laquo;Плаза&raquo;, можно насладиться не столь вызывающей роскошью усеянных бриллиантами витрин ювелирных магазинов Тиффани, либо Картье, либо Ван-Клефа и Арпельса. Они просто восхитительны, особенно под Рождество.</p>\r\n<blockquote>\r\n<p>Порой я устаю от прогулок по прекрасным улицам Лос-Анджелеса. Я понимаю, что это звучит ненормально, но у меня возникает желание съездить в Нью-Йорк и понаблюдать за страданиями людей.</p>\r\n<cite>Донна Саммер</cite></blockquote>\r\n<p><span style=\"font-size: 10pt;\">*Материалы для оформления этой статьи были частично взяты с ресурса <em>wikiway.com</em></span></p>',	1,	1,	'2018-06-25 21:00:00',	'coffee-dark-design-1581687.jpg',	'2020-06-03 10:58:41',	1,	8,	'2020-06-04',	5.0,	32),
(5,	1,	'OkayCMS 3.0',	'okaycms-30',	'OkayCMS 3.0',	'OkayCMS 3.0',	'Достопримечательности Нью-Йорка \r\n \r\n \r\n \r\n  \r\n Манхэттен &ndash; самый маленький и при этом наиболее популярный среди туристов район... \r\n \r\n \r\n \r\n  \r\n Статуя Свободы &mdash; одна из самых знаменитых скульптур в мире, это символ Нью-Йорка ... \r\n \r\n \r\n \r\n  \r\n Бруклин &mdash; второй по популярности район в Нью-Йорке после Манхэттена, в котором проживает 2,5... \r\n \r\n \r\n \r\n  \r\n Пятая авеню &mdash; улица в самом центре Манхеттен, которая также представляет собой яркий символ... \r\n \r\n \r\n \r\n  \r\n Бродвей &ndash; э',	'<p>Наша команда достаточно долго работала над новой версией OkayCMS 3.0.0 Изменения включенные в новую версию, существенно расширили функциональные возможности. Было внедрено множество глобальных изменений с полностью переработанным ядром и полностью обновленным программным кодом. Мы надеемся вы оцените нашу работу и новые возможности системы;</p>',	'<h3 style=\"text-align: center;\">Вышла новая версия OKAY CMS 3</h3>\r\n<p>Наша команда достаточно долго работала над новой версией OkayCMS 3.0.0 Изменения включенные в новую версию, существенно расширили функциональные возможности.</p>\r\n<p>Было внедрено множество глобальных изменений с полностью переработанным ядром и полностью обновленным программным кодом. Мы надеемся вы оцените нашу работу и новые возможности системы</p>\r\n<div class=\"table\">\r\n<div class=\"table__row\">\r\n<div class=\"table__cell\">\r\n<h5>1. Новый дизайн</h5>\r\n<figure><img src=\"../files/uploads/article_okay_design.jpg\" alt=\"\" width=\"800\" height=\"800\" />\r\n<figcaption>Новый дизайн разработан по всем требованиям юзабилити для интернет-магазинов</figcaption>\r\n</figure>\r\n</div>\r\n<div class=\"table__cell\">\r\n<h5>2. Раздел обучения</h5>\r\n<figure><img src=\"../files/uploads/article_okay_learning%20(1).jpg\" alt=\"Okaycms Learning\" width=\"800\" height=\"800\" />\r\n<figcaption>Новый раздел обучение, где собраны инструкции для базовых работ на сайте.</figcaption>\r\n</figure>\r\n</div>\r\n<div class=\"table__cell\">\r\n<h5>2. Модульность</h5>\r\n<figure><img src=\"../files/uploads/article_okay_module.jpg\" alt=\"OkaycmsModules\" width=\"800\" height=\"800\" />\r\n<figcaption>Полностью переработанная структура, появление модульности</figcaption>\r\n</figure>\r\n</div>\r\n<div class=\"table__cell\">\r\n<h5>2. Настройка цветов сайта</h5>\r\n<figure><img src=\"../files/uploads/article_okay_settings.jpg\" alt=\"Okaycms Settings\" width=\"800\" height=\"799\" />\r\n<figcaption>В настройках дизайна появился новый блок, для настройки цветов сайта</figcaption>\r\n</figure>\r\n</div>\r\n</div>\r\n</div>\r\n<h3 style=\"text-align: center;\">Почему мы пошли на такое глобальное изменение?</h3>\r\n<p><strong>Первая</strong>. Основа первой и второй версии OkayCMS была сделана с использованием старого кода. На момент создания нашей системы, в 2015 году код, который использовался ещё был актуальным, но входить в 2020 год с тем что было - нехорошо.</p>\r\n<p><strong>Вторая.</strong> Проблемы с расширением функционала магазина. В силу того что прошлые версии системы были не модульные, когда приходилось глобально расширять функционал - все изменения вносились сразу в ядро и это создавало сложный код. Все последующие доработки в такой проект внедрялись всё сложнее и сложнее. Сейчас, с переходом к модульности эта проблема частично будет решена.</p>\r\n<p><strong>Третья.</strong> Обновления системы. Эта проблема частично вытекает из второй. Когда доработки затрагивали ядро системы, сделать обновление доработанной системы было проблематично. В некоторых случаях более разумно было отказаться от обновлений сильно доработанной системы. Теперь, когда работы будут выполняться отдельно от ядра - обновления системы должны проходить быстрее и безболезненнее.</p>\r\n<p><strong>Четвертая.</strong> Удобство для новых пользователей. Основа успешного развития - это хорошее коммьюнити вокруг продукта. Код прошлых версий был простой, удобный, но всё же специфический, не использующий паттернов и сделанный \"по своему\". Проблема, которая из этого вытекала, новым программистам, которые начинали свое образование с разбирательсв с фреймворками вроде Laravel система казалась сразу непонятной и они не сильно хотели браться делать на ней небольшие доработки. Новая версия системы больше соответсвует основным трендам в мире программирования и должна сделать более простой порог входа для новых программистов, новых веб-студий и т.п. которые решат использовать нашу систему в работе.</p>\r\n<h3 style=\"text-align: center;\">Как обновиться с прошлых версий OkayCMS до версии 3.*?</h3>\r\n<p>OkayCMS 3 - это система с полностью переработанным ядром и полностью обновленным программным кодом, поэтому шаблоны и модули с прошлых версий несовместимы.</p>\r\n<p>Все владельцы лицензий Pro версии OkayCMS могут заказать перенос своих данных на новую версию или же, в случае большого количества доработок и индивидуальных шаблонов - остаться на версии 2.* которую мы будем продолжать поддерживать и на которую мы будем выпускать обновления, содержащие фиксы замечаний, о которых нам будет известно. Перенос данных на версию 3.* с предыдущих версий займет 1 час времени техподдержки.</p>\r\n<p>В случае переноса данных на новую версию мы перенесем на версию 3.* все ваши товары, категории, бренды, страницы, записи блога, заказы и зарегистрированных покупателей. После переноса вы получите сайт со всем функционалом версии OkayCMS 3.* дизайном версии 3.* и содержимым базы данных с вашего сайта на предыдущей версии OkayCMS. Для заказа обновления до 3.0 напишите нам на почту info@okay-cms.com или обратитесь в тех.поддержку из админ. панели.</p>',	1,	1,	'2019-07-06 21:00:00',	'dream-come-true.jpg',	'2020-06-03 09:05:55',	1,	0,	NULL,	0.0,	0),
(6,	2,	'Инструкция по оформлению статей',	'instruktsiya-po-oformleniyu-statej',	'Инструкция по оформлению статей',	'Инструкция по оформлению статей, Статьи',	'Заголовки  \r\n Наличие заголовков  &lt;h1&gt;  &mdash;  &lt;h6&gt;  в статьях важны для SEO оптимизации. Поисковые роботы их сканируют, и на основе ключевой информации в статях, формируют выдачу . Они также отвечают за структуру страницы и ранжируются по приоритету важности. \r\n Заголовок  &lt;h1&gt;  - это всегда название статьи и на странице он должен быть только один. В статьях важные разделы лучше разделяйте заголовками  &lt;h2&gt;  и всегда соблюдайте иерархию вложенности. Не допускайте, чтобы заголовок ',	'<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.</p>',	'<h2><strong>Заголовки</strong></h2>\r\n<p>Наличие заголовков <strong>&lt;h1&gt;</strong> &mdash; <strong>&lt;h6&gt; </strong>в статьях важны для SEO оптимизации. Поисковые роботы их сканируют, и на основе ключевой информации в статях, формируют выдачу . Они также отвечают за структуру страницы и ранжируются по приоритету важности.</p>\r\n<p><img class=\"fn_img_zoom\" src=\"data:image/png;base64,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\" width=\"700\" height=\"299\" /></p>\r\n<p>Заголовок <strong>&lt;h1&gt;</strong> - это всегда название статьи и на странице он должен быть только один. В статьях важные разделы лучше разделяйте заголовками <strong>&lt;h2&gt; </strong>и всегда соблюдайте иерархию вложенности. Не допускайте, чтобы заголовок младшего уровня стоял выше старшего!</p>\r\n<blockquote>\r\n<p>Кстати в системе <strong>OkayCMC</strong> оглавления в статьях строится на заголовках. Вам не нужно их создавать вручную и прописывать им якоря. Оглавление для статьи формируется автоматически с якорями на нужный раздел.</p>\r\n</blockquote>\r\n<p>&nbsp;</p>\r\n<h2><strong>Оформление маркированного и нумированного списков</strong></h2>\r\n<p>Часто в статьях приходиться как то выделить набор отдельных фраз или предложений, которые начинаются с маркера или цифры. В таких случаях лучший способ использовать списки. С их помощью можно упорядочить и систематизировать разные данные и представить их в наглядном и удобном для пользователя виде. В примерах ниже приведены варианты оформлений, как по умолчанию, так и дополнительного вида.</p>\r\n<div>&nbsp;</div>\r\n<h3>Нумированный список по умолчанию:</h3>\r\n<ol>\r\n<li>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Lorem ipsum dolor sit amet, consectetur adipiscing elit.</li>\r\n<li>In eget velit vulputate, aliquam tellus vel, cursus purus.</li>\r\n<li>Curabitur fermentum justo quis sem lacinia, pharetra bibendum purus congue.</li>\r\n<li>Curabitur tempor enim quis lobortis tristique.</li>\r\n<li>Praesent blandit turpis sed odio accumsan, a scelerisque risus ornare.</li>\r\n</ol>\r\n<p>&nbsp;</p>\r\n<h3>Маркированного списка по умолчанию:</h3>\r\n<ul>\r\n<li>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Lorem ipsum dolor sit amet, consectetur adipiscing elit.</li>\r\n<li>In eget velit vulputate, aliquam tellus vel, cursus purus.</li>\r\n<li>Curabitur fermentum justo quis sem lacinia, pharetra bibendum purus congue.</li>\r\n<li>Curabitur tempor enim quis lobortis tristique.</li>\r\n<li>Praesent blandit turpis sed odio accumsan, a scelerisque risus ornare.</li>\r\n</ul>\r\n<p>&nbsp;</p>\r\n<h2 id=\"5\"><strong>Изображения и видео</strong></h2>\r\n<p>Чтобы Ваша статья смотрелась более презентабельной, оформляйте её различными изображениями, иллюстрациями, подходящие по смыслу к абзацу или заголовку . Добавляйте картинки как полным изображением, так и слайдером.</p>\r\n<p><img class=\"fn_img_zoom\" src=\"data:image/png;base64,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\" width=\"700\" height=\"288\" /></p>\r\n<p>В текстовом редакторе для изображений, добавлены несколько классов для их оформления. Если изображению добавить класс <strong>image_zoom</strong>, то по клику на него, откроется модальное окно с увеличенной версией этого изображения.</p>\r\n<p><img class=\"fn_img_zoom\" src=\"data:image/jpeg;base64,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\" width=\"800\" height=\"600\" /></p>\r\n<p>Классы <strong>image_slider</strong> и<strong> image_gallery </strong>формируют карусель из загруженных друг за другом изображений. Главное различие между ними в том, что <strong>image_gallery</strong> формирует карусель из трех слайдов, в <strong>image_slider </strong>из одного.</p>\r\n<p><img class=\"fn_img_gallery\" src=\"data:image/jpeg;base64,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\" width=\"800\" height=\"600\" /></p>\r\n<p><img class=\"fn_img_gallery\" src=\"data:image/jpeg;base64,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\" width=\"800\" height=\"600\" /></p>\r\n<p><img class=\"fn_img_gallery\" src=\"data:image/jpeg;base64,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\" width=\"800\" height=\"600\" /></p>\r\n<p><img class=\"fn_img_gallery\" src=\"data:image/jpeg;base64,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\" width=\"800\" height=\"600\" /></p>',	1,	1,	'2020-05-31 21:00:00',	'blogmanual.jpg',	'2020-06-03 10:34:44',	3,	12,	'2020-06-03',	0.0,	0);

DROP TABLE IF EXISTS `ok_blog_categories`;
CREATE TABLE `ok_blog_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) NOT NULL DEFAULT 0,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `name_h1` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `meta_title` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `meta_keywords` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `meta_description` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `annotation` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `position` int(11) NOT NULL DEFAULT 0,
  `visible` tinyint(1) NOT NULL DEFAULT 1,
  `external_id` varchar(36) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `level_depth` tinyint(1) NOT NULL DEFAULT 1,
  `last_modify` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `created` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `parent_id` (`parent_id`),
  KEY `position` (`position`),
  KEY `visible` (`visible`),
  KEY `external_id` (`external_id`),
  KEY `created` (`created`),
  KEY `url` (`url`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `ok_blog_categories` (`id`, `parent_id`, `name`, `name_h1`, `meta_title`, `meta_keywords`, `meta_description`, `annotation`, `description`, `url`, `image`, `position`, `visible`, `external_id`, `level_depth`, `last_modify`, `created`) VALUES
(1,	0,	'Новости',	'',	'Новости',	'Новости',	'',	'',	'',	'news',	'',	1,	1,	'',	1,	'2020-05-19 05:06:47',	NULL),
(2,	0,	'Статьи',	'',	'Статьи',	'Статьи',	'',	'',	'',	'blog',	'',	2,	1,	'',	1,	'2020-05-19 05:07:03',	NULL),
(3,	2,	'Советы',	'',	'Советы',	'Советы',	'',	'',	'',	'sovety',	'',	3,	1,	'',	2,	'2020-06-03 07:56:18',	NULL);

DROP TABLE IF EXISTS `ok_blog_categories_relation`;
CREATE TABLE `ok_blog_categories_relation` (
  `post_id` int(11) NOT NULL,
  `category_id` int(11) NOT NULL,
  `position` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`post_id`,`category_id`),
  KEY `position` (`position`),
  KEY `post_id` (`post_id`),
  KEY `category_id` (`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `ok_blog_categories_relation` (`post_id`, `category_id`, `position`) VALUES
(1,	1,	0),
(2,	1,	0),
(3,	2,	0),
(4,	1,	0),
(5,	1,	0),
(6,	3,	0),
(6,	2,	1);

DROP TABLE IF EXISTS `ok_brands`;
CREATE TABLE `ok_brands` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `meta_title` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `meta_keywords` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `meta_description` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `annotation` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_modify` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `position` int(11) NOT NULL DEFAULT 0,
  `visible` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `url` (`url`(100)),
  KEY `name` (`name`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `ok_brands` (`id`, `name`, `url`, `meta_title`, `meta_keywords`, `meta_description`, `annotation`, `description`, `image`, `last_modify`, `position`, `visible`) VALUES
(1,	'Puff',	'puff',	'Puff',	'Puff',	'Puff',	'',	'',	'pkay-puff.png',	'2019-06-10 08:56:29',	1,	1),
(2,	'Алтермо',	'altermo',	'Алтермо',	'Алтермо',	'Алтермо',	'',	'',	'altermo.png',	'2017-05-11 09:12:59',	2,	1),
(3,	'Ferroli',	'ferroli',	'Ferroli',	'Ferroli',	'Ferroli',	'',	'',	'ferroli.jpg',	'2017-05-11 09:12:59',	3,	1),
(4,	'Global',	'global',	'Global',	'Global',	'Global',	'',	'',	'global.png',	'2017-05-11 09:12:59',	4,	1),
(5,	'Atlantic',	'atlantic',	'Atlantic',	'Atlantic',	'Atlantic',	'',	'',	'atlantic.png',	'2017-05-11 09:12:59',	5,	1),
(6,	'Beretta',	'beretta',	'Beretta',	'Beretta',	'Beretta',	'',	'',	'beretta.jpg',	'2019-06-10 10:48:52',	6,	1),
(7,	'Bosch',	'bosch',	'Bosch',	'Bosch',	'Bosch',	'<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus</p>\r\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus</p>',	'<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus</p>\r\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus</p>\r\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus</p>',	'bosch.png',	'2019-06-12 09:59:48',	7,	1),
(8,	'Vaillant',	'vaillant',	'Vaillant',	'Vaillant',	'Vaillant',	'',	'',	'vaillant.jpg',	'2017-05-11 09:13:00',	8,	1),
(10,	'Organik food',	'organikfood',	'Organik food',	'Organik food',	'',	'',	'',	'organik-food.png',	'2019-05-28 12:30:05',	10,	1),
(11,	'Nature product',	'natureproduct',	'Nature product',	'Nature product',	'Есть много вариантов Lorem Ipsum, но большинство из них имеет не всегда приемлемые модификации, например, юмористические вставки или слова, которые даже отдалённо не напоминают латынь. Если вам нужен Lorem Ipsum для серьёзного проекта, вы наверняка не хотите какой-нибудь шутки, скрытой в середине абзаца.',	'<p>Есть много вариантов Lorem Ipsum, но большинство из них имеет не всегда приемлемые модификации, например, юмористические вставки или слова, которые даже отдалённо не напоминают латынь. Если вам нужен Lorem Ipsum для серьёзного проекта, вы наверняка не хотите какой-нибудь шутки, скрытой в середине абзаца.</p>',	'',	'brand41ff.png',	'2019-05-28 12:35:49',	11,	1),
(12,	'Fitbit',	'fitbit',	'Fitbit',	'Fitbit',	'',	'',	'',	'fitbit-logo.png',	'2019-07-05 12:31:30',	12,	1),
(13,	'Britax romer',	'britaxromer',	'Britax romer',	'Britax romer',	'',	'',	'',	'britax_romer_logo.png',	'2019-07-05 12:24:45',	13,	1),
(14,	'GARNIER',	'garnier',	'GARNIER',	'GARNIER',	'',	'',	'',	'okay_garnier.png',	'2019-06-10 14:31:28',	14,	1),
(15,	'Haibike',	'haibike',	'Haibike',	'Haibike',	'',	'',	'',	'okay_brand_bike.png',	'2019-07-04 10:11:36',	15,	1),
(16,	'Royal Canin',	'royalcanin',	'Royal Canin',	'Royal Canin',	'',	'',	'',	'okay_royalcanin.png',	'2019-07-05 11:58:54',	16,	1);

DROP TABLE IF EXISTS `ok_callbacks`;
CREATE TABLE `ok_callbacks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` timestamp NOT NULL DEFAULT current_timestamp(),
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `phone` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `message` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `processed` tinyint(1) NOT NULL DEFAULT 0,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `admin_notes` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `ok_callbacks` (`id`, `date`, `name`, `phone`, `message`, `processed`, `url`, `admin_notes`) VALUES
(1,	'2019-07-11 13:22:26',	'вася',	'566565',	'F5 и повторная отправка',	0,	'http://new.demookay.com/',	'');

DROP TABLE IF EXISTS `ok_categories`;
CREATE TABLE `ok_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) NOT NULL DEFAULT 0,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `name_h1` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `meta_title` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `meta_keywords` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `meta_description` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `annotation` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `position` int(11) NOT NULL DEFAULT 0,
  `visible` tinyint(1) NOT NULL DEFAULT 1,
  `external_id` varchar(36) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `level_depth` tinyint(1) NOT NULL DEFAULT 1,
  `auto_meta_title` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `auto_meta_keywords` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `auto_meta_desc` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `auto_description` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_modify` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `created` timestamp NULL DEFAULT NULL,
  `auto_h1` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `parent_id` (`parent_id`),
  KEY `position` (`position`),
  KEY `visible` (`visible`),
  KEY `external_id` (`external_id`),
  KEY `created` (`created`),
  KEY `url` (`url`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `ok_categories` (`id`, `parent_id`, `name`, `name_h1`, `meta_title`, `meta_keywords`, `meta_description`, `annotation`, `description`, `url`, `image`, `position`, `visible`, `external_id`, `level_depth`, `auto_meta_title`, `auto_meta_keywords`, `auto_meta_desc`, `auto_description`, `last_modify`, `created`, `auto_h1`) VALUES
(1,	0,	'Мебель для дома',	'',	'Мебель для дома',	'Мебель для дома',	'Мебель для дома',	'',	'',	'mebel-dlya-doma',	'family-sofa_2.png',	1,	1,	'',	1,	'',	'',	'',	'',	'2019-08-08 13:36:41',	'2018-06-19 14:21:13',	NULL),
(2,	32,	'Кресло мешок',	'',	'Кресло мешок',	'Кресло мешок',	'Кресло мешок',	'',	'',	'kreslo-meshok',	'bean-bag_1.png',	3,	1,	'',	3,	'',	'',	'',	'',	'2019-08-08 13:39:11',	'2018-06-19 14:21:13',	NULL),
(3,	0,	'Техника для дома',	'',	'Техника для дома',	'Техника для дома',	'Гаджеты',	'',	'',	'tehnika-dlya-doma',	'electrical-appliances_1.png',	58,	1,	'',	1,	'',	'',	'',	'',	'2019-08-08 13:50:37',	'2018-06-19 14:21:13',	NULL),
(4,	0,	'Смартфоны',	'',	'Смартфоны',	'Смартфоны',	'Смартфоны',	'',	'',	'smartfony',	'smartphone_1.png',	6,	1,	'',	2,	'',	'',	'',	'',	'2019-08-21 13:17:23',	'2018-06-19 14:21:13',	NULL),
(5,	4,	'Meizu',	'',	'Meizu',	'Meizu',	'Meizu',	'',	'',	'meizu',	'meizu-logo_1.png',	5,	1,	'',	3,	'',	'',	'',	'',	'2019-08-08 13:51:10',	'2018-06-19 14:21:13',	NULL),
(8,	4,	'Xiaomi',	'',	'Xiaomi',	'Xiaomi',	'Xiaomi',	'',	'',	'xiaomi',	'xiaomi-logo_1.png',	8,	1,	'',	3,	'',	'',	'',	'',	'2019-08-08 13:51:29',	'2018-06-19 14:21:13',	NULL),
(9,	0,	'Детские игрушки',	'',	'Детские игрушки',	'Детские игрушки',	'Детские игрушки',	'',	'',	'detskie-igrushki',	'puzzle_1.png',	59,	1,	'',	1,	'',	'',	'',	'',	'2019-08-08 13:57:02',	'2018-06-19 14:21:13',	NULL),
(10,	9,	'Мягкие игрушки',	'',	'Мягкие игрушки',	'Мягкие игрушки',	'Мягкие игрушки',	'',	'',	'myagkie-igrushki',	'',	10,	1,	'',	2,	'',	'',	'',	'',	'2019-01-24 13:18:20',	'2018-06-19 14:21:13',	NULL),
(11,	9,	'Детские машинки',	'',	'Детские машинки',	'Детские машинки',	'Детские машинки',	'',	'',	'detskie-mashinki',	'',	11,	1,	'',	2,	'',	'',	'',	'',	'2019-01-24 13:19:20',	'2018-06-19 14:21:13',	NULL),
(17,	0,	'Товары для бизнеса',	'',	'Товары для бизнеса',	'Товары для бизнеса',	'',	'',	'',	'tovary-dlya-biznesa',	'cash-register_1.png',	60,	1,	'',	1,	'',	'',	'',	NULL,	'2019-08-08 13:57:43',	'2019-04-24 14:02:57',	NULL),
(18,	0,	'Одежда, обувь и украшения',	'',	'Одежда, обувь и украшения',	'Одежда, обувь и украшения',	'',	'',	'',	'odezhda-obuv-i-ukrasheniya',	't-shirt_1.png',	61,	1,	'',	1,	'',	'',	'',	NULL,	'2019-08-08 13:58:08',	'2019-04-24 14:03:42',	NULL),
(19,	0,	'Художественная литература',	'',	'Художественная литература',	'Художественная литература',	'',	'',	'',	'hudozhestvennaya-literatura',	'open-book_1.png',	62,	1,	'',	1,	'',	'',	'',	NULL,	'2019-08-08 13:58:26',	'2019-04-24 14:25:09',	NULL),
(20,	0,	'Строительные инструменты',	'',	'Строительные инструменты',	'Строительные инструменты',	'Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim a',	'<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus</p>\r\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus</p>\r\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus</p>',	'<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus</p>\r\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus</p>',	'stroitelnye-instrumenty',	'machine_1.png',	63,	1,	'',	1,	'',	'',	'',	NULL,	'2019-08-08 13:58:47',	'2019-04-24 14:26:18',	NULL),
(21,	0,	'Товары для спорта',	'',	'Товары для спорта',	'Товары для спорта',	'',	'',	'',	'tovary-dlya-sporta',	'table-tennis_1.png',	64,	1,	'',	1,	'',	'',	'',	NULL,	'2019-08-08 13:59:16',	'2019-04-24 14:27:44',	NULL),
(22,	0,	'Красота и здоровье',	'',	'Красота и здоровье',	'Красота и здоровье',	'',	'',	'',	'krasota-i-zdorove',	'charity_1.png',	65,	1,	'',	1,	'',	'',	'',	NULL,	'2019-08-08 14:00:06',	'2019-04-24 14:28:27',	NULL),
(23,	0,	'Напитки и продукты',	'',	'Напитки и продукты',	'Напитки и продукты',	'Есть много вариантов Lorem Ipsum, но большинство из них имеет не всегда приемлемые модификации, например, юмористические вставки или слова, которые даже отдалённо не напоминают латынь. Если вам нужен Lorem Ipsum для серьёзного проекта, вы наверняка не хотите какой-нибудь шутки, скрытой в середине абзаца.',	'<p>Есть много вариантов Lorem Ipsum, но большинство из них имеет не всегда приемлемые модификации, например, юмористические вставки или слова, которые даже отдалённо не напоминают латынь. Если вам нужен Lorem Ipsum для серьёзного проекта, вы наверняка не хотите какой-нибудь шутки, скрытой в середине абзаца.</p>',	'<p>Давно выяснено, что при оценке дизайна и композиции читаемый текст мешает сосредоточиться. Lorem Ipsum используют потому, что тот обеспечивает более или менее стандартное заполнение шаблона, а также реальное распределение букв и пробелов в абзацах, которое не получается при простой дубликации \"Здесь ваш текст.. Здесь ваш текст.. Здесь ваш текст..\" Многие программы электронной вёрстки и редакторы HTML используют Lorem Ipsum в качестве текста по умолчанию, так что поиск по ключевым словам \"lorem ipsum\" сразу показывает, как много веб-страниц всё ещё дожидаются своего настоящего рождения. За прошедшие годы текст Lorem Ipsum получил много версий. Некоторые версии появились по ошибке, некоторые - намеренно (например, юмористические варианты).</p>',	'napitki-i-produkty',	'fast-food_1.png',	66,	1,	'',	1,	'',	'',	'',	NULL,	'2019-08-08 14:01:37',	'2019-04-24 14:29:19',	NULL),
(24,	0,	'Товары для животных',	'',	'Товары для животных',	'Товары для животных',	'',	'',	'',	'tovary-dlya-zhivotnyh',	'pawprint_1.png',	70,	1,	'',	1,	'',	'',	'',	NULL,	'2019-08-08 13:59:44',	'2019-04-24 14:30:33',	NULL),
(26,	23,	'Фрукты и овощи',	'',	'Фрукты и овощи',	'Фрукты и овощи',	'',	'',	'',	'frukty-i-ovoschi',	'cherries_1.png',	36,	1,	'',	2,	'',	'',	'',	NULL,	'2019-08-08 14:02:04',	'2019-05-28 08:35:53',	NULL),
(27,	23,	'Мясо и рыба',	'',	'Мясо и рыба',	'Мясо и рыба',	'',	'',	'',	'myaso-i-ryba',	'meat_1.png',	37,	1,	'',	2,	'',	'',	'',	NULL,	'2019-08-08 14:02:22',	'2019-05-28 09:55:50',	NULL),
(28,	23,	'Бакалея',	'',	'Бакалея',	'Бакалея',	'',	'',	'',	'bakaleya',	'eggs_1.png',	38,	1,	'',	2,	'',	'',	'',	NULL,	'2019-08-08 14:02:45',	'2019-05-28 09:56:53',	NULL),
(29,	23,	'Соки',	'',	'Соки',	'Соки',	'',	'',	'',	'soki',	'lemonade_1.png',	39,	1,	'',	2,	'',	'',	'',	NULL,	'2019-08-08 14:03:18',	'2019-05-28 12:12:40',	NULL),
(30,	23,	'Алкогольные напитки',	'',	'Алкогольные напитки',	'Алкогольные напитки',	'',	'',	'',	'alkogolnye-napitki',	'wine_1.png',	40,	1,	'',	2,	'',	'',	'',	NULL,	'2019-08-08 14:03:47',	'2019-05-28 12:20:40',	NULL),
(31,	22,	'Витамины',	'',	'Витамины',	'Витамины',	'',	'',	'',	'vitaminy',	'medicine_1.png',	31,	1,	'',	2,	'',	'',	'',	NULL,	'2019-08-08 14:00:45',	'2019-05-28 12:53:41',	NULL),
(32,	1,	'Cтолы и стулья',	'',	'Cтолы и стулья',	'Cтолы и стулья',	'',	'',	'',	'ctoly-i-stulya',	'dining-table_1.png',	2,	1,	'',	2,	'',	'',	'',	NULL,	'2019-08-08 13:36:51',	'2019-05-28 13:42:25',	NULL),
(33,	32,	'Обеденные столы',	'',	'Обеденные столы',	'Обеденные столы',	'',	'',	'',	'obedennye-stoly',	'table_1.png',	9,	1,	'',	3,	'',	'',	'',	NULL,	'2019-08-08 13:42:54',	'2019-05-28 13:42:43',	NULL),
(34,	32,	'Журнальные столы',	'',	'Журнальные столы',	'Журнальные столы',	'',	'',	'',	'zhurnalnye-stoly',	'table1_1.png',	17,	1,	'',	3,	'',	'',	'',	NULL,	'2019-08-08 13:43:16',	'2019-05-28 13:43:06',	NULL),
(35,	32,	'Компьютерные столы',	'',	'Компьютерные столы',	'Компьютерные столы',	'',	'',	'',	'kompyuternye-stoly',	'desktop_1.png',	18,	1,	'',	3,	'',	'',	'',	NULL,	'2019-08-08 13:43:33',	'2019-05-28 13:43:31',	NULL),
(36,	32,	'Офисные кресла',	'',	'Офисные кресла',	'Офисные кресла',	'',	'',	'',	'ofisnye-kresla',	'chair_1.png',	19,	1,	'',	3,	'',	'',	'',	NULL,	'2019-08-08 13:43:47',	'2019-05-28 13:45:00',	NULL),
(37,	32,	'табуреты',	'',	'табуреты',	'табуреты',	'',	'',	'',	'taburety',	'stool_1.png',	20,	1,	'',	3,	'',	'',	'',	NULL,	'2019-08-08 13:44:02',	'2019-05-28 13:45:18',	NULL),
(38,	32,	'Столики для ноутбуков',	'',	'Столики для ноутбуков',	'Столики для ноутбуков',	'',	'',	'',	'stoliki-dlya-noutbukov',	'bench_1.png',	21,	1,	'',	3,	'',	'',	'',	NULL,	'2019-08-08 13:44:20',	'2019-05-28 13:45:46',	NULL),
(39,	32,	'Складные столы',	'',	'Складные столы',	'Складные столы',	'',	'',	'',	'skladnye-stoly',	'camp-chair_1.png',	22,	1,	'',	3,	'',	'',	'',	NULL,	'2019-08-08 13:45:19',	'2019-05-28 13:46:06',	NULL),
(40,	32,	'Складные стулья',	'',	'Складные стулья',	'Складные стулья',	'',	'',	'',	'skladnye-stulya',	'directors-chair_2.png',	23,	1,	'',	3,	'',	'',	'',	NULL,	'2019-08-08 13:44:58',	'2019-05-28 13:46:55',	NULL),
(42,	1,	'Спальня',	'',	'Спальня',	'Спальня',	'',	'',	'',	'spalnya',	'big-cot_1.png',	42,	1,	'',	2,	'',	'',	'',	NULL,	'2019-08-08 13:37:41',	'2019-05-28 15:58:56',	NULL),
(43,	42,	'Комоды',	'',	'Комоды',	'Комоды',	'',	'',	'',	'komody',	'drawer_1.png',	43,	1,	'',	3,	'',	'',	'',	NULL,	'2019-08-08 13:46:48',	'2019-05-28 16:00:25',	NULL),
(44,	42,	'Шкафы-купе',	'',	'Шкафы-купе',	'Шкафы-купе',	'',	'',	'',	'shkafy-kupe',	'closet_1.png',	44,	1,	'',	3,	'',	'',	'',	NULL,	'2019-08-08 13:47:07',	'2019-05-28 16:05:00',	NULL),
(45,	42,	'Кровати',	'',	'Кровати',	'Кровати',	'',	'',	'',	'krovati',	'bed_1.png',	45,	1,	'',	3,	'',	'',	'',	NULL,	'2019-08-08 13:47:30',	'2019-05-28 16:06:16',	NULL),
(46,	42,	'Зеркала для спальни',	'',	'Зеркала для спальни',	'Зеркала для спальни',	'',	'',	'',	'zerkala-dlya-spalni',	'mirror_1.png',	46,	1,	'',	3,	'',	'',	'',	NULL,	'2019-08-08 13:47:49',	'2019-05-28 16:10:23',	NULL),
(47,	42,	'Туалетные столики',	'',	'Туалетные столики',	'Туалетные столики',	'',	'',	'',	'tualetnye-stoliki',	'dresser_1.png',	47,	1,	'',	3,	'',	'',	'',	NULL,	'2019-08-08 13:48:09',	'2019-05-28 16:12:46',	NULL),
(48,	42,	'Матрасы',	'',	'Матрасы',	'Матрасы',	'',	'',	'',	'matrasy',	'mattress_1.png',	48,	1,	'',	3,	'',	'',	'',	NULL,	'2019-08-08 13:48:28',	'2019-05-28 16:15:10',	NULL),
(49,	42,	'Прикроватные тумбы',	'',	'Прикроватные тумбы',	'Прикроватные тумбы',	'',	'',	'',	'prikrovatnye-tumby',	'cupboard1_1.png',	49,	1,	'',	3,	'',	'',	'',	NULL,	'2019-08-08 13:48:47',	'2019-05-28 16:23:04',	NULL),
(50,	1,	'Ванная комната',	'',	'Ванная комната',	'Ванная комната',	'',	'',	'',	'vannaya-komnata',	'bathtub_1.png',	50,	1,	'',	2,	'',	'',	'',	NULL,	'2019-08-08 13:37:52',	'2019-05-28 16:33:48',	NULL),
(51,	50,	'Пеналы',	'',	'Пеналы',	'Пеналы',	'',	'',	'',	'penaly',	'cabinet_1.png',	51,	1,	'',	3,	'',	'',	'',	NULL,	'2019-08-08 13:49:18',	'2019-05-28 16:40:37',	NULL),
(52,	50,	'Тумбы для ванной',	'',	'Тумбы для ванной',	'Тумбы для ванной',	'',	'',	'',	'tumby-dlya-vannoj',	'cupboard_2.png',	52,	1,	'',	3,	'',	'',	'',	NULL,	'2019-08-08 13:49:37',	'2019-05-28 16:42:30',	NULL),
(53,	50,	'Комплекты для ванной',	'',	'Комплекты для ванной',	'Комплекты для ванной',	'',	'',	'',	'komplekty-dlya-vannoj',	'sink_1.png',	53,	1,	'',	3,	'',	'',	'',	NULL,	'2019-08-08 13:50:00',	'2019-05-28 16:45:31',	NULL),
(54,	3,	'Радиаторы отопления',	'',	'Радиаторы отопления',	'Радиаторы отопления',	'',	'',	'',	'radiatory-otopleniya',	'heater_1.png',	27,	1,	'',	2,	'',	'',	'',	NULL,	'2019-08-08 13:52:31',	'2019-05-29 08:49:32',	NULL),
(55,	3,	'Водонагреватели',	'',	'Водонагреватели',	'Водонагреватели',	'',	'',	'',	'vodonagrevateli',	'water-heater_1.png',	28,	1,	'',	2,	'',	'',	'',	NULL,	'2019-08-08 13:52:50',	'2019-05-29 08:49:55',	NULL),
(56,	3,	'Холодильники',	'',	'Холодильники',	'Холодильники',	'',	'',	'',	'holodilniki',	'refrigerator_1.png',	29,	1,	'',	2,	'',	'',	'',	NULL,	'2019-08-08 13:53:09',	'2019-05-29 08:50:18',	NULL),
(57,	3,	'Телевизоры',	'',	'Телевизоры',	'Телевизоры',	'',	'',	'',	'televizory',	'television_1.png',	30,	1,	'',	2,	'',	'',	'',	NULL,	'2019-08-08 13:53:29',	'2019-05-29 08:50:46',	NULL),
(58,	3,	'Стиральные машины',	'',	'Стиральные машины',	'Стиральные машины',	'',	'',	'',	'stiralnye-mashiny',	'washing-machine_1.png',	33,	1,	'',	2,	'',	'',	'',	NULL,	'2019-08-08 13:54:07',	'2019-05-29 08:51:53',	NULL),
(59,	3,	'Кондиционеры',	'',	'Кондиционеры',	'Кондиционеры',	'',	'',	'',	'konditsionery',	'air-conditioner_1.png',	34,	1,	'',	2,	'',	'',	'',	NULL,	'2019-08-08 13:54:33',	'2019-05-29 08:52:23',	NULL),
(60,	3,	'Микроволновые печи',	'',	'Микроволновые печи',	'Микроволновые печи',	'',	'',	'',	'mikrovolnovye-pechi',	'microwave-oven_1.png',	35,	1,	'',	2,	'',	'',	'',	NULL,	'2019-08-08 13:54:59',	'2019-05-29 08:53:21',	NULL),
(61,	3,	'Акустика',	'',	'Акустика',	'Акустика',	'',	'',	'',	'akustika',	'speaker_1.png',	41,	1,	'',	2,	'',	'',	'',	NULL,	'2019-08-08 13:55:15',	'2019-05-29 08:56:42',	NULL),
(62,	3,	'Вытяжки',	'',	'Вытяжки',	'Вытяжки',	'',	'',	'',	'vytyazhki',	'fan_1.png',	54,	1,	'',	2,	'',	'',	'',	NULL,	'2019-08-08 13:55:33',	'2019-05-29 08:58:04',	NULL),
(63,	3,	'Спутниковые антенны',	'',	'Спутниковые антенны',	'Спутниковые антенны',	'',	'',	'',	'sputnikovye-antenny',	'satellite-dish_2.png',	55,	1,	'',	2,	'',	'',	'',	NULL,	'2019-08-08 13:56:21',	'2019-05-29 08:59:42',	NULL),
(64,	3,	'Роутеры',	'',	'Роутеры',	'Роутеры',	'',	'',	'',	'routery',	'router_1.png',	56,	1,	'',	2,	'',	'',	'',	NULL,	'2019-08-08 13:56:40',	'2019-05-29 09:00:28',	NULL),
(65,	3,	'Газовые плиты',	'',	'Газовые плиты',	'Газовые плиты',	'',	'',	'',	'gazovye-plity',	'oven_1.png',	32,	1,	'',	2,	'',	'',	'',	NULL,	'2019-08-08 13:53:50',	'2019-05-29 09:03:27',	NULL),
(66,	1,	'Диваны',	'',	'Диваны',	'Диваны',	'',	'',	'',	'divany',	'family-sofa_3.png',	57,	1,	'',	2,	'',	'',	'',	NULL,	'2019-08-08 13:38:10',	'2019-06-10 08:36:15',	NULL),
(67,	4,	'Samsung Galaxy',	'',	'Samsung Galaxy',	'Samsung Galaxy',	'',	'',	'',	'samsung-galaxy',	'samsung_galaxy_logo.svg_1.png',	67,	1,	'',	3,	'',	'',	'',	NULL,	'2019-08-08 13:51:51',	'2019-06-10 11:03:01',	NULL),
(68,	4,	'Iphone',	'',	'Iphone',	'Iphone',	'',	'',	'',	'iphone',	'iphone-logo-png-transparent_1.png',	68,	1,	'',	3,	'',	'',	'',	NULL,	'2019-08-08 13:52:11',	'2019-06-10 11:03:21',	NULL),
(69,	22,	'Косметика',	'',	'Косметика',	'Косметика',	'',	'',	'',	'kosmetika',	'cosmetics_1.png',	69,	1,	'',	2,	'',	'',	'',	NULL,	'2019-08-08 14:01:13',	'2019-06-10 14:08:57',	NULL);

DROP TABLE IF EXISTS `ok_categories_features`;
CREATE TABLE `ok_categories_features` (
  `category_id` int(11) NOT NULL,
  `feature_id` int(11) NOT NULL,
  PRIMARY KEY (`category_id`,`feature_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `ok_categories_features` (`category_id`, `feature_id`) VALUES
(1,	1),
(1,	2),
(1,	3),
(1,	4),
(1,	5),
(1,	6),
(1,	7),
(1,	8),
(1,	9),
(2,	1),
(2,	2),
(2,	3),
(2,	4),
(2,	5),
(2,	6),
(2,	7),
(2,	8),
(2,	9),
(3,	1),
(3,	10),
(3,	11),
(3,	12),
(3,	13),
(3,	14),
(3,	15),
(3,	16),
(3,	17),
(3,	18),
(3,	19),
(3,	20),
(3,	21),
(3,	22),
(3,	23),
(3,	24),
(3,	25),
(3,	26),
(3,	27),
(3,	28),
(3,	29),
(3,	30),
(3,	31),
(3,	32),
(3,	33),
(3,	34),
(3,	35),
(3,	36),
(3,	37),
(3,	38),
(3,	39),
(3,	40),
(3,	41),
(3,	48),
(3,	49),
(3,	50),
(3,	51),
(3,	52),
(3,	53),
(3,	54),
(3,	55),
(3,	56),
(3,	57),
(3,	58),
(3,	59),
(3,	60),
(3,	61),
(3,	62),
(3,	63),
(3,	64),
(3,	65),
(3,	66),
(3,	67),
(3,	68),
(3,	69),
(3,	70),
(3,	71),
(3,	72),
(3,	73),
(4,	1),
(4,	10),
(4,	11),
(4,	12),
(4,	13),
(4,	14),
(4,	15),
(4,	16),
(4,	17),
(4,	18),
(4,	19),
(4,	20),
(4,	21),
(4,	22),
(4,	23),
(4,	24),
(4,	25),
(4,	26),
(4,	27),
(4,	28),
(4,	29),
(4,	30),
(4,	31),
(4,	32),
(4,	33),
(4,	34),
(4,	35),
(4,	36),
(4,	37),
(4,	38),
(4,	39),
(4,	40),
(5,	1),
(5,	10),
(5,	11),
(5,	12),
(5,	13),
(5,	14),
(5,	15),
(5,	16),
(5,	17),
(5,	18),
(5,	19),
(5,	20),
(5,	21),
(5,	22),
(5,	23),
(5,	24),
(5,	25),
(5,	26),
(5,	27),
(5,	28),
(5,	29),
(5,	30),
(5,	31),
(5,	32),
(5,	33),
(5,	34),
(5,	35),
(5,	36),
(5,	37),
(5,	38),
(5,	39),
(5,	40),
(8,	1),
(8,	10),
(8,	11),
(8,	12),
(8,	13),
(8,	14),
(8,	15),
(8,	16),
(8,	17),
(8,	18),
(8,	19),
(8,	20),
(8,	21),
(8,	22),
(8,	23),
(8,	24),
(8,	25),
(8,	26),
(8,	27),
(8,	28),
(8,	29),
(8,	30),
(8,	31),
(8,	32),
(8,	33),
(8,	34),
(8,	35),
(8,	36),
(8,	37),
(8,	38),
(8,	39),
(8,	40),
(9,	10),
(9,	42),
(9,	43),
(9,	44),
(9,	45),
(9,	46),
(9,	47),
(10,	10),
(10,	42),
(10,	43),
(11,	10),
(11,	42),
(11,	43),
(11,	44),
(11,	45),
(11,	46),
(11,	47),
(17,	16),
(17,	30),
(17,	33),
(17,	76),
(17,	96),
(17,	97),
(17,	98),
(17,	99),
(17,	100),
(17,	101),
(17,	102),
(17,	103),
(17,	104),
(17,	105),
(17,	106),
(17,	107),
(17,	108),
(19,	80),
(19,	81),
(19,	82),
(19,	83),
(19,	84),
(19,	85),
(19,	86),
(19,	87),
(21,	1),
(21,	88),
(21,	89),
(21,	90),
(21,	91),
(21,	92),
(21,	93),
(21,	94),
(21,	95),
(23,	74),
(23,	75),
(24,	1),
(24,	42),
(24,	109),
(24,	110),
(24,	111),
(24,	112),
(26,	74),
(27,	74),
(27,	75),
(40,	1),
(40,	37),
(40,	45),
(40,	76),
(40,	77),
(52,	38),
(52,	45),
(52,	62),
(52,	113),
(52,	114),
(52,	115),
(54,	48),
(54,	49),
(54,	50),
(54,	51),
(54,	52),
(54,	53),
(54,	54),
(54,	55),
(54,	56),
(55,	48),
(55,	57),
(55,	58),
(55,	59),
(55,	60),
(55,	61),
(55,	62),
(55,	63),
(55,	64),
(55,	65),
(55,	66),
(55,	67),
(55,	68),
(55,	69),
(55,	70),
(55,	71),
(55,	72),
(55,	73),
(66,	1),
(66,	37),
(66,	45),
(66,	76),
(66,	77),
(66,	78),
(66,	79);

DROP TABLE IF EXISTS `ok_comments`;
CREATE TABLE `ok_comments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) NOT NULL DEFAULT 0,
  `date` timestamp NOT NULL DEFAULT current_timestamp(),
  `ip` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `object_id` int(11) NOT NULL DEFAULT 0,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `text` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` enum('product','post') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'product',
  `approved` int(1) NOT NULL DEFAULT 0,
  `lang_id` int(11) NOT NULL DEFAULT 0,
  `user_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_id` (`object_id`),
  KEY `type` (`type`),
  KEY `parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `ok_comments` (`id`, `parent_id`, `date`, `ip`, `object_id`, `name`, `email`, `text`, `type`, `approved`, `lang_id`, `user_id`) VALUES
(1,	0,	'2019-07-09 16:52:38',	'89.238.191.213',	1,	'Андрей',	'',	'Отличный товар. Приобрели около года назад. Ни разу не пожалели о покупке.',	'product',	0,	1,	NULL);

DROP TABLE IF EXISTS `ok_coupons`;
CREATE TABLE `ok_coupons` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `expire` timestamp NULL DEFAULT NULL,
  `type` enum('absolute','percentage') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'absolute',
  `value` decimal(10,2) NOT NULL DEFAULT 0.00,
  `min_order_price` decimal(10,2) DEFAULT NULL,
  `single` tinyint(1) NOT NULL DEFAULT 0,
  `usages` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `ok_coupons` (`id`, `code`, `expire`, `type`, `value`, `min_order_price`, `single`, `usages`) VALUES
(1,	'OKAYCMS',	NULL,	'percentage',	10.00,	0.00,	0,	109);

DROP TABLE IF EXISTS `ok_currencies`;
CREATE TABLE `ok_currencies` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sign` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `code` char(3) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `rate_from` decimal(10,2) NOT NULL DEFAULT 1.00,
  `rate_to` decimal(10,2) NOT NULL DEFAULT 1.00,
  `cents` int(1) NOT NULL DEFAULT 2,
  `position` int(11) NOT NULL DEFAULT 0,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `position` (`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `ok_currencies` (`id`, `name`, `sign`, `code`, `rate_from`, `rate_to`, `cents`, `position`, `enabled`) VALUES
(1,	'доллары',	'$',	'USD',	1.00,	65.00,	2,	2,	1),
(2,	'рубли',	'руб',	'RUR',	7.50,	7.50,	0,	1,	1),
(4,	'гривны',	'грн',	'UAH',	1.00,	3.30,	2,	4,	1);

DROP TABLE IF EXISTS `ok_deliveries`;
CREATE TABLE `ok_deliveries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `free_from` decimal(10,2) DEFAULT 0.00,
  `price` decimal(10,2) DEFAULT 0.00,
  `enabled` tinyint(1) NOT NULL DEFAULT 0,
  `position` int(11) NOT NULL DEFAULT 0,
  `separate_payment` tinyint(1) DEFAULT 0,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `settings` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `module_id` int(11) DEFAULT NULL,
  `paid` tinyint(1) DEFAULT NULL,
  `hide_front_delivery_price` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `position` (`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `ok_deliveries` (`id`, `name`, `description`, `free_from`, `price`, `enabled`, `position`, `separate_payment`, `image`, `settings`, `module_id`, `paid`, `hide_front_delivery_price`) VALUES
(1,	'Курьерская доставка по городу',	'<p>Курьерская доставка осуществляется службой компаний-перевозчиков города. Ваш заказ будет отправлен на следующий день после заказа. Доставка занимает от 1 до 3 дней.</p>',	0.00,	0.00,	1,	2,	0,	'kureroff.ru_kurier.png',	'a:1:{s:12:\"service_type\";s:14:\"WarehouseDoors\";}',	12,	0,	0),
(2,	'Самовывоз',	'<p>Удобный, бесплатный и быстрый способ получения заказа.</p>\r\n<p>Адрес офиса: Москва, ул. Космонавта Волкова 14</p>',	0.00,	0.00,	1,	3,	0,	'samovyvoz.png',	'a:0:{}',	0,	NULL,	NULL),
(3,	'Новая почта',	'',	999999.00,	100.00,	1,	3,	0,	'preview.jpg',	'a:1:{s:12:\"service_type\";s:18:\"WarehouseWarehouse\";}',	12,	1,	0);

DROP TABLE IF EXISTS `ok_delivery_payment`;
CREATE TABLE `ok_delivery_payment` (
  `delivery_id` int(11) NOT NULL,
  `payment_method_id` int(11) NOT NULL,
  PRIMARY KEY (`delivery_id`,`payment_method_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Связка способом оплаты и способов доставки';

INSERT INTO `ok_delivery_payment` (`delivery_id`, `payment_method_id`) VALUES
(1,	6),
(1,	14),
(1,	18),
(1,	19),
(1,	20),
(1,	21),
(2,	6),
(2,	18),
(2,	19),
(2,	20),
(2,	21),
(3,	6),
(3,	18),
(3,	19),
(3,	20),
(3,	21);

DROP TABLE IF EXISTS `ok_discounts`;
CREATE TABLE `ok_discounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `entity` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `entity_id` int(11) NOT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` decimal(10,2) NOT NULL,
  `from_last_discount` tinyint(1) DEFAULT 1,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `ok_features`;
CREATE TABLE `ok_features` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `position` int(11) NOT NULL DEFAULT 0,
  `in_filter` tinyint(1) DEFAULT 0,
  `auto_name_id` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `auto_value_id` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `external_id` varchar(36) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `url_in_product` tinyint(1) DEFAULT 0,
  `to_index_new_value` tinyint(1) DEFAULT 0,
  `description` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `position` (`position`),
  KEY `in_filter` (`in_filter`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `ok_features` (`id`, `name`, `position`, `in_filter`, `auto_name_id`, `auto_value_id`, `url`, `external_id`, `url_in_product`, `to_index_new_value`, `description`) VALUES
(1,	'Вес',	1,	1,	'',	'',	'ves',	'',	NULL,	1,	NULL),
(2,	'Высота',	2,	1,	'',	'',	'vysota',	'',	0,	0,	NULL),
(3,	'Диаметр',	3,	1,	'',	'',	'diametr',	'',	0,	0,	NULL),
(4,	'Ткань',	4,	1,	'',	'',	'tkan',	'',	NULL,	0,	NULL),
(5,	'Предназначение',	5,	1,	'',	'',	'prednaznachenie',	'',	0,	0,	NULL),
(6,	'Наполнитель',	6,	1,	'',	'',	'napolnitel',	'',	0,	0,	NULL),
(7,	'Количество наполнителя',	7,	1,	'',	'',	'kolichestvonapolnitelya',	'',	0,	0,	NULL),
(8,	'Объемный вес для транспортных компаний',	8,	1,	'',	'',	'obemnyjvesdlyatransportnyhkompanij',	'',	0,	0,	NULL),
(9,	'Производство ',	9,	1,	'',	'',	'proizvodstvo',	'',	0,	0,	NULL),
(10,	'Серия',	10,	1,	'',	'',	'seriya',	'',	0,	0,	NULL),
(11,	'Диагональ',	11,	1,	'',	'',	'diagonal',	'',	0,	0,	NULL),
(12,	'Тип экрана',	12,	1,	'',	'',	'tipekrana',	'',	0,	0,	NULL),
(13,	'Разрешение экрана',	13,	1,	'',	'',	'razreshenieekrana',	'',	0,	0,	NULL),
(14,	'Система',	14,	1,	'',	'',	'sistema',	'',	0,	0,	NULL),
(15,	'Количество ядер',	15,	1,	'',	'',	'kolichestvoyader',	'',	0,	0,	NULL),
(16,	'Процессор',	16,	1,	'',	'',	'protsessor',	'',	0,	0,	NULL),
(17,	'Частота процессора',	17,	1,	'',	'',	'chastotaprotsessora',	'',	0,	0,	NULL),
(18,	'Оперативная память',	18,	1,	'',	'',	'operativnayapamyat',	'',	0,	0,	NULL),
(19,	'Встроенная память',	19,	1,	'',	'',	'vstroennayapamyat',	'',	0,	0,	NULL),
(20,	'Поддержка SD карт',	20,	1,	'',	'',	'podderzhkasdkart',	'',	0,	0,	NULL),
(21,	'Sim-карт',	21,	1,	'',	'',	'simkart',	'',	0,	0,	NULL),
(22,	'Размеры SIM',	22,	1,	'',	'',	'razmerysim',	'',	0,	0,	NULL),
(23,	'GSM (2G)',	23,	1,	'',	'',	'gsm2g',	'',	0,	0,	NULL),
(24,	'3G',	24,	1,	'',	'',	'3g',	'',	0,	0,	NULL),
(25,	'LTE (4G)',	25,	1,	'',	'',	'lte4g',	'',	0,	0,	NULL),
(26,	'WCDMA',	26,	1,	'',	'',	'wcdma',	'',	0,	0,	NULL),
(27,	'Основная камера',	27,	1,	'',	'',	'osnovnayakamera',	'',	0,	0,	NULL),
(28,	'Фронтальная камера',	28,	1,	'',	'',	'frontalnayakamera',	'',	0,	0,	NULL),
(29,	'Вспышка',	29,	1,	'',	'',	'vspyshka',	'',	0,	0,	NULL),
(30,	'Bluetooth',	30,	1,	'',	'',	'bluetooth',	'',	0,	0,	NULL),
(31,	'GPS',	31,	1,	'',	'',	'gps',	'',	0,	0,	NULL),
(32,	'A-GPS',	32,	1,	'',	'',	'agps',	'',	0,	0,	NULL),
(33,	'Wi-Fi',	33,	1,	'',	'',	'wifi',	'',	0,	0,	NULL),
(34,	'ИК порт',	34,	1,	'',	'',	'ikport',	'',	0,	0,	NULL),
(35,	'Разъемы',	35,	1,	'',	'',	'razemy',	'',	0,	0,	NULL),
(36,	'Аккумулятор',	36,	1,	'',	'',	'akkumulyator',	'',	0,	0,	NULL),
(37,	'Размеры',	37,	1,	'',	'',	'razmery',	'',	0,	0,	NULL),
(38,	'Цвет',	38,	1,	'',	'',	'tsvet',	'',	0,	0,	NULL),
(39,	'Wi-Fi Hotspot',	39,	1,	'',	'',	'wifihotspot',	'',	0,	0,	NULL),
(40,	'Сканер отпечатков пальцев',	40,	1,	'',	'',	'skanerotpechatkovpaltsev',	'',	0,	0,	NULL),
(41,	'3G (UMTS)',	41,	1,	'',	'',	'3gumts',	'',	0,	0,	NULL),
(42,	'Возраст',	42,	1,	'',	'',	'vozrast',	'',	0,	0,	NULL),
(43,	'Пол',	43,	1,	'',	'',	'pol',	'',	0,	0,	NULL),
(44,	'Комплектация',	44,	1,	'',	'',	'komplektatsiya',	'',	0,	0,	NULL),
(45,	'Материал',	45,	1,	'',	'',	'material',	'',	0,	0,	NULL),
(46,	'Размеры упаковки',	46,	1,	'',	'',	'razmeryupakovki',	'',	0,	0,	NULL),
(47,	'Размер игрушки',	47,	1,	'',	'',	'razmerigrushki',	'',	0,	0,	NULL),
(48,	'Страна производитель',	48,	1,	'',	'',	'stranaproizvoditel',	'',	0,	0,	NULL),
(49,	'Тепловая мощность',	49,	1,	'',	'',	'teplovayamoschnost',	'',	0,	0,	NULL),
(50,	'Максимальная температура теплоносителя',	50,	1,	'',	'',	'maksimalnayatemperaturateplonositelya',	'',	0,	0,	NULL),
(51,	'Максимальное рабочее давление',	51,	1,	'',	'',	'maksimalnoerabocheedavlenie',	'',	0,	0,	NULL),
(52,	'Конструкция радиатора',	52,	1,	'',	'',	'konstruktsiyaradiatora',	'',	0,	0,	NULL),
(53,	'Способ подключения',	53,	1,	'',	'',	'sposobpodklyucheniya',	'',	0,	0,	NULL),
(54,	'Кол-во секций в радиаторе',	54,	1,	'',	'',	'kolvosektsijvradiatore',	'',	0,	0,	NULL),
(55,	'Объем воды в радиаторе',	55,	1,	'',	'',	'obemvodyvradiatore',	'',	0,	0,	NULL),
(56,	'Опрессовочное давление',	56,	1,	'',	'',	'opressovochnoedavlenie',	'',	0,	0,	NULL),
(57,	'Способ установки',	57,	1,	'',	'',	'sposobustanovki',	'',	0,	0,	NULL),
(58,	'Номинальный объем водонагревателя',	58,	1,	'',	'',	'nominalnyjobemvodonagrevatelya',	'',	0,	0,	NULL),
(59,	'Положение установки',	59,	1,	'',	'',	'polozhenieustanovki',	'',	0,	0,	NULL),
(60,	'Форма',	60,	1,	'',	'',	'forma',	'',	0,	0,	NULL),
(61,	'Мощность ТЭНа',	61,	1,	'',	'',	'moschnosttena',	'',	0,	0,	NULL),
(62,	'Гарантия',	62,	1,	'',	'',	'garantiya',	'',	0,	0,	NULL),
(63,	'Тип нагревательного элемента (ТЭНа)',	63,	1,	'',	'',	'tipnagrevatelnogoelementatena',	'',	0,	0,	NULL),
(64,	'Мощность',	64,	1,	'',	'',	'moschnost',	'',	0,	0,	NULL),
(65,	'Отвод газов',	65,	1,	'',	'',	'otvodgazov',	'',	0,	0,	NULL),
(66,	'Тип розжига',	66,	1,	'',	'',	'tiprozzhiga',	'',	0,	0,	NULL),
(67,	'Производительность',	67,	1,	'',	'',	'proizvoditelnost',	'',	0,	0,	NULL),
(68,	'Производительность ГВС',	68,	1,	'',	'',	'proizvoditelnostgvs',	'',	0,	0,	NULL),
(69,	'Модуляция мощности',	69,	1,	'',	'',	'modulyatsiyamoschnosti',	'',	0,	0,	NULL),
(70,	'Вес (кг)',	70,	1,	'',	'',	'veskg',	'',	0,	0,	NULL),
(71,	'Объем (м3)',	71,	1,	'',	'',	'obemm3',	'',	0,	0,	NULL),
(72,	'Габариты В.Ш.Г. (мм.)',	72,	1,	'',	'',	'gabarityvshgmm',	'',	0,	0,	NULL),
(73,	'Мин. давление газа',	73,	1,	'',	'',	'mindavleniegaza',	'',	0,	0,	NULL),
(74,	'Страна',	74,	1,	'',	'',	'strana',	'',	0,	0,	NULL),
(75,	'Вид мяса',	75,	1,	'',	'',	'vidspmyasa',	'',	NULL,	NULL,	NULL),
(76,	'Производитель',	76,	1,	'',	'',	'proizvoditel',	'',	0,	0,	NULL),
(77,	'Количество мест',	77,	1,	'',	'',	'kolichestvospmest',	'',	0,	0,	NULL),
(78,	'Высота сиденья',	78,	1,	'',	'',	'vysotaspsidenya',	'',	0,	0,	NULL),
(79,	'Водонепронецаемый',	79,	1,	'',	'',	'vodonepronetsaemyj',	'',	0,	0,	NULL),
(80,	'Автор',	80,	1,	'',	'',	'avtor',	'',	NULL,	NULL,	NULL),
(81,	'Язык',	81,	1,	'',	'',	'yazyk',	'',	0,	0,	NULL),
(82,	'Оригинальное название',	82,	1,	'',	'',	'originalnoespnazvanie',	'',	0,	0,	NULL),
(83,	'Обложка',	83,	1,	'',	'',	'oblozhka',	'',	0,	0,	NULL),
(84,	'Страниц',	84,	1,	'',	'',	'stranits',	'',	0,	0,	NULL),
(85,	'Иллюстрации',	85,	1,	'',	'',	'illyustratsii',	'',	0,	0,	NULL),
(86,	'Год издания',	86,	1,	'',	'',	'godspizdaniya',	'',	NULL,	NULL,	NULL),
(87,	'Рубрика',	87,	1,	'',	'',	'rubrika',	'',	0,	0,	NULL),
(88,	'тип товара',	88,	1,	'',	'',	'tipsptovara',	'',	1,	NULL,	NULL),
(89,	'диаметр колеса',	89,	1,	'',	'',	'diametrspkolesa',	'',	0,	0,	NULL),
(90,	'длина хода вилки',	90,	1,	'',	'',	'dlinasphodaspvilki',	'',	0,	0,	NULL),
(91,	'вилка',	91,	1,	'',	'',	'vilka',	'',	0,	0,	NULL),
(92,	'материал рамы',	92,	1,	'',	'',	'materialspramy',	'',	0,	0,	NULL),
(93,	'задний переключатель',	93,	1,	'',	'',	'zadnijsppereklyuchatel',	'',	0,	0,	NULL),
(94,	'тип заднего амортизатора',	94,	1,	'',	'',	'tipspzadnegospamortizatora',	'',	0,	0,	NULL),
(95,	'тип тормозов',	95,	1,	'',	'',	'tipsptormozov',	'',	0,	0,	NULL),
(96,	'Операционная сиситема',	96,	1,	'',	'',	'operatsionnayaspsisitema',	'',	0,	0,	NULL),
(97,	'Память',	97,	1,	'',	'',	'pamyat',	'',	NULL,	1,	NULL),
(98,	'Дисплей',	98,	1,	'',	'',	'displej',	'',	NULL,	NULL,	NULL),
(99,	'Клавиатура',	99,	0,	'',	'',	'klaviatura',	'',	0,	0,	NULL),
(100,	'Параметры сканера',	100,	0,	'',	'',	'parametryspskanera',	'',	0,	0,	NULL),
(101,	'Тип штрих-кодов',	101,	1,	'',	'',	'tipspshtrihmkodov',	'',	NULL,	1,	NULL),
(102,	'PTT',	102,	1,	'',	'',	'ptt',	'',	NULL,	1,	NULL),
(103,	'Датчик',	103,	1,	'',	'',	'datchik',	'',	0,	0,	NULL),
(104,	'Пылевлагозащита',	104,	1,	'',	'',	'pylevlagozaschita',	'',	0,	0,	NULL),
(105,	'Ударопрочность',	105,	1,	'',	'',	'udaroprochnost',	'',	0,	0,	NULL),
(106,	'Рабочая температура',	106,	1,	'',	'',	'rabochayasptemperatura',	'',	0,	0,	NULL),
(107,	'Габариты (мм)',	107,	1,	'',	'',	'gabaritysplbmmrb',	'',	NULL,	1,	NULL),
(108,	'Ширина бумаги',	108,	1,	'',	'',	'shirinaspbumagi',	'',	NULL,	NULL,	NULL),
(109,	'Тип корма',	109,	1,	'',	'',	'tipspkorma',	'',	NULL,	1,	NULL),
(110,	'Назначение корма',	110,	1,	'',	'',	'naznacheniespkorma',	'',	NULL,	1,	NULL),
(111,	'Порода',	111,	1,	'',	'',	'poroda',	'',	NULL,	1,	NULL),
(112,	'Класс корма',	112,	1,	'',	'',	'klassspkorma',	'',	NULL,	1,	NULL),
(113,	'Монтаж',	113,	0,	'',	'',	'montazh',	'',	0,	0,	NULL),
(114,	'Дверцы',	114,	0,	'',	'',	'dvertsy',	'',	0,	0,	NULL),
(115,	'Габариты',	115,	0,	'',	'',	'gabarity',	'',	0,	0,	NULL);

DROP TABLE IF EXISTS `ok_features_aliases`;
CREATE TABLE `ok_features_aliases` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `variable` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `position` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `variable` (`variable`(100)),
  KEY `position` (`position`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `ok_features_aliases_values`;
CREATE TABLE `ok_features_aliases_values` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `feature_alias_id` int(11) NOT NULL,
  `value` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `feature_id` int(11) DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `feature_id` (`feature_id`),
  KEY `feature_alias_id` (`feature_alias_id`),
  KEY `value` (`value`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `ok_features_values`;
CREATE TABLE `ok_features_values` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `feature_id` int(11) NOT NULL,
  `value` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `translit` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `position` int(11) NOT NULL DEFAULT 0,
  `to_index` tinyint(1) DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `feature_id_translit` (`feature_id`,`translit`(100)),
  KEY `feature_id` (`feature_id`),
  KEY `position` (`position`),
  KEY `value` (`value`(64))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `ok_features_values` (`id`, `feature_id`, `value`, `translit`, `position`, `to_index`) VALUES
(1,	71,	'0.04',	'0d04',	1,	1),
(2,	71,	'0.05',	'0d05',	2,	1),
(3,	71,	'0.06',	'0d06',	3,	1),
(4,	73,	'0.15бар',	'0d15bar',	4,	1),
(5,	73,	'0.1бар',	'0d1bar',	5,	1),
(6,	8,	'0.25 м3',	'0d25spm3',	6,	1),
(7,	55,	'0.35л.',	'0d35ld',	7,	1),
(8,	55,	'0.37л',	'0d37l',	8,	1),
(9,	55,	'0.5л.',	'0d5ld',	9,	1),
(10,	30,	'4.2',	'4d2',	10,	1),
(11,	30,	'4.1',	'4d1',	11,	1),
(12,	18,	'1 ГБ',	'1spgb',	12,	1),
(13,	44,	'1 машинка',	'1spmashinka',	13,	1),
(14,	17,	'1.0 Ггц',	'1d0spggts',	14,	1),
(15,	17,	'1.1 ГГц',	'1d1spggts',	15,	1),
(16,	17,	'1.2 ГГц',	'1d2spggts',	16,	1),
(17,	17,	'1.4 ГГц',	'1d4spggts',	17,	1),
(18,	17,	'1.5 ГГц',	'1d5spggts',	18,	1),
(19,	61,	'1.5кВт.',	'1d5kvtd',	19,	1),
(20,	17,	'1.7 ГГц',	'1d7spggts',	20,	1),
(21,	17,	'1.8 ГГц',	'1d8spggts',	21,	1),
(22,	15,	'10',	'10',	22,	1),
(23,	54,	'10',	'10',	23,	1),
(24,	15,	'10 (8- Cortex-A53 / 2- A72)',	'10splb8mspcortexma53spfsp2mspa72rb',	24,	1),
(25,	54,	'10 секц.',	'10spsektsd',	25,	1),
(26,	54,	'10 секций',	'10spsektsij',	26,	1),
(27,	70,	'10.00',	'10d00',	27,	1),
(28,	11,	'10.1\"',	'10d1qu',	28,	1),
(29,	58,	'100л.',	'100ld',	29,	1),
(30,	13,	'1024x600 пикс.',	'1024x600sppiksd',	30,	1),
(31,	13,	'1080x1920 пикс.',	'1080x1920sppiksd',	31,	1),
(32,	1,	'10кг.',	'10kgd',	32,	1),
(33,	68,	'10л/мин.',	'10lfmind',	33,	1),
(34,	1,	'11 кг.',	'11spkgd',	34,	1),
(35,	67,	'11 л/мин',	'11splfmin',	35,	1),
(36,	70,	'11.00',	'11d00',	36,	1),
(37,	1,	'11.5кг.',	'11d5kgd',	37,	1),
(38,	2,	'110 см',	'110spsm',	38,	1),
(39,	50,	'110град.',	'110gradd',	39,	1),
(40,	50,	'116 град.',	'116spgradd',	40,	1),
(41,	68,	'11л.',	'11ld',	41,	1),
(42,	27,	'12 Мп',	'12spmp',	42,	1),
(43,	19,	'128 ГБ',	'128spgb',	43,	1),
(44,	13,	'1280x720 пикс.',	'1280x720sppiksd',	44,	1),
(45,	13,	'1280x800 пикс.',	'1280x800sppiksd',	45,	1),
(46,	1,	'12кг.',	'12kgd',	46,	1),
(47,	1,	'13 кг.',	'13spkgd',	47,	1),
(48,	27,	'13 Мп',	'13spmp',	48,	1),
(49,	1,	'13.5кг.',	'13d5kgd',	49,	1),
(50,	50,	'130°C',	'130degc',	50,	1),
(51,	1,	'132 г',	'132spg',	51,	1),
(52,	1,	'134 г',	'134spg',	52,	1),
(53,	37,	'134.0 x 67.2 x 9.2 мм',	'134d0spxsp67d2spxsp9d2spmm',	53,	1),
(54,	1,	'нет',	'net',	54,	1),
(55,	37,	'138.1 х 69.59 x 7.8 мм',	'138d1sphsp69d59spxsp7d8spmm',	55,	1),
(56,	37,	'139.2 x 70.0 x 8.7 мм',	'139d2spxsp70d0spxsp8d7spmm',	56,	1),
(57,	37,	'139.3 x 69.6 x 8.5 мм',	'139d3spxsp69d6spxsp8d5spmm',	57,	1),
(58,	68,	'13л/мин.',	'13lfmind',	58,	1),
(59,	67,	'14 л/мин',	'14splfmin',	59,	1),
(60,	70,	'14.00',	'14d00',	60,	1),
(61,	37,	'141.3 x 69.6 x 8.9 мм',	'141d3spxsp69d6spxsp8d9spmm',	61,	1),
(62,	37,	'141.5 х 69.5 х 8.3 мм',	'141d5sphsp69d5sphsp8d3spmm',	62,	1),
(63,	37,	'141.9 x 69.0 x 8.3 мм',	'141d9spxsp69d0spxsp8d3spmm',	63,	1),
(64,	1,	'144 г',	'144spg',	64,	1),
(65,	49,	'145Вт.',	'145vtd',	65,	1),
(66,	37,	'147.7 х 70.8 х 7.3 мм',	'147d7sphsp70d8sphsp7d3spmm',	66,	1),
(67,	1,	'149 г',	'149spg',	67,	1),
(68,	1,	'13г.',	'13gd',	68,	1),
(69,	68,	'14л.',	'14ld',	69,	1),
(70,	1,	'15.5кг.',	'15d5kgd',	70,	1),
(71,	1,	'150 г',	'150spg',	71,	1),
(72,	37,	'150.9 х 75.2 х 8.7 мм',	'150d9sphsp75d2sphsp8d7spmm',	72,	1),
(73,	37,	'151.0 x 76.0 x 8.35 мм',	'151d0spxsp76d0spxsp8d35spmm',	73,	1),
(74,	37,	'151.0 x 76.0 x 8.4 мм',	'151d0spxsp76d0spxsp8d4spmm',	74,	1),
(75,	37,	'153.6 х 75.2 х 7.25 мм',	'153d6sphsp75d2sphsp7d25spmm',	75,	1),
(76,	37,	'153.6 х 75.5 х 8.2 мм',	'153d6sphsp75d5sphsp8d2spmm',	76,	1),
(77,	37,	'154.6 х 77.7 х 8 мм',	'154d6sphsp77d7sphsp8spmm',	77,	1),
(78,	1,	'155 г',	'155spg',	78,	1),
(79,	1,	'156 г',	'156spg',	79,	1),
(80,	37,	'156.7 х 78.0 х 7.5 мм',	'156d7sphsp78d0sphsp7d5spmm',	80,	1),
(81,	68,	'15л/мин.',	'15lfmind',	81,	1),
(82,	51,	'16 бар',	'16spbar',	82,	1),
(83,	19,	'16 ГБ',	'16spgb',	83,	1),
(84,	70,	'16.00',	'16d00',	84,	1),
(85,	1,	'160 г',	'160spg',	85,	1),
(86,	1,	'163 г',	'163spg',	86,	1),
(87,	49,	'166Вт.',	'166vtd',	87,	1),
(88,	1,	'168 г',	'168spg',	88,	1),
(89,	49,	'169Вт.',	'169vtd',	89,	1),
(90,	64,	'17.4кВт.',	'17d4kvtd',	90,	1),
(91,	1,	'175 г',	'175spg',	91,	1),
(92,	1,	'17кг.',	'17kgd',	92,	1),
(93,	64,	'18.6кВт.',	'18d6kvtd',	93,	1),
(94,	25,	'1800 / 1900 / 2100 / 2300 / 2500 / 2600 МГц',	'1800spfsp1900spfsp2100spfsp2300spfsp2500spfsp2600spmgts',	94,	1),
(95,	25,	'1800. 1900. 2100. 2300. 2500. 2600. 850. 900 МГц',	'1800dsp1900dsp2100dsp2300dsp2500dsp2600dsp850dsp900spmgts',	95,	1),
(96,	49,	'181Вт.',	'181vtd',	96,	1),
(97,	51,	'18бар',	'18bar',	97,	1),
(98,	64,	'19.2кВт.',	'19d2kvtd',	98,	1),
(99,	37,	'191.0 х 101.0 х 8.8 мм',	'191d0sphsp101d0sphsp8d8spmm',	99,	1),
(100,	49,	'195Вт.',	'195vtd',	100,	1),
(101,	47,	'1:64 (машинка)',	'1col64splbmashinkarb',	101,	1),
(102,	21,	'2 sim',	'2spsim',	102,	1),
(103,	17,	'2 x 2.3GHz Cortex-A72 + 4 x 2.0GHz Cortex-A53 + 4 x 1.4GHz Cortex-A53',	'2spxsp2d3ghzspcortexma72sppsp4spxsp2d0ghzspcortexma53sppsp4spxsp1d4ghzspcortexma53',	103,	1),
(104,	17,	'2 x 2.5 ГГц Cortex-A72 + 4 x 2.0 ГГц Cortex-A53 + 4 x 1.4 ГГц Cortex-A53',	'2spxsp2d5spggtsspcortexma72sppsp4spxsp2d0spggtsspcortexma53sppsp4spxsp1d4spggtsspcortexma53',	104,	1),
(105,	18,	'2 ГБ',	'2spgb',	105,	1),
(106,	44,	'2 емкости с водой. 1 машинка серии \"Измени цвет\"',	'2spemkostispsspvodojdsp1spmashinkaspseriispquizmenisptsvetqu',	106,	1),
(107,	28,	'2 Мп',	'2spmp',	107,	1),
(108,	17,	'2.0 ГГц',	'2d0spggts',	108,	1),
(109,	17,	'2.1 ГГц',	'2d1spggts',	109,	1),
(110,	61,	'2.1кВт.',	'2d1kvtd',	110,	1),
(111,	17,	'2.35 ГГц',	'2d35spggts',	111,	1),
(112,	56,	'2.4 бар',	'2d4spbar',	112,	1),
(113,	61,	'2.4кВт.',	'2d4kvtd',	113,	1),
(114,	61,	'2.5кВт.',	'2d5kvtd',	114,	1),
(115,	7,	'200 литров',	'200splitrov',	115,	1),
(116,	1,	'20кг.',	'20kgd',	116,	1),
(117,	27,	'21 Мп',	'21spmp',	117,	1),
(118,	27,	'21.16 Мп',	'21d16spmp',	118,	1),
(119,	46,	'21.5 х 16 х 6 см',	'21d5sphsp16sphsp6spsm',	119,	1),
(120,	64,	'22 кВт.',	'22spkvtd',	120,	1),
(121,	64,	'22.6кВт.',	'22d6kvtd',	121,	1),
(122,	36,	'2200 мАч',	'2200spmach',	122,	1),
(123,	1,	'22кг.',	'22kgd',	123,	1),
(124,	64,	'24.4кВт.',	'24d4kvtd',	124,	1),
(125,	37,	'247.0 х 171.0 х 8.95 мм',	'247d0sphsp171d0sphsp8d95spmm',	125,	1),
(126,	36,	'2560 мАч',	'2560spmach',	126,	1),
(127,	46,	'25х25х9 см',	'25h25h9spsm',	127,	1),
(128,	64,	'26.2кВт.',	'26d2kvtd',	128,	1),
(129,	1,	'260 г',	'260spg',	129,	1),
(130,	1,	'26кг.',	'26kgd',	130,	1),
(131,	64,	'27.2 кВт.',	'27d2spkvtd',	131,	1),
(132,	1,	'27кг.',	'27kgd',	132,	1),
(133,	46,	'28 х 16 см',	'28sphsp16spsm',	133,	1),
(134,	36,	'2870 мАч',	'2870spmach',	134,	1),
(135,	61,	'2кВт.',	'2kvtd',	135,	1),
(136,	18,	'3 ГБ',	'3spgb',	136,	1),
(137,	62,	'3 года',	'3spgoda',	137,	1),
(138,	42,	'3+',	'3p',	138,	1),
(139,	47,	'30 см (длина одной дорожки)',	'30spsmsplbdlinaspodnojspdorozhkirb',	139,	1),
(140,	36,	'3020 мАч',	'3020spmach',	140,	1),
(141,	36,	'3020 мАч (съемный)',	'3020spmachsplbsemnyjrb',	141,	1),
(142,	36,	'3050 мАч',	'3050spmach',	142,	1),
(143,	36,	'3060 мАч',	'3060spmach',	143,	1),
(144,	36,	'3080 мАч',	'3080spmach',	144,	1),
(145,	1,	'30кг.',	'30kgd',	145,	1),
(146,	58,	'30л.',	'30ld',	146,	1),
(147,	46,	'31 х 5 х 3 см',	'31sphsp5sphsp3spsm',	147,	1),
(148,	46,	'31 х 8х 5 см',	'31sphsp8hsp5spsm',	148,	1),
(149,	36,	'3100 мАч',	'3100spmach',	149,	1),
(150,	19,	'32 ГБ',	'32spgb',	150,	1),
(151,	36,	'3450 мАч',	'3450spmach',	151,	1),
(152,	36,	'3800 мАч',	'3800spmach',	152,	1),
(153,	15,	'4',	'4',	153,	1),
(154,	15,	'4 (Cortex A-53)',	'4splbcortexspam53rb',	154,	1),
(155,	17,	'4 x 1.8 Ггц + 4 x 1.0 ГГц',	'4spxsp1d8spggtssppsp4spxsp1d0spggts',	155,	1),
(156,	18,	'4 ГБ',	'4spgb',	156,	1),
(157,	28,	'4 Мп',	'4spmp',	157,	1),
(158,	17,	'4 х 1 ГГц + 4 х 1.5 ГГц',	'4sphsp1spggtssppsp4sphsp1d5spggts',	158,	1),
(159,	17,	'4 х 2.1 ГГц + 4 х 1.5 ГГц',	'4sphsp2d1spggtssppsp4sphsp1d5spggts',	159,	1),
(160,	42,	'4+',	'4p',	160,	1),
(161,	30,	'4.0',	'4d0',	161,	1),
(162,	30,	'4.2 LE',	'4d2sple',	162,	1),
(163,	11,	'4.7\"',	'4d7qu',	163,	1),
(164,	46,	'40.5 х 19 х 6 см',	'40d5sphsp19sphsp6spsm',	164,	1),
(165,	36,	'4100 мАч',	'4100spmach',	165,	1),
(166,	62,	'5 лет',	'5splet',	166,	1),
(167,	27,	'5 Мп',	'5spmp',	167,	1),
(168,	28,	'5 Мп',	'5spmp',	168,	1),
(169,	42,	'5+',	'5p',	169,	1),
(170,	11,	'5.0\"',	'5d0qu',	170,	1),
(171,	11,	'5.2\"',	'5d2qu',	171,	1),
(172,	11,	'5.5\"',	'5d5qu',	172,	1),
(173,	11,	'5.7\"',	'5d7qu',	173,	1),
(174,	58,	'50л.',	'50ld',	174,	1),
(175,	46,	'51 х 30.5 х 7 см',	'51sphsp30d5sphsp7spsm',	175,	1),
(176,	1,	'525 г',	'525spg',	176,	1),
(177,	72,	'580х310х220',	'580h310h220',	177,	1),
(178,	15,	'6 (Cortex A-57)',	'6splbcortexspam57rb',	178,	1),
(179,	18,	'6 ГБ',	'6spgb',	179,	1),
(180,	19,	'64 ГБ',	'64spgb',	180,	1),
(181,	72,	'655х350х220',	'655h350h220',	181,	1),
(182,	72,	'655х425х220',	'655h425h220',	182,	1),
(183,	62,	'7 года',	'7spgoda',	183,	1),
(184,	62,	'7 лет',	'7splet',	184,	1),
(185,	11,	'7.0\"',	'7d0qu',	185,	1),
(186,	36,	'7000 мАч',	'7000spmach',	186,	1),
(187,	58,	'75л.',	'75ld',	187,	1),
(188,	15,	'8',	'8',	188,	1),
(189,	15,	'8 (Cortex A-53)',	'8splbcortexspam53rb',	189,	1),
(190,	15,	'8 (Cortex A-57 + Cortex A-53)',	'8splbcortexspam57sppspcortexspam53rb',	190,	1),
(191,	62,	'8 лет',	'8splet',	191,	1),
(192,	27,	'8 Мп',	'8spmp',	192,	1),
(193,	3,	'80 см',	'80spsm',	193,	1),
(194,	33,	'802.11 a/b/g/n',	'802d11spafbfgfn',	194,	1),
(195,	33,	'802.11 a/b/g/n/ac',	'802d11spafbfgfnfac',	195,	1),
(196,	33,	'802.11 b/g/n',	'802d11spbfgfn',	196,	1),
(197,	58,	'80л.',	'80ld',	197,	1),
(198,	24,	'850 / 1900 / 2100 МГц',	'850spfsp1900spfsp2100spmgts',	198,	1),
(199,	23,	'850 / 900 / 1800 / 1900 МГц',	'850spfsp900spfsp1800spfsp1900spmgts',	199,	1),
(200,	24,	'850 / 900 / 1900 / 2100 МГц',	'850spfsp900spfsp1900spfsp2100spmgts',	200,	1),
(201,	26,	'850 / 900 / 1900 / 2100 МГц',	'850spfsp900spfsp1900spfsp2100spmgts',	201,	1),
(202,	23,	'850 / 900 / 1900 МГц',	'850spfsp900spfsp1900spmgts',	202,	1),
(203,	23,	'900 / 1800 / 1900 МГц',	'900spfsp1800spfsp1900spmgts',	203,	1),
(204,	23,	'900 / 1800 МГц',	'900spfsp1800spmgts',	204,	1),
(205,	26,	'900 / 1900 / 2100 МГц',	'900spfsp1900spfsp2100spmgts',	205,	1),
(206,	24,	'900 / 2100 МГц',	'900spfsp2100spmgts',	206,	1),
(207,	26,	'900 / 2100 МГц',	'900spfsp2100spmgts',	207,	1),
(208,	14,	'Android 4.4',	'androidsp4d4',	208,	1),
(209,	14,	'Android 5.0',	'androidsp5d0',	209,	1),
(210,	14,	'Android 5.1',	'androidsp5d1',	210,	1),
(211,	14,	'Android 6.0',	'androidsp6d0',	211,	1),
(212,	14,	'Android 6.0 + Flyme',	'androidsp6d0sppspflyme',	212,	1),
(213,	14,	'Android 6.0.1 +  MIUI 8',	'androidsp6d0d1sppspspmiuisp8',	213,	1),
(214,	14,	'Android 6.0.1 +  MIUI V8',	'androidsp6d0d1sppspspmiuispv8',	214,	1),
(215,	10,	'City',	'city',	215,	1),
(216,	38,	'Dark Blue',	'darkspblue',	216,	1),
(217,	25,	'FDD-LTE',	'fddmlte',	217,	1),
(218,	12,	'IGZO Full HD',	'igzospfullsphd',	218,	1),
(219,	12,	'IPS',	'ips',	219,	1),
(220,	12,	'IPS (Sharp)',	'ipssplbsharprb',	220,	1),
(221,	12,	'IPS Full HD',	'ipsspfullsphd',	221,	1),
(222,	12,	'IPS HD',	'ipssphd',	222,	1),
(223,	10,	'M2',	'm2',	223,	1),
(224,	10,	'M3',	'm3',	224,	1),
(225,	16,	'MediaTek MT6750',	'mediatekspmt6750',	225,	1),
(226,	16,	'MediaTek MT6753',	'mediatekspmt6753',	226,	1),
(227,	16,	'MediaTek MT6755',	'mediatekspmt6755',	227,	1),
(228,	16,	'MediaTek MT6797',	'mediatekspmt6797',	228,	1),
(229,	16,	'MediaTek MT6797T',	'mediatekspmt6797t',	229,	1),
(230,	16,	'MediaTek MT8735P',	'mediatekspmt8735p',	230,	1),
(231,	10,	'Mi4C',	'mi4c',	231,	1),
(232,	10,	'Mi5s',	'mi5s',	232,	1),
(233,	22,	'micro-SIM',	'micromsim',	233,	1),
(234,	22,	'micro-SIM. nano-SIM (microSD)',	'micromsimdspnanomsimsplbmicrosdrb',	234,	1),
(235,	35,	'microUSB. OTG. Аудио 3.5 мм',	'microusbdspotgdspaudiosp3d5spmm',	235,	1),
(236,	35,	'microUSB. Type-C. OTG. Аудио 3.5 мм',	'microusbdsptypemcdspotgdspaudiosp3d5spmm',	236,	1),
(237,	35,	'microUSB. Аудио 3.5 мм',	'microusbdspaudiosp3d5spmm',	237,	1),
(238,	35,	'microUSB. Аудио 3.5 мм. 2 слота для sim-карт',	'microusbdspaudiosp3d5spmmdsp2spslotaspdlyaspsimmkart',	238,	1),
(239,	10,	'MX',	'mx',	239,	1),
(240,	22,	'nano-SIM',	'nanomsim',	240,	1),
(241,	22,	'nano-SIM. micro-SIM (microSD)',	'nanomsimdspmicromsimsplbmicrosdrb',	241,	1),
(242,	22,	'nano-SIM. nano-SIM',	'nanomsimdspnanomsim',	242,	1),
(243,	22,	'nano-SIM. nano-SIM (microSD)',	'nanomsimdspnanomsimsplbmicrosdrb',	243,	1),
(244,	10,	'Pro',	'pro',	244,	1),
(245,	16,	'Qualcomm Snapdragon 210',	'qualcommspsnapdragonsp210',	245,	1),
(246,	16,	'Qualcomm Snapdragon 410',	'qualcommspsnapdragonsp410',	246,	1),
(247,	10,	'Redmi 3S',	'redmisp3s',	247,	1),
(248,	10,	'Redmi 4',	'redmisp4',	248,	1),
(249,	10,	'Redmi Note',	'redmispnote',	249,	1),
(250,	10,	'Redmi Note 4',	'redmispnotesp4',	250,	1),
(251,	16,	'Samsung Exynos 7',	'samsungspexynossp7',	251,	1),
(252,	38,	'Silver',	'silver',	252,	1),
(253,	16,	'Snapdragon 430',	'snapdragonsp430',	253,	1),
(254,	16,	'Snapdragon 435',	'snapdragonsp435',	254,	1),
(255,	16,	'Snapdragon 625',	'snapdragonsp625',	255,	1),
(256,	16,	'Snapdragon 808',	'snapdragonsp808',	256,	1),
(257,	16,	'Snapdragon 82',	'snapdragonsp82',	257,	1),
(258,	16,	'Snapdragon 821',	'snapdragonsp821',	258,	1),
(259,	12,	'Super AMOLED Full HD',	'superspamoledspfullsphd',	259,	1),
(260,	25,	'TD-LTE',	'tdmlte',	260,	1),
(261,	10,	'Track builder',	'trackspbuilder',	261,	1),
(262,	35,	'USB Type-C. OTG. Аудио 3.5 мм',	'usbsptypemcdspotgdspaudiosp3d5spmm',	262,	1),
(263,	10,	'Workshop',	'workshop',	263,	1),
(264,	10,	'Базовые треки и игровые наборы',	'bazovyesptrekispispigrovyespnabory',	264,	1),
(265,	38,	'Белый. золотой. синий. серый. розовый',	'belyjdspzolotojdspsinijdspseryjdsprozovyj',	265,	1),
(266,	38,	'Белый. серый. золотой',	'belyjdspseryjdspzolotoj',	266,	1),
(267,	38,	'Белый. синий. серый. розовый',	'belyjdspsinijdspseryjdsprozovyj',	267,	1),
(268,	53,	'Боковое',	'bokovoe',	268,	1),
(269,	4,	'велюр',	'velyur',	269,	1),
(270,	59,	'Вертикальный',	'vertikalnyj',	270,	1),
(271,	66,	'гидротурбинка (электро)',	'gidroturbinkasplbelektrorb',	271,	1),
(272,	69,	'Две ступени',	'dvespstupeni',	272,	1),
(273,	27,	'двойная. по 13 Мп каждая',	'dvojnayadspposp13spmpspkazhdaya',	273,	1),
(274,	43,	'девочка..мальчик',	'devochkaddmalchik',	274,	1),
(275,	69,	'Десять ступеней',	'desyatspstupenej',	275,	1),
(276,	5,	'для детей до 12 лет',	'dlyaspdetejspdosp12splet',	276,	1),
(277,	20,	'до 128 ГБ',	'dosp128spgb',	277,	1),
(278,	20,	'до 32 ГБ',	'dosp32spgb',	278,	1),
(279,	1,	'до 4 кг',	'dosp4spkg',	279,	1),
(280,	20,	'до 64 ГБ',	'dosp64spgb',	280,	1),
(281,	10,	'Другие интерактивные питомцы',	'drugiespinteraktivnyesppitomtsy',	281,	1),
(282,	65,	'дымоход',	'dymohod',	282,	1),
(283,	29,	'Есть',	'est',	283,	1),
(284,	31,	'Есть',	'est',	284,	1),
(285,	32,	'Есть',	'est',	285,	1),
(286,	34,	'Есть',	'est',	286,	1),
(287,	39,	'Есть',	'est',	287,	1),
(288,	40,	'Есть',	'est',	288,	1),
(289,	41,	'есть',	'est',	289,	1),
(290,	69,	'есть',	'est',	290,	1),
(291,	40,	'Есть (mTouch)',	'estsplbmtouchrb',	291,	1),
(292,	4,	'жаккард',	'zhakkard',	292,	1),
(293,	48,	'Испания',	'ispaniya',	293,	1),
(294,	48,	'Италия',	'italiya',	294,	1),
(295,	43,	'мальчик',	'malchik',	295,	1),
(296,	4,	'микро-вельвет',	'mikromvelvet',	296,	1),
(297,	57,	'Настенный',	'nastennyj',	297,	1),
(298,	69,	'нет',	'net',	298,	1),
(299,	4,	'оксфорд (плащевая ткань)',	'oksfordsplbplaschevayasptkanrb',	299,	1),
(300,	66,	'от батареек (электро)',	'otspbatareeksplbelektrorb',	300,	1),
(301,	66,	'от батареек (электронный)',	'otspbatareeksplbelektronnyjrb',	301,	1),
(302,	63,	'открытый (\"мокрый\")',	'otkrytyjsplbqumokryjqurb',	302,	1),
(303,	6,	'пенополистирол 1-2 мм',	'penopolistirolsp1m2spmm',	303,	1),
(304,	45,	'Пластик',	'plastik',	304,	1),
(305,	48,	'Португалия',	'portugaliya',	305,	1),
(306,	60,	'прямоугольная',	'pryamougolnaya',	306,	1),
(307,	66,	'пьезорозжиг',	'pezorozzhig',	307,	1),
(308,	66,	'пьезорозжиг (кнопкой)',	'pezorozzhigsplbknopkojrb',	308,	1),
(309,	9,	'Россия',	'rossiya',	309,	1),
(310,	52,	'Секционная',	'sektsionnaya',	310,	1),
(311,	38,	'Серый. серебряный. золотой',	'seryjdspserebryanyjdspzolotoj',	311,	1),
(312,	38,	'Серый. серебряный. золотой. Rose-gold',	'seryjdspserebryanyjdspzolotojdsprosemgold',	312,	1),
(313,	63,	'скрытый (\"сухой\")',	'skrytyjsplbqusuhojqurb',	313,	1),
(314,	38,	'Темно-серый. золотой. серебряный',	'temnomseryjdspzolotojdspserebryanyj',	314,	1),
(315,	38,	'Темно-серый. золотой. серый',	'temnomseryjdspzolotojdspseryj',	315,	1),
(316,	38,	'Темно-серый. золотой. серый. Rose-gold',	'temnomseryjdspzolotojdspseryjdsprosemgold',	316,	1),
(317,	48,	'Украина',	'ukraina',	317,	1),
(318,	59,	'Универсальный',	'universalnyj',	318,	1),
(319,	60,	'Цилиндрическая',	'tsilindricheskaya',	319,	1),
(320,	38,	'Черный',	'chernyj',	320,	1),
(321,	38,	'Черный. Champagne. розовый',	'chernyjdspchampagnedsprozovyj',	321,	1),
(322,	38,	'Черный. голубой. розовый. белый. желтый',	'chernyjdspgolubojdsprozovyjdspbelyjdspzheltyj',	322,	1),
(323,	38,	'Черный. розовый. золотой. серебряный. бирюзовый',	'chernyjdsprozovyjdspzolotojdspserebryanyjdspbiryuzovyj',	323,	1),
(324,	74,	'Финляндия',	'finlyandiya',	324,	1),
(325,	74,	'Баранина',	'baranina',	325,	1),
(326,	74,	'Россия',	'rossiya',	326,	1),
(328,	75,	'Курица',	'kuritsa',	328,	1),
(329,	74,	'Говядина',	'govyadina',	329,	1),
(330,	75,	'Свинина',	'svinina',	330,	1),
(331,	45,	'Коттон',	'kotton',	331,	1),
(332,	76,	'Франция',	'frantsiya',	332,	1),
(333,	37,	'(H)218.5, (W)133.0',	'lbhrb218d5csplbwrb133d0',	333,	1),
(334,	77,	'8',	'8',	334,	1),
(335,	78,	'1.55м',	'1d55m',	335,	1),
(336,	79,	'да',	'da',	336,	1),
(337,	1,	'145кг.',	'145kgd',	337,	1),
(338,	1,	'295',	'295',	338,	1),
(339,	37,	'65.5L x 89.5W x 25.5H',	'65d5lspxsp89d5wspxsp25d5h',	339,	1),
(340,	45,	'Дерево',	'derevo',	340,	1),
(341,	76,	'Италия',	'italiya',	341,	1),
(342,	37,	'(H)91.0, (W)54ю8',	'lbhrb91d0csplbwrb54yu8',	342,	1),
(343,	77,	'нет',	'net',	343,	1),
(345,	80,	'С. Кінг',	'sdspking',	345,	1),
(346,	81,	'украинский',	'ukrainskij',	346,	1),
(347,	82,	'The Stand, vol.1',	'thespstandcspvold1',	347,	1),
(348,	83,	'переплет',	'pereplet',	348,	1),
(349,	84,	'576',	'576',	349,	1),
(350,	85,	'ч/б',	'chfb',	350,	1),
(351,	86,	'2019',	'2019',	351,	1),
(352,	87,	'Фантастика, фэнтези',	'fantastikacspfentezi',	352,	1),
(353,	86,	'2017',	'2017',	353,	1),
(354,	88,	'Велосипед',	'velosiped',	354,	1),
(355,	89,	'25.5 дюйма',	'25d5spdyujma',	355,	1),
(356,	90,	'от 130 до 150 мм',	'otsp130spdosp150spmm',	356,	1),
(357,	91,	'RockShox Revelation RC Lockout, air, Travel: 120mm, aluminium steerer tube 1 18 - 1 12 tapered, thru-axle Boost',	'rockshoxsprevelationsprcsplockoutcspaircsptravelcolsp120mmcspaluminiumspsteerersptubesp1sp18spmsp1sp12sptaperedcspthrumaxlespboost',	357,	1),
(358,	1,	'25.8 кг',	'25d8spkg',	358,	1),
(359,	92,	'Shimano Tourney RD-TY21B',	'shimanosptourneysprdmty21b',	359,	1),
(360,	93,	'Sram NX Eagle, 12 speed',	'sramspnxspeaglecsp12spspeed',	360,	1),
(361,	89,	'26.5 дюйма',	'26d5spdyujma',	361,	1),
(362,	90,	'от 110 до 160 мм',	'otsp110spdosp160spmm',	362,	1),
(363,	91,	'Жесткая стальная',	'zhestkayaspstalnaya',	363,	1),
(364,	92,	'алюминий PRO',	'alyuminijsppro',	364,	1),
(365,	94,	'без амортизатора',	'bezspamortizatora',	365,	1),
(366,	95,	'ободной',	'obodnoj',	366,	1),
(367,	1,	'793 г',	'793spg',	367,	1),
(368,	88,	'Велошлем',	'veloshlem',	368,	1),
(369,	89,	'нет',	'net',	369,	1),
(370,	90,	'нет',	'net',	370,	1),
(371,	91,	'нет',	'net',	371,	1),
(372,	92,	'нет',	'net',	372,	1),
(373,	93,	'нет',	'net',	373,	1),
(374,	94,	'нет',	'net',	374,	1),
(375,	88,	'Велоперчатка',	'veloperchatka',	375,	1),
(376,	1,	'332 г',	'332spg',	376,	1),
(377,	88,	'Велообувь',	'veloobuv',	377,	1),
(378,	1,	'6 кг',	'6spkg',	378,	1),
(379,	88,	'Гиря',	'girya',	379,	1),
(380,	1,	'8 кг',	'8spkg',	380,	1),
(381,	88,	'Гантели',	'ganteli',	381,	1),
(382,	1,	'136.5кг.',	'136d5kgd',	382,	1),
(383,	88,	'Велотренажер',	'velotrenazher',	383,	1),
(384,	1,	'139 кг',	'139spkg',	384,	1),
(385,	88,	'Тренажер',	'trenazher',	385,	1),
(386,	88,	'Гироскутер',	'giroskuter',	386,	1),
(387,	88,	'Гироборд',	'girobord',	387,	1),
(388,	88,	'Фитнесс-трекер',	'fitnessmtreker',	388,	1),
(389,	88,	'Экшн-камера',	'ekshnmkamera',	389,	1),
(390,	96,	'Windows POSReady 2009, Windows 7, Windows 8.1 Industry, Windows 10 IoT Enterprise',	'windowsspposreadysp2009cspwindowssp7cspwindowssp8d1spindustrycspwindowssp10spiotspenterprise',	390,	1),
(391,	16,	'Intel Celeron N3160 2,24 ГГц;',	'intelspceleronspn3160sp2c24spggtssem',	391,	1),
(392,	97,	'1 МБ SDRAM / 2 МБ Flash ROM',	'1spmbspsdramspfsp2spmbspflashsprom',	392,	1),
(393,	98,	'Цветной сенсорный ЖК 4,3″',	'tsvetnojspsensornyjspzhksp4c3',	393,	1),
(394,	99,	'На 28, 43 и 53 клавиши',	'nasp28csp43spisp53spklavishi',	394,	1),
(395,	100,	'Лазерный',	'lazernyj',	395,	1),
(396,	101,	'1D: UPC-A, UPC-E, EAN8, EAN13, CODE39, ITF, CODEBAR, CODE128, CODE93; 2D: PDF417, QR code(DataMatrix/Maxicode/Azec optional)',	'1dcolspupcmacspupcmecspean8cspean13cspcode39cspitfcspcodebarcspcode128cspcode93semsp2dcolsppdf417cspqrspcodelbdatamatrixfmaxicodefazecspoptionalrb',	396,	1),
(397,	30,	'есть',	'est',	397,	1),
(398,	33,	'нет',	'net',	398,	1),
(399,	102,	'нет',	'net',	399,	1),
(400,	103,	'датчик прозрачности (фиксированный по центру); датчик черной метки (подвижный); датчик открытой печатающей головки; датчик наличия этикетки',	'datchikspprozrachnostisplbfiksirovannyjspposptsentrurbsemspdatchikspchernojspmetkisplbpodvizhnyjrbsemspdatchikspotkrytojsppechatayuschejspgolovkisemspdatchikspnalichiyaspetiketki',	400,	1),
(401,	104,	'IP64 (корпус, закрывающий электронное оборудование, дисплей и клавиатура) согласно стандартам защиты IEC',	'ip64splbkorpuscspzakryvayuschijspelektronnoespoborudovaniecspdisplejspispklaviaturarbspsoglasnospstandartamspzaschityspiec',	401,	1),
(402,	105,	'нет',	'net',	402,	1),
(403,	106,	'от -20 до +45°C',	'otspm20spdospp45degc',	403,	1),
(404,	107,	'305 х 295 х 345 мм',	'305sphsp295sphsp345spmm',	404,	1),
(405,	76,	'Sam4s (Корея)',	'sam4ssplbkoreyarb',	405,	1),
(406,	108,	'57,5 мм',	'57c5spmm',	406,	1),
(407,	1,	'12г',	'12g',	407,	1),
(408,	42,	'Для взрослых кошек',	'dlyaspvzroslyhspkoshek',	408,	1),
(409,	109,	'Сухой корм',	'suhojspkorm',	409,	1),
(410,	110,	'Для крупных пород',	'dlyaspkrupnyhspporod',	410,	1),
(411,	111,	'Персидский',	'persidskij',	411,	1),
(412,	112,	'Премиум',	'premium',	412,	1),
(413,	1,	'10г',	'10g',	413,	1),
(414,	42,	'Для котят',	'dlyaspkotyat',	414,	1),
(415,	111,	'Британская',	'britanskaya',	415,	1),
(416,	42,	'От 12 мес.',	'otsp12spmesd',	416,	1),
(417,	111,	'Для всех',	'dlyaspvseh',	417,	1),
(418,	42,	'От 1 года',	'otsp1spgoda',	418,	1),
(419,	110,	'Основное кормление',	'osnovnoespkormlenie',	419,	1),
(420,	111,	'Всех видов',	'vsehspvidov',	420,	1),
(421,	1,	'79 кг.',	'79spkgd',	421,	1),
(422,	37,	'191-200см',	'191m200sm',	422,	1),
(423,	45,	'Буковые ламели',	'bukovyesplameli',	423,	1),
(424,	76,	'RedKing',	'redking',	424,	1),
(425,	78,	'191',	'191',	425,	1),
(426,	1,	'90кг.',	'90kgd',	426,	1),
(427,	37,	'150.9 х 115.2 х 87 cm',	'150d9sphsp115d2sphsp87spcm',	427,	1),
(428,	77,	'2',	'2',	428,	1),
(429,	78,	'160',	'160',	429,	1),
(430,	38,	'Белый',	'belyj',	430,	1),
(431,	45,	'Керамика',	'keramika',	431,	1),
(432,	113,	'напольный',	'napolnyj',	432,	1),
(433,	114,	'Распашные',	'raspashnye',	433,	1),
(434,	115,	'455x650x650',	'455x650x650',	434,	1),
(436,	38,	'Красный',	'krasnyj',	436,	1),
(437,	112,	'Супер премиум',	'supersppremium',	437,	1),
(438,	112,	'Эконом',	'ekonom',	438,	1);

DROP TABLE IF EXISTS `ok_features_values_aliases_values`;
CREATE TABLE `ok_features_values_aliases_values` (
  `feature_alias_id` int(11) NOT NULL,
  `translit` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `feature_id` int(11) NOT NULL,
  `lang_id` int(11) NOT NULL,
  KEY `feature_alias_id` (`feature_alias_id`),
  KEY `feature_id` (`feature_id`),
  KEY `lang_id` (`lang_id`),
  KEY `translit` (`translit`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `ok_feedbacks`;
CREATE TABLE `ok_feedbacks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` timestamp NOT NULL DEFAULT current_timestamp(),
  `ip` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `message` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `processed` tinyint(1) NOT NULL DEFAULT 0,
  `lang_id` int(11) NOT NULL DEFAULT 0,
  `is_admin` tinyint(1) NOT NULL DEFAULT 0,
  `parent_id` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `ok_feedbacks` (`id`, `date`, `ip`, `name`, `email`, `message`, `processed`, `lang_id`, `is_admin`, `parent_id`) VALUES
(1,	'2019-11-20 15:37:14',	'192.168.220.1',	'Роман',	'test@gmail.com',	'Как к вам пройти?',	0,	1,	0,	0);

DROP TABLE IF EXISTS `ok_groups`;
CREATE TABLE `ok_groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `discount` decimal(5,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `ok_groups` (`id`, `name`, `discount`) VALUES
(1,	'Постоянный покупатель',	2.00);

DROP TABLE IF EXISTS `ok_images`;
CREATE TABLE `ok_images` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `product_id` int(11) NOT NULL DEFAULT 0,
  `filename` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `position` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `product_id` (`product_id`),
  KEY `position` (`position`),
  KEY `filename` (`filename`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `ok_images` (`id`, `name`, `product_id`, `filename`, `position`) VALUES
(1,	'',	1,	'beskarkasnoe_kreslo_meshok_grusha_copy_9.jpg',	1),
(2,	'',	1,	'beskarkasnoe_kreslo_meshok_grusha_copy_459.jpg',	2),
(3,	'',	2,	'beskarkasnoe_kreslo_meshok_grusha_copy_19.jpg',	3),
(4,	'',	3,	'beskarkasnoe_kreslo_meshok_grusha_copy_12.jpg',	4),
(5,	'',	4,	'beskarkasnoe_kreslo_meshok_grusha_copy_14.jpg',	5),
(6,	'',	5,	'beskarkasnoe_kreslo_meshok_grusha_Oksford_Bordo_4.jpg',	6),
(7,	'',	6,	'beskarkasnoe_kreslo_meshok_grusha_copy_3.jpg',	7),
(8,	'',	7,	'beskarkasnoe_kreslo_meshok_grusha_copy_8_9.jpg',	8),
(9,	'',	8,	'beskarkasnoe_kreslo_meshok_grusha_copy_46_2.jpg',	9),
(10,	'',	9,	'beskarkasnoe_kreslo_meshok_grusha_copy_7.jpg',	10),
(11,	'',	10,	'beskarkasnoe_kreslo_meshok_grusha_blue_velvet_1.jpg',	11),
(12,	'',	11,	'kreslo_meshok_grusha_turquoise_velvet.jpg',	12),
(13,	'',	12,	'beskarkasnoe_kreslo_meshok_grusha_copy_28.jpg',	13),
(14,	'',	13,	'kreslo_meshol_malina_4.jpg',	14),
(15,	'',	14,	'beskarkasnoe_kreslo_meshok_grusha_fuxia_2.jpg',	15),
(16,	'',	15,	'beskarkasnoe_kreslo_meshok_grusha_pink.jpg',	16),
(17,	'',	16,	'kreslo_meshok_velvet_lime.jpg',	17),
(18,	'',	16,	'kreslo_meshok_velvet_lime.jpg',	18),
(19,	'',	17,	'kreslo_meshok_biatrice_2.jpg',	19),
(20,	'',	18,	'kreslo_meshok_balloons_2.jpg',	20),
(21,	'',	19,	'kreslo_meshok_graffity_orange_2.jpg',	21),
(22,	'',	20,	'kreslo_meshok_mini_cooper_2.jpg',	22),
(23,	'',	21,	'kreslo_meshok_iphone_2.jpg',	0),
(24,	'',	22,	'kreslo_meshok_cats_2.jpg',	24),
(25,	'',	23,	'271012-01.jpg',	25),
(26,	'',	24,	'171101-01.jpg',	26),
(27,	'',	25,	'271011-01.jpg',	27),
(28,	'',	26,	's040708-02.jpg',	28),
(29,	'',	27,	's010785-01.jpg',	29),
(30,	'',	28,	's040703-02.jpg',	30),
(31,	'',	29,	's040721-02.jpg',	31),
(32,	'',	30,	's040722-01.jpg',	32),
(33,	'',	31,	's040709-01.jpg',	33),
(34,	'',	32,	's040719-01.jpg',	34),
(35,	'',	33,	's040718-02.jpg',	35),
(36,	'',	34,	's040704-01.jpg',	36),
(48,	'',	37,	's040727-01.jpg',	48),
(49,	'',	38,	's040753-02.jpg',	49),
(50,	'',	39,	'151213-02.jpg',	50),
(51,	'',	40,	'151218-01.jpg',	51),
(52,	'',	41,	'151220-01.jpg',	52),
(53,	'',	42,	's020301-01.jpg',	53),
(54,	'',	43,	'ss210205-01.jpg',	54),
(55,	'',	44,	's020307-01.jpg',	55),
(56,	'',	45,	's010303-01.jpg',	56),
(57,	'',	46,	's020306-01.jpg',	57),
(58,	'',	47,	's020304-01.jpg',	58),
(59,	'',	48,	'4h.jpg',	0),
(60,	'',	49,	'1_91.jpg',	60),
(61,	'',	49,	'2_89.jpg',	61),
(62,	'',	49,	'5_57.jpg',	62),
(63,	'',	49,	'6_47.jpg',	63),
(64,	'',	49,	'8_21.jpg',	64),
(65,	'',	49,	'9_4.jpg',	65),
(66,	'',	49,	'4_74.jpg',	66),
(67,	'',	49,	'7_33.jpg',	67),
(68,	'',	49,	'3_77.jpg',	68),
(69,	'',	50,	'1_92.jpg',	0),
(70,	'',	50,	'2_90.jpg',	1),
(71,	'',	50,	'5_58.jpg',	2),
(72,	'',	50,	'6_48.jpg',	3),
(73,	'',	50,	'7_34.jpg',	4),
(75,	'',	50,	'4_75.jpg',	5),
(76,	'',	50,	'3_78.jpg',	6),
(77,	'',	51,	'1_93.jpg',	77),
(78,	'',	51,	'2_91.jpg',	78),
(79,	'',	51,	'7_35.jpg',	79),
(80,	'',	51,	'6_49.jpg',	80),
(81,	'',	51,	'8_23.jpg',	81),
(82,	'',	51,	'9_5.jpg',	82),
(83,	'',	51,	'4_76.jpg',	83),
(84,	'',	51,	'5_59.jpg',	84),
(85,	'',	51,	'3_79.jpg',	85),
(86,	'',	52,	'1_94.jpg',	86),
(87,	'',	52,	'2_92.jpg',	87),
(88,	'',	52,	'7_36.jpg',	88),
(89,	'',	52,	'6_50.jpg',	89),
(90,	'',	52,	'8_24.jpg',	90),
(91,	'',	52,	'9_6.jpg',	91),
(92,	'',	52,	'4_77.jpg',	92),
(93,	'',	52,	'5_60.jpg',	93),
(94,	'',	52,	'3_80.jpg',	94),
(95,	'',	53,	'6_51.jpg',	95),
(96,	'',	53,	'1_100.jpg',	96),
(97,	'',	53,	'2_96.jpg',	97),
(98,	'',	53,	'7_37.jpg',	98),
(99,	'',	53,	'9_7.jpg',	99),
(100,	'',	53,	'3_83.jpg',	100),
(101,	'',	53,	'8_25.jpg',	101),
(102,	'',	53,	'5_63.jpg',	102),
(103,	'',	53,	'4_80.jpg',	103),
(104,	'',	54,	'1_102.jpg',	104),
(105,	'',	54,	'4_82.jpg',	105),
(106,	'',	54,	'2_98.jpg',	106),
(107,	'',	54,	'5_64.jpg',	107),
(108,	'',	54,	'3_85.jpg',	108),
(109,	'',	54,	'6_52.jpg',	109),
(110,	'',	55,	'1_103.jpg',	110),
(111,	'',	55,	'2_99.jpg',	111),
(112,	'',	55,	'6_53.jpg',	112),
(113,	'',	55,	'4_83.jpg',	113),
(114,	'',	55,	'5_65.jpg',	114),
(115,	'',	55,	'3_86.jpg',	115),
(116,	'',	56,	'1_101.jpg',	116),
(117,	'',	56,	'2_97.jpg',	117),
(118,	'',	56,	'3_84.jpg',	118),
(119,	'',	56,	'4_81.jpg',	119),
(120,	'',	57,	'1_99.jpg',	120),
(121,	'',	57,	'2_95.jpg',	121),
(122,	'',	57,	'3_82.jpg',	122),
(123,	'',	57,	'4_79.jpg',	123),
(124,	'',	57,	'5_62.jpg',	124),
(125,	'',	58,	'bgk04_1.jpg',	125),
(126,	'',	58,	'bgk04_5.jpg',	126),
(127,	'',	58,	'bgk04_4.jpg',	127),
(128,	'',	59,	'2_612.jpg',	128),
(129,	'',	59,	'3_567.jpg',	129),
(130,	'',	59,	'1_713.jpg',	130),
(131,	'',	60,	'3_568.jpg',	131),
(132,	'',	60,	'2_613.jpg',	132),
(133,	'',	60,	'4_519.jpg',	133),
(134,	'',	60,	'1_714.jpg',	134),
(135,	'',	61,	'2_614.jpg',	135),
(136,	'',	61,	'3_569.jpg',	136),
(137,	'',	61,	'1_715.jpg',	137),
(138,	'',	61,	'4_520.jpg',	138),
(139,	'',	61,	'7_311.jpg',	139),
(140,	'',	61,	'6_394.jpg',	140),
(141,	'',	61,	'5_436.jpg',	141),
(142,	'',	61,	'8_213.jpg',	142),
(143,	'',	62,	'1_716.jpg',	143),
(144,	'',	62,	'2_615.jpg',	144),
(145,	'',	62,	'3_570.jpg',	145),
(146,	'',	62,	'7_312.jpg',	146),
(147,	'',	62,	'4_521.jpg',	147),
(148,	'',	62,	'5_437.jpg',	148),
(149,	'',	62,	'6_395.jpg',	149),
(150,	'',	62,	'8_214.jpg',	150),
(151,	'',	62,	'9_146.jpg',	151),
(152,	'',	63,	'2_616.jpg',	152),
(153,	'',	63,	'1_717.jpg',	153),
(154,	'',	63,	'8_215.jpg',	154),
(155,	'',	63,	'7_313.jpg',	155),
(156,	'',	63,	'6_396.jpg',	156),
(157,	'',	63,	'3_571.jpg',	157),
(158,	'',	63,	'4_522.jpg',	158),
(159,	'',	63,	'5_438.jpg',	159),
(160,	'',	63,	'9_147.jpg',	160),
(161,	'',	64,	'1_718.jpg',	161),
(162,	'',	64,	'9_148.jpg',	162),
(163,	'',	64,	'5_439.jpg',	163),
(164,	'',	64,	'3_572.jpg',	164),
(165,	'',	64,	'2_617.jpg',	165),
(166,	'',	64,	'4_523.jpg',	166),
(167,	'',	64,	'6_397.jpg',	167),
(168,	'',	64,	'7_314.jpg',	168),
(169,	'',	64,	'8_216.jpg',	169),
(170,	'',	65,	'2_618.jpg',	170),
(171,	'',	65,	'5_440.jpg',	171),
(172,	'',	65,	'9_149.jpg',	172),
(173,	'',	65,	'1_719.jpg',	173),
(174,	'',	65,	'3_573.jpg',	174),
(175,	'',	65,	'4_524.jpg',	175),
(176,	'',	65,	'6_398.jpg',	176),
(177,	'',	65,	'8_217.jpg',	177),
(178,	'',	65,	'7_315.jpg',	178),
(179,	'',	66,	'3_574.jpg',	179),
(180,	'',	66,	'2_619.jpg',	180),
(181,	'',	66,	'1_720.jpg',	181),
(182,	'',	67,	'6_399.jpg',	182),
(183,	'',	67,	'7_316.jpg',	183),
(184,	'',	67,	'4_525.jpg',	184),
(185,	'',	67,	'2_620.jpg',	185),
(186,	'',	67,	'3_575.jpg',	186),
(187,	'',	67,	'1_721.jpg',	187),
(188,	'',	67,	'5_441.jpg',	188),
(189,	'',	68,	'1_722.jpg',	189),
(190,	'',	68,	'2_621.jpg',	190),
(191,	'',	68,	'4_526.jpg',	191),
(192,	'',	68,	'3_576.jpg',	192),
(193,	'',	69,	'1_723.jpg',	193),
(194,	'',	69,	'2_622.jpg',	194),
(195,	'',	69,	'7_317.jpg',	195),
(196,	'',	69,	'3_577.jpg',	196),
(197,	'',	69,	'6_400.jpg',	197),
(198,	'',	69,	'5_442.jpg',	198),
(199,	'',	69,	'4_527.jpg',	199),
(200,	'',	70,	'9_150.jpg',	200),
(201,	'',	70,	'5_443.jpg',	201),
(202,	'',	70,	'1_724.jpg',	202),
(203,	'',	70,	'2_623.jpg',	203),
(204,	'',	70,	'6_401.jpg',	204),
(205,	'',	70,	'7_318.jpg',	205),
(206,	'',	70,	'3_578.jpg',	206),
(207,	'',	70,	'8_218.jpg',	207),
(208,	'',	70,	'4_528.jpg',	208),
(209,	'',	71,	'3_579.jpg',	209),
(210,	'',	71,	'2_624.jpg',	210),
(211,	'',	71,	'1_725.jpg',	211),
(212,	'',	72,	'1_726.jpg',	212),
(213,	'',	72,	'2_625.jpg',	213),
(214,	'',	72,	'3_580.jpg',	214),
(215,	'',	72,	'5_444.jpg',	215),
(216,	'',	72,	'6_402.jpg',	216),
(217,	'',	72,	'4_529.jpg',	217),
(218,	'',	72,	'7_319.jpg',	218),
(219,	'',	73,	'bimetall-ALTERMO-400x400.jpg',	219),
(220,	'',	74,	'lrb500.jpg',	220),
(221,	'',	75,	'record_137200700.jpg',	221),
(222,	'',	76,	'iseo.jpg',	222),
(223,	'',	77,	'1362382587_aluminium-radiator-global.jpg',	223),
(224,	'',	78,	'1362382587_aluminium-radiator-global.jpg',	0),
(225,	'',	79,	'atlantic-vm-080-d400-2-bc.jpg',	225),
(226,	'',	79,	'opro-turbo-1.jpg',	226),
(227,	'',	79,	'opro-turbo.jpg',	227),
(228,	'',	80,	'Atlantic_VM_050_D400-2-B2.jpg',	228),
(229,	'',	80,	'opro-turbo.jpg',	229),
(230,	'',	81,	'atlantic-opro-profi.jpg',	230),
(231,	'',	82,	'atlantic-opro-profi.jpg',	231),
(232,	'',	83,	'atlantic-opro-slim.jpg',	232),
(233,	'',	83,	'atlantic-opro-slim-2.jpg',	233),
(234,	'',	84,	'Atlantic_VM_050_D400-2-BC.jpg',	234),
(235,	'',	84,	'atlantic-statite-elite-pro3.jpg',	235),
(236,	'',	84,	'atlantic-statite-elite-pro.jpg',	236),
(237,	'',	85,	'atlantic-slim-steatite-vm-80-n3cm-e-1_1.jpg',	237),
(238,	'',	85,	'atlantic-slim-steatite-80_1.jpg',	238),
(239,	'',	86,	'atlantic-statite-cube.jpg',	239),
(240,	'',	86,	'atlantic-statite-cube.jpg',	240),
(241,	'',	87,	'atlantic-statite-cube.jpg',	241),
(242,	'',	87,	'atlantic-statite-cube.jpg',	242),
(243,	'',	88,	'atlantic-statite-cube.jpg',	243),
(244,	'',	88,	'atlantic-statite-cube.jpg',	244),
(245,	'',	89,	'atlantic-vm-080-d400-2-bc.jpg',	245),
(246,	'',	89,	'opro-turbo-1.jpg',	246),
(247,	'',	89,	'opro-turbo.jpg',	247),
(248,	'',	90,	'atlantic-opro-profi.jpg',	248),
(249,	'',	91,	'Aqua_Idrabagno.jpg',	249),
(250,	'',	92,	'Aqua_Idrabagno.jpg',	250),
(251,	'',	93,	'Aqua_Idrabagno.jpg',	251),
(252,	'',	94,	'Aqua_Idrabagno.jpg',	252),
(253,	'',	95,	'bosch-wrd-13-2g.jpg',	253),
(254,	'',	96,	'Therm_4000.jpg',	254),
(255,	'',	97,	'Therm_4000.jpg',	255),
(256,	'',	98,	'bosch-wrd-13-2g.jpg',	256),
(257,	'',	99,	'bossh_wr_13_2_b.jpg',	257),
(258,	'',	100,	'Therm_4000.jpg',	258),
(259,	'',	101,	'bosch-wrd-13-2g.jpg',	259),
(260,	'',	102,	'bossh_wr_13_2_b.jpg',	260),
(261,	'',	103,	'Therm_4000.jpg',	261),
(262,	'',	104,	'Therm_4000.jpg',	262),
(263,	'',	105,	'THERM_2000_O.jpg',	263),
(264,	'',	105,	'bosch-therm-2000.jpg',	264),
(265,	'',	106,	'mag_370x500-kopiya.png',	265),
(266,	'',	106,	'_06_atmomag_gwh03_1014_04-kopiya.jpg',	266),
(267,	'',	107,	'mag_370x500-kopiya.png',	267),
(268,	'',	107,	'_06_atmomag_gwh03_1014_04-kopiya.jpg',	268),
(269,	'',	108,	'mag_370x500-kopiya.png',	269),
(270,	'',	108,	'_06_atmomag_gwh03_1014_04-kopiya.jpg',	270),
(271,	'',	109,	'mag_370x500-kopiya.png',	0),
(272,	'',	109,	'_06_atmomag_gwh03_1014_04-kopiya.jpg',	1),
(273,	'',	110,	'mag_pro_370x500.png',	0),
(274,	'',	111,	'4-600x600.jpg',	0),
(275,	'',	112,	'okay-food4.jpg',	0),
(276,	'',	112,	'okay-food9.jpg',	1),
(277,	'',	112,	'okay-food7.jpg',	2),
(278,	'',	112,	'okay-food8.jpg',	3),
(279,	'',	113,	'okay-food12.jpg',	0),
(284,	'',	113,	'okay-food2.jpg',	1),
(285,	'',	113,	'okay-food5.jpg',	2),
(286,	'',	113,	'okay-food8.jpg',	3),
(287,	'',	113,	'okay-food9.jpg',	4),
(288,	'',	114,	'okay-food13.jpg',	0),
(289,	'',	114,	'okay-food15.jpg',	1),
(290,	'',	114,	'okay-food2.jpg',	2),
(291,	'',	114,	'okay-food4.jpg',	3),
(292,	'',	114,	'okay-food11.jpg',	4),
(293,	'',	115,	'okay-food8.jpg',	0),
(294,	'',	115,	'okay-food1.jpg',	0),
(295,	'',	115,	'okay-food14.jpg',	0),
(296,	'',	115,	'okay-food5.jpg',	0),
(297,	'',	115,	'okay-food9.jpg',	0),
(298,	'',	115,	'okay-food10.jpg',	0),
(299,	'',	116,	'okay-food2.jpg',	0),
(300,	'',	116,	'okay-food3.jpg',	0),
(301,	'',	117,	'okay-food1.jpg',	0),
(302,	'',	117,	'okay-food11.jpg',	0),
(303,	'',	117,	'okay-food12.jpg',	0),
(304,	'',	118,	'okay-food7.jpg',	0),
(305,	'',	118,	'okay-food4.jpg',	0),
(306,	'',	118,	'okay-food14.jpg',	0),
(307,	'',	118,	'okay-food11.jpg',	0),
(308,	'',	118,	'okay-food9.jpg',	0),
(309,	'',	119,	'okay-food11.jpg',	0),
(310,	'',	119,	'okay-food2.jpg',	0),
(311,	'',	119,	'okay-food1.jpg',	0),
(312,	'',	119,	'okay-food7.jpg',	0),
(313,	'',	119,	'okay-food8.jpg',	0),
(314,	'',	119,	'okay-food9.jpg',	0),
(315,	'',	120,	'okay-food19.jpg',	0),
(316,	'',	120,	'okay-food18.jpg',	0),
(317,	'',	120,	'okay-food17.jpg',	0),
(318,	'',	121,	'okay-food20.jpg',	0),
(319,	'',	121,	'okay-food21.jpg',	1),
(320,	'',	122,	'okay-food23.jpg',	0),
(321,	'',	122,	'okay-food22.jpg',	0),
(322,	'',	123,	'okay-food25.jpg',	0),
(323,	'',	123,	'okay-food24.jpg',	0),
(324,	'',	124,	'okay-food26.jpg',	0),
(325,	'',	125,	'okay-food27.jpg',	0),
(326,	'',	125,	'okay-food28.jpg',	0),
(327,	'',	126,	'okay-food29.jpg',	0),
(328,	'',	126,	'okay-food30.jpg',	1),
(329,	'',	127,	'okay-food31.jpg',	0),
(330,	'',	127,	'okay-food33.jpg',	0),
(331,	'',	128,	'okay-food34.jpg',	0),
(332,	'',	129,	'okay-food36.jpg',	0),
(333,	'',	129,	'okay-food37.jpg',	0),
(334,	'',	130,	'okay-food38.jpg',	0),
(335,	'',	131,	'okay-food39.jpg',	0),
(336,	'',	132,	'okay-food40.jpg',	0),
(337,	'',	133,	'okay-food42.jpg',	0),
(338,	'',	133,	'okay-food41.jpg',	0),
(339,	'',	134,	'okay-food44.jpg',	0),
(340,	'',	134,	'okay-food43.jpg',	0),
(341,	'',	135,	'okay-food45.jpg',	0),
(342,	'',	136,	'okay-heals1.jpg',	0),
(343,	'',	136,	'okay-heals2.jpg',	1),
(346,	'',	137,	'okay-heals5.jpg',	1),
(347,	'',	137,	'okay-heals3.jpg',	0),
(348,	'',	137,	'okay-heals4.jpg',	2),
(355,	'',	138,	'okay-heals6.jpg',	0),
(356,	'',	138,	'okay-heals8.jpg',	1),
(357,	'',	138,	'okay-heals7.jpg',	2),
(361,	'',	139,	'okay-heals9.jpg',	0),
(362,	'',	139,	'okay-heals10.jpg',	0),
(363,	'',	139,	'okay-heals11.jpg',	0),
(367,	'',	140,	'okay-heals12.jpg',	0),
(368,	'',	140,	'okay-heals13.jpg',	1),
(369,	'',	140,	'okay-heals14.jpg',	2),
(373,	'',	141,	'okay-heals15.jpg',	0),
(374,	'',	141,	'okay-heals16.jpg',	0),
(375,	'',	141,	'okay-heals17.jpg',	0),
(379,	'',	142,	'okay-heals18.jpg',	0),
(380,	'',	142,	'okay-heals20.jpg',	0),
(381,	'',	142,	'okay-heals19.jpg',	0),
(385,	'',	143,	'okay-heals21.jpg',	0),
(386,	'',	143,	'okay-heals22.jpg',	0),
(387,	'',	143,	'okay-heals23.jpg',	0),
(388,	'',	144,	'okay_couch3.jpg',	0),
(389,	'',	144,	'okay_couch1.jpg',	1),
(390,	'',	144,	'okay_couch2.jpg',	2),
(391,	'',	144,	'okay_couch5.jpg',	3),
(392,	'',	144,	'okay_couch4.jpg',	4),
(393,	'',	145,	'okay_couch3.jpg',	1),
(394,	'',	145,	'okay_couch1.jpg',	0),
(395,	'',	145,	'okay_couch2.jpg',	2),
(396,	'',	145,	'okay_couch5.jpg',	3),
(397,	'',	145,	'okay_couch4.jpg',	4),
(398,	'',	146,	'okay_couch1.jpg',	2),
(399,	'',	146,	'okay_couch3.jpg',	1),
(400,	'',	146,	'okay_couch2.jpg',	3),
(401,	'',	146,	'okay_couch5.jpg',	0),
(402,	'',	146,	'okay_couch4.jpg',	4),
(403,	'',	147,	'okay_couch5.jpg',	1),
(404,	'',	147,	'okay_couch3.jpg',	2),
(405,	'',	147,	'okay_couch1.jpg',	3),
(406,	'',	147,	'okay_couch2.jpg',	4),
(407,	'',	147,	'okay_couch4.jpg',	0),
(408,	'',	148,	'okay_couch4.jpg',	1),
(409,	'',	148,	'okay_couch5.jpg',	2),
(410,	'',	148,	'okay_couch3.jpg',	3),
(411,	'',	148,	'okay_couch1.jpg',	4),
(412,	'',	148,	'okay_couch2.jpg',	0),
(418,	'',	150,	'okay_couch6.jpg',	0),
(419,	'',	150,	'okay_couch10.jpg',	1),
(420,	'',	150,	'okay_couch9.jpg',	2),
(421,	'',	150,	'okay_couch8png.jpg',	3),
(422,	'',	150,	'okay_couch7png.jpg',	4),
(423,	'',	150,	'okay_couch5.jpg',	5),
(424,	'',	151,	'okay_couch6.jpg',	1),
(425,	'',	151,	'okay_couch10.jpg',	0),
(426,	'',	151,	'okay_couch9.jpg',	2),
(427,	'',	151,	'okay_couch8png.jpg',	3),
(428,	'',	151,	'okay_couch7png.jpg',	4),
(429,	'',	151,	'okay_couch5.jpg',	5),
(430,	'',	152,	'okay_couch10.jpg',	1),
(431,	'',	152,	'okay_couch6.jpg',	2),
(432,	'',	152,	'okay_couch9.jpg',	3),
(433,	'',	152,	'okay_couch8png.jpg',	4),
(434,	'',	152,	'okay_couch7png.jpg',	5),
(435,	'',	152,	'okay_couch5.jpg',	0),
(436,	'',	153,	'okay_couch5.jpg',	1),
(437,	'',	153,	'okay_couch10.jpg',	2),
(438,	'',	153,	'okay_couch6.jpg',	3),
(439,	'',	153,	'okay_couch9.jpg',	4),
(440,	'',	153,	'okay_couch8png.jpg',	5),
(441,	'',	153,	'okay_couch7png.jpg',	0),
(442,	'',	154,	'okay_stool3.jpg',	0),
(443,	'',	154,	'okay_stool4.jpg',	0),
(444,	'',	154,	'okay_stool1.jpg',	0),
(445,	'',	154,	'okay_stool2.jpg',	0),
(446,	'',	154,	'okay_stool5.jpg',	0),
(447,	'',	155,	'okay_stool3.jpg',	1),
(448,	'',	155,	'okay_stool4.jpg',	2),
(449,	'',	155,	'okay_stool1.jpg',	3),
(450,	'',	155,	'okay_stool2.jpg',	0),
(451,	'',	155,	'okay_stool5.jpg',	4),
(452,	'',	156,	'okay_stool2.jpg',	1),
(453,	'',	156,	'okay_stool3.jpg',	2),
(454,	'',	156,	'okay_stool4.jpg',	3),
(455,	'',	156,	'okay_stool1.jpg',	0),
(456,	'',	156,	'okay_stool5.jpg',	4),
(457,	'',	157,	'okay_stool1.jpg',	1),
(458,	'',	157,	'okay_stool2.jpg',	2),
(459,	'',	157,	'okay_stool3.jpg',	3),
(460,	'',	157,	'okay_stool4.jpg',	0),
(461,	'',	157,	'okay_stool5.jpg',	4),
(473,	'',	158,	'okay_chaire5.jpg',	0),
(474,	'',	158,	'okay_chaire6png.jpg',	1),
(475,	'',	158,	'okay_chaire2.jpg',	2),
(476,	'',	158,	'okay_chaire7.jpg',	3),
(477,	'',	158,	'okay_chaire1.jpg',	4),
(478,	'',	158,	'okay_chaire3.jpg',	5),
(479,	'',	159,	'okay_chaire5.jpg',	1),
(480,	'',	159,	'okay_chaire6png.jpg',	2),
(481,	'',	159,	'okay_chaire2.jpg',	3),
(482,	'',	159,	'okay_chaire7.jpg',	0),
(483,	'',	159,	'okay_chaire1.jpg',	4),
(484,	'',	159,	'okay_chaire3.jpg',	5),
(485,	'',	160,	'okay_chaire7.jpg',	1),
(486,	'',	160,	'okay_chaire5.jpg',	2),
(487,	'',	160,	'okay_chaire6png.jpg',	0),
(488,	'',	160,	'okay_chaire2.jpg',	3),
(489,	'',	160,	'okay_chaire1.jpg',	4),
(490,	'',	160,	'okay_chaire3.jpg',	5),
(491,	'',	161,	'okay_chaire6png.jpg',	1),
(492,	'',	161,	'okay_chaire7.jpg',	2),
(493,	'',	161,	'okay_chaire5.jpg',	3),
(494,	'',	161,	'okay_chaire2.jpg',	0),
(495,	'',	161,	'okay_chaire1.jpg',	4),
(496,	'',	161,	'okay_chaire3.jpg',	5),
(497,	'',	162,	'79-large_default.jpg',	0),
(499,	'',	163,	'okay_quilt1.jpg',	0),
(501,	'',	164,	'okay_quilt2.jpg',	0),
(503,	'',	165,	'okay_quilt3.jpg',	0),
(505,	'',	166,	'okay_quilt4.jpg',	0),
(507,	'',	167,	'okay_quilt6.jpg',	0),
(508,	'',	167,	'okay_quilt7.jpg',	0),
(509,	'',	167,	'okay_quilt8.jpg',	0),
(510,	'',	166,	'okay_quilt5.jpg',	0),
(511,	'',	166,	'okay_quilt6.jpg',	0),
(512,	'',	166,	'okay_quilt7.jpg',	0),
(513,	'',	162,	'okay_quilt3.jpg',	1),
(514,	'',	162,	'okay_quilt1.jpg',	2),
(515,	'',	162,	'okay_quilt1.jpg',	3),
(516,	'',	162,	'okay_quilt2.jpg',	4),
(517,	'',	163,	'okay_quilt3.jpg',	1),
(518,	'',	163,	'okay_quilt4.jpg',	2),
(519,	'',	163,	'okay_quilt5.jpg',	3),
(520,	'',	164,	'79-large_default.jpg',	1),
(521,	'',	164,	'okay_quilt4.jpg',	2),
(522,	'',	165,	'okay_quilt5.jpg',	1),
(523,	'',	168,	'okay_bathroom_penal4.jpg',	0),
(524,	'',	168,	'okay_bathroom_penal5.jpg',	0),
(525,	'',	168,	'okay_bathroom_penal6.jpg',	0),
(526,	'',	169,	'okay_bathroom_penal4.jpg',	1),
(527,	'',	169,	'okay_bathroom_penal5.jpg',	0),
(528,	'',	169,	'okay_bathroom_penal6.jpg',	2),
(529,	'',	170,	'okay_bathroom_penal5.jpg',	1),
(530,	'',	170,	'okay_bathroom_penal4.jpg',	2),
(531,	'',	170,	'okay_bathroom_penal6.jpg',	0),
(535,	'',	171,	'okay_bathroom_penal1.jpg',	0),
(536,	'',	171,	'okay_bathroom_penal2.jpg',	1),
(537,	'',	171,	'okay_bathroom_penal3.jpg',	2),
(538,	'',	172,	'okay_bathroom_penal1.jpg',	1),
(539,	'',	172,	'okay_bathroom_penal2.jpg',	0),
(540,	'',	172,	'okay_bathroom_penal3.jpg',	2),
(541,	'',	173,	'okay_bathroom_penal2.jpg',	1),
(542,	'',	173,	'okay_bathroom_penal1.jpg',	2),
(543,	'',	173,	'okay_bathroom_penal3.jpg',	0),
(544,	'',	174,	'okay_bathroom_tumba1.jpg',	0),
(545,	'',	174,	'okay_bathroom_tumba2.jpg',	0),
(546,	'',	174,	'okay_bathroom_tumba3.jpg',	0),
(547,	'',	174,	'okay_bathroom_tumba5.jpg',	0),
(548,	'',	174,	'okay_bathroom_tumba4.jpg',	0),
(549,	'',	175,	'okay_bathroom_tumba1.jpg',	1),
(550,	'',	175,	'okay_bathroom_tumba2.jpg',	0),
(551,	'',	175,	'okay_bathroom_tumba3.jpg',	2),
(552,	'',	175,	'okay_bathroom_tumba5.jpg',	3),
(553,	'',	175,	'okay_bathroom_tumba4.jpg',	4),
(554,	'',	176,	'okay_bathroom_tumba2.jpg',	2),
(555,	'',	176,	'okay_bathroom_tumba1.jpg',	3),
(556,	'',	176,	'okay_bathroom_tumba3.jpg',	1),
(557,	'',	176,	'okay_bathroom_tumba5.jpg',	4),
(558,	'',	176,	'okay_bathroom_tumba4.jpg',	5),
(559,	'',	177,	'okay_bathroom_tumba3.jpg',	1),
(560,	'',	177,	'okay_bathroom_tumba2.jpg',	2),
(561,	'',	177,	'okay_bathroom_tumba1.jpg',	3),
(562,	'',	177,	'okay_bathroom_tumba5.jpg',	0),
(563,	'',	177,	'okay_bathroom_tumba4.jpg',	4),
(564,	'',	178,	'okay_bathroom_tumba5.jpg',	2),
(565,	'',	178,	'okay_bathroom_tumba3.jpg',	3),
(566,	'',	178,	'okay_bathroom_tumba2.jpg',	4),
(567,	'',	178,	'okay_bathroom_tumba1.jpg',	5),
(568,	'',	178,	'okay_bathroom_tumba4.jpg',	1),
(569,	'',	179,	'okay_screwdriver1.jpg',	0),
(570,	'',	179,	'okay_screwdriver2.jpg',	0),
(571,	'',	179,	'okay_screwdriver3.jpg',	0),
(575,	'',	180,	'okay_screwdriver4.jpg',	0),
(576,	'',	180,	'okay_screwdriver5.jpg',	0),
(577,	'',	180,	'okay_screwdriver6.jpg',	0),
(581,	'',	181,	'okay_screwdriver7.jpg',	0),
(582,	'',	181,	'okay_screwdriver8.jpg',	0),
(583,	'',	181,	'okay_screwdriver9.jpg',	0),
(587,	'',	182,	'okay_screwdriver10.jpg',	0),
(588,	'',	182,	'okay_screwdriver11.jpg',	1),
(589,	'',	182,	'okay_screwdriver12.jpg',	2),
(596,	'',	183,	'okay_screwdriver13.jpg',	0),
(597,	'',	183,	'okay_screwdriver14.jpg',	0),
(598,	'',	183,	'okay_screwdriver15.jpg',	0),
(602,	'',	185,	'okay_screwdriver16.jpg',	0),
(603,	'',	185,	'okay_screwdriver17.jpg',	0),
(604,	'',	185,	'okay_screwdriver18.jpg',	0),
(608,	'',	186,	'okay_screwdriver19.jpg',	0),
(609,	'',	186,	'okay_screwdriver20.jpg',	0),
(610,	'',	186,	'okay_screwdriver21.jpg',	0),
(614,	'',	187,	'okay_screwdriver22.jpg',	0),
(615,	'',	187,	'okay_screwdriver23.jpg',	0),
(616,	'',	187,	'okay_screwdriver24.jpg',	0),
(617,	'',	188,	'okay-book1.jpg',	0),
(619,	'',	189,	'okay-book2.jpg',	0),
(621,	'',	190,	'okay-book3.jpg',	0),
(623,	'',	191,	'okay-book4.jpg',	0),
(625,	'',	192,	'okay-book5.jpg',	0),
(627,	'',	193,	'okay-book6.jpg',	0),
(629,	'',	194,	'okay-book7.jpg',	0),
(631,	'',	195,	'okay-book8.jpg',	0),
(632,	'',	188,	'okay-book2.jpg',	0),
(633,	'',	188,	'okay-book4.jpg',	0),
(634,	'',	188,	'okay-book5.jpg',	0),
(635,	'',	188,	'okay-book3.jpg',	0),
(636,	'',	189,	'okay-book4.jpg',	0),
(637,	'',	189,	'okay-book6.jpg',	0),
(638,	'',	189,	'okay-book5.jpg',	0),
(639,	'',	189,	'okay-book3.jpg',	0),
(640,	'',	190,	'okay-book1.jpg',	0),
(641,	'',	190,	'okay-book8.jpg',	0),
(642,	'',	190,	'okay-book7.jpg',	0),
(643,	'',	191,	'okay-book5.jpg',	1),
(644,	'',	191,	'okay-book6.jpg',	2),
(645,	'',	192,	'okay-book7.jpg',	0),
(646,	'',	192,	'okay-book8.jpg',	0),
(647,	'',	193,	'okay-book3.jpg',	1),
(648,	'',	193,	'okay-book4.jpg',	2),
(649,	'',	193,	'okay-book5.jpg',	3),
(650,	'',	194,	'okay-book1.jpg',	0),
(651,	'',	194,	'okay-book2.jpg',	0),
(652,	'',	194,	'okay-book3.jpg',	0),
(653,	'',	195,	'okay-book3.jpg',	0),
(654,	'',	195,	'okay-book4.jpg',	0),
(655,	'',	195,	'okay-book5.jpg',	0),
(656,	'',	195,	'okay-book6.jpg',	0),
(657,	'',	196,	'okay_beauty1.jpg',	0),
(658,	'',	196,	'okay_beauty2.jpg',	0),
(659,	'',	196,	'okay_beauty3.jpg',	0),
(663,	'',	197,	'okay_beauty4.jpg',	0),
(664,	'',	197,	'okay_beauty5.jpg',	0),
(665,	'',	197,	'okay_beauty6.jpg',	0),
(669,	'',	198,	'okay_beauty7.jpg',	0),
(670,	'',	198,	'okay_beauty9.jpg',	1),
(671,	'',	198,	'okay_beauty8.jpg',	2),
(675,	'',	199,	'okay_beauty11.jpg',	0),
(676,	'',	199,	'okay_beauty10.jpg',	0),
(677,	'',	199,	'okay_beauty12.jpg',	0),
(681,	'',	200,	'okay_beauty13.jpg',	0),
(682,	'',	200,	'okay_beauty14.jpg',	0),
(683,	'',	201,	'okay_beauty15.jpg',	0),
(684,	'',	201,	'okay_beauty16.jpg',	0),
(685,	'',	201,	'okay_beauty17.jpg',	0),
(688,	'',	202,	'okay_beauty18.jpg',	0),
(689,	'',	202,	'okay_beauty19.jpg',	0),
(690,	'',	202,	'okay_beauty20.jpg',	0),
(691,	'',	203,	'okay_beauty18.jpg',	1),
(692,	'',	203,	'okay_beauty19.jpg',	2),
(693,	'',	203,	'okay_beauty20.jpg',	0),
(694,	'',	204,	'okay_beauty20.jpg',	1),
(695,	'',	204,	'okay_beauty18.jpg',	2),
(696,	'',	204,	'okay_beauty19.jpg',	0),
(697,	'',	205,	'okay_sport6.jpg',	0),
(698,	'',	205,	'okay_sport1.png',	0),
(699,	'',	205,	'okay_sport2.png',	0),
(700,	'',	205,	'okay_sport3.png',	0),
(701,	'',	205,	'okay_sport4.png',	0),
(702,	'',	206,	'okay_sport5.jpg',	0),
(703,	'',	206,	'okay_sport1.png',	1),
(704,	'',	206,	'okay_sport2.png',	2),
(705,	'',	206,	'okay_sport3.png',	3),
(706,	'',	206,	'okay_sport4.png',	4),
(707,	'',	206,	'okay_sport6.jpg',	5),
(708,	'',	207,	'okay_sport2.png',	0),
(709,	'',	207,	'okay_sport1.png',	1),
(710,	'',	207,	'okay_sport3.png',	2),
(711,	'',	207,	'okay_sport4.png',	3),
(712,	'',	208,	'okay_sport4.png',	0),
(713,	'',	208,	'okay_sport1.png',	0),
(714,	'',	208,	'okay_sport2.png',	0),
(715,	'',	208,	'okay_sport3.png',	0),
(716,	'',	209,	'okay_sport3.png',	0),
(717,	'',	209,	'okay_sport1.png',	0),
(718,	'',	209,	'okay_sport2.png',	0),
(719,	'',	209,	'okay_sport4.png',	0),
(720,	'',	210,	'okay_sport12.jpg',	0),
(721,	'',	210,	'okay_sport7.jpg',	1),
(722,	'',	210,	'okay_sport8.jpg',	2),
(723,	'',	210,	'okay_sport9.jpg',	3),
(724,	'',	210,	'okay_sport10.jpg',	4),
(725,	'',	210,	'okay_sport11.jpg',	5),
(726,	'',	211,	'okay_sport8.jpg',	0),
(727,	'',	211,	'okay_sport9.jpg',	0),
(728,	'',	211,	'okay_sport12.jpg',	0),
(729,	'',	212,	'okay_sport7.jpg',	0),
(730,	'',	212,	'okay_sport8.jpg',	1),
(731,	'',	212,	'okay_sport9.jpg',	2),
(732,	'',	213,	'okay_sport13.jpg',	0),
(733,	'',	213,	'okay_sport15.jpg',	0),
(734,	'',	213,	'okay_sport14.jpg',	0),
(735,	'',	214,	'okay_sport16.jpg',	0),
(736,	'',	214,	'okay_sport17.jpg',	1),
(737,	'',	215,	'okay_sport18.jpg',	0),
(738,	'',	215,	'okay_sport19.jpg',	0),
(739,	'',	216,	'okay_sport20.jpg',	0),
(740,	'',	217,	'okay_sport22.jpg',	1),
(741,	'',	217,	'okay_sport21.jpeg',	0),
(742,	'',	217,	'okay_sport23.jpeg',	2),
(743,	'',	217,	'okay_sport24.jpeg',	3),
(744,	'',	218,	'okay_sport21.jpeg',	1),
(745,	'',	218,	'okay_sport22.jpg',	0),
(746,	'',	218,	'okay_sport23.jpeg',	2),
(747,	'',	218,	'okay_sport24.jpeg',	3),
(748,	'',	219,	'okay_sport6.jpg',	1),
(749,	'',	219,	'okay_sport1.png',	0),
(750,	'',	219,	'okay_sport2.png',	2),
(751,	'',	219,	'okay_sport3.png',	3),
(752,	'',	219,	'okay_sport4.png',	4),
(753,	'',	220,	'okay_tech1.jpg',	0),
(754,	'',	220,	'okay_tech2.jpg',	1),
(755,	'',	220,	'okay_tech3.jpg',	2),
(759,	'',	221,	'okay_tech4.jpg',	0),
(760,	'',	221,	'okay_tech5.jpg',	0),
(763,	'',	222,	'okay_tech6.jpg',	0),
(764,	'',	222,	'okay_tech7.jpg',	0),
(767,	'',	223,	'okay_tech8.jpg',	0),
(768,	'',	223,	'okay_tech9.jpg',	1),
(771,	'',	224,	'okay_tech10.jpg',	0),
(772,	'',	224,	'okay_tech11.jpg',	1),
(773,	'',	224,	'okay_tech12.jpg',	2),
(774,	'',	225,	'okay_animal.jpg',	0),
(776,	'',	226,	'okay_animal2.jpg',	0),
(777,	'',	227,	'okay_animal3.jpg',	0),
(778,	'',	228,	'okay_animal4.jpg',	0),
(779,	'',	229,	'okay_animal6.jpg',	0),
(780,	'',	230,	'okay_couch1.jpg',	0),
(781,	'',	230,	'okay_couch2.jpg',	1),
(782,	'',	230,	'okay_couch3.jpg',	2),
(783,	'',	230,	'okay_couch4.jpg',	3),
(784,	'',	231,	'okay_couch2.jpg',	0),
(785,	'',	231,	'okay_couch1.jpg',	1),
(786,	'',	231,	'okay_couch3.jpg',	2),
(787,	'',	231,	'okay_couch4.jpg',	3),
(788,	'',	178,	'okay_bathroom_tumba4.png',	0),
(789,	'',	177,	'okay_bathroom_tumba5.jpg',	0),
(790,	'',	176,	'okay_bathroom_tumba6.png',	0);

DROP TABLE IF EXISTS `ok_import_log`;
CREATE TABLE `ok_import_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` int(11) NOT NULL,
  `status` varchar(8) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `product_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `variant_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `product_id` (`product_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


DROP TABLE IF EXISTS `ok_labels`;
CREATE TABLE `ok_labels` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `color` varchar(6) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `position` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `ok_labels` (`id`, `name`, `color`, `position`) VALUES
(1,	'перезвонить',	'fa9e52',	1),
(2,	'оптовик',	'bc66f2',	2),
(3,	'отложен',	'ed8080',	3);

DROP TABLE IF EXISTS `ok_languages`;
CREATE TABLE `ok_languages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `label` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `href_lang` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 0,
  `position` int(11) NOT NULL DEFAULT 0,
  `name_ru` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `name_ua` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `name_en` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `ok_languages` (`id`, `name`, `label`, `href_lang`, `enabled`, `position`, `name_ru`, `name_ua`, `name_en`) VALUES
(1,	'Русский',	'ru',	'ru',	1,	1,	'Русский',	'Російська',	'Russian'),
(2,	'Английский',	'en',	'en',	1,	2,	'Английский',	'Англійська',	'English'),
(3,	'Украинский',	'ua',	'uk',	1,	3,	'Украинский',	'Українська',	'Ukrainian');

DROP TABLE IF EXISTS `ok_lang_advantages`;
CREATE TABLE `ok_lang_advantages` (
  `advantage_id` int(11) DEFAULT NULL,
  `lang_id` int(11) NOT NULL,
  `text` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  UNIQUE KEY `lang_id` (`advantage_id`,`lang_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `ok_lang_advantages` (`advantage_id`, `lang_id`, `text`) VALUES
(1,	1,	'Доставка по всей стране'),
(1,	2,	'Nationwide delivery'),
(1,	3,	'Доставка по всій країні'),
(2,	1,	'100% гарантия качества'),
(2,	2,	'100% quality guarantee'),
(2,	3,	'100% гарантія якості'),
(3,	1,	'14 дней на возврат товара'),
(3,	2,	'14 days for return'),
(3,	3,	'14 днів на повернення товару'),
(4,	1,	'Самовывоз из магазина'),
(4,	2,	'Pickup'),
(4,	3,	'Самовивіз з магазину');

DROP TABLE IF EXISTS `ok_lang_authors`;
CREATE TABLE `ok_lang_authors` (
  `lang_id` int(11) NOT NULL,
  `author_id` int(11) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `position_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_title` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `meta_keywords` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `meta_description` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  UNIQUE KEY `lang_id` (`lang_id`,`author_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `ok_lang_authors` (`lang_id`, `author_id`, `name`, `position_name`, `meta_title`, `meta_keywords`, `meta_description`, `description`) VALUES
(1,	1,	'Виталий Владов',	'Chief Executive Officer',	'Виталий Владов',	'Виталий Владов',	'Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.',	'<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.</p>'),
(1,	2,	'Александр Вавилин',	'Developer',	'Александр Вавилин',	'Александр Вавилин',	'Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim a',	'<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis.</p>'),
(1,	3,	'Марина Баранец',	'Manager',	'Баранец Марина',	'Баранец Марина',	'Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. \r\n Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas.',	'<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.</p>\r\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas.</p>'),
(1,	4,	'Олег Янчук',	'Developer',	'Олег Янчук',	'Олег Янчук',	'Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim a',	'<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat.</p>'),
(2,	1,	'Виталий Владов',	'Chief Executive Officer',	'Виталий Владов',	'Виталий Владов',	'',	''),
(2,	2,	'Вавилин Александр',	'Developer',	'Вавилин Александр',	'Вавилин Александр',	'Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim a',	'<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis.</p>'),
(2,	3,	'Баранец Марина',	'Manager',	'Баранец Марина',	'Баранец Марина',	'Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. \r\n Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas.',	'<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.</p>\r\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas.</p>'),
(2,	4,	'Олег Янчук',	'Developer',	'Олег Янчук',	'Олег Янчук',	'Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim a',	'<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat.</p>'),
(3,	1,	'Виталий Владов',	'Chief Executive Officer',	'Виталий Владов',	'Виталий Владов',	'',	''),
(3,	2,	'Вавилин Александр',	'Developer',	'Вавилин Александр',	'Вавилин Александр',	'Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim a',	'<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis.</p>'),
(3,	3,	'Баранец Марина',	'Manager',	'Баранец Марина',	'Баранец Марина',	'Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. \r\n Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas.',	'<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.</p>\r\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas.</p>'),
(3,	4,	'Олег Янчук',	'Developer',	'Олег Янчук',	'Олег Янчук',	'Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim a',	'<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat.</p>');

DROP TABLE IF EXISTS `ok_lang_blog`;
CREATE TABLE `ok_lang_blog` (
  `lang_id` int(11) NOT NULL,
  `blog_id` int(11) NOT NULL,
  `name` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `meta_title` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `meta_keywords` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `meta_description` varchar(512) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `annotation` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  UNIQUE KEY `lang_id` (`lang_id`,`blog_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `ok_lang_blog` (`lang_id`, `blog_id`, `name`, `meta_title`, `meta_keywords`, `meta_description`, `annotation`, `description`) VALUES
(1,	1,	'Основные изменения в OkayCMS 2.0',	'Основные изменения в OkayCMS 2.0',	'Основные изменения в OkayCMS 2.0',	'1.        Административная панель.        Абсолютно новый дизайн, структура и верстка согласно современным подходам. Теперь админ-панель более дружелюбная, понятная и удобная для пользователя. Предусмотрено место для размещения нового функционала, доработок и модулей. Главный козырь новой админки &ndash; ее адаптивность. Вносить корректировки, обрабатывать заказы, отвечать на запросы теперь удобно с любого устройства.    \r\n   2.        Техническая поддержка OkayCMS.        В админ-панель внедрен функционал ',	'<p>1. Административная панель. Абсолютно новый дизайн, структура и верстка согласно современным подходам. Теперь админ-панель более дружелюбная, понятная и удобная для пользователя. Предусмотрено место для размещения нового функционала, доработок и модулей. Главный козырь новой админки &ndash; ее адаптивность. Вносить корректировки, обрабатывать заказы, отвечать на запросы теперь удобно с любого устройства.</p>',	'<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span style=\"color: #000000;\"><span lang=\"ru-RU\">1. </span></span><span style=\"color: #4f81bd;\"><span style=\"font-family: Cambria,serif;\"><span style=\"font-size: medium;\"><strong><span style=\"color: #000000;\">Административная панель. </span></strong></span></span></span><span style=\"color: #000000;\"><span lang=\"ru-RU\">Абсолютно новый дизайн, структура и верстка согласно современным подходам. Теперь админ-панель более дружелюбная, понятная и удобная для пользователя. Предусмотрено место для размещения нового функционала, доработок и модулей. Главный козырь новой админки &ndash; ее адаптивность. Вносить корректировки, обрабатывать заказы, отвечать на запросы теперь удобно с любого устройства. </span></span></p>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span style=\"color: #000000;\"><span lang=\"ru-RU\">2. </span></span><span style=\"color: #4f81bd;\"><span style=\"font-family: Cambria,serif;\"><span style=\"font-size: medium;\"><strong><span style=\"color: #000000;\">Техническая поддержка OkayCMS. </span></strong></span></span></span><span style=\"color: #000000;\"><span lang=\"ru-RU\">В админ-панель внедрен функционал для связи с техподдержкой </span></span><span style=\"color: #000000;\"><span lang=\"en-US\">OkayCMS</span></span><span style=\"color: #000000;\"><span lang=\"ru-RU\">. Теперь вам не нужно звонить, писать на почту или скайп. Задать вопросы, получить консультацию, помощь в установке </span></span><span style=\"color: #000000;\"><span lang=\"en-US\">CMS</span></span><span style=\"color: #000000;\"><span lang=\"ru-RU\">, шаблона или дополнения можно прямо из административной панели, отправив запрос в техподдержку. Это поможет нам быстрее отвечать на ваши вопросы, а история переписок по всем темам всегда будут храниться в одном месте - у вас в админке. <a href=\"https://okay-cms.com/support\">Подробнее о техподдержке</a>. </span></span></p>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span style=\"color: #000000;\"><span lang=\"ru-RU\">В 2.0 пользователь лицензионной </span><span lang=\"en-US\">OkayCMS</span> <span lang=\"en-US\">Pro</span><span lang=\"ru-RU\"> получит 10 часов бесплатной техподдержки, пользователь </span><span lang=\"en-US\">OkayCMS</span> <span lang=\"en-US\">Lite</span><span lang=\"ru-RU\"> &ndash; 30 минут с возможностью докупить часы техподдержки. </span></span></p>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span style=\"color: #000000;\"><span lang=\"ru-RU\">3. </span></span><span style=\"color: #4f81bd;\"><span style=\"font-family: Cambria,serif;\"><span style=\"font-size: medium;\"><strong><span style=\"color: #000000;\">Мультиязычнсть сайта. </span></strong></span></span></span><span style=\"color: #000000;\"><span lang=\"ru-RU\">Переделана мультиязычность клиентской части и добавлена мультиязычность админ-панели. Теперь переводы статических фраз хранятся не в базе данных, а в файлах. Для клиентской части это упрощает установку новых тем и возможность переключения между ними. Для обеих частей (как админки, так и клиентской) это облегчает перевод сайта на другие языки. Теперь сделать сайт для клиента полностью на иностранном языке не составляет проблемы. Для этого необходимо перевести фразы всего в двух файлах. На момент релиза в </span></span><span style=\"color: #000000;\"><span lang=\"en-US\">OkayCMS</span></span><span style=\"color: #000000;\"><span lang=\"ru-RU\"> 2.0 добавлено два языка для административной панели - русский и английский, но в ближайшее время их количество увеличится.</span></span></p>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span style=\"color: #000000;\"><span lang=\"ru-RU\">4. </span></span><span style=\"color: #4f81bd;\"><span style=\"font-family: Cambria,serif;\"><span style=\"font-size: medium;\"><strong><span style=\"color: #000000;\">Новый дефолтный шаблон.</span></strong></span></span></span><span style=\"color: #000000;\"><span lang=\"ru-RU\"> Код шаблона теперь чище и приятнее для разработчиков, детальнее прокомментирован. Сам шаблон теперь позволяет добавлять большое количество категорий.</span></span></p>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span style=\"color: #000000;\"><span lang=\"ru-RU\">5. </span></span><span style=\"color: #4f81bd;\"><span style=\"font-family: Cambria,serif;\"><span style=\"font-size: medium;\"><strong><span style=\"color: #000000;\">PHP 7.</span></strong></span></span></span><span style=\"color: #000000;\"><span lang=\"ru-RU\"> Полная поддержка PHP 7, которая позволит позволит сайтам на OkayCMS работать быстрее.</span></span></p>'),
(1,	2,	'Как работает техподдержка OkayCMS 2.0',	'Как работает техподдержка OkayCMS 2.0',	'Как работает техподдержка OkayCMS 2.0',	'Приобретая лицензию OkayCMS Pro 2.0, вы получаете 10 часов комплексной поддержки и консультаций по работе с OkayCMS. Предлагаем более подробно ознакомиться с видами консультаций и регламентом работы службы поддержки.  \r\n  Специалисты технической поддержки выполняют следующие работы:  \r\n \r\n \r\n  дают консультации о системных требованиях для оптимальной работы системы;  \r\n \r\n \r\n  дают консультации по работе c OkayCMS для администратора магазина;  \r\n \r\n \r\n  предоставляют консультации по внедрению дополнительног',	'<p>Приобретая лицензию OkayCMS Pro 2.0, вы получаете 10 часов комплексной поддержки и консультаций по работе с OkayCMS. Предлагаем более подробно ознакомиться с видами консультаций и регламентом работы службы поддержки.</p>',	'<p><span lang=\"ru-RU\">Приобретая лицензию OkayCMS Pro 2.0, вы получаете 10 часов комплексной поддержки и консультаций по работе с OkayCMS. Предлагаем более подробно ознакомиться с видами консультаций и регламентом работы службы поддержки.</span></p>\r\n<h2 class=\"western\"><span lang=\"ru-RU\">Специалисты технической поддержки выполняют следующие работы:</span></h2>\r\n<ul>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">дают консультации о системных требованиях для оптимальной работы системы;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">дают консультации&nbsp;по работе c OkayCMS для администратора магазина;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">предоставляют консультации по внедрению дополнительного функционала в OkayCMS;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">оказывают помощь в установке OkayCMS на хостинг;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">проводят установку шаблонов и дополнений из</span><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">&nbsp;</span></span></span></span><a href=\"https://okay-cms.com/catalog/dopolneniya\"><span style=\"color: #38c0f3;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">MarketPlace OkayCMS</span></span></span></span></a><span lang=\"ru-RU\">;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">проводят обновление OkayCMS до последней актуальной версии.</span></p>\r\n</li>\r\n</ul>\r\n<h2 class=\"western\"><span lang=\"ru-RU\">Регламент работы:</span></h2>\r\n<ol>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">В административной панели вашего сайта на OkayCMS в разделе \"Техническая поддержка\" создайте новое обращение.</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">Подробно опишите проблему и сформулируйте название обращения. После этого подайте обращение на рассмотрение.&nbsp;</span><strong><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">Внимание! Одно обращение в службу поддержки должно содержать одну проблему, не пишите несколько проблем в одном обращении.</span></span></span></span></strong></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">Следите за </span><span lang=\"en-US\">E</span><span lang=\"ru-RU\">mail-уведомлениями о прогрессе решения вашего вопроса в течении одного рабочего дня. Ответ так же будет отображен в админ-панели вашего сайта.</span></p>\r\n</li>\r\n</ol>\r\n<h2 class=\"western\"><span lang=\"ru-RU\">Что может повлиять на время решения вашего запроса?</span></h2>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">Для ускорения реакции на ваше обращение мы советуем следовать простым правилам:</span></p>\r\n<ul>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">подробно описывайте проблему, шаги к ее воспроизведению;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">укажите реквизиты доступа в административную часть вашего сайта;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">укажите актуальные доступы к FTP и СУБД (PHPMyAdmin), если для решения проблемы необходимо вмешательство в исходный код;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">предоставьте информацию о версии продукта.</span></p>\r\n</li>\r\n</ul>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">Дополнительно службой поддержки может быть затребована информация о настройках ПО, а также информация для доступа к серверу по FTP, SSH или административной панели хостинг-провайдера.</span></p>\r\n<h2 class=\"western\"><span lang=\"ru-RU\">Обработка обращения прекращается в случае:</span></h2>\r\n<ul>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">если пользователь не может дать затребованную агентом поддержки информацию для решения вопроса;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">клиент не может предоставить доступы к сайту (FTP, SSH, панель управления хостингом и т. д.);</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">проблема не может быть воспроизведена;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">обращение содержит несколько связанных между собой проблем;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">хостинг не соответствует системным требованиям;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">вопрос задан неконкретно или диалог ведется в неконструктивной форме;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">вопрос выходит за рамки технической поддержки;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">если в течение 30 календарных дней ответ от пользователя не был получен, обращение считается обработанным автоматически.</span></p>\r\n</li>\r\n</ul>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"color: #767679;\">&nbsp;</span></p>\r\n<h2 class=\"western\"><span lang=\"ru-RU\">Услуги, которые не покрывает поддержка OkayCMS*:</span></h2>\r\n<ul>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">перенос данных с других систем;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">разработка дополнительного функционала;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">услуги по веб-разработке. Для этого обратитесь к нашим партнерам;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">web-дизайн;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">поддержка посторонних решений;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">работы по настройке сервера.&nbsp;</span></p>\r\n</li>\r\n</ul>\r\n<h2 class=\"western\"><span lang=\"ru-RU\">Если часы техподдержки закончились?</span></h2>\r\n<ol>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">Перейдите на сайт </span><span lang=\"en-US\">okay</span><span lang=\"ru-RU\">-</span><span lang=\"en-US\">cms</span><span lang=\"ru-RU\">.</span><span lang=\"en-US\">com</span><span lang=\"ru-RU\">/</span><span lang=\"en-US\">support</span><span lang=\"ru-RU\"> в раздел Техническая поддержка.</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">Приобретите необходимое количество часов техподдержки.</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">Ожидайте обновления техподдержки в админ-панели своего сайта.</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">После обновления отправьте свой запрос в техподдержку.</span></p>\r\n</li>\r\n</ol>'),
(1,	3,	'Как установить OkayCMS 2.0 на сайт',	'Как установить OkayCMS 2.0 на сайт',	'Как установить OkayCMS 2.0 на сайт',	'Шаг 1.    Файлы    для установки OkayCMS  \r\n    \r\n \r\n \r\n  Зайдите на официальный сайт OkayCMS.   \r\n \r\n \r\n  Кликните по кнопке          Скачать CMS в шапке сайта. \r\n \r\n \r\n  Сохраните файл к себе на компьютер. Сохраненный файл-архив имеет вид OkayCMS_1.0.1.zip (цифры в названии файла после слова OkayCMS могут отличаться, это зависит от скачиваемой вами версии).  \r\n \r\n \r\n  Разархивируйте файл OkayCMS_1.0.1.zip. (Кликните правой кнопкой мыши на файле и выберите пункт Извлечь в OkayCMS_1.0.1.)           \r\n \r\n \r\n',	'<p>Шаг 1. Файлы для установки OkayCMS Зайдите на официальный сайт OkayCMS. Кликните по кнопке Скачать CMS в шапке сайта. Сохраните файл к себе на компьютер. Сохраненный файл-архив имеет вид OkayCMS_1.0.1.zip (цифры в названии файла после слова OkayCMS могут отличаться, это зависит от скачиваемой вами версии).</p>',	'<h2 class=\"western\"><strong>Шаг 1. </strong><strong><span lang=\"ru-RU\">Файлы</span></strong><strong> для установки OkayCMS</strong></h2>\r\n<p lang=\"ru-RU\" style=\"margin-bottom: 0.35cm; line-height: 115%;\"><br /><br /></p>\r\n<ol>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">Зайдите на официальный сайт OkayCMS. </span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">Кликните по кнопке</span><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">&nbsp;</span></span></span></span>Скачать CMS в шапке сайта.</p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">Сохраните файл к себе на компьютер. Сохраненный файл-архив имеет вид OkayCMS_1.0.1.zip (цифры в названии файла после слова OkayCMS могут отличаться, это зависит от скачиваемой вами версии).</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">Разархивируйте файл OkayCMS_1.0.1.zip. (Кликните правой кнопкой мыши на файле и выберите пункт Извлечь в OkayCMS_1.0.1.)</span><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">&nbsp;</span></span></span></span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">После распаковки архива появится папка OkayCMS_1.0.1, внутри которой будут 2 файла:&nbsp;install.php&nbsp;и&nbsp;okaycms.zip. Эти файлы необходимо загрузить на сервер вашего хостинг-провайдера в корень вашего сайта.</span></p>\r\n</li>\r\n</ol>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">ВНИМАНИЕ! В корень сайта необходимо поместить 2 файла, которые были извлечены из архива OkayCMS_1.0.1.zip, а не сам архив.</span></p>\r\n<h2 class=\"western\"><strong>Шаг 2. Создание базы данных</strong></h2>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"color: #767679;\">&nbsp;</span></p>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"font-family: Times New Roman,serif;\"><span style=\"font-size: medium;\"><span lang=\"ru-RU\">ВНИМАНИЕ! Далее вы будете работать с панелью управления хостинга. Существует большое количество хостинг-провайдеров. Однако</span><span lang=\"ru-RU\">&nbsp;</span><span lang=\"ru-RU\">принцип проводимых действий везде одинаковый.</span></span></span></p>\r\n<p lang=\"ru-RU\" style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><br /><br /></p>\r\n<ol>\r\n<li>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"font-family: Times New Roman,serif;\"><span style=\"font-size: medium;\"><span lang=\"ru-RU\">Зайдите в панель управления вашего хостинга и выберите пункт</span><span lang=\"ru-RU\">&nbsp;</span><span lang=\"ru-RU\">Базы данных.</span></span></span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"font-family: Times New Roman,serif;\"><span style=\"font-size: medium;\"><span lang=\"ru-RU\">Найдите и кликните</span><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">&nbsp;</span></span></span></span><strong><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">Создать базу данных</span></span></span></span></strong><span lang=\"ru-RU\">. В появившемся окне введите</span><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">&nbsp;</span></span></span></span><strong><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">имя базы данных, используя английскую раскладку</span></span></span></span></strong><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">&nbsp;</span></span></span></span><span lang=\"ru-RU\">клавиатуры. Запишите его, оно вам пригодится далее.</span></span></span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"font-family: Times New Roman,serif;\"><span style=\"font-size: medium;\"><span lang=\"ru-RU\">Выберите кодировку</span><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">&nbsp;</span></span></span></span><strong><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">utf8_general_ci</span></span></span></span></strong><span lang=\"ru-RU\">. (Иногда вместо слова Кодировка может быть слово Сравнение)</span></span></span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"font-family: Times New Roman,serif;\"><span style=\"font-size: medium;\"><span lang=\"ru-RU\">Введите имя пользователя, если оно не сгенерировалось автоматически. Так же запишите это имя, оно будет использоваться далее. </span></span></span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"font-family: Times New Roman,serif;\"><span style=\"font-size: medium;\"><span lang=\"ru-RU\">Кликните кнопку</span><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">&nbsp;</span></span></span></span><strong><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">Создать.</span></span></span></span></strong></span></span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"font-family: Times New Roman,serif;\"><span style=\"font-size: medium;\"><span lang=\"ru-RU\">Появится сообщение: база данных успешно создана.</span></span></span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"font-family: Times New Roman,serif;\"><span style=\"font-size: medium;\"><span lang=\"ru-RU\">Для доступа используйте логин ****** и пароль *******</span></span></span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"font-family: Times New Roman,serif;\"><span style=\"font-size: medium;\"><span lang=\"ru-RU\">Запишите пароль к базе данных.</span></span></span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"font-family: Times New Roman,serif;\"><span style=\"font-size: medium;\"><span lang=\"ru-RU\">Возможно, на некоторых хостингах пароль вам придется придумать самостоятельно.</span></span></span></p>\r\n</li>\r\n</ol>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\">&nbsp;</p>\r\n<h2 class=\"western\"><strong>Шаг 3. Загрузка дистрибутива на хостинг</strong></h2>\r\n<p lang=\"ru-RU\" style=\"margin-bottom: 0.35cm; line-height: 115%;\"><br /><br /></p>\r\n<ol>\r\n<li>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"font-family: Times New Roman,serif;\"><span style=\"font-size: medium;\"><span lang=\"ru-RU\">Для загрузки файлов на хостинг понадобится FTP-менеджер, например</span><span lang=\"ru-RU\">&nbsp;</span><span lang=\"ru-RU\">FileZilla,</span><span lang=\"ru-RU\">&nbsp;</span><span lang=\"ru-RU\">Total Commander. </span></span></span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"font-family: Times New Roman,serif;\"><span style=\"font-size: medium;\"><span lang=\"ru-RU\">Запустите FTP-менеджер FileZilla. Для соединения с сервером введите данные, предоставленные вашим хостинг-провайдером и нажмите кнопку Соединение</span></span></span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"font-family: Times New Roman,serif;\"><span style=\"font-size: medium;\"><span lang=\"ru-RU\">В одной из двух частей окна вашего файл-менеджера найдите папку OkayCMS, которую вы создали в Шаге1, зайдите в нее и закачайте файлы</span><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">&nbsp;</span></span></span></span><strong><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">install.php</span></span></span></span></strong><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">&nbsp;</span></span></span></span><span lang=\"ru-RU\">и</span><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">&nbsp;</span></span></span></span><strong><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">okaycms_source.zip</span></span></span></span></strong><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">&nbsp;</span></span></span></span><span lang=\"ru-RU\">на сервер в корень сайта. (Кликните правой кнопкой мыши на файле и выберите</span><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">&nbsp;</span></span></span></span><strong><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">Закачать на сервер</span></span></span></span></strong><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">&nbsp;</span></span></span></span><span lang=\"ru-RU\">или просто перетащите файлы мышкой с левой в другую часть окна).</span></span></span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"font-family: Times New Roman,serif;\"><span style=\"font-size: medium;\"><span lang=\"ru-RU\">На этом работа с FTP-менеджером FileZilla закончена.</span></span></span></p>\r\n</li>\r\n</ol>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"color: #767679;\">&nbsp;</span></p>\r\n<h2 class=\"western\"><a name=\"_GoBack\"></a><strong><span lang=\"ru-RU\">Шаг 4. Завершающий этап установки</span></strong></h2>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">Далее читайте Инструкцию в <a href=\"https://okay-cms.com/article/kak-ustanovit-okaycms-na-sajt\">блоге OkayCMS</a>.</span></p>'),
(1,	4,	'Город Нью-Йорк (New York City)',	'Город Нью-Йорк (New York City)',	'Город Нью-Йорк (New York City)',	'Почти год мы работали над улучшением OkayCMS. Куда еще лучше? спроосите вы, а вот мы нашли. Технологии все время развиваются, и мы не хотим отставать. Наша цель вести свою систему к простоте и функциональности, своевременно удовлетворять запросы пользователей. Поэтому обновление принесло в OkayCMS новые полезные штуки и унесло неиспользуемый функционал и какие-то недочеты, которые в том числе и вы нам помогали искать. Что же в итоге получилось, узнаете из текста. ',	'<p>Нью-Йорк &mdash; пожалуй, самый известный город в мире, в котором сосредоточены финансовые учреждения, многочисленные исторические и культурные достопримечательности, музеи, магазины, театры и многое другое. Это шумный и яркий город небоскребов и свободы, который многим знаком по обилию кинофильмов и фото, где действие разворачивается на его улицах. Здесь столько возможностей, сколько можно вообразить. От Таймс-сквер до самого темного уголка Бронкса &mdash; царство крайностей. От русского анклава в Бруклине на Брайтон-Бич до филиала Южной Америки в Квинсе &mdash; сообщества из любой страны мира.</p>',	'<p><strong>Нью-Йорк</strong> &mdash; пожалуй, самый известный город в мире, в котором сосредоточены финансовые учреждения, многочисленные исторические и культурные достопримечательности, музеи, магазины, театры и многое другое. Это шумный и яркий город небоскребов и свободы, который многим знаком по обилию кинофильмов и фото, где действие разворачивается на его улицах. Здесь столько возможностей, сколько можно вообразить. От Таймс-сквер до самого темного уголка Бронкса &mdash; царство крайностей. От русского анклава в Бруклине на Брайтон-Бич до филиала Южной Америки в Квинсе &mdash; сообщества из любой страны мира.</p>\r\n<p class=\"video\" style=\"text-align: center;\"><iframe src=\"https://www.youtube.com/embed/TmDKbUrSYxQ\" width=\"560\" height=\"315\" frameborder=\"0\" allowfullscreen=\"allowfullscreen\"></iframe></p>\r\n<h3 style=\"text-align: center;\">Основные моменты</h3>\r\n<p>Две главные достопримечательности, давно ставшие символами Нью-Йорка &ndash; это его легендарные небоскребы (например, Эмпайр Стейт Билдинг) и Статуя Свободы. Величественные здания можно осмотреть и при пешей прогулке, а вот до другого объекта можно добраться только на пароме с Нижнего Манхеттена.</p>\r\n<div class=\"table\">\r\n<div class=\"table__row\">\r\n<div class=\"table__cell\">Практически все самые известные достопримечательности сосредоточены на Манхеттене. Здесь находятся известные на весь мир Уолт-стрит, где кипит финансовая жизнь всей Америки, Бродвей с многочисленными театрами, Центральный вокзал, самая дорогая улица &ndash; Пятая Авеню с шикарными магазинами и ресторанами, Рокфеллер-центр, около которого каждое Рождество устанавливают огромную ель, Музейная миля со всемирно известными музеями. Но самым посещаемым местом является Таймс Сквер. Здесь всегда многолюдно и в разгар рабочего дня, и ночью, когда включается впечатляющая неоновая подсветка.</div>\r\n<div class=\"table__cell\"><img src=\"../files/uploads/architecture-buildings-car-1634275.jpg\" width=\"800\" height=\"533\" /></div>\r\n</div>\r\n</div>\r\n<p>Непременно стоит заглянуть и в другие районы города. Хотя бы для того, чтобы почувствовать их атмосферу, в каждом из них можно найти много интересного. Так, например, Бронксе имеется зоопарк и ботанический сад.</p>\r\n<p>В каждом округе Нью-Йорка есть свои парки и скверы, но самым известным, несомненно, является огромный Центральный парк в сердце Манхеттена. Это искусственно созданный уголок природы посреди серого бетонного мегаполиса.</p>\r\n<p>Нью-Йорк уже давно приобрел славу одного из самых дорогих городов в мире. Поэтому проживание, еда, покупки и передвижение по городу обойдется в немалую сумму. Но все же здесь стоит побывать хотя бы раз в жизни. Кто-то влюбляется в Нью-Йорк с первого взгляда, кто-то начинает ненавидеть этот мегаполис с безумным ритмом жизни. В любом случае равнодушно относиться к этому городу невозможно.</p>\r\n<h3 style=\"text-align: center;\">Достопримечательности Нью-Йорка</h3>\r\n<div class=\"table\">\r\n<div class=\"table__row\">\r\n<div class=\"table__cell table__cell--col-3\">\r\n<figure><img src=\"../files/uploads/okay_mankhetten.jpg\" alt=\"Манхеттен\" width=\"380\" height=\"380\" />\r\n<figcaption>Манхэттен &ndash; самый маленький и при этом наиболее популярный среди туристов район...</figcaption>\r\n</figure>\r\n</div>\r\n<div class=\"table__cell table__cell--col-3\">\r\n<figure><img src=\"../files/uploads/okay_statuya_svobody.JPG\" alt=\"Статуя Свободы\" width=\"380\" height=\"380\" />\r\n<figcaption>Статуя Свободы &mdash; одна из самых знаменитых скульптур в мире, это символ Нью-Йорка ...</figcaption>\r\n</figure>\r\n</div>\r\n<div class=\"table__cell table__cell--col-3\">\r\n<figure><img src=\"../files/uploads/okay_bruklin.jpg\" alt=\"Бруклин\" width=\"380\" height=\"380\" />\r\n<figcaption>Бруклин &mdash; второй по популярности район в Нью-Йорке после Манхэттена, в котором проживает 2,5...</figcaption>\r\n</figure>\r\n</div>\r\n<div class=\"table__cell table__cell--col-3\">\r\n<figure><img src=\"../files/uploads/okay_pyatoe_avenyu.jpg\" alt=\"Пятая авеню\" width=\"380\" height=\"380\" />\r\n<figcaption>Пятая авеню &mdash; улица в самом центре Манхеттен, которая также представляет собой яркий символ...</figcaption>\r\n</figure>\r\n</div>\r\n<div class=\"table__cell table__cell--col-3\">\r\n<figure><img src=\"../files/uploads/okay_broadway.jpg\" alt=\"Бродвей\" width=\"380\" height=\"380\" />\r\n<figcaption>Бродвей &ndash; это не только главная улица Нью-Йорка, а возможно и всех Соединенных Штатов, это еще и...</figcaption>\r\n</figure>\r\n</div>\r\n<div class=\"table__cell table__cell--col-3\">\r\n<figure><img src=\"../files/uploads/okay_uoll_strit.jpg\" alt=\"Уолл Стрит\" width=\"380\" height=\"380\" />\r\n<figcaption>Уолл-стрит &mdash; небольшая узкая улица в нижней части Манхэттена, ведущая от Бродвея к побережью...</figcaption>\r\n</figure>\r\n</div>\r\n</div>\r\n</div>\r\n<h3 style=\"text-align: center;\">Музеи Нью-Йорка</h3>\r\n<div class=\"table\">\r\n<div class=\"table__row\">\r\n<div class=\"table__cell\"><img src=\"../files/uploads/okay_museum.jpg\" alt=\"Музеи нью Йорка\" width=\"1024\" height=\"500\" /></div>\r\n<div class=\"table__cell\">\r\n<p>Пожалуй, вся оставшаяся жизнь ушла бы у вас на посещение 120 музеев Нью-Йорка. Ниже приводится далеко не полный их перечень.</p>\r\n<ol>\r\n<li>Художественный музей Метрополитен.</li>\r\n<li>Музей современного искусства.</li>\r\n<li>Музей Гуггенхайма.</li>\r\n<li>Музей американского искусства Уитни.</li>\r\n<li>Американский музей естествознания.</li>\r\n<li>Музей города Нью-Йорка.</li>\r\n<li>Национальный музей американских индейцев.</li>\r\n</ol>\r\n</div>\r\n</div>\r\n</div>\r\n<h3 style=\"text-align: center;\">Остров Манхэттен</h3>\r\n<p>Этот остров длиной 21 км и шириной 3 км содержит почти все, что бы вам хотелось посмотреть. Четыре других городских района: Бруклин, Куинс, Стейтен-Айленд и Бронкс (все большей частью жилые) &mdash; по-своему неповторимы, но для местных жителей и приезжих Нью-Йорк &mdash; это Манхэттен.</p>\r\n<p><strong>Мидтаун.</strong> Вполне возможно, что ваша гостиница окажется в Мидтауне, откуда легко добраться пешком до любого лежащего окрест места. Нью-Йорк отличает еще то, что он замечательно подходит для пеших прогулок по своим широким тротуарам. В любом случае начинать надо от центра.</p>\r\n<p><strong>Рокфеллеровский центр</strong>. Это скопление вознесшихся вверх башен из индианского известняка между Пятой и Шестой авеню, от 48-й до 51-й улицы составляет сердцевину Нью-Йорка. Джон Д. Рокфеллер-младший арендовал данный участок земли у Колумбийского университета в 1928 г., чтобы спасти его от дурной славы притона для питейных заведений в пору действия сухого закона. Они вскоре исчезли, уступив место первым небоскребам, где размещались правления компаний и центр радиовещания, которые соединялись с подземным залом, где находилось свыше 200 магазинов и ресторанов.</p>\r\n<p><strong>Пятая авеню</strong>. Этот проспект, по меньшей мере отрезок между 34-й улицей и Центральным парком, стал олицетворением роскоши, которой можно вкусить или полюбоваться. Если ваши средства не позволяют остановиться в гостинице &laquo;Плаза&raquo;, можно насладиться не столь вызывающей роскошью усеянных бриллиантами витрин ювелирных магазинов Тиффани, либо Картье, либо Ван-Клефа и Арпельса. Они просто восхитительны, особенно под Рождество.</p>\r\n<blockquote>\r\n<p>Порой я устаю от прогулок по прекрасным улицам Лос-Анджелеса. Я понимаю, что это звучит ненормально, но у меня возникает желание съездить в Нью-Йорк и понаблюдать за страданиями людей.</p>\r\n<cite>Донна Саммер</cite></blockquote>\r\n<p><span style=\"font-size: 10pt;\">*Материалы для оформления этой статьи были частично взяты с ресурса <em>wikiway.com</em></span></p>'),
(1,	5,	'OkayCMS 3.0',	'OkayCMS 3.0',	'OkayCMS 3.0',	'Достопримечательности Нью-Йорка \r\n \r\n \r\n \r\n  \r\n Манхэттен &ndash; самый маленький и при этом наиболее популярный среди туристов район... \r\n \r\n \r\n \r\n  \r\n Статуя Свободы &mdash; одна из самых знаменитых скульптур в мире, это символ Нью-Йорка ... \r\n \r\n \r\n \r\n  \r\n Бруклин &mdash; второй по популярности район в Нью-Йорке после Манхэттена, в котором проживает 2,5... \r\n \r\n \r\n \r\n  \r\n Пятая авеню &mdash; улица в самом центре Манхеттен, которая также представляет собой яркий символ... \r\n \r\n \r\n \r\n  \r\n Бродвей &ndash; э',	'<p>Наша команда достаточно долго работала над новой версией OkayCMS 3.0.0 Изменения включенные в новую версию, существенно расширили функциональные возможности. Было внедрено множество глобальных изменений с полностью переработанным ядром и полностью обновленным программным кодом. Мы надеемся вы оцените нашу работу и новые возможности системы;</p>',	'<h3 style=\"text-align: center;\">Вышла новая версия OKAY CMS 3</h3>\r\n<p>Наша команда достаточно долго работала над новой версией OkayCMS 3.0.0 Изменения включенные в новую версию, существенно расширили функциональные возможности.</p>\r\n<p>Было внедрено множество глобальных изменений с полностью переработанным ядром и полностью обновленным программным кодом. Мы надеемся вы оцените нашу работу и новые возможности системы</p>\r\n<div class=\"table\">\r\n<div class=\"table__row\">\r\n<div class=\"table__cell\">\r\n<h5>1. Новый дизайн</h5>\r\n<figure><img src=\"../files/uploads/article_okay_design.jpg\" alt=\"\" width=\"800\" height=\"800\" />\r\n<figcaption>Новый дизайн разработан по всем требованиям юзабилити для интернет-магазинов</figcaption>\r\n</figure>\r\n</div>\r\n<div class=\"table__cell\">\r\n<h5>2. Раздел обучения</h5>\r\n<figure><img src=\"../files/uploads/article_okay_learning%20(1).jpg\" alt=\"Okaycms Learning\" width=\"800\" height=\"800\" />\r\n<figcaption>Новый раздел обучение, где собраны инструкции для базовых работ на сайте.</figcaption>\r\n</figure>\r\n</div>\r\n<div class=\"table__cell\">\r\n<h5>2. Модульность</h5>\r\n<figure><img src=\"../files/uploads/article_okay_module.jpg\" alt=\"OkaycmsModules\" width=\"800\" height=\"800\" />\r\n<figcaption>Полностью переработанная структура, появление модульности</figcaption>\r\n</figure>\r\n</div>\r\n<div class=\"table__cell\">\r\n<h5>2. Настройка цветов сайта</h5>\r\n<figure><img src=\"../files/uploads/article_okay_settings.jpg\" alt=\"Okaycms Settings\" width=\"800\" height=\"799\" />\r\n<figcaption>В настройках дизайна появился новый блок, для настройки цветов сайта</figcaption>\r\n</figure>\r\n</div>\r\n</div>\r\n</div>\r\n<h3 style=\"text-align: center;\">Почему мы пошли на такое глобальное изменение?</h3>\r\n<p><strong>Первая</strong>. Основа первой и второй версии OkayCMS была сделана с использованием старого кода. На момент создания нашей системы, в 2015 году код, который использовался ещё был актуальным, но входить в 2020 год с тем что было - нехорошо.</p>\r\n<p><strong>Вторая.</strong> Проблемы с расширением функционала магазина. В силу того что прошлые версии системы были не модульные, когда приходилось глобально расширять функционал - все изменения вносились сразу в ядро и это создавало сложный код. Все последующие доработки в такой проект внедрялись всё сложнее и сложнее. Сейчас, с переходом к модульности эта проблема частично будет решена.</p>\r\n<p><strong>Третья.</strong> Обновления системы. Эта проблема частично вытекает из второй. Когда доработки затрагивали ядро системы, сделать обновление доработанной системы было проблематично. В некоторых случаях более разумно было отказаться от обновлений сильно доработанной системы. Теперь, когда работы будут выполняться отдельно от ядра - обновления системы должны проходить быстрее и безболезненнее.</p>\r\n<p><strong>Четвертая.</strong> Удобство для новых пользователей. Основа успешного развития - это хорошее коммьюнити вокруг продукта. Код прошлых версий был простой, удобный, но всё же специфический, не использующий паттернов и сделанный \"по своему\". Проблема, которая из этого вытекала, новым программистам, которые начинали свое образование с разбирательсв с фреймворками вроде Laravel система казалась сразу непонятной и они не сильно хотели браться делать на ней небольшие доработки. Новая версия системы больше соответсвует основным трендам в мире программирования и должна сделать более простой порог входа для новых программистов, новых веб-студий и т.п. которые решат использовать нашу систему в работе.</p>\r\n<h3 style=\"text-align: center;\">Как обновиться с прошлых версий OkayCMS до версии 3.*?</h3>\r\n<p>OkayCMS 3 - это система с полностью переработанным ядром и полностью обновленным программным кодом, поэтому шаблоны и модули с прошлых версий несовместимы.</p>\r\n<p>Все владельцы лицензий Pro версии OkayCMS могут заказать перенос своих данных на новую версию или же, в случае большого количества доработок и индивидуальных шаблонов - остаться на версии 2.* которую мы будем продолжать поддерживать и на которую мы будем выпускать обновления, содержащие фиксы замечаний, о которых нам будет известно. Перенос данных на версию 3.* с предыдущих версий займет 1 час времени техподдержки.</p>\r\n<p>В случае переноса данных на новую версию мы перенесем на версию 3.* все ваши товары, категории, бренды, страницы, записи блога, заказы и зарегистрированных покупателей. После переноса вы получите сайт со всем функционалом версии OkayCMS 3.* дизайном версии 3.* и содержимым базы данных с вашего сайта на предыдущей версии OkayCMS. Для заказа обновления до 3.0 напишите нам на почту info@okay-cms.com или обратитесь в тех.поддержку из админ. панели.</p>'),
(1,	6,	'Инструкция по оформлению статей',	'Инструкция по оформлению статей',	'Инструкция по оформлению статей, Статьи',	'Заголовки  \r\n Наличие заголовков  &lt;h1&gt;  &mdash;  &lt;h6&gt;  в статьях важны для SEO оптимизации. Поисковые роботы их сканируют, и на основе ключевой информации в статях, формируют выдачу . Они также отвечают за структуру страницы и ранжируются по приоритету важности. \r\n Заголовок  &lt;h1&gt;  - это всегда название статьи и на странице он должен быть только один. В статьях важные разделы лучше разделяйте заголовками  &lt;h2&gt;  и всегда соблюдайте иерархию вложенности. Не допускайте, чтобы заголовок ',	'<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.</p>',	'<h2><strong>Заголовки</strong></h2>\r\n<p>Наличие заголовков <strong>&lt;h1&gt;</strong> &mdash; <strong>&lt;h6&gt; </strong>в статьях важны для SEO оптимизации. Поисковые роботы их сканируют, и на основе ключевой информации в статях, формируют выдачу . Они также отвечают за структуру страницы и ранжируются по приоритету важности.</p>\r\n<p><img class=\"fn_img_zoom\" src=\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAABK0AAAH/CAYAAACVRy6JAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAKC2SURBVHhe7f3/exzXfd9/+2/BT3t1cyHItleypHmR5scIebuboGQV4DJdq17RMaLcQB1UJFMjRiy38Idwa+azsRFFoFDJggOFgQgbNoTINwp9qNBEHH6JYdGFxNCkLUKJEabxWpZhSyNZzvueMzNn9szs7FfsLgaD5+O6zkVidr7P2cXOC+ecec+bb74pP/3pT+WNN96QH/3oRxQKhUKhUCgUCoVCoVAoFMqOlB//+MdOTvXWW2/Je3Rg9e677woAAAAAAACwU37+85/LT37yEye4eo9KsNQEAAAAAAAAYKf94he/kNdff13eo5peAQAAAAAAAHGh8ipCKwAAAAAAAMQKoRUAAAAAAABih9AKAAAAAAAAsUNoBQAAAAAAgNghtAIAAAAAAEDsEFoBAAAAAAAgdgitAAAAAAAAEDuEVgAAAAAAAIgdQisAAAAAAADEDqEVAAAAAAAAYofQCgAAAAAAALFDaAUAAAAAAIDYIbQCAAAAAABA7BBaAQAAAAAAIHYIrQAAAAAAABA7hFYAAAAAAACIHUIrAAAAAAAAxE5bQ6tf/OIX8sPX35B/+Md/lu+/tkmh7Lry2uY/yf8pvi4///m7Xq0GAAAAAACd0LbQSgVW6ob/jZ/8VN5+5x1vKrC7qLBK1eF7/3Cf4AoAAAAAgA5qW2ilWqe8/uMt7ydgd1PBlarTAAAAAACgM9oWWqlWVrRMQVKoloOqtRUAAAAAAOiMtoVWajwgIEmo0wAAAAAAdA6hFVAn6jQAAAAAAJ1DaAXUiToNAAAAAEDnEFoBdaJOAwAAAADQOYRWQJ2o0wAAAAAAdA6hFVAn6jQAAAAAAJ1DaAXUiToNAAAAAEDnEFoBdaJOAwAAAADQOYRWQJ2o0wAAAAAAdA6hFVAn6jQAAAAAAJ0T+9DqpS98SNI975WRr3oTPJtf/YS8157+3ke+JkQJ6ISWhlbff0G+9Nhj8li18tXr3swAAAAAAOw9uzK0sr71mBz/1ffKr/Q/JmuWNxFos7aEVl/8C1lcXAyWL/+ZPEFoBQAAAADY43ZfaLX5NRk59F5J/+rH5RmaWKGD2hJaRQVT1V4DAAAAAGCP2F2hlfUt+Xz/++yfP2D/HFr/Vz9hT++Ts3/1inz5Dz4sv/ar77V/fr+8/3cfk8vmrD9ck2f+66Dk3v/r8iv2etU87/3go/LlV95yX3/pMelzpkcXNzz7moyon48/Ji85C9l0mHboE1LatS1Zv/io9B96v7v8r/66HLH359I9b1va5mV54j9/RN6bdbfxrw99RD7x5VekeiOyetbt7WeF0vcFvfcvyeeP29PM47FZq5+TX/fmDXTPtOxzbJ/DI+9V18J+XW37I5Py4uvuy3eWH5Pf++C/84/nV977gAx+4bLRjdPbXo99rrwprojz6lzX0PbtNT3zO962Q/u8+VdP2tv+gPxr9Vr42m7TTodWb977G1l8Zlqm1GuPPS5PPH1RXvjOP8k73uvazaUnyrsa2qW0uuvyVTXtSy/I970pjsjtviP/9J0X5OLTT8jjznqmZPqZRfmbe296r3ve+Xu59vxfyNNPPO5s6/EnnpaLL6xL0Xu5ktrH9H154Uvu/kcWY1+vf1VN+6p9dIbiX8vFx915v/SCebRFWX9xQZ6ZnvLWpY7rq3L1nvvqG3f/Wp7/iy/J//SO57GpaXlm8Zr8vXGy3e19SQKr9ffX2A/vvAa3/4688vUvetsO7vM7f3/N3vbT8oSz3945Wa91JgEAAAAgeXZRaPWWrBXU/98nx7/wrfJAxws33nvoN+XQfzgjv/9fxuQ//YffdIKpX+k/bwQbV+W/HzsuH/69P5In5r8iX/rcw87YWOlD/01W1Ep/uCZft6fPq/KZh5x1Hv69afdnu3zju2odoXBFh2m/+qB8/ls6ILH39wsPOtv/18c+7uzP7//OB90w5dCYLP3Qm81f9jflo5+btbfxpHzimAqiIoI5X53r1vv562dkSh+TcVzVQ6uX5DEnILSn26UUGm3KVx/5gDOttO2PyKH//Kzozf5w7pS8t//j8ugX3OM5/RtqPe+T//DUbW+O7YVWP1wac69ZaF6/2+j7h+S/f8k+zulH5TdUcBYIEpu3k6HVO3dfkFkVYkzNyEWnG+FFmZlSoca0fO1bb3hzudww5c/l+atX5apdnv9z9XNzoVXx+ldl2p72+JN/Ll9R2/3Kn8uTaj8en5VL/sJFe5vT9jamZGbxr+xtrsrys0/K4489LrMv3C0L1bT6jkmHQKXjccqLX5EnQ/taHlq9Id/6mtovNd0Mjd6Ruy/MOiFc6bj+Qp7+sxXRNVRuL8vMF/9CvrLsHc+cu57ppZv+8WwrtPr+JffYnX0z5i3a12banmafk8W/so9zdVmeffJx53y/cLfSmQQAAACAZNo1odVHHnEHXv+1j38leuB1L9xIn3hSnFzJcVueOKHCjaMytuJNKvNDeeZ31Dwfks+XEhuXt85SuKOZ4YoOcUIh0w+fld9Rrb0+8DlZNRK27z7hBka//rmrzs8/nPs9J3waeMK/XRax7PWrZfvPy8vepIA61x0ZAillx1UeWn33qY/Z+/U++e3f+V1nXj80uvb/uK2vAue5htXPyWG1zCNf8yZsI7SyVmRMtWj7wMflt/+dOe8PZe7/q8Kxh+QJY8cse3l1fo8/tu5Nad7OhVZvyDfnVYufL8rXXzGCix+8KH+u5vvicilskfty+YI97YkluelNccOVZkKr27L8Rfvnxy/KXxsNfd759nPOmFuPz3/T3jPb7WX5ov3zE899u7yF1ONfk295U4LqPaaIEEiJOH/h0Oqdm0tO4PbFixdlxv7XD43e+KbMq8Doiefk2/XmQG/8tVxU2zPOWfOh1Q/sa6SCqIty8dngvLeXVeurJ+Q5c8e85R//WvSZBAAAAICk2jWh1VDBbUVTsdWMF27kCsEbu5cfe9CZXi20+OojKkBpJrT6gnzZafEU0fpracwJS37tD0Np2cvn5bha9j8+La/aPy79FxW0vF9+43fH3FZLTnlEjh1Q+xQOdTx1rrvp0Grzgvy2arFkr+e7odBIn8//8JS7hbroLpfbDq3ektWJf2///AEZW/lWKGj7Szmt6sf+D8qgfx7tMvRh+bXAtpu3c6HVt+RrTshSCqJcG3JpVoUeF+TyfW+S3JWVGXtaWbjSRGi1cUlm1c8XLou/ekdwfzYuzTrrf/LCVwMDyv+FCrzKQh2t3mNqMrR65xX5utr+tL3+u+68fmj0ra85rayeWApuubryc9ZsaFX864tOK7QLl38QCtr0sT8pF75aOo+Li3/hhIJl1wsAAAAAEm7XhFYqtNj8qtvaKvKpgZUCpvD0zesyo8a0OqLHPdKlidBKdUV0gpJH5Nnw4dZa1gtb3MDsffJr7/938n8dCZf/W77uLhRU57qbC6025csfP2q//iH5f771lrz61MeceXVoFRhjLNJbcut5d0yrQ3rMK13KQqsKxdxfb1/V9qxvfcEJv9zWdisypoK98LH+6q/LobLzaJdP//+cubZj50KrCiGTrSw4eeeafCW03oqhVaWiZ6y4j8Fg5vsvfMlZbmr6KXnqqXB5Vi5vuEsF1XtMzYRW78jdFbVPT8hXrhXVIF9OyzA/tLr+VWd/Sy2fyhW/u+qMafWUP+aVV8pCq0qlQmhVtK/PE/brX1qRu+94reL8efWxTsl02Xm0y7OXJfJUAgAAAEBC7arQqjSeUkTLJi/cODzx194EV7Cl1VX57x9QwcgH5COf+7Jc+d/fl+9///vypSE1rbnugZfteSKDtIZaWlXrvhihjS2tVr3xon7dPo/qcMIhVa2WVrq746/8xpg8sXLDOb/ff/Gc5Oxp5aHVQ/LfzLG25j8rA2q+yNDKG2PLf2pk+Ni8llYH/ps0ciobsStaWr3ydWesp5mVu96EUrhS2pQXGD35FXmx2jhRDba0ulBq7lWHNra08saLevziX7sDwYdDqlotrbzujo9Nz8ny1Zfl3j/+o/zjP67Kl9W0stDqSfnKi8Y5vPqifOVJbz+8+Uqh1SveGFu6S2T42KJazgEAAADA3rXLQitbpScIeuFGMKDRY1r1ydlV+0fdTS0wz6bMnFTzNDumVWlQ9Pc+8jV7bR497pQe4N1TaUyrimN1Ralz3Q2HVv/u4/LbKtQz1lt2/lf+m9Pd7ldU10FvksltOWbMb7P+amLbY1p95Hc+bp8nczD38Lx6TKujMvTlFoZLhp0LrfT4T9OydLPa+E+lMZHMPKZiaBVu5VS2XT2m1QW5/ANvkq3SmFZu6yFnljrUe0yNhlbPysWLarwoY5/DodX9y3JBLau6Dkbsr245FmiJVVyVZ9UyZaFV/d0DZy5edM5TaTD38nnd62dve6XyAPYAAAAAsFfsvtBK2fyajKjBuM2n9Xnhxq/86vv8p9r5Tw/UAYu1LJ9QXcqMJ/U9as/za1n1tL5mQyslqgVYKcz6lfeflP+kxlfyn/BnjMvlh3Dvk0P/4Q/l81/6inzpC/+3/KePPCAfeiy8Xa3OdTcaWql5ez4gp0uPH4w4/7flyf+o9td4euDvDcr7T7jb0MHZvz72qPt0xi/8F/mN975f/rUK2bYRWqkSfApk+bz66YHq+n7wE/aN//ysfP7TZ+TD//a3peKpbMDOhVZSetLe40/Kn39FjXNUetLeV68XRe7/rfyvxWflaTVPYGD27YRW6mF27tMD/Sf8GU8PLD3NTj898DGZmrkoy+qpd3+1LIsXn5HpxYjj89Q8JkejoZUqj8ts6dGG5aGVvCM3l9z99Z8eaG979omvOdvwQ7knn5XlVXUsz8ufP/mETKl920Zo5ezb9Nek9LDHiHn10wPVkxgvLstfXb0qf7W8KBefmZYqpxIAAAAAEml3hlY2Pb6V3yrICzeOF74iT/zuA/JrKrzoeb+8/3cfk8vGrmz+1WMy+P9RIZX9eva4fPh/LMum83S77YRWtsgWYFuyfvFR6T/kbe9Xf12O2Ptz6Z4XtGlb/1ue/a+DcsQfA+r98t5/NyifWymFR+XqWXfjoVW4xVfk+Vf7+wcfkfdm3WXS2Q9I/x8uuV0SrVfky3/wYe/8v09+rf+/yOy3Nt0nNG4rtHLH2CqJPrat/z0vj35EX3+72PuW+8gfS9VTWaedDK2UN+/9jSw+My1TTgDyuDzx9EV54Tv/5LbI2XhRnlFd4p64ICuv+KmIYzuhlQp4/uk7L8jFp59wutQ54y09syh/c+9N73XPO/8k33lxQZ7xx4Cy9+9/PiML3wxsoUzVY3I0EVqFW3xFjWGl9veFi/L0E6q1l73M40/I03/xovyd82JR1u3XvugEaI/J1Bf/Qpa/XZRXvv7kNkMrb4wtX/SxvfNP35EXF56RaW/7at/+5zMLUuNUAgAAAEDixD60qlvFgAlojY7XaQAAAAAA9jBCK6BOhFYAAAAAAHQOoRVQJ0IrAAAAAAA6h9AKqBOhFQAAAAAAnZOc0ApoM+o0AAAAAACdQ2gF1Ik6DQAAAABA5xBaAXWiTgMAAAAA0DmEVkCdqNMAAAAAAHQOoRVQJ+o0AAAAAACdQ2gF1Ik6DQAAAABA5xBaAXWiTgMAAAAA0DmEVkCdqNMAAAAAAHQOoRVQJ+o0AAAAAACd07bQ6oevv+H9D0gGVaf/9m//lkKhUCgUCoVCoVAoFEpEabW2hVYAAAAAAABAswitAAAAAAAAEDuEVgAAAAAAAIgdQisAAAAAAADEDqEVAAAAAAAAYofQCgAAAAAAALFDaAUAAAAAAIDYIbQCAAAAAABA7BBaAQAAAAAAIHYIrQAAAAAAABA7hFYAAAAAAACIHUIrAAAAAAAAxA6hFQAAAAAAAGKH0AoAAAAAAACxQ2gFAAAAAACA2GlbaPW3f/u3FAqFQqFQKBQKhUKhUCiUPVJajdCKQqFQKBQKhUKhUCgUCoWy7dJqbQ2t0BjOGepFXUG9qCuoF3Vl9+GaISmoy7sX12732cvXjPrauEbPWTvOMaFVjHDOUC/qCupFXUG9qCu7D9cMSUFd3r24drvPXr5m1NfGNXrO2nGOCa1ihHOGelFXUC/qCupFXdl9uGZIirjX5df+/gey9tK6XL3x7Y4WtU217Tjjc2j32cvXjPrauEbPWTvOMaFVjHDOUC/qCupFXUG9qCu7D9cMSRHnuqxCo6hAqZMlzsEVn0O7z16+ZtTXxjV6ztpxjgmtYoRzhnpRV1Av6grqRV3ZfbhmSIo41+WdaGEVLmof4orPod1nL18z6mvjGj1n7TjHhFYxwjlDvagrqBd1BfWiruw+XDMkRZzrclSItBMlrvgc2n328jWjvjau0XPWjnNMaBUjnDPUi7qCelFXUC/qyu7DNUNSxLkuRwVIO1Hiis+h3WcvXzPqa+MaPWftOMeEVjHCOUO9qCuoF3UF9aKu7D5cMyRFnOtyVIC0EyWu+BzaffbyNaO+Nq7Rc9aOc0xoFSOcM9SLuoJ6UVdQL+rK7sM1Q1LEuS5HBUg7UeKKz6HdZy9fM+pr4xo9Z+04x4RWMcI5Q72oK6gXdQX1oq7sPlwzJEWc63JUgLQTJa74HNp99vI1S9qxW9bbcvf7G95P7dHoOWvHOY51aPXGT7bkzB+eladmL3pT4ue5r7/gFFVhtmsvf4CgMdQV1Iu6gnpRV3YfrhmSIs51OSpA2okSV3wO7T57+Zq1+9hVfjH+P74guYGTcuKjH3f+3yoqcwh/Frz8d3fkjx9/ytmuSWUTl1evyTPPflXmv/a88/9mNXrO2nGOYxtaqRP/OyN/IF2/fNC54HGlKoKqKOrf7QZXe/kDBI2hrqBe1BXUi7pS29//4B+dP6apL6N//PgXvak7J8nXLHzDrsor9pdzJFOc63JUXdyJElfNXrueA//Wuc9Lgv916YpTdou9/Pu+nceufkcd/MCAU6/V9wT1fUH9rP7fCjqgUiGUFhVa/Z9/LspTs88609W/Kux6/MlZJ69oRqPnrB3nOJahlRlYqYusviTGlQqqWhVc7eUPEDSGuoJ6UVdQL+pKdeq7iP4yqstOB1etuGbqD4PmMemibihb/VfieqnvgerLfnhfOtHyXn3/rPbH0lqvt5oKK9Q2Vd1T50H9q65JnL8bN6PZuqzvF5op9V7HcHgUVQbyQ5HbqKf8hn2vE7XOcKlHJ85H2HY+h9R2TfXsfyfff/WY/9rX/X1T/9fifCzb/d0RdSyNlJ3Uru865ncElV+YIZL+3G4F1RXQDK5U9qCCK51BqO3qwCqcTajpzbS4avScteMcxy602k2Bldaq4KpdbyIkD3UF9aKuoF6trivqd7j+gqputncz86+n4bKT31Nacc2ijilcdurGSoWCavudDM70MVdS6/VWUiGd2pYO7fRf7fU+mDfIu12zddn8nGm0qGXrERUghcvh3zgRuY16ilo2ap3hUo9OnI+w7XwOqe2a6tn/ZvezXVQLK71vZrAe52PZ7u+OqGNppOykVn/XUVR+USmwUtTvMvV6q6jvHSp3CH8uqAyiUmClqMBKvd6oRs9ZO85xrEKr3RhYaa0IrtpxgZFM1BXUi7qCerWyrqiQx/yCqkq9N11xVO0v5js57mYrrpl5HOYNsroRU0GJfn0nrp8+753sdqOPt5Jar7eK+g6sW1aFvw/rlh3tvOGNqvNmeFnr9UbF+XeV+b7YyRJX27l2u/0PGpr6/FTvy3BYEVfbfb+p93vYdqZ1Uqs/a9Q11wFlVGClflafja3+vFZdAM1t1coi1M+qdZZ6rVGNnrN2fJ7HKrSq9qVQF/XLW83X6abRqlKoXxjqYusEs1rpRIXQXhgLnaexb3ivQGRDnvjgZ+QF76ek2F5dqXY+viFn7Dr0m0+19ykU6Jymf3G8+JkanyvqvWW8/sE/k+95r2B3auWXDN1CRn2J1zfYcRgDqlHq9776zmF+KTWLuuHayT+wteKa6WOJCobUcevXdyKc03+57uQ51sdbSa3XW0W/byq1MlPBsHnD0mr6OMNFi3pNlWa18vOn1czgaCdLXMX52iHadq9Z1Ht9O9M6qZX1VX0G6z/uVAqsdL6x3e9AKnRS3QDNroCaDqR0BhH1+v+69A3n9WY+Sxo9Z+34TIhVaBX1hbBW6USTcdWUTg1eZoZStYo5QFq9mrvA35AzgZtJ70aS4Mq46d7Z0Opznz8vX3t+xfupnHpNzdOIZj8MdMBZKZT63lMfrfp6U9R1iEt9jNO+RIhPXQmHve7nypkXvR9tTl0yzqVTd/jc6Zg4fa5EUV/iVKCjv8Cp/7fqL+rtOPYo6oud2mf1maiORx2LDlFUUa9tpwVQK46jFddMH0+t0KqTrZ0UFVSp7bayS0U99PFWUuv1VlHnW21nO62XtkMfZ7hoUa+p0qxm63I9f/De7jk0g6N6Sj3jW9U7jpVZtqOd56mVvzvaqVO/O9otDr87VH0J2860StpxzVpZX/X7qlZgFfV6o9TvRJ0zrN182ZvqUgOtq+mVAqtqr9ej0XPWjs+EWIVW6mLq4KrSxVUXTP0iNwfobGdwpSqFusgqtFLhVbgpnhauEM1UzFZdYG4eba/+mfzmL39UnnhVtRza2dDqT6a/JL/9nz4hf/Hl57wpJSsvrlZ8rZpm64oKGs6MfaZCqxh1rj5qv/5RQqsdEqe6UiZw7lSIpd5f3o+Kes/R2qpj4lxX1O8//XtcUzdDalorWsy049jD1A2iDqx0Uceg9l8HcNsNcVpxHK24Zvr41F+BzRtkdXz6O9lOBCc6tFFf+jtJn49Kar3eKup9pENSdR22G1o0Sh9nuGhRr6nSrGbrsq6j1Yr5WdQM831RT6lnfKt6x7Eyy3a08zw1e+3U54ruQdMJ7fzdoT6vtvs7oV5x+N0RVX8aKfXaDd911PcB9X9VVItk9a+iswr1vmrFdx9Fb8cMntT/dVah/q+Kyi/0PLqFVbP5hNLoOWvVOTbFKrRS1MnUH6zq32onV32A68rfqspgUgGVrgRqpP5KVKXYbmCltOYCu927zBYRzs2md566nCDHm+7N678WuCE1pkfciOoWOeWvV1s2tD27BMORasuGbpK9Y6odrux8aKWovwKoD1bzrwX6w1Z9IP/szbe8qfVptq44odWL7nkO1BGbDjvVv41fF/Pals53oJ7YRW8zON28PsE6UtpHbzsvqjBSLxM1zVahvlfal7iJS10JC9cL53waAaCqW6XX9fvOvJ6ha2HUo/C6UJ+41hX1pc18r5mlVV3MWn3sJvXdIhxY6aJurvQfz1phu8fRimsWdZxmUcfc7Pea7dD1qNPdSvVxV1Lr9e3Qf5VvprQ6WIzahipa1GuqNKtVnz/tYAZHO1niqtlrpz5LVTdY9Xmr1fMe2E5db8fvDt2VVxX1f62dx7LTvzvUvodtZ1o1cf2uo34vqmPR9Vf/ztLXVP2s/t+OjMJkhlaKbnCje32pn9X/t/N7vNFz1o7P89iFVoo6qfUGV3rcDJVmtpr6BaEuerVfFK0KrJTmz1n0jaH2wlNGyKBu6P2bRX1jafICCuMGMnyDqbjhh/2fQOuKWsuGtue0htI/11rWCyjUsfmtqJwXaog6xp1hfujqD9v/+tnPN/ULstm64l+3QD1QSudXnfdS+FDPdVH1rnSO1TYCAYTalvlz4LrbXvxGoA4Egw99nb3tlO1zeFq1+m4L70tMxaGuBJnXosSpC95nTzDoVPMH64Vz7kP1pPwzBI2KX12p/kVdvdYqrTx2Tf0OrxRYqVLrO0kztnMcrbhmUccZLuq4O03Xo061XtB06yY1ZlSY+j6oXmtXl0X93beZ0sr3llJpX7RarzeqVZ8/7aBDo50ucdXstVN1Vt3Hme+1et4D2/08avXvDt0qVBXzDzPtPpad/N2h9j1sO9Nqict3HfX7XwVR+jrr31M6rNS/PzoRVKkgSncT1FmEGu9K0eNvt+r7SqPnrB2f57EMrRR1kvWbvdobWs2n5mnHFwgVQtW64K1ocqe15gKXhwxBZogTEeiEAwWHWqd5w+puo+yGs+ayoe01tKz3f6dVTfnNc2URx7iD9Ifudj5slWbrih8UmNdQMcKdQGhV73Uxr4d5XZXI0CriGoYDJpvaX3dfQvvriJoWFrr+uyS0Una6rvic6xV97s1zGQwz1XkPX+PQ9fLqyRNjjbyfESU2dcWmfg+q0Ef93g7/TtRf5rb7u9LUqmPX1L7p/QyXqGNqlWaPoxXXTB+febOlqGNVN8r6fLTjj4PVdOrLf5j+Y6iqx/pGJHwuOt36y6TOh+52ovaxXXVSU8ettqVKVKuQWq/Xq9m6rG8amyn17q86xlqlnnGsKpV6x7eqRyfOR1iz107f56n3Vae1+neH+vxUnxftfj+G7dTvDnXdwrYzrR47/V1HXVv9/lL/6mnq94H6V5VO/N4yG8yof/U09Rmh/lUlKrTSr6nSqEbP2XbrV5TYhlaKOtHqA7RaaKWoyqGb5rWSvuDVLq6qINttcqe17AKHgwbvplOdJ7fo1yICnYjgoDyYMG5IvRtPZ/6ay6rlovbDVnNZ7ybZXi7YoqOWiGPcYaop63959LPyw2Lz77tm60optPJCBid0CIYJgdCqruti1g2bWSeUqKDIqJN+iKHm8+tGqZRCq9B2IqfZKtZ3W9S+xNhO1hXFbUkV8f5xznF4ulmPot93pRDSFahr2Jadriua/otz1E297kJhdp9ohVYcu6J+j1e64VPfQ9odnjRzHK24ZvoYw6GVpqar19vxPasS1fJCn/edUO3GX30vbcV3vu3S+1hvmNEs81xEbavW6/Vqti7r4KOZUm/9UsdVq9QzjlWlUu/4VvXoxPkIa8Xn0E5o1e+OnbYTvzui6k8jpVk79V3H/H4Q9Tsg/Hq7qEzC7OEVzijM18MPhdMNbVSpNuxRlEbPWTs+E2IdWtVDVRJVQdoZWnXqy0nLzpl5Q+kEAebNo3kzGXFjWTa/EgoHzPWr/5uhVdVlw9tTP3uv1VxW/18t00hwFXGMCdBsXTFDK//8P2WfeyNkKgut6rouzgsus04oah0VgyL3ejr7pOYrC8i0iO1ETSvb39D1r7ovydRsXSmFmhEq1gsztIq6XqH698HP2CU8H3ZKK34HqQejqN/JUV2r9O/rTrfYqYf5hVMXffOn/nLa6dY+9WrFNdPHWym00i2PVOkUHX7uZF1R58MMANT3TDWtU98J1XaqBby6tVU7u0/q8FCVqBuxWq83omXfgdsgKkDaiRJXcb52iLbda6be82HbmdZJzRy7/uNNrcBK/c5o5/cFPV5VrcAqqgeYGqtbLa9KeNlaGj1n7fhM2PWhlf5i045UUyWU6sLr/qHt1tQ5s28egwGOe2Po32yGgoBgy4nQDb0jtLwtfPMaaC0RCChqLRvenppf37DWWtacV62n3uAq6hh3v2bfX8HQSteH8mmlc9vIdfHUCq3sn0vbc9dfCjoqXdeI7URNq1rfbeF92QOaqyu13jfl1yp4rt3Xy+pN6LPCue7h+oId06nf23GkvpCq7xG6qC+g6ounuimPa2CltOKaqd8BqqjAUR2vLuomWZ0XFdboL+OdooOyVrfKa1angiqTvglS/4apa6Ouiyrt3De1brUPajtRoUmt1xsR588fdWxxKHHV7LXTny3tuIfrNHU/2s4AudW2+35T1y1sO9M6qZljV5/D6g9Y4c9b9bP+rO7EH7hUKKUa1VQLrNTr5n6q6eFWV41q9Jy14/N8V4dW6oKoDzpVUdQXq1ZTYZW++I0mks1o6pypGz77+NU50CV40+/eHJZe+zPjZrTSjal3w6lLOJQylym74ay0rBJ6zS7Bfa22bCig0Mdd82a30jHubs2+v8KhlXseg+cnGFopDVwXpUqd8EMKc32BEClcR/S+RWyn4rTS8sH6roT2ZQ9o1eeKW6LPZfRr9s8qJIx4XdVD87qHf8bO6MTvbbRWK65Z6T1auaiby07dkKnvdnpckHZ8t6tF34BUK524yVY3P2ZLL7Vfqqhp+mY/LqFeKzRblztxvaICpGqlnvGt6h3Hyizb0c7z1Oy1U/VXFbVtLS7vv0boY1DFfE/G+Vi2+7tD7XvYdqZ1UjPHrq5TuOWvGVipz+RO/IFLhU+XV695P7nMwEo9QdAMrBT12aFe205w1eg52279irKrQytdUaKSz1bRg7Grf9utE+cMyUBdQb12pq54oZX3E3aHZuqK+h3cirLTovapmdJprXh/64Aoqqgv4urLump51QlqWzqQ0UW1AOskMyiqVDrZ6kwFd+Y+6Wuy3RAjbpqty524XmZwVE+pZ3yresexMst2tPM8NXvtVMCj6rfattaJ69lqutePKmbQHudj2e7vjqhjaaTspGaOXbX+VZ+9Wjiw6tTvSPU5oBrTaOHASnUB1FTjG93oRncrbDa4avScbbd+RdnVoZV6o6vSzmRTXWwVWG23WV09OnHOkAzUFdRrZ+oKodVu1ExdCX8RbbbstKh9aqZ0Gr8LkBRxrsvh8GinSlw1e+10QB23EKoZKqxSIVy7GlG02l7+3dHMsavrquqpqrPqDynq/6ruqp87+d7UuYQqqsWVblyjAiszD1HzqekqrNLU62pao4OwK42es3bUr10dWiUN5wz1oq6gXjtTVwitdqNm6ooZ2Gyn7LSofWqmdBq/C5AUca7L4fBop0pc8Tm0++zla7adY1ddBFXrZFVUi9dOdAmMop4EqFpcqaIa1oTD0qjQajsaPWftqF+EVjHCOUO9qCuoF3UF9aKu7D5cMyRFnOtyVIC0EyWu+BzaffbyNdsrx97MUwIrafScteMcE1rFCOcM9aKuoF7UFdSLurL7cM2QFHGuy1EB0k6UuOJzaPfZy9eM+tq4Rs9ZO84xoVWMcM5QL+oK6kVdQb2oK7sP1wxJEee6HBUg7USJKz6Hdp+9fM2or41r9Jy14xwTWsUI5wz1oq6gXtQV1Iu6svtwzZAUca7LUQHSTpS44nNo99nL14z62rhGz1k7zjGhVYzUOmf/8i//QtmDJQrvL9SLuoJ6UVd2H64ZkiLOdTkqQNqJEld8Du0+e/maUV8b1+g5a8c5JrSKkahzFhViUPZu0Xh/oV7UFdSLurL7cM2QFHGuy2svrUeGSJ0sah/iis+h3WcvXzPqa+MaPWftOMeEVjFinrOowEKVX/ziF5Q9VKLqgCq8v1Av6grqRV3ZfbhmSIo41+XX/v4HkUFSJ4vah7jic2j32cvXjPrauEbPWTvOMaFVjKhzFg4nSgHGv8i77/5C3rX/T9lDxb7m6tqHQ6wbN244/wK18FmMelFXdh+uGZIi7nVZhUY70eJKbTPOgZXC59Dus5evGfW1cY2es3acY0KrGNFBhBlWvfPOz+W1116TV155xTmnlL1XvvOd7zh1wAyvzLoCVKPqEFAP6sruwzVDUlCXdy+u3e6zl68Z9bVxjZ6zdpxjQqsY0UGEG0y4Lat+8IMfOIHVz372M28u7DU/+clP5Pbt205wpVteXb9+3Q+wdHhFoUQVM+DcCwXN4/f27sM1Q1JQl3cvrt3us5evGfW1cY2es3ac47aGVpT6i7qxVEWFEdev2/96/79586YTWmBve/vtt2VtbU2uXbsm13Qdcf51i64/FAqlVKI+aykUCoVCoVAoFEr7SqvR0iomdCsB1XLGGbvq3Xfl5z//OecRft1QN+HvvPOOUy9+/nO3fqh6oopudUWh7OWi3yvhAgAAAKD9CK0SSt9YuTde/+IMwK0CCRVQcB73LvOmWxXVosqyLHn77Xfk7Xfs+vHzd+3yc/m5CjhVeGXXGwplT5cKDy7QBQAAAED7EFollL6hUjdZ7o3Xu05gpcIJdR6/f+81yh4r33t1wy93v3/PKd/61ppsbGzIyy+/7NQLCoVSXqIeXEBwBQAAALSf+j7eaoRWMVAKrcxWVj8Xy3rbOY9RoQYl2SUYWG3Ine/dcwZjZ1B+oLqoBxeYwRUAAACA9iC0SiB9I6WKOZaVamX1lmURWu3BUhZYqX+/96rTgoRB+YHa1IMLvv3tbzufp+oPAQRXAAAAQPsRWiWQvokKdw1UrazefOstQqs9WMzQSrWwUoHVHbvwngLqp94vpYcVBLsJAgAAAGg9QqsEqhhavf22/OxNQqu9VqJaWanA6rt3v897CmiAer/op23S2goAAABoP0KrBIoOrX7udA0ktNp7JdDKyusWqAKr23cIrYBGqPeL6matgqtSN0FCKwAAAKBdCK0SKBxameNZEVrtvVIKrcxWVq/K3333e7yngAao94vqZq3+CGC2tiK0AgAAANqD0CqBqoVWbxJa7amiAytVzLGsVCurW9+9y3sKaIB6v6jPUfV5ao5tpT9zCa4AAACA1kp8aPU7I38gXb98cFvlxEc/7q2teZ3cj2qh1c9+9iah1R4qpVZWwa6BqpXVK7fvEFoBDVDvF/UwC7e1FV0EAQAAgHZLfGgVFf40U7Yrap3NlHoQWlF0qRha3fmevPx3hFZAI9T7RXWxVg+1ILQCAAAA2m/PhFbNOviBgW0tr213PxpZntCKokt0aPWq0zWQ0ApojA6t1GepGteK0AoAAABoL0KrGgitKHEuD/xWvzx08qORr6kSDq3M8ax2bWi1tS6LhSHp25+RdFeXdKmS6pZsX17OzlyVDcubDwizVmQ0o+rMsCx4kxphhlb+uFaEVgAAAEDb7MnQ6hX7Zj03cNIZI+rqjW97U6O1O7T6X5eueP+rrtLyUdoVWj3zn9198Mt/Xoicj9K5ogKr97znPZLN7ot8vVpopd4Huy202rw8IcfSXlBVoaQOj8ryprcA4NuUheGMV0+aD63UwywIrQAAAIDO2JOhlQqr9HQVSlXT7tBKTVMBmgoQqqm0fJT2hFYL8ruBkOqqfPbfE1zFoVQLrqqGVre+u6tCK2utILmUF06lj8jpmStyu+g2q7KKL8nixAnJ6OAqV5A1WlxBszZkfiQrKa9+bKullf0ZSmgFAAAAdMaeDK10EKWKCoyq6URopctTsxe9qeUqLR+lPaFVebn8R/+R0ComRQdX/+pf/avA9LiEVm/8ZMt5gqYqzdmU2XzKDRxSOSlEJlKWrBVyXjCRkv7p6kEw9gZr45JMHEt7YRWhFQAAALCb7MnQSnUJVGGUanE1/7Wve1NLzFZPnQytVFEh2t//4B+9V0v06/XoTGi1IL9r78/vPmtMe/YPjGP5j/LZvw7O67/mB11eay09/d//iVzW6/KKE4xFvl5t2dD27HL0j64ayxn75u2z+3roNbs424/YrziWqOAqLqHVHz/+Rec81wqJK7pZkKNe4HBw4po3MYK1LGd6vGAiPytFbzL2IGtDLhUelKxunZfKyrHcPkIrAAAAYBfZk6FVNaq1U8+Bfytn/vCs83OnQytV1PbDY23p1+rRvtDKDIOC4Y4qz/yREe6oMMgPe9RyfyDP6NecUt69MCogUuNoOcHYX/+JHPVfq7VsaHtqWf9nI5hyppvHER1o7ZbQ6g8/9WhZN8E4hFYqBFZ1Wp3LWmPIVXJvut8LG/bJ+Ko3MdJNKRz1QoqjBfunCFZRXlosyKmBXsl2e623VElnpHfglBQW12XLm9W0MOzNV6kMmzGIJRtXZ2QssI20ZPb3yVBhUdajNuBYkOHwequUo4XII3QCm6szYzLQm5Vuv0tlRvb3DVU8vsC5iypqsPveARmbq7S8siXr9rkd6tsvGT32mF6u4iD5xnYD59Bmrcn0Q4f8Ywi/XM3NwlFv31OSfbAgl+yNl6YRWgEAAAC7wZ4LrVQ3JdXqI2oAdB1Y6aBKtcTaqdAq3AJMv1aP9oVWZikPjoLFDI4iQqtAkKRLKDTytlEWWtVcNiK0CgRe9nzPhgMr4zV/Hfa2/8hcNr5FB1aqldVL31n3p+90aKXeb3oMufH/8QVvauM2lj4rj+T7JNs9Uj1sqNXSanNZRg8bQVVkSUl2ZEHCY7nXHVpZt2R20Bw/KaJkTsjU9chobNuhlXVrVgaz1Y8xc2JKyjdfI7QySsY+1rKx7jcvR3TDCxY1SP5SWXJVKbSyZHXc/owxlm8otJr8LckNFWTRSAgJrQAAAIDdZU+FVuoGWrWg0tPMYEgFVvrGWs2n/tXzqbJdldZjbkMVdYO/O7oH2iUcHjk/m8ejX4sIrQItsXQJh1ZqOe9nM3iquawbOJXvh57PnV7qMmi+5q7DeVKiCuQCgVc8y++N/OfIwEqVnQ6tdLdAFf6q91V7Bce0OnkhHFndkel+PS7WYRmZuyH39S5t3Zf1lYKcyOiAJCNjL3qvefzQqlILLof5hLqUZAfPy5XbRXvPbPY2bsydliN+C6ScTJatqBRaVWxFVW2eTfs1fQyprAyeLw1Wv3X/hsydPiJpb9lUbjJ0HFVaPMmW3F9fkcIJfWwHJdBL01qTQq7UouzYpxblhndyreJtWTG76WVGZClwaSps98609DvLHJWJyICvcYRWAAAAwO6yZ0IrdcOsBoFW/1c30rr1hwqrwoGVZgZX21VpPXq6al2l9qPSjX2l5aPsSGjldKUzwyEzqKoQWoWnhUMrc/1meFRz2fD2jPDLn88NtoLBlffaHxnrN7cbw6IDK9UlMBxYqbKToVUrugXWZ0vuv3pDFj91zAhkIp4eeG1CDjqvpyQ/W9ZOyOXPUx4I1RNaWSuj/hMMj05cj+xGZz4FMZWfDbVY2k5oZcnKqA6VKgU9wWAveB6qhVaee9PS7207N/myN1HlS/3eOntkcG7DDelCNheG/XNzcHzVmCd6u9cm7M88e1rPmeXI9TWD0AoAAADYXfZMaGUGVpoOrlRRLbCiAiP9+nZVWo+aplqhRHVXNDWyH20JrZ79g4iAx94n3T0w1PrJHUBdB0cRoVV4ebs4yxg/q9ZO/jYD4VGtZcPb00FV+P/h4Mpbrz3NH2A+5qGVCqsqBVaq7FRopd5LatB1dS630y2wulJ4Y5Z9g3NyKyLluPelj8n+/VnpTg/LQsUUZEVGve6FqZElb5qrdmhl2fN4rY16zshylaRFBzJdXcdlKvCQw22EVpY93QvDqgc912TioDtf1/EpKW2+jtDqzpQc97adn9XNpYzlAusLK8qFk1HnJ2K7xQty0jmWUIuubSK0AgAAAHaXPRNaqWIGVoruulQpsFL0sttVaT2qi2KlbZsa2Y+2hFYqvPH2QZfIEMt/7U+M4CgqtNLTjXWGQylzmbLwqNKyEa/ZJRhM6dDKLvq4nOXd7QaOq2y7u6u0K7RSIbAqlepuZ7oFRodWqnvakdPzkcFVbZWDm9qh1aqM73PnSdnLVt382jnp9fZ3cN6ccxuh1eq47HOmp2S4cirnWDvX6yzf1TUopc1XC60sKd5ekXHdBTB1Uvzel8VZyTvrqrbPLmt+0Ntur5xb8yaGt7t1V+a8LpaRY2dtA6EVAAAAsLvsmdAqHFjpLoHVAitFL79d211PI8u3JbSi7MrSrtBKt6JS/4bfP6orYGe6BZZYxdfkxsp5OX2kNBB4ZBfBELXcq6/ekJWLM1L45MMycKi7NIB6w6FVPYGTx5qXwch5txFaLQy7+9d1VGpvXodH5rxGeFStpHIyftmIkm4W5Kj3WlnWFWaEdaV5o7b7S3LkU0sVnjbYPEIrAAAAYHfZM6GVqd7ASolavhnbXU8jyxNaUXRpV2il3jdRwZU5vX3dAquwNmTeGAi9bDB2+/WrM2cl35eVbj0weKXSztCq4rydCa2i560ztLJL5sR0KRBsJLSKnNfY7sEPysMPeE9eTB+TCTMcawFCKwAAAGB32TOhVVRRrUFU96VqRc+7XeZ2t1PqQWhF0aVdoZUSFVx1pltgDUYw0jU4X+qmF3jCnS5pyezfL335R+Ts+efkyu1vyjmzq5phT7W0ikifnNZsMyf9wdQzoyvuuW1lSytnojFYfOQTFptHaAUAAADsLokPrfRN9XaKGrtnuzq5H4RWFF3aGVopZnClgqr2dAvckG/+z7Py8MAh6T45K6G2UxFKoU4pYDKfrJeWY59alBv3o0K10kDsjYdWDYxp5Y8/tTNjWq2O73OWr39MK82S5TM97jypEXGGqm9gTKvibN7bbpUxrbxpk17AmMpNVjjfjSO0AgAAAHaXxIdWexGhFUWXdodWihlcqdL6boFGUNJlr3+1eiAj1ybkoDOv+QRAI4z60Ezlwb2Np+M1Hlo18/TAcKuobYRWzTw9MHAs9YRWZvCj991Yrt6nB6aGjSc4Rm/XWhn1WnVFdPNsEqEVAAAAsLsQWiUQoRVFl06EVooKrk589ONOaUu3wDvT0q/HoMoMy0Kl1CnQBbBHzvjJ0ZKM6OXzlVprbcqCPx6WXRoOrcygpUuOTlyXqDNhrRUk5+1Lqn86FPJsI7QSszXZUZm4Hrn1Ute7rpT0T5tbry+08ltp6ZZWtjvT/d46e2RwbiMyMNtcGC7vWuiotN1Nmc171/LguNTKKutBaAUAAADsLoRWCURoRdGlU6FV+5lhi10yJ2Ri8Yb4Pfy27sv6lZnA0wMzwwtGiyqjlU9XRk4UVuR20UtBIpZ1ShOhVTD4Skl28LxcuV10Axp7OzfmTsuRtLeeVE4Koccbbl2f8MeHys9Wal1UJdjatF/L6PVnZfD8Ff84t+7fkLnTRyTtLVv+dMXqoZUzptXciBzWgdvJC6XwLxAWBrtfWsXbslJ4ULIVQ8fK27VWx71Wc+GArTmEVgAAAMDuQmiVQIRWFF2SE1oplqxNG+FHxZKWI2NLshHMg8Ram5RjOjCKLCpkmpEnR7yuiKFwqr7QymbdktlB7wl4lUroyXj+unVJ9UvljKZ6ayzr1qwMZnWAFF3Sxyak/MF8RnhUq0S1dtu8LBPHQsFfqKSygzJ7K3RhqoZlRtjYY29zm70ECa0AAACA3YXQKoEIrSi6JCu0clkbV2XmbF769mf8VkPuUwD7JH92Rq7crdw90dq4JFOnBqQ3UwpX0pleGThVkMV1d7nihZNe4HRcpozgqO7QymHJxtUZGRvolYwflNn72Dsgp6ZWJLyLSyOlkCmd6ZOx5bJEyVBHF0JrQ67OjMlAr3GO0hnpHTglUyt3I7st1g6tUtKdtc/V2Jx4pyrClqwvFmSoLyvdOlxMdUu2Ly9n514S3bgtqHoLLzGeTnhw4po3sTmEVgAAAMDuQmiVQIRWFF2SGFoBO4XQCgAAAOgsQqsEqie0wt5AXQBah9AKAAAA6CxCqwQiqIBGXQBah9AKAAAA6CxCqwQiqIBGXQBah9AKAAAA6CxCqwQiqIBGXQBah9AKAAAA6KxdF1pRapcbN2445fr163Ld/vfatWvyN39zVb75N38jq6t/7cyDvYHQCmgd9X5Rn6Hqs1R9pqrPVvUZqz5r9eeu/hymUCgUCoVCoVAorSmtRkurHUZQAY26ALSOer/Q0goAAADoHEKrBCKogEZdAFqH0AoAAADoLEKrBCKogEZdAFqH0AoAAADoLEKrBCKogEZdAFqH0AoAAADoLEKrBCKogEZdAFqH0AoAAADoLEKrBCKogEZdAFqH0AoAAADoLEKrBCKo2Dvy+byMjIx4P5VLXl3YkvXFgpwa6JVMuku6ulRJSXe2VwbG5uSlouXNhyTbWp+Ts/k+yXanvDqQlsz+PhmauiQbbawChFYAAABAZxFaJVC7g4rvPfVR6frlg6XywT+T73mvobNUYPWe97xH3ve+93lTgtpdFzrKWpPpExkvpKhQ0sdk4vKmtwCSx5K1yWOSjrr2XkllR2ShTVWA0AoAAADoLEKrBGpfUPENORMVUr34GTnzovd/dFy14Kp9daHTirI0ogOrlBwemZErt4viNKqxinJ7pSAnMl5wkcrLLLlVIhWXRiTj1YHsgwVZ0XVg677cmBuRwykvuMpNyk1nidYitAIAAAA6i9AqgdoVVLwwdlC6xr7h/YQ40cFVT0+PN8XVrrrQcXem5LgTVnTJ0XNrblARdmda+r3Q4uDENW8ikuOOTB33Qqn8rETlkpsLw16o1SOjK97EFiK0AgAAADqL0CqB2hJUvPpn8pu//FF54lXv5zIb8sQHjS6DXvnNpzbs11QLrc/IC7qlllPC6wotH2jNpZc3vPgZYx61bGh9an+rva6p9QSCOHMfD+6qFmRRwVVb6sIOuFk46oQVXalhWag4ZlFRZvNuqNHVPy33vKlIiHvT0l8zkFqV8X1uHThaaH1bK0IrAAAAoLMIrRKoLUFFICSqTo155YZVmg6CjOBJrc//2QusjPDIGTfL316nQit3P0r7rrZbYbkYKhQKZd0E21IXdsDNC5+UfF9Wuk/OStGbVs4IrfLR822tL0phqE/2Z9LufKqkM9I7cEqmLm2Ut+C6WZCjer6oMrzgzWizNuTS1CkZ6M34Yy6lurPSN1SQxfUtb6aQWus3SqUQJnJQ8t4BGZu5GjkouR8ARhX7XOzvOy1zlfbX1vT2jhaCXfY2L8vEB71zFX4typXPygf223Ug1S/TFRPJm1I46h4LoRUAAACw+xFaJVBbgopth1bh8McNiJyWTE4rrlAoFQiaOhRaRRyj6hIZPJZ40oGVamX1+uuve1OTE1rVw1orSM7rHnh86o43Vas9gLcaJylXCHU9rDO0sm7NymBWhzgRJZWVwdlbjYdiRikPYTbl8kT1Y0ofm5DwuPRVQytd7P0dWwnv7Ta3FwimirIw3FNatp7Qqh7Wggx7daC/crLVNEIrAAAAoLMIrRKoLUFFZLAULTq0Kl/WD4QiAzEzaDICLk+wJZb7ut+1UJdqr+vXwqGVOY9X4h5affrTn44MrJS21IWYsYqvyY3FCX8g9lR2TMJ5i7Uy6g/gfXhkTm7c1y2JtuT+jTkZOewFTqmTcsFsouWHSkelYsOd4pKM6EHg08fkU4s3xF29JcWXFuVTx3SrroyMLIXaf9Vcf+WWQzcnc5Jylk1JdvB8aWD6rbty5fygZCsMSl6x5ZNVlNfsczF80F2u6/iUmNFfS7enxyjLDLf0SX+lQO64lOWWLUBoBQAAAHQWoVUCtSeocIOfegKchltaOWFRtZZWNic0M4Ik+7VgKNVISyvjWMKhlb/M7qADK9UlMBxYKe2pC/EQ1WKop/9cWUsf1arnwkk3lKo0gHdpoPd9Mr7qTVPqCK2uTdh1Us2TyklhrawtlYi1JoWcF4odnJDAEPHNhlbFC3LSC4kywws1BiVPyUkjiasYWnms+UH39a5h8Ts/tnh7+pyVt4hrntnS7qB9ESOuxLYRWgEAAACdRWiVQG0LKnRwZIw95XjxM2WtoMpDq+BykS2lwq+Ht2MKBEwtCq28/awnmIsLFVZVCqyUttWFGIgKrdT4SgeGZuVWILG4Ip/9wH5nDKb8bNRIV8qCDHvrMIepaiRU6jmzXDEosS4/Kvuc9TQaikWHVtbCsNfqqVqLok2Z+ZC7rDnGV63Qqjibd19PjciSN62l2yva57pHrT/Uqm0brLVJOZZ2t53KFSQqO2wFQisAAACgswitEqi9QYUXMHktnpwSCpeiQ6vPyAsqIPKXC7es8oItXWq1eGo4tDLWba4/EFopof2os0tkXLW3LsSE061tUSYezHrBSuXWQL6t+/Lqq+ty5bkZKXwyL33GwOwNhVbWvAx6yw3OV0tKlmTEawUUGGupydBq7VyvM62r95ysedOivDyZc+frGRX9wL3KoZXqKjkjJ72ujmYI17Ltbd2VueGM83OrWkNtXS+UAqvDo7Jc9cJvD6EVAAAA0FmEVgkUv6DCC628n9A58asL7bQllx896AYkXT1yZjkYiZQ/9S66NBRa+a/3yrlqaU6F8KnZ0Gph2J3WNThfPfhZGHbnM7r6RbdQC5ZUbjzQzbK12/slyX3mUvVQsS6WbCyNymF/LK3gPrcDoRUAAADQWYRWCRS/oILQaqfEry60WXFW8l440jOq2/qY4y25JZ3ZL70DD8sjnyzIzMUVuXF/rrnugQkNrVQ3y2OTpScptmR7+x6WPyoMuiFTKisj2xqBfUuuF0pPMsycmG5bl0AToRUAAADQWYRWCRS/oILQaqfEry40444snH1YBnozcqLmwN2lsam6dPpkDiJ+ckZeKkalG02OaVV398DS+gPjajUZWtXbXa8UGI2LHkrLnxYxppVVvC0rhRNewJeRUe8xjK3cnrU6LgfVz5UGrq9pU5ZHD5eeZDgyLxsdCKwUQisAAACgswitEigZQQVaIRl1ofT0v67MqHg5SjT/KYBd0qubPvmtf/rFHE4qYHXcGyi9TQOxL5+RHmc9nRyI/Y5MHXeXbWQgdnO5fd7OtnZ7lqyMuuNaVd6HSszAKi3HCtdly3ulEwitAAAAgM4itEqgZAQVaIWk1AVrZdTv3ld5kPVNWfAG+e7qOigT17zJfmhVIXCxNmRusMebp9HQSuTahDeOVqWWQ9aaFHJe6HZwQvRuOfz1VwrUKnQrNFuPVTgfpS6RKTlpPKavdmh1T6b73XX7XSxbvb3NWck760tJ/3St1nMlm7N5v4VVrlDqvtgphFYAAABAZxFaJVBSggpsX3LqQlGWRnQglZLsgwVZuV30Qgv11LvQ0wNHlvyWPmbrKzVYt7+cVZTbV2bk9JHSkwNVaTS0kuKSjHhP3OtKH5HTczfkvtP8x5LiS4vyqWN6/Rl73WbcY8nGjA5hSmNABVUIrWw3J3N+gBM4H1t35cr5Qcl6IVMqVwiM91QttFLdA6+cPxkdPrV4e/70HvvYS5upzAjOfunDT8i3Xn1VXq1W3IvQUoRWAAAAQGcRWiVQcoIKbFei6oK1IfMjpWAquqTk8OhSaIwjS1bP6i5lUSUtR8ZmZMLr2pabfNlbzlZPaGWzbs3KYLbKUwlTWXlwOmJgc12OT0l0e6PKoZVqWXZ5ojQYeVRJHxmT5VCzKD8sqlHC4dO2txcOyawVGfXCvoPjq/65qaTe/fZLIH1sDUIrAAAAoLMIrRIoUUEFtiV5dcGSjaszMjbQK9nuUkikngbYN1SQxZd066uwLVmfG3MGc9ehS6o76y6z7rbI8bv5mQFSnaGVY+uurEwNSV+22w/I0pleGTg1JSt3g61+SqFVSrpzp2X+VqXIplpopajWXHPO+cikvXWmuiXbl5ezcy9J1Jjz1cOftGT298nQ1KUKg5tvY3sRLbv87n6pfqnVS7As6KtVCK0AAACAXY/QKoGSF1SgWdQFoHUIrQAAAIDOIrRKIIIKaNQFoHUIrYA4WZDhNrasBAAA8UBolUAEFdCoC0DrEFqFbcndK89K4ZN56duflW5voHxVVJfd3oFTUliM7jYKbN92Qytj+YhCDgYAQDwQWiUQQQU06gLQOoRWJRtLn5CcMa5c1ZI+JhOXQyP0A9tGaAUAwF5AaJVABBXQqAtA6xBalVjLZ6THu7lPdR+SgYfPyvmLF+WiV86fzYdCrYwMLxBcoZW2G1rdkW8YdVaVP314n19nCa0AAIgHQqsEIqiARl0AWofQymAty9gDp2Wu4hM7lU25PJ7zn6bZ1XNGlukqiJbZbmhVzny6KqEVAADxQGiVQAQV0KgLQOsQWjVjU2bzusVVj4yueJOBbSO0AgBgLyC0SiCCCmjUBaB1CK2aUzsIsKT40qIUTg1I7/6MpL15u7rSktnfJ/mzc/JStdHcbxbkqL9MjRKxA9bGVZk5m5e+bHepVVg6I/v78nJ2rp6B5NfkXK+xjRrlaOGmt1wUSzauzsjZfJ9kje6VamD7vvzZGi3bbAvDgW2VF/ecDhUWZX3LW6aKrXXvumTS/jpS3VlnkP2plbtSdRXGdal6zMUlGcl4+5c5I8t17JerPLRy9neoT/Yb+5vO9MrA2Ixc3ajdzI/QCgCA+CG0SiCCCmjUBaB1CK2aszquxwkqb2m1tT4np4+UAoaKJXVYRpcrjInVdGi1KZcnjhkhWXRJZR+UqevVkpTqA3qHS8UAZ/OyTByrdS5Skn1wSiruTs3QyiiZYak4zJh1S2YHs6UQr0JJHxmTpUphUF2h1aa9yxl3famcFNZqB0slZmg1U/taVqtDHkIrAADih9AqgQgqoFEXgNYhtGqctVaQXMoLDQ5OyDVvumatjstBJyRISfehAXn47PnSwNjnz0o+Z7R+SuVlNipzMMKRfQ//aWBg7bLyjTveQkZY4qy7W3L50mDyM4VTMnDACJCqBiql8OTo78+Ub1OVP31Y9ul5ogKcTXsdurWRXVLdOcn752LGae10IG28nitI5O74odU+efhPQ/ugyvkxeSBbasGVOvG03PMW9VlrUsgZg+inD8jAqYLMeOsoG2S/UvhVR2i1OZv3rm9K+qf1tamXEVqlUt560nJgYKz0UABVh8xQ1L6Ok1UafRFaAQAQP4RWCURQAY26ALQOoVW0O9/wAoJAOS9n8znp1oFV+phMRqYsRVn67JjMVeyrZslaoTSY+8GJcOxlq7cbmmFzftB/+mFX5qTM3oraty1ZnzkpGX++UVmJzK1K4UnFoKPqPm7K/GCPuw27ZE7OSvTurMvMyVLQlhldKe8q6IdWR6XiqbBWZfygu46urmF77032+T5XCm5SuXG5HBVIWRtyyRhkP9U/LWWRU43rYgaaGfvEVW8DFcUIrVRJ5eRcZBO04AMBes4sV+xiSWgFAED8EFolEEEFNOoC0DqEVtEWho3gIKL8m/4/kpU6xhOqbFXG93nry03Ky95UX8Oh1TWZ0KFNjZY3KsRZHT/oH8vxqYjWQPempd97vanQ6tqE19pMhUSTUn13zMDpuJTtTj2hla10zfpl2mxqVbwgJ3XQmBmRpaI3PVJwkP0z4UdDVjtmszVXze1UYoZWKclHNsPzWMtypsebt2dUKj0PgNAKAID4IbRKIIIKaNQFoHUIraLVCq1USR85XaU1VS03pXDUW9fRQnmo02hotXZOer35q7W68ZlBTv90eXc6Y/vNhFZr53rddUcFPxGKF076rYb6A4mTra7QalNmPuQuHw5wrPlBb/kKAV2YEbj1hAcsq3jMRhDY8DhWJiO06jkjtU5dxaDOQGgFAED8EFolEEHF3pHP52VkZMT7qRx1AWgdQqtGWFJ8bV2uzJyWI3ospkoBhbUhV2fOSr5vv2SMcZuiS7g7m63R0MoYrHxwvp7A5GWZzHnbT43IkjfV52+/V86tedPCquxjKUwZlPp2Z1Jy3rpSI6G9qRFabd2/IYuf0gOWl48jVQptqhxLwJKM6EAv3ArOOObAWGN/rLtcpiRXvZlbDUZoFdUCL6QUDlYO9AitAACIH0KrBGpXUPHC2EHp+uVg+c2nNrxXsRNUYPWe97xH3ve+93lTgtpVF4C9iNCqOdbGjOR1sHF8Kjj2kbUmkzWfmGeW7YdWzQQTpWApYvsro974WFVaN1XcR6MVWdS6IxlhTfgAjECuakll5cGp6xJu+1Y6zurdC0uqtIIzjjmy5D4v696szalyHiKUrjuhFQAAuwmhVQK1K6hQoRUhVfxUC67aVRd2zNa6LBaGpC9beqJYqjsrvQPVBnLGrqAGdp4yr21aMr0DMja3XnZjvVMIrZplyfyg+34Nd826NuF1E1Pv5ewDcqoQ9fS9P5WH9ZhWcWxp5a+vSkupKvvYnpZWtUv6wENSCI2y3q6WVtElJbnCWu3umRURWgEAsBcQWiVQu4IKQqv40sFVT0+PN8XVrrqwIzYXZMR4VHs6s1/278+Wnk7WlZZjk9u5AcKOCbS2SUl31r62RjCZOTEd/Xj/DiO0apYZWpmBgTHA+sFxWa14jWu0Rmo0tDLmr29Mq1nJe/NHjWn18mTOfa3KAN/V9rEUlNQ5ptVs3pu/2phW++ThPw2Hf245fzYf6LJp9tCz7OX1+66uMa1Wx2WfN3/dY1rZn+XDGW/7dn0414oxrQitAABILEKrBGpXUFFPaPW9pz5a6j74wT+T73nTRTbkiQ+WuhWWv/ZReeJV78cXP2N0PQy9ZnO2EVgeSlRw1a660Hk3ZdJ70lTq8EiwVVXg0esHZbzynS9iyRiUOTMs88ZT5rbWZ+Skc3NbPvbOTiC0MmxuSpVntQVtzpa6B3blZdZ/UlydoYN1WR5tZUur0NMDqw8EXuvpgUW5cNIL06MGadeq7WPg6YGF6gFti54eaF1+1A+bAvsTeHqgfa6rXuTmnx5orRUkV/d2KiG0AgBgLyC0SqB2BRVRY1qdedF70aPmcaa9+mfym36w5AVWY99wflKCwZMRTKnlftkMqaIDLUKrcoVCoaybYLvqQqdZy2fcMWNS9g1v5M1N6WlYZX/tR7xZ9o2nc/Ma3crEb1VSx0DL7UZopblBjfNEwJeKVVsqba3PycjhUgvJnuEFe2nNaGnVMyjzUe9ta0PmhzP+8q0JrewjWBj2xqGyS+akzN6KOootuT51whs0XM03Kivh2e5MS78XvhycuOZNjFB1H4uyMNzjbsMumZOzEr0712XqROlcZOzPurLZmgitwp+ZZnCTyo1LqAehy74uS6OHS920+6eDY5UpNa7Lpr2v+tzWDOsiEVoBALAXEFolULuCirKWVk6AFA6YIkIrJ4j6jLyg/u8zwyjv/y+GAyvFnO8bckYFZU+ZgRgUHVipVlavv/66NzU5odXKqHtDl7LvIird1/hPhoq407A2rsrM2XxgLKyuVLdk+4aksFg+ZpJ541JWjPVvrS9KYahPst3eTbm3zqlLG5H7WXW9fom+oXKOYWxAejO6G121MZ/M7lShks7IfnsfZ65HjxTV0DH5N6WhIGFzQU4fcs91zRBhfUY+1rtfMtkKXav0TXhmTEIZeccRWnm++7gcc667W1Ldh2Tg4U9KYabUBW2m8EnJ54z3m5ovO1LWoibwnkgfkfzZ84FubDmnHqYk5bfUak1opYLuhZGssX9pOZI/K+f9/T8lAweMAeJDLbKKa8/LxZmCDPqB3EGpllnV3MdQ9+fguZiRwqkBOWA8WbFiyOOHVnV2D7TP7ckLpRjRER4cP5WVB04VZMZY3r0u3uuVWkrVvC6WrBV0K9kuydifrZF/k6iI0AoAgL2A0CqB2hVUlHcPNEIqhwqVvIDJDK1UuFUWMoVDK7flVnn3w9J8Tksv1Vor0IoLn/70pyMDK6VddaGz/kGe/6O89O3PyIPh8Vs0+ybrnBfShFs7BLqhqABmf3gsrPLBgPWNixrkfb8zv1E++XV7Dvtma9pogaGCIPs1P+ix15kdKb8Bq7pef5/Kb6g2l0flcPgY/PCqS9LHJkM3sDq08saH8reR8R51r9YT7hbVxDFFhla6u5S77Q8/sZ32UaWuWamTF4wWOjuD0KpEtaA6HQqlKhe77jw4JZE5qf3enTZaD5UXt97NVHt6X1OhlbIplwsPStb/LIguqeyDMh1KiHSQrktmZKl6/axnHzcvS+FBM0iLKupcVhnjzQ+t6iuZE08Hn/inWbdk/vSR0udFhZI+MibLlZKmuq7Lpr3L+vo3OjA7oRUAAHsBoVUCtSuoqBlamS2qwqFVPS2tXnVbUpVvw37tKWMdhFY+HVipLoHhwEppV12IDasor62vSEHf9Jb9xb80ds3RRy+JMVySveyGLJ1xA5HwE8H0jUulGy1rddwbgyYtxybM9VqysaQDJvsGzBzh2FZ9vTpoCt1Q+eMB2TergzNiDue1dX1KTngDGgdvmiusS7GPe27Qa7lmPHmsqWOKCq28acFuYI3bun9D5vRNc81xhzqD0Krc1t0r8qxqVdVnBpzqmnVLtndAHj47I1fuRrfqK9mS9bmz9jqMMNlr4adbQpaesNfK0Mrlt8Q0Q12vRWJh8SUpRlQ9f3/s/cydno/uzmeqex/t99vVGTmb7wsG05n90jdUkMUa3THrCa3cJ66eimxlGua0vDw1IL0RT2yduXK3+vL1HrO1JgVvzMKurowM1z3AFaEVAAB7AaFVArUrqIjuHlgKowKvB4IlN9wqG9PK/9kMsMLBlbes6hZohmOEVg4VVlUKrJR21YWdZ9yseOWXcp+RS+F7nW99Xh5QN6I9ZyTyoVz+U8GCNzHVw6XSwMuVgpnN2bx7gxfabjOh1bUJL1g7WohsEVEKm8xBmauEVratuY+56/Tvypo8pojQyt3fHml6aDHjRtcp/yYvT71U69a6MwitAAAAgM4itEqgdgUVTve8XzaL2VJK/Wy0pioLltwwyl828JoZWtnUsv487roDYRmhVd3aVRd23tflk16Xt4wxzkvVriqRdPjVQGhlzcugs8w+GV/1ppVZkdEeNU8wvGk8tFqTc73useVLj1wLuSfT/e48pcffVwmttq7LOa9Vg9+VstljCodW1rKcUfMcnJBqw/tUtTImB5wujUarm/QRGWvswrYFoRUAAADQWYRWCZTcoAKN2ht1YUvurhT8bnLVnkJlFV+TV1+9IStqYONPmgOzNxBaRbQuKhcVJNVYb2TQFB2qhenxdUpPAdPrCo9pVQqCAuNgNXtM5nJWUb45oY4vZb9e9hyx5myty9yI94SyVE5CvS07jtAKAAAA6CxCqwTaG0EF6rGX6kKpm1xKhheM1EoFH2MDcsgcb0eXdNobw6bVoZUaWsbdhrmOdoVWer2l7n56XVVK+phM6tSq2WPyl9Pl30j+qZdqjpPTmDsyddxdf/jR/J1GaAUAAAB0FqFVAu2loALVJaMu3JQLqlVU5v1Vuq4pqzK+LxSqmAP8pjPSO/CwPOI8Rn5Fbrx6X7YqhEKtbGlldutrd0urff4JilqXyyrelpVx7zHzmVFZUblVs8fkL3dcPn3xvIyox/+nsjI4e6uBJ4DV5ody/dP2XuwcQisAAACgswitEigZQQVaIRl1odTS5uD4apUwpDy0ujfd74YdZU8V9PhjOTUQWlkLMux0sasy/pMe22nbY1qVWkxVHtOqdH7qGtNKCe9fs8cUDrs27fU43TQz9jz1xVbffSov+1U3zfxsxacNrp3rtddpr3dwvqVhWKMIrQAAAIDOIrRKoGQEFWiFpNSF4oWT/rhGhQoDVlkro5JxApRSqOI/lr7Cs8v9J+I1Elo18qS91LCYPRUbD60aeXpgVNhVIbTyA76UjCypn5s8pogWWpvzg9Kjph0cl9V6EiZ7//c56zCffmiw7H09qF7vkuORM3QOoRUAAADQWYRWCZSUoALbl5y6cFMmdTe/zAmZ+mbRaHGjBmKfkGPeUwRVix3dqMrvVtaTl5lbRoJiFeWluRE5rJ9O11BoZQZFaTk2cUk2/FVbsrE06q03JbnAyOGWzA+622sktJLNWcl768sOzsi6MWDU1vUpfwD6zMiSETZVC63sfZwf9gK+ftGNs5o6pshuhXdkut+9VpXOX1Bp/lRuXC6VNizWxiUpnMg4r3VlRmSpUlOsDiG0AgAAADqL0CqBkhNUYLsSVRc2l2VUjZnkhCRdks64T8TLeGGVM+1YQa6bo4D73dVU0U/SM5+gd1qGnXBHtzhy1QqtVJCzNn3CC37sks44+5L1B3tPSXZkwQvPXpYnPmxv139SYY+cWTYCNF/loGlzWYdGdkl1S1Y9CTCT9rYVehKgQ68r/PTA0D6OrdhHojVyTJ5KY2Hp6al+qetBgvZ1GsmWtuPss3++7JI5IdOVHgnZQYRWAAAAQGcRWiVQooIKbEvi6oK1IVdnxmSgN+M99c8uzgDrp6SwuB751DrVWmdqqK8UbqnQp2/In391fJ8zvefMsh/g1A6tXFvrc3I231cKdux1H7L3ZerShhEG6QDJ3de+seVg8OOr1jrKO45TA9Lrh1VpyfTl5exc1HEb2ywr9nK9AzIWuVy9x+SpFFrZc66Mui2kzJZvVW2ty2JhSPr8sEqFV30yVFgMtC7bSYRWAAAAQGcRWiVQ4oIKNI26ALQOoRUAAADQWYRWCURQAY26ALQOoRUAAADQWYRWCVQtqHjzzbc4j3tItbpAaAU0htAKAAAA6CxCqwSqGlQQWu0pVesCoRXQEEIrAAAAoLMIrRIoHFS8++678s47P/dDq+985zv2Ddfb3txIsnBdMEOrf/7nH/KeAhpAaAUAAAB0FqFVAoWDCje0ekest992QquNjQ25ffs2wdUeEK4LOrT6P//8z3Lr1t/xngIaQGgFAAAAdBahVQKFgwo/tLLeljffesu56VLBlTqflGSXGzduOOX69ety3f732rVr8jd/c1Wu2T+/8sotZx4A9VHvF0IrAAAAoHPacc9KaLXD9M2TKu++64ZWZrcw1drqpz/9mfxk66fy4zd+Iq//+A2n/Oj1Hzul+KPXKQkpPyz+yP/3h/a///zDovyff7aL/S/dA4HGEFoBAAAAnUVolVD6BuoXv/gXv1uYGtfKbG21tfVTP7jS4dWPXn9DXlfFC7Iou7v86EcqhPSCyNd/7IZXRTe8+ud/LvKeAhpAaAUAAAB0FqFVQpVCq2AXQd3a6s233KfHqRZXW16rqzd+suUUHWJRdn9RwZX+93XvXzfIUq2vXuc9BTSA0AoAAADoLEKrhDJDq2BrKzO4esvpKqjDKzfA+iklQeUnW1tu8QLJN5zg6ifyox+7wRXvKaB+hFYAAABAZxFaJZgZXJljW+ngSnUV1OGV0/JKBVh2edMLsijJKD+1i2pNt2X/qwIs3ZpOdQPlPQXUj9AKAAAA6CxCqwQzQyvd2soMrtQYVzq8st52AyxKsoobSKow8k35mf2v05puyxuE/8eEVkAjCK0AAACAziK0Sriy4Eq1uDLCq1KAVQqxKMkpTiDpFSfEUuGV0/Lqp06XQd5TQP0IrQAAAIDOIrRKOH0jVQqujFZXqrz7rl90iEVJTtGB5Ntvvy1v2/9aTnD1lvz0TdVV8Ke8p4AGEFoBAAAAnUVotQeYwZUqgfBKt7yiJLL8XIWRdnnHvrl+2y6qG+ibb7rjl23tutDKko1LU3JqoFcy6S7p6rJLqluyfUMydWnDfhW7web8oPTY1+5o4aY3ZfcgtAIAAAA6i9BqDzGDK7OUQixK0orZis4Jrt52uwqqca7U+Fa75z1lyVohJykVVHWlJdOXl0ceeUQeHjgk3Sk1LSW5whrBVdzdnJScc70IrQAAAADURmi1B5mBFSXZxQyvnBZXThfB3RdaWavjctBpWZWTc9e3vKkua63gBSEHZXyV2Cq2rDUp5FJuCzlCKwAAAAB1ILTa48yAg5K8Uim0Ujfd6uZ7d7ynLFkYdsOO41N3vGlBq+P7nNd7Rle8KYgXS9bOHbWvUUZGRvKEVgAAAADqQmgFJJgZXjljXDldBN/ZZaHVPXnu0wPSm8nJuTVvUsjNggpEuqRreMGbornjYA317S+Ng6W6F/YOyNjcugTbbC3IsPN6eSkFLFuyPjcmA70ZSTuvpaQ72ydDU5dko6yR100pHC1fV7AclbLsxtqQS1ND0pftLnWHjNxf28JwaH1eSWekd+CsLJXvlL36SzI11CfZbq/VkzPvmMytl63dXr1aX3AfN5fHJOcsG7HvFVgro5Kxt3VwfFUsb58JrQAAAADUQmgFJFgyQqtaNmU27wYw/dP3vGmKMQ5W+oAMPPxI+ThYk2Zw4oVWPTn5mD2fmleXzz5nr9e6JbMnM852SuvLewFOl6RyBVkLZEQ6tOqR3MeC61PlgwfVa0eDwc/mZRn3utClunOSV/M+PCAHvMAtM7xgH63BC4B6ch8z1p2Xvkzamd6VGZUVY582L497XSlT0p3T44Id8AK4jAwvBNZeHlpZKzKaUevtk4cf+ayo01LTpn1e1TJHz7nnh9AKAAAAQJ0IrYAES3potXX/hsyNHHaCqVR2LBDQyJ0pOe4EN8MSymLEWjsnR9Vr+8Zl1Zvmh1ZHCxIVp9ycdAOwVO6cBIbVMsKszOiKMRi8Dq2M0MdQ3oqpKEsj3nqG54Mtt/wwKyX900YXyYoBUCnIy88W3UnFJRlR4ZEKp+aDT1v0w6xUvwRXH9zH4oWT9jnokTPL5tLVbNrrsI8plZOCTvQIrQAAAADUidAKSLCkhlZ+d0BdDp2S5ze8Fz3ffSov+zPpCuGI7go4bP9PqxZarchoj5o/OoCS4gU56bRgyovOiBoOre5NS7/afo+9T/46DNcm3MHozaCtSgCkz5F+7d50v/Nzz/CCRK/+oPP6vnEjxgvso3c8ByfkmvNqbXfsbabCLdoIrQAAAADUidAKSLCkhlb3nvus2xUu31caqypzQqaD/fN8W/dflVdvrMjFi+flrOo+548XVWdo9fKk5NRrveckelgtS+YH1fpSMrLkTWo0tFoacfdpcD7QCqpkTc71qmVyMvmyN6lSAGS9IlP9bsus4QV3bUsjbsurwfkKraTWzkmv2n5uUkqr1/u4JXefGZSecEuvKvRTHVP52cgujYRWAAAAAGohtAISLKmhVYC1IfOqC5oKXMrGcCrIQwe88Z38ogY2P+AMDF53aLUyKj3qtYqBUukJhn53vAZDK90SqrfSaPNSlNm8Wmaf+I2hvAAoOKbVwzLgHXP62OPesdyT6X61bG/FweylOCt5dYxGSy53H0sl99kb5YPBR7HWpKC6M/YMynyoayahFQAAAIB6EVoBCbYnQivFWpYzTve9Uksn/cS6rlRWHjhVkJnnrsj6q69J0UmdGuwe2EBoVWrJ1K7QygievAAouqSk+7cm5LITGjUQWhmtydx97JXPPL8ihRMqGCwfrD3SzYI7Zlg9peyJj/FFaAUAAAB0FqEVkGCJCK3+4Xn5o3yfZA+MSuXxv3VA1CVuBqIDni750ExUyNJgaFWze6DeXju7B67K+D61TB3dA7fuysq4N3D8yQvOGFY1uweujss+tf3I7oH2D/rJgSl7+xHHE3DvOfnsI7rlV6h80B07y28d9tRVb6H4I7QCOqn0ub6bwm0AANBahFZAgiUitJI7MnVc3bhUGU/JHwhdd52rHhhZy2fcllMtH4i9X6bvedMaDa3qHYi9Z9TeG0+1rnbWvAwax1jvQOw9o/7ay/axaG9PnbeycaoaQffAxNq6e0WeLXxS8n37JdvthqROSWdkf++AnCosyktuU0egDq0LrbbWV+T82bz07c9IWtdL1VV8f58MUS8BAIg1QisgwZIRWpld/XIyfmkj2BLJuiWzJ90xrVK5SS9wKrW0OnpuLTC/tTEvw6rFkHPTUm9oZd8+TXotl3Ln5Lo5sJOx/czIkhEINRha2UsujXjrGZ6XDXOnNy/LuBojqqv+J/FZq+PBpw0Wl2TEOe6MDM8Hz+Hm5XFn0PRwK6ryfdTHlJFRc/CwRhBaJdC6zOSz3sMNapRUVh6cul7f2GjY41oQWm1dl6kH66ib6SMyttx0FA8AANqI0ApIsKSEViKWrE2f8AZPT0l3Lu92LTOeHpjKjog53FJxaaRs/ocHDjh/ZU8f+5T8vtN6ywxkqodWZjjVlT4gAw+r7m55yXktSlK5cX/8qOc+q/btiPsX/dSI+D0GDeWBkM0Pp+z1deckr47x4QE54B1j5uSs3DKzIi8ACg7Ero7zkHQ7Lb+CIZcfTkWcExVEnZy9FQizovbRDxArnadaCK0SyW2pl5ZMX17Onr8oz11Zl1dffdUp61eek/NjD0jWqXtu/QuEr0CkbYZWb7wonz6sW/ypz7whKcysyA2zXp72PqdVSfVLnQ9HBQAAHURoBSRYckIr19b6nIwN9PpBlfskwAE5NXUp2DLJYcnGpYI8dKjb+yu7fdNyaEDGZq4685Y/7a9GaOXYkvW5MRno1V1M7HVm+2QosP3SjZYKnir99T4ytFKsDbk0NSR9Wb3f7jGOza2Xt07xAqDy4h1rxDLWxiWZGuordd9KZ6R3YEzm1svbvkTv4x2Z7lfL9shwZD/GGgitkql4S166W739VKCVo9nNFYi0/ZZWblBfHsibNucHve7iXbLPfzQrAACIC0IrIMGSFloBO4nQavt0WBx4oIBBjYs1c/ZhGejNeq0FVXHD4fzZOYnIVj1GwFG1lAfF1sZVmRkbkF4/KFaBc1b68mdl5mqoO3IZL+yup1QLXrbWZbEwFBxzyQmUT0lhMSKw9tU67mrBftDW+qIUhvpkfybtL5/O9MrAqYIsVj7x9i7op4VGhPC+TZnNe0F55owsV883PeHQakvWFwsy1Le/9IeLVLdk+4aqniPLfr9Wpx9yYZf8bOSYfwAAYOcQWgEJRmgFtA6h1XYZwUVZS6tNWR4zumpVKuljMrkWFUI0E1ptyfWpB41ui1ElJdkHpyVyk47thlaWbCyNyRG/9Wh0SR8Zk+hGm/Ued5ekDo/JSlQiY23IUs1zn5YjY8vRD2CoGVpZslZwxwRU4+YVKp/MEOPYBs/J9Amve3Zksa/TyEKTD4gwtkNoBQBA7BBaAQlGaAW0DqFVs7bk/voVmRk57Hd5PfF0ePAgS1ZGVShRPvbQqzdWgmMPHZyQa95SJaXgofczL/rjaZWX18R9UJwRpNhFdeU9fb60zRsr5+X0kVKLo9JDHkL8wKZXPvNieFuqzMjHvHVEhVabC8Pe2Ht2SR+QhyaelSvr7rLrV56VCXMQ8cyILJUlKtWPO7yO8m65m7IwXAqD0gcekolnr8i6s/y6XHl2Qh7M6nGhwg+b8NQIray1c97rPTI430isVB7IpbIPVtm/Kk+YraY4K3lv/XQPBAAgfgitgAQjtAJah9CqDn6AEV2ccGi+wvhCm5dlMfx0UMPmbN4LX3pktGxArFLAUdd4acZ+lj0R1Lcl18/pYKtCIOKvJ7q7Y6AlVji0Ktqv9XivZYZlPrL/niUb86VgK2MfeHCuOo7buiyP6u5voX0oLgz74zmVPbVUszZk3g+2Ip4cWi202rSP0RvHLGNvu7GWUMHQKpUrRLd4M7bhPy21bpasjquHCKjlD8pEeRoKAAB2GKEVkGCEVkDrEFrVoY7QamjqcnPduKx5GfTWUx7QNBZarYz2uPtU84lxRnAS1cLLP95hier8Vy20ujfd706PCoICirIwrPf3pFwINHWq57hLYzb1BNK+ezLd707vyoxK9V0oBWypkxeCra0qhlabMj/o7nfFwKkqM7Q6LlNVrtOdqePefJXCwyihQDCqFRkAANhxhFZAghFaAa1DaFUHqyivGd3TdLmxMiOFoVIXv5qtbrbul63D7Gq3vdDKGHh7cL5iyy6tOJt3540KRFZGvZZKjYZWRZnNe9N7z8maN7Wi1XHZ56wnJSNL3jRH9eO2ii/J4h+UxpOaNGcxusX1nqu5B6VB9FMjEtyFqNAqOI5VYLt1M0Kr3KRUzaL86xDVCi9KMLBqLlQDAACdQGgFJBihFdA6hFbbVxrDKSUng02GbJtyeWpI+oyn11Uq2wutSkFS7XltfmDUJaHGUvaqht19KhtYXqsUWhmBTNlKIxgBU3CfjfVUK5kTUrgcigmNVnH17YIO70Itqqq2rmt0HCtTA+eooWOxZG36hB9YpY9NElgBABBjhFZAghFaAa1DaNUKa3Ku1wsi+qflnjdVtTxaGqn2dLhgiUto5Qc5Rwv2HkSJSWjlDHAfegJhR0KrZsay0toRWlmyNnms1OLvRLUnQwIAgDggtAISjNAKaB1Cq1Ywgggz6Lk2IQf9IKEgK+v3pXxs9GphUyOhldE9MD9bcxyj0thT5d0DbxaO1lhPpdDK6B5Yz+Dhfve3yt0Do5+aeENWzp+WI2l3nlT/tPhDQzX41LzSOGCVugeaT1Bclzlj8PbhhWZiq1aHVubA+nY9OzkrtwisAACIPUIrIMEIrYDWIbSqzLLPSV02ZyWf8oIIo6WVNT/oTuvql+lS86uQVoVWrRqI3ZKF4ZTzWuXQp1Jo1cmB2O3TPvMhb1vm+W3zQOzWmhRy7vlR41oVGm7S1MrQalMuj5eeBJkdabb1FwAA6DRCKyDBCK2A1iG0quSaTBw5Iqfn1iNaRxm2rkvhmB6vKiX9Zlqkx4bqOigTZY/oU4yBve2y3dBKbk5KzgvPUrlzcj1yx4NBR2B/FSPIyc9Waq9VObSS4pKMZLzXMsMyvxEV6lhya/Zk6Ql3oyv2FFOjoVUwWCoujZTWPTwv0btwS2ZPllpNlQVslUIrZdM+fuMYG2tw1arQalOWRw/71/Hw6DKBFQAAuwihFZBghFZA6xBaRSsuDHtd17ok1Z2T/NnzcnHlht9Fbf3Kc3J+bEAOeF3UVCkb/Pre03JCt8DK9MnYzBVZ95a/sXJexh7I+oGVKtsOrUIhWFf6iJw+vyI3vK5tV54tyNCR0oDwmZMXSt3q1JMN16/IeR3klLV+MlUJrWylgenVerLy4MSzcmU9+rhTh8/KalmoVDruyt0DR+SwPrdlA8ZvyoLfjc/eRvZBmXhWn3u17Jg8kPVaS6nA5+xqKDSzVQutbNbqeKnrp30O6g+MWhBaWRsybxzfoU8syctl5yhYXitGJXcAAGCnEFoBCUZoBbQOoVUF1oZcKjwUCKUql7QcOT0fMZZQ8IluUSUzXJBHKwZTjYZWitrmg5LVgU5kSUl2MDj20cuTucA8B8cjghxf9dBK2Vwe88ecqlTSxyYk/PA/lxHs1CyVxpbalOWxI/7g5NElLccmLkcHTjVCK+c8+wFhSnKFtSrny7T90Cp8reop9dcfAADQCYRWQIIRWgGtQ2hVw9Z9ubFYkE/m+2R/trvUiinVLdn9fZI/OyNX7lbtQChb63MyNtArGT/ESUumd0DGnK6H1YKpZkIrl7VxVWbO5qXP2OdUd1b68mdl5upGWcDiD75uH1cuMoAz1Q6tHFvrslg4JQO9mVJ4lM5I78ApKSxW63ZZO7RKZ/ZL31BBFtdrnftFKZwakN5MqYVZOtMrA6dqLFsztFLMFl31Dsy+/dDKv1YNFEIrAADihdAKSDBCK6B1CK0AAACAziK0AhKM0ApoHUIrAAAAoLMIrYAES1RopcbNmRoyuvCkpPuQ7jaEjirOSj7UpaZUqnUR2t0IrQAAAIDOIrQCEiw5oVVpPJT0kSEpzFyUizP66V6NDOyLllgdl332tcj0PSyPPPJIqHxWnrvnzZcwhFYAAABAZxFaAQmWlNCqeOGk07qq7HHp1poUcupx7Adl4po3DW1XnM3b57xHRoPPzk88QisAAACgswitgARLRmh1T6b7Vbez4zJ1x5tksOYHnRZYPPGpc1ZGe+xz3i/TCW1RVQmhFQAAANBZhFZAgiUjtLoh5z/UK5ncOVnzpgQsDDuhVU+g2Y8lG5emZKhvf/mj8+dvBboSVnokuh+CbV6XmdN9ku1WLbrs19IZ6RuakksboQ6JxiPXo8uwhB/avnl9Rk73ZaU75c6TzvTJ0NQlCa66wiPtU91yaOCsLIX3w7olfznxUOmx9c58YzIXfmS9d97Mx8NvLpyWA+p8HS3YW63ECxF7RmWPNbQitAIAAAA6jNAKSLBkhFbVWHL50X2ixrU6eaHoTRO58/QJSXd1Serwh+Xs+Yty8eJFOX82L0ecACsjoyuloEeHVsc/7c6ny/Nr9vo2F2Q4o4KfrDxwqiAzaj1jD0hWhUyZEzK9ZgRGOrQ6/unAelT59HG13WBotbkwLBm1j9kH5FRhxp7vvIw9kHW7QZ6YltKqdWh1XD7tr3NGCkNHnGMMBEx+d8m0HMmflfP2vDOFIfe4U4dldNnoXBkOrYr2sfbY2z75x3Lx+TUpnc2wFRm15+vKfVL+ZGxADnlhnhu4XQ5230wYQisAAACgswitgARLcmhlFV+TGzMn3eAnVzBCnm/J5x/ISLrnjCyHGyFdftQZQDw1suRNKYVWZosjV1EunFSBTMZ+LRjFbNnrOajW0z8tfo9FHVqVr0gWhlXoZIRWxQty0gm+7GmBVW/J5UcP2vOmpH9ar1mHVuGWWpa9XrV/paf1XZtwlw0PTG9tzEje2d6o+HldKLRyx6nKy2zltMr18qTk1HHaxR8U//xZyTuD4keMO5YghFYAAABAZxFaAQmWzNBqQYa90MQpv/Rb8vhLoXSqIm9ZI1iqGFrdm5Z+NW9+NqLVUVFm82r7OZl82ZvUQGh1b7rf2WY+KiEqzkperSc3Ke6qa4VWeh+8FlD7xmXVeT1oddxtkebndYHQ6o5MHe+S1MkLVVpYeVY+Lfu7U1UGxQ+2eksSQisAAACgswitgARLZmh1R77hdJE7L2fzXhe5VFZGQq2hVKhTfG1drjzntgR65OGB0jhP9YRWSyNOV73ec5EjaZUv10BotTSiwp1eiV51OKSq3j3QD490C6jB+UArK58XUvljdfmhlSUbc4PSE+o22ZTVcaclW8V92OUIrQAAAIDOIrQCEiyZoVXQ1vUJNywyugNat+bltNddzS0p6c72Sf7ssBxXP9cTWoVDnpDthFbuz6VufUGVQquo0iP957xxpKps31EhtHLLL8lvTd6Q0FDtjbPmZVCtr+pA7rsXoRUAAADQWYRWQIIlIrS695x8oi8rmZGFCq13vKfZde2TcdUvzlqRUTV4eldGTp6/IuuvFUvL6a539YRWsWtpVVpesYq3ZW44Y0/3uuM12dJq8JnX5BvncvaxpuXYZHAsrEqs4n0pRs1Y1rUxWQitAAAAgM4itAISLBGhlVyTiYNd0pXqF39s8gAdWnkh0Mqo9FQKb3T3tXpCKz2mVf+0vYWw1oxp1T9dvub6x7SyrZ2TXn+b3phWPaP2/8pVH9Nq0z4ed1D3c+YTESOsjPY461HdCsOs5TPOud/npIfJQ2gFAAAAdBahFZBgyQitRDZn806rp+BTAl2bC8POEwS7Dk7INTVBB1MfmgkNFH5LzverYMZ+zRhcvWJoZc9R6+mBXcenyp4eGBXYhEOr2k8P7JLjU7WeHmgfkvc0xJ5RN6aq+fRA84mKgdDKdmda+u15Ak9EjKCDqbJrYa3JOWc/K3V73P0IrQAAAIDOIrQCEiwpoZVqCbTgdIXrkvSRvJw9HxqIPX1MJv0ERYc8KTk8WJCZixdlpnBKHsimJJU9Jrl99mvGmEuVQyvb5oIMq66Gqaw8cMpd1/mxBySrAiC9zeKaPK+mjxx2grWc3/SqpCy0sumwLZV9QE4VZpzjGXsg66wjfWzSCIT08ZgDsbvH1Od0gzwo46vezP4T/NJyJH9WzjvzDcmRtHsMgcHqw6GVWLI6rkKvHhmcD4Z0Qea1GJLCjL0/58ec86u2W28Xw92I0AoAAADoLEIrIMGSE1opW7I+NyYDh7qdYMcJTTK9MjA2I1c3QjHJ5mUpPHRIulW45MzXJ0NTl2TD8rr1pU6KGgZKqRpaKfa6pob6JNvtttJKdWelb2hKLult6m6BXSnp/i0zbCqJCq2UzctTMtSX9fbTHSze3U9vBocOrcIlLZneh6RwaSMYElm3ZH7MeFJiOiO9A2Mytx4aZr0stLIVF2RYdTHMjEr1BwmGr4W9L31DMhXel4QhtAIAAAA6i9AKSLBkhVbAziK0AgAAADqL0ApIMEIroHUIrQAAAIDOIrQCEozQCmgdQisAAACgswitgAQjtAJah9AKAAAA6CxCKyDBCK2A1iG0AgAAADqL0ApIMEIroHUIrQAAAIDOIrQCEozQCmgdQisAAACgswitgAQjtAJah9AKAAAA6CxCKyDBCK2A1iG0AgAAADqL0ApIMEIroHUIrQAAAIDOIrQCEozQCmgdQisAAACgswitgAQjtAJah9AKAAAA6CxCKyDBCK2A1iG0AgAAADqL0ApIMEIroHUIrQAAAIDOIrQCEozQCmgdQisAAACgswitgAQjtAJah9AKAAAA6CxCKyDBCK2A1iG0AgAAADqL0ApIMEIroHUIrQAAAIDOIrQCEixJodXW+pyMDRyS7lSXdHV1Sar7kAyMzcsty5sBLbF5eUqG+jKSts9xV1daMn2nZW59y3t1byO0AgAAADqL0ApIsKSEVtbKmGRVWJU+IkOFGbl4cUYKQ0ecYCWVm5Sb3nzYns2FYcnY5zR9ZEgKMxfl4vkx6cvY5z3VL9N3vJn2MEIroH1uFo46f5DoOlrgMx0AAPgIrYAES0ZodUemjts3Mj2DMr/pTXJYsnZO3eSkZHiB5lbbd00mDqoQsCBr5um8MyXH7RvJgxPXvAl7F6FVs7bk7pVnpXBqQHr361Z8qqQls79P8mdn5MpdWvPtddsJrfxl6ynDC95SAABgNyC0AhIsEaHV68/LJ3uzcmBsxZtguFmQo/ZNyNGCcYtj3ZL5MfvmOJP2blJS0p3tk9Pzt6SUxSzIsHkT4xX3XsaSjUvhLnJDMnU5kJjZqxguW75Uhu0tlFgbl2RqqE8yaff1dKZPhqYui7nGyJuudEb6xpYD86kAYH1uTAYOdUtKzZPqlkMDYzIf6CfpHZ9/c1aUlU+7LdMC58q0Mio9XftkfNX7GWUIrZpxRT5zIFVet8tKWo5NBN8T2Fs6FVplxl70lgIAALsBoRWQYIkIraqwls9Ij30T0j99z5uyKbN5+wY5lZUHxs7LxYsXZaZwyu3i1pWR0RUd7HihzvFPO/Po8o07pS5yqcODfhe5B7LqpjsjwwvGLbUTWu2Th/+0tLwqn1atwszQatPeltPF7rAMOl0bz8vYA1kncMoML/g36e5Nl7k+PV/KPj7dN8+StULOXbZvTM7b880UhuSICsNSOSn4TaRCodW1CTlo7//JP74oz68V3Wkh7vbt/d68LFNDOXfsMBWIPVSQSxtmILZ3EVo1w5LlMz2S6s7JUOFZubL+qtz3GlVZxdfkxsp5OX2kFDCX6jr2mu2EVtVtyvxgj7fuc8GWpAAAIPYIrYAES25otSX3b8zISRUGZUZkSecw331K8pl0eWsiJ7QxWxmFWyJ5rGU50xNxY7N1WR49aE8/OCF+JzkntDoq4U0tDNvz+aGVe8Ou5jsXXKFcfvSgPf2g6F537g1beH2rMr7PXl//tDixnNdVr2dwPtAixdqYkXyqS1InL4h7Kszj8/bh+JRUiwOWRtxgLptNlQKxiQfdscTMc7yHEVo1aXNDquae1poUcl5rLMYz2rPaE1qVgv5gsA8AAHYLQisgwZIYWvk3Nk7Jydmr9aQpboizz+/7ViG0crrIdUl+tnydd6aO29szus/VFVqtyKgKwfKzXphk8AIovU+RoZV1WR5VodXgvH3rJXJvuj+4Dz4djuXF3fXS8W1dn5CjgVZm0dz9Lg/EtpbPOC3PGNOK0KqdSu/rYNdax9ZduTJzVvJ9+/0utrrb71BhUSo93FLX6aolFJBYG1dlJtC9WHXn7ZWBsRm5WjV5895ztUrFQMaSjaszMjbQaxxjWjK9AzI2c7Vi6Bf8PAyVVLdk+4aksLgu1UYM21pflMJQn2S7dTfO2ufW/fxT80ZcL4cRFmVUC05vchXB0MrrBt1bGgMt1Z2VvqGphlp+6pazZS1lAQDArkFoBSRYEkOr4trzTve582fzknNusiJuRrbuy6s3VpwudmcfyUufvgH1Q6oKoZXX5S9yXCfvJq20inpCq3BYZgrug3vDFuoe2Jexp2VkxGvm5M6jg6kg9zW9P+YN9C/Jb03eqHrTqrj73SOjZUOHrcm5Xvu13KS87E3Zqwit2kWHrnY9C4U6b7z4Gbf7q1+fy0sqOxIZijQWWllya3bQbVkYNZ8qqawMzppj45m2EVpZt2R20O0yHLmMXVLZQZkNjFvnqhpa+SUlucJaxH5vyuWJY34oFFnSx2QiPJ6fUiO0stYKknPOZe3AXPOPpXdQRo6VQsOyksrJxGrEh2BIaR8qHT8AANgNCK2ABEtiaBXgjxdl3zg5dySbsjzmDjiubm7UX+b39w7Iw2eHnVZN8Q+t3P0OlNRhGV12bxobDq2G52VjXrU0qN3KYHV8n7G86aYUjtrrqthCZO8gtGq9rfs3ZHHihN8aRge0vuKSjGS7JTdUkGevrMtrRTd6cMbDWvyUHPMCrR77fRR+W/ihVfh9HqHUIqdL0kdOy8yV2+JsyirKazfmjHG3Kr2XvPdchRDHf3+XvY827f1U4bRaNi1HTs/IldtFJ2BxjnHudCm0i2ixVHm9lhRvX5HzJ/W6+8Uf+s9htITqSkn2wQlZvHHfDbe37sv6SkEedMbys1+P6lZXLbSy1uSc+sywXz96rv6wKPgZqPapICvrpX26sTghJ5zxCe2SGZWqWZj+3WDPa44dCAAAdh9CKyDBEhFarc/Ix3ozcmIqekQm98bUDVv0wOxHH12RwBP0i7OSVzc6pcQpOrSq2T2wV+x7MFddoVXt7oG93gqDoZPLKn5TzqmxflIn5YK9gtrdAwdl3rmRM4+vaO+T/VqPvU/lh+Urzubt5VP2DXn4TtAbVyvqGPYYQqvtCYYSwZI+8JAULm1EBhyWfb4r0e/5Ut0vqTu0suz3qRdw9AzORXfFszZkTg/mHRWYeE8ybTS0suzPHDcs65HBuQrHvzEng+pzxJ4vM7oSmKdyaOW5Ny39zvpTMrLkTVPu2NO9VmVHJ65Ht8Tcui4TXviU6p8OjolXMbSyZHVcjddnL5MrNDTouVk/MmeWI/fJWh13xieM/qwqccfo8/Zd/fGiLy9n515yg0gAALCrEFoBCZaI0EquyYQaBD3qr/2b8+7NXI99E2n/6N70GMGSw5KNmbzboqBWaFVrIPbMmPgPS68rtKo1EHtG9NPX3X0vX19geq2B2E887Q7YHj4+b7mq41IVL8hJtY7Qjebm/KATChyvEBruJYRW22OGEmUl1S2503OVx1CqxA+LKr0X7VIjtLLs97Lb4ui4VK3m3vsoMjDR++F9FoX5xx4Ilyx7H71wpcaDEtzQ3J7Pb1Xqil6vwQ+tcjJp9O/1l+s5I8uhQzGVQsHQ+a0QWvkhnP15PRm5Q5WV6ke4VZjJ665sz1f2wA2Df+1DJXV4VLyGqwAAYJcgtAISLBmhlX0jpMcmSR+R/Nnz/phWbreZUncdfcOUyj4oEzPeuFADBySdStvFnrdWaGXT3YRShweloNZxfkwecLrJeNsprsnzF2dkvF+FUcEbQSUYWtn8LoyHZbAw4+7TA+74NWa3FfeGzRzT6qLMFIbcY/TDslKXHv8Jf3qeQKgXPj4vPEvlZbbiDVtp3ekjQ86x66cHNtpiIqkIrVrP7eY34XdFi6pr1sYlmToVHBy9vDQfWtUMfnwvy2TOXaduIenToVWFdURvw+t6a0+vFsA4Xp6UnFo+FMpX23fV9XLG6x4YbilV77kRWZIR9dlpzztoNmWLCq1UV06nxVpK8pU/aCryj6X3nITOboDe9+hu12GWFF8zu6Da5yI/S3dBAAB2EUIrIMGSElopW+tzwSdrpTPSOzAmc4GmGZbcmj9dGnhdzfPQhCyuvyLT/fbPByfEbWtUObRS69i4NCVDffqpVWnJ9J2WmevebY7fsiMtR8aWy25+ykIrm3PTPdTn73s60yenZ64HlvVv2ALF3fZ8YABm76lah7rd1iGpbjlkH+NfBuaJOD6vlUi4e1GQOn/Guu3z1zc0I9cbbf2SUIRWbbQ567QWVIHHSdUXVjPGJqpemg+t6g9wqsy7NOK+ZxoKrbz3qV1qbzp63ujPjWDp6f+T0Hu4gbCs0rx+aFVefuljc02FQtUCOFMj18vkt1ar2pILAADEDaEVkGBJCq2AnUZo1U5Fmc2XhxEro3ocqRNSWPEGRze1oHtgvWFJ1ZZWOsSpsK3obbSwpVXVkpLs4KyYuXb9wU+tllYRJaordx3aHVqV6ko9ISEAAIgLQisgwQitgNYhtGqn0lhFpTCiFOqUhURaC0KrVoxppQOXSl3WogOZNo9pZRXl9krBf+KeOS6dv1wrx7Sy1qSgHhyhpkc86bCWzoVWPTIaNfAYAACIJUIrIMEIrYDWIbRqxjV5eqLWAOuW3JrJe+FIl/T7fbdKLZuiwyBL1s55Qcc2Qivz6YGp/vOBFkm+qk8PvCNTx93lo548qlQKZEpPD0xJ//lbkV13t/X0QFvkeTCeHnjw9/9XdHe+Zp4eaHTnbPrpgU2EVsWlz8rYfPT5cxl1xXsaKwAA2B0IrYAEI7QCWofQqnHFhWE3jEofkIGx87Jy41W5rwOsrfuyfuVZmXjQfTBBVNBxbUI9ZVMFDYdlZO6Gt6wlxdtXZOb0EW/cOVW2EVrZ9AMY1PzpI6dl5orXFdEqyms35uT0ET0IfOnBD2LXA0u25O6cXrbyWEmVA5lNez/dwdKdcfJOz8iV20UnfHEGqZ877T1wwi4RrZeqBj3q/BotrXoCzYtKD15wug8+OCGLN+7bR2PzltOD40d296sUWtn8B2fYr5sPm6il6dDKWpVx9XRXe5rzEIlnr8j6a+45VGMA3l8P1pWD46veawAAYDcgtAISjNAKaB1Cq8aphxAUHjpghEuVS/rYhFwOJxybCzKiw5OykpLs6RHJO//fXmilQpyN+RHnaZnl2/FKKiuDs0ZrHn+cKbdUe8hB1UDG2pD5kVJwF1VS2UGZjWgC5q+3VknlZLI81ZLrhWPVr036mEyUXRRbldBKKYWAKcmVbzhS86HVhiyNmQFmpVI+thcAAIg/QisgwQitgNYhtGre1t0r8mzhlAz07i89AdQu6cx+6cuflZmrG5Vbv2yty9zYgPTqp4Kqp2r2DsjY3Lps+U/V225o5bI2rspMYFtqH3tlYGxGrm6E9tB4kuiBh6ardoWrHchYsnF1JviEVH2cM1clvGmtemiVku6sve+npuRSpRXYttYXpTDUJ9luHQ6q5fpkqLBYuVtnjdBKHY/fkiuVk3N1PIK06dDKYxVfksXCJyXfF6xjqe5s7ToGAABii9AKSDBCK6B1CK0AAACAziK0AhKM0ApoHUIrAAAAoLMIrYAEI7QCWofQCgAAAOgsQisgwQitgNYhtAIAAAA6i9AKSLBqodWbb77FewpogHq/qPcNoRUAAADQGYRWQIJVC61+RmgFNES9X9T7htAKAAAA6AxCKyDBwqHVu+++K++883M/tPrOd75j33y/7c0NoJKf/exn8u1vf9sPrdT7SL2fCK0AAACA9iG0AhIsOrR6R6y333Zuvjc2NuT27dsEV0AVP/nJT+TVV1913i/qfaPeP+p9RGgFAAAAtBehFZBgFUMr62158623nEGl1Y24em9RKJToolpYff/735ef/vSnzvtGvX8IrQAAAID2U9/HW43QCogJfSOtyrvvuqFVeFyrn/70Z/KTrZ/Kj9/4ibz+4zec8qPXf+yU4o9ep1D2VNF1X78X1PtCvT/U+0R3DfTHs1Khlf2+Mt9nAAAAAFqH0ApIOH0z/Ytf/IvTKkTdbKvxeMzWVlv2TbkOrnR49aPX7Zt2Vbybdwol8cWu7069t/+v3wvqfaHeH+p9Umpl9XNjEHYCKwAAAKBdCK2AhCuFVsEugrq11ZtvWc4NuWpJsuW1unrjJ1tO0TfuFMpeKbruO2GV/X5wWlg5gZXlt7KiayAAAADQGYRWQMKZoVWwtZUZXL3ldH3S4ZUbYKmbdgpl7xX9HlDvB/W+UO8PM7AyW1kRWgEAAADtQ2gF7AFmcGWObaWDK9XlSYdXTssrFWCpm3UvyKJQ9kJx6ruu+/b7QIdV6v0RCKy8sawIrAAAAID2IrQC9gAztNKtrczgSo3Ro8Mr9Th/daNOoezlot4HpbDKfZ/4gZX3PiK0AgAAANqL0ArYI8qCK9XiygivSgFWKcSiUPZi0SGVDqrMsMptYUVgBQAAAHQCoRWwR+gb7FJwZbS6cm7GVZcnt+gbdQplrxbz/aDfIzqsMgMrVQAAAAC0B6EVsIeYN9qqBMIr3fKKQqGUitGyKhxWqQIAAACgfQitgD0ofOOtSynEolAoqkS9T1QBAAAA0H6EVsAeFnUzTqFQKhcAAAAAnUNoBcARdYNOoVAIqgAAAICdQmgFAAAAAACA2CG0AgAAAAAAQOwQWgEAAAAAACB2CK0AAAAAAAAQO4RWAAAAAAAAiB1CKwAAAAAAAMQOoRUAAAAAAABih9AKAAAAAAAAsUNoBQAAAAAAgNghtAIAAAAAAEDsEFoBAAAAAAAgdgitAAAAAAAAEDuEVgAAAOiMhWHp6uqSrqMFuelNAgAAqITQCgAAdJxVfEkWC6dkoHe/ZNJdbpDRlZLubJ/kz87I1Q3LmxOJ0o7QanNBhjOq/vTI4NyGUHMAAEgOQisAANBZ3/qcvN8Jqcywygyv7JLKyuDsLQKIpGl5aLUps/mUs87M8IL9EwAASBJCKwAA0GHXZOL9WXlgbEau3C4GgqmtuytSeDArKSe8OigT17wXkAwtDa0sWSvk3Lpy9JyskXACAJA4hFYAAKDjLKtawnBHpo6r0KpLekZXvGlIhBaGVtbKqGTUulI5KZBYAQCQSIRWAAAgdm4WjrrhxvCCN0XbkvXFgpwa6JVst9stTI+FNTR1SSKHwtJBSZVibsbauCozYwPSm0l7r9vrPzQgpyqtXynOSj60zrJSKajZWpfFwpD0Zbu9FmZdks6osb3mZH3LmydgQYbN9Zol1S3ZviGZulRpbCdLNq7OyJh9/vzumPYyhwZOVV6mRtC0ab/uhEeZYVmo1T/PXJd93HOB85yWTO+AjM2t21e5BnMcq3k6BQIAkFSEVgAAIGaKcuGkG0gdDPQPvC1PDuiAwws59melO6V/7pJUrlDeTUwHJSrQ2b9f9keUT37dnXVzeVQOG+tLZ4JjbaWyIzIflVzdLMjRStvQYVRE6GOtTcsJJ3zx1t+dNcI4u6SPSeF6OMLRoZU7FljZdpySkeGyBGlTlkcPG/Oo85eRtP9zSrIj8+XBXLXQSodH9bZ20uval5Ocf9zl+3F4bMWuBZXclMkc41gBALAXEFoBAIDYsIq3ZWXimBtgRLTc2Zw9KQcenJDFG/eN1jiWbFyakGNeuHR86o433VMtdDFYawXJOYFVSg6PzMlLxVIIs7W+KJ865gVmB8dlNZzP6NCqrGWYTb8W3r7fWqhLMicKsnLXOKKNq3J+0BvbK5WX2cB50KHVUSmUpWAbMj+ccfczNykve5PVOfLHf0odlpG5l6R0eKr12qf883dwfDXY4qri+dPhUUpyk9XOrEGvy9mPnIyv3C1dR3vfLxVOuK22Ko5nVmkcq6KsPX9RLl58XtYqp10AAGCXIbQCAAA75KYUjnoBRqikj5yW+VvhZKi6O1PH3eXzs8FWOnWFVqXWXT2D89Gtd6xVGT/o7l9ZMNZEaHVt4qC3X5UGES89Ga/nzLIRJFUJrZSo4y1ekJNOIFe5O521Oi4HnfUel8DhRZ6/UnjUUGsnP7SqtB+lY943vupNK/G7Ipa17NJ1qcI5AQAAuxKhFQAA2CEvyxMfNrq3Bbr6peXI6XlpKLeqFE5Vmm6y5mXQ2W710OPedL+7rv5puedNcyyNuK1/6g6t1uRcr9peSoYXqhzkyqj0qGV7RqU0JH2V0Grrrsx5La3MrpXW/KC739XOgX1E0/1qvV3SP20cXcT58wOuzIgsNdKySa8rcDxB/jkOn8uq41gRWgEAkESEVgAAIFa27q5I4YQbvKTys8FWPKoL2dSQ9AXGQAqVZkIrHSx1DUtE7FSyOi771Hz7xiXQDsjbRlTroOjQqkZrKc0f4D0vs344pJetNKZVeeBXeWD7oNXxfc58gePQ588Yr8sd5+uonKtnHCtTPddCz2Puq7UmharjWBFaAQCQRIRWAAAgfqwFGXZaXZljG23Kgh6vKRSiOEU/hW4HQqvibN7ZxtGoxKRtoVWVkj4iY8ulaKcloVVZSUn/dKibZC1Nhlb3nj7hBXKNFAIsAAB2O0IrAAAQQ7r7XJf42cXLk5JTYYQawPvSRnCwcKVSIFJPUOJ3D6w0ALjLHzcr1D1Qh0KD8xEtj2p0Dzx5oXL/Omv5TGPdA62ivDRz0hv36aToVfvdAw9OSOXDuyNTx9V6a3cPrDy2VA31XAs9jxFa+aFbQ4XQCgCA3Y7QCgAAdJa1IRtRY3AbSoOC7xO/0U+NwGNz5kPRr9cTlNQ1EPuKjDpjKoVbGBVlNq+m98q5NW+SKTK0qmcg9jsy3e91iRtdqX8gdj8QMwK4egZiXxn1gqh+CRxe5PmzZHXc2/+IpzxW1GRoVVudLdcAAMCuQmgFAAA6ymmtlD4gD008K1duF4MtprbuypWZETnsDcie6p8WPz+5Ny39TjBxUM587a5seZOd1kVzpWWaC61sNycl56wjJdnBGXmpWNqzrfU5GTnsBkjhkMlaO+eGUpUGF68QWklxSUacEKxL0scmZOWuf0RibVzyx/Xq6hmUYM5ULaCxZOPSo+72unIy+bI32XZz0n3aX1cqK4MzL0np8LZk3Th/R8+tBa9JpfNnjDNVMegLI7QCAAANILQCAAAdZMmt+dNyxBnIWxd3QHF3cO9SUUHO5UASUpSlkfCYVnpA9pS8/2ReetX/mw2tbJvLo6Xwyy7pTHC/UtkRo1XRgpzu1oOfVxjPSqkUWtmstWk54QVXzvq7s5Lt9sIxVdLHZLKsGZYOaEIDsQeevmjv+8kLoSBpU5ZHDxtjQ6UlExjQPiXZkYhBzqudP/+JfinJFUJhVxRCKwAA0ABCKwAA0HmqddRiQU4N9JYGULeLCm16B05JYXG91JIqQLUKGpOBQzosSkn3oQEZm7PnrxQONRBaKdbGVZkZG5Bef7/SkukdkFNTl2Qj2ATJC0rScuCh6Qpd/GxVQivH1rosFoakz3/6nwqj+iR/dk7WI0+C3m5UcZcdKttXzZKNqzMyZp93P4xLZ5xzPhU1TphS4/xZawWvhVpGhmv1EyS0AgAADSC0AgAAAAAAQOwQWgEAAAAAACB2CK0AAAAAAAAQO4RWAAAAAAAAiB1CKwAAAAAAAMQOoRUAAAAAAABih9AKAAAAAAAAsUNoBQAAAAAAgNghtAIAAAAAAEDsEFoBAAAAAAAgdgitAAAAAAAAEDuEVgAAAAAAAIgdQisAAAAAAADEDqEVAAAAAAAAYofQCgAAAAAAALFDaAUAAAAAAIDYIbQCAAAAAABA7BBaAQAAAAAAIHYIrQAAAAAAABA7hFYAAAAAAACIHUIrAAAAAAAAxA6hFQAAAAAAAGKH0AoAAAAAAACxQ2gFAAAAAACA2CG0AgAAAAAAQOwQWgEAAAAAACB2CK0AAAAAAAAQO4RWAAAAAAAAiB1CKwAAAAAAAMQOoRUAAAAAAABih9AKAAAAAAAAsUNoBQAAAAAAgNghtAIAAAAAAEDsEFoBAAAAAAAgdgitAAAA0CY3pXC0S7q6hmXBmwIAAFAvQisAABA7W3evyMzZvPTtz0i6S4Uedkl1S7YvL2dnrsqG5c2ImGs2tFqQYX3dIwshGAAAewGhFQAAiJfvPi7HvHAi1Z2V/fv3uyXbLSk9/fCoLG968yPGmgytirOSV9daBZX6+gfKJ+Xr3qwAACC5CK0AAEDMFGVldkau3C5KuEGVtXFJxnMpJ7jqGV3xpiK+mgytbhbkqAqthmlPBQDAXkZoBQAAdpeFYSe06jrxtPyDN0mxNq66XQqNFlnpTK8MjM3J+pY3k69G97OjBbnpzSlb67JYGDLWm5ZM74CMza1L2Wodtbq2HZWCv3LNko2rMzI20CuZtDufamXWNzQll6L6QupzEC5OF8ohmboc3Qxta31RCkN9ku12g7+udEZ6B8ZkrvwElYIj81xo1qqMH1Tby0lhrVpfTSO0sjbk0pR9HjNpY19PR297acQ51wSTAADsbYRWAABg97A25C9//6ATehw1k5/b5+WBlApHVFBV6kbmB0C5ggSzFR0spSUT6HbmlQ8/IS+r2TYXZCRbCnjc17PSrbd1bDK0Xtu9aekPzK+LXi4cWlmyNnnMG7srJd1Zb34/3MnKyEIohPJCq0D3ycAyOZkMJU2bCyOSDZ8jI4g7NrkWbNlWMbSyZHVcXYOU5MIbKaNDq6OSc1rIRR/f6aWiN7/Lmh90XgtcYwAAsOcQWgEAgJj6unzSDGTs4oZQaTlyel5uBRIWS1amJ2Qx3Gpn67qc88KSkxfMYESHVtW6rd2USW/Zw6NLgcHfVTfFiWNu6JIZXYkOe8q6tpUCHDOLKS6NSEbNnzkhU9fN/d+S9ZlBN2hK9cv0HW+y4oVW5aGODpS6ZN/4qjfNdnNScs56Dsvo0oaxv5ZsXJqQY855zcjoinEkFUIra2XU2d9UflZqDyumj1ltOyfnQsd3/VzODc1C27hZOOos44dyfXl55JFH5Oz5FXmpGDjbAAAgwQitAABATEV3s0t1H5KHCpfqf4KgbpU0suRNUOoIrVZGpUfNE9U9Ttmcl8EetY68zJp5mBf2lAdKUaHVPZnuV9N6ZHgh2NrIZcnaOTfACYRQFUMrm/ea2bVuZbSn8vy2zflB91jzs+LvRVRoVVySkYw9LWOft7oGwi+FVh+aiVpgVcb3qdf7ZfqeN8mm9zeypLLy4HSoVRgAAEgkQisAALBLWFK8fUXOD2ad1jmZ4YVgSx+rKC8tFuSTjzwsA71GCy3dDS3Q8ql2aLV2rtdZrt9MU0KWRtyug4FVNxJaWfMyqPajZ1Qqjt708qTk1DxmeFQhtNq6/w2vZZnZampNzvWq7QaDoaAlGXG6Dhrnoyy0KtrHm3HWPVxfYmWLbl1WYsn8YLXXNfvav3ZDFice9Lo4hlqFAQCARCK0AgAAu8w1mVCDgAfCnzWZ9LrrVSwNhlYLw+5yZb38DLobW3DVbqCUm3RGxTJEBDgVuuAFefsaEVpFl38jDz9712iJVEerMn/fIkKrUPmlwflSa6yaItYb4p7nWqFVyZ2p485+BFvOAQCAJCK0AgAAu044UCpeOOm0vkrlxmXlbmhcKx3wNBha6UCq0ZZWehDx8rArqtWRtx9NtrQqG4jdH+zdbA2lt9tkSyv1lD9z3TWfGGhqfWgla+ekN3w+AABAIhFaAQCAmLHEqpaJWJflUWccpB7RwzbpgGlwvnxBHSI1GlrVPaZV6qSYY7y73Qp75dyaN8EXFVrVP6bVwYlr3jRbhe6Bjs0Z+ZDa733jokfBqndMq9TJC1XHtNq0t+sOGm+ft4bGtGoktLJka6tyBbDsfXAGbx+cN1qTAQCAJCK0AgAAsWItn5FM9kEprNyW8IPi1FP7CifUuEpd0nVwQnSMc2+635nWMzgfGOfK2piXYTVwuJq/0dBK7sh0v/v0wOzInJgNuNR+jDtjR4WeHmityrjqupgakfLOa1Ghlb2I9zS+rvQxKXyzaAQx6umBJ93X6n56oNq3J93QytyHO9PS77SSysrI3F17zZp6euC4+2TBup4eaMlawX3iXypXkNoNrpoIrdR200fk9NxLZdd/6+6cdz3DT4MEAABJRGgFAABi5ebTerBtu/hd0+yS7XZb2KjAJDsos7eMREM/1U695neZy0ja/jmTy8k+tVzDoZVtc0FGsm441ZXOBNarpmVOTPvBzdc/uV+y3RFBli86tHKCoMlj3jpT0p11j1evqyt1WEaXQ82aanYPLN+HzYUR/7ymM978epD6roycCD+RLzK0UjbtzbvBYWZkqcb4Vo2HVi9/6aEa11+FiKFB+AEAQCIRWgEAgNixii/JYuGUDPSWQpiurrRkegdkbOaqbJQnQm4rrId6JZN25091H5KHCpdkY80LX5oJrRRrQy5NDUmfH5p4+zG3brRY0uFLSrp/a7JCC6RKoZVra31OxgbM/c9K39CUXIo6WC+0Ki8q9OqToSn7uCuco6mhvlIgls5I78CYzK2HxgFTKoZWNmtNCt5TCofnNyICOq2JllY2a+OqPBu+/irA6huSwmLwvAMAgOQitAIAAAAAAEDsEFoBAAAAAAAgdgitAAAAAAAAEDuEVgAAAAAAAIgdQisAAAAAAADEDqEVAAAAAAAAYofQCgAAAAAAALFDaAUAAAAAAIDYIbQCAAAAAABA7BBaAQAAAAAAIHYIrQAAAAAAABA7hFYAAAAAAACIHUIrAAAAAAAAxA6hFQAAAAAAAGKH0AoAAAAAAACxQ2gFAAAAAACA2CG0AgAAAAAAQOwQWgEAAAAAACB2CK0AAAAAAAAQO4RWAAAAAAAAiB1CKwAAAAAAAMQOoRUAAAAAAABih9AKAAAAAAAAsUNoBQAAAAAAgNghtAIAAAAAAEDsEFoBAAAAAAAgdgitAAAAAAAAEDuEVgAAAAAAAIgdQisAAAAAAADEDqEVAAAAAAAAYofQCgAAAAAAALFDaAUAAAAAAIDYIbQCAABAC9yUwtEu6TpasP8HAACwfYRWAABg17A2rsrM2bz07c9IuqtLuuyS6s5KX/6szK1veXNhZzQbWlmycWlKTg30SibtXtOudEb29w3J5P+74c0DAAD2IkIrAACwSxTlwsmUdHWlpPvQgDz8yCPyiF0eHjjgBVgZGV7Y9OZF5zUTWm3K8uhhSXlBVV/evaaPPDwgh7qzMrpiefMBAIC9iNAKAADsGtbaJVm5W96iyrp1XvpTXdKVGpYFco4d0nhotTmbdwKrzMkZKWsoZ1nCpQQAYG8jtAIAAImwMKxaWx2VgpGYON0JxwakN5N2u511pSXT+5AULm2EApEFGXZejyrD9qsua+OSTA31+d3YUt2HZGBsrjxwURaGQ+sxS2mdWv3rrrCvqqXS0IxcL5vf7X431Ke7VLot1cbm1iU8683CUfv14Dl0bNrbzNj7lCvIWsUkqRRaXV+fk7GBQ9KtgkR7m+lMn5yevxU65ysy2mO/nhkVGlQBAIAohFYAAGD327osjx7skq6eUVnxJol8Sz73fntaqlsODTzsdzs74IRC4a6EXhB08IPufIHylFy15yiuTkjOCWHScsBbXz7X7XZtywxLWc9EJ7TqkdzHguv7oNrPUGjV2Lqj91XPn+qfljvenKpL5epEzut+d0AGHlbz5iXXrbpZdklmeEHMVUeHVpsyP9hjn8ecTFZtQuWFVj0ZydjHkj7gdeH0z3lK+qdLeyar47LP3od946veBAAAgCBCKwAAsMvck+c+Wwpr/BAmfUTGloPJUXH1UnnLo81ZyauAKDcpL3uT/CBoONz+yWOtyGjGfj2Vk3OBFVqyMT8smbKwyN72bD4iAFJZlgpwjNCq4XVX2tc7MnU8uG5rZdRdPncueB6sDZkfzpQFSVGhlduFLyX52XAqF+aFVvb2wmGYbM7LoGpVZYSK7vnpkuEFS2795YQ8dMgL6bzWcBN/GW6ZBQAA9hpCKwAAsMuUwhGzZPrG6nyCYFFm82oZs7VT9dDKWhh2ApXjU2YspVmyfKbHXl8w7HEDoJxMlpIxRzi0anzdNUIrPxiy7G2pFlXHJXrVy3JGBUnGGFRlodWdaWessLIQKpK+LnmZLXqTDEsjal9K63a3ZR93f78TinXn8m4IabTMyhXWCK4AANjDCK0AAMAutyX3b8zJyOFUWRc2a2NJzg70+uNEBUv9oZUbsOyTSj3ZSq2GvAk2dxlzG65waNX4ur19DXcPPJK2jz8rI35fQi9E2jcu0asuD+/cfSl1afywOqdRXR8jedurMBC7u+6jfmj18mTOOS6nq+Z8aIwxbwytrtRJuRARgAEAgL2B0AoAACSDN0ZSz6jXAU13uzPGidKlfFyp1odWK6OqhVQbQ6uokj4gDxUue62img2tjPWp0qbQSpZG3O6AvedkzZtkWjvXa8/fI/pyAgCAvYfQCgAAJIMXWvnB08qo9Ng/Hy31q/NYMj+oApn6Q6taXfjcbnhGIKO3ERHgNNo9sHzdFfZ1667MOeNUHZSJa2pCre6B9nrU2F5Vugdu2vumxsTqGZyvv3tgvaFVcVby6jgIrQAAQAWEVgAAYJe4I0+PTcjK3Yhxq7auy7mcCmhScuLpe+40L7Ta9+hlMbueWWsF70l99YdWDQ+WXrTX12NPG1nyJpS0byB2kc2ZD9nrLrXK2v5A7JZ9Gt35ao8v1WBoJUX7XKjWaFW6B/ackWUGtQIAYM8itAIAALvD7SdlwBuguzvbJ/lH3K5+Dw8ckm4nhOqSzIlpWdMhh7Uq4043wFL3wIcHDki6KyMZp9tgA6GVrRR2ldaXz3lPvDO60F19yhtfqqtHzkQkLmWhla3edbu8fQ2NafVIPueeh1S/lHIoS9YKOXc96QMy8LCa13vaoj0tPMB6ebBks9ak4ASCGRmu2k+w0dDKtrkgI1k3bCwfiL3W9gAAQNIRWgEAgN1j665cmTkr+b6sH1R1pbol2zckhcV1KWuDtXlZCg/pUCsl3YcG5OySamWkfm4stFKsjUsyNdTnD+ye6j4kA2NzYj600A2l0nJkbDmyS11UaKXUs26Xt6/h4p2HqcvhrVqycWlKhvoyknbmdc/D2Fz5+YoMlhS/5dOgzG1UavrURGilbK3L3NiA9GZU0FftOAAAwF5DaAUAAAAAAIDYIbQCAAAAAABA7BBaAQAAAAAAIHYIrQAAAAAAABA7hFYAAAAAAACIHUIrAAAAAAAAxA6hFQAAAAAAAGKH0AoAAAAAAACxQ2gFAAAAAACA2CG0AgAAAAAAQOwQWgEAAAAAACB2CK0AAAAAAAAQO4RWAAAAAAAAiB1CKwAAAAAAAMQOoRUAAAAAAABih9AKAAAAAAAAsUNoBQAAAAAAgNghtAIAAAAAAEDsEFoBAAAAAAAgdgitAAAAAAAAEDuEVgAAAAAAAIgdQisAAAAAAADEDqEVAAAAAAAAYofQCgAAAAAAALFDaAUAAAAAAIDYIbQCAAAAAABA7BBaAQAAAAAAIHYIrQAAAAAAABA7hFYAAAAAAACIHUIrAAAAAAAAxA6hFQAAAAAAAGKH0AoAAAAAAACxQ2gFAAAAAACA2CG0AgAAAAAAQOwQWgEAAAAAACB2CK0AAAAAAAAQO4RWAAAAAAAAiB1CKwAAAAAAAMQOoRUAAAAAAABih9AKAAAAAAAAsUNoBQAAAAAAgNghtAIAAAAAAEDsEFoBAAAAAAAgdgitAAAAAAAAEDuEVgAAAAAAAIgdQisAAAAAAADEDqEVAAAAAAAAYofQCgAAAAAAALFDaAUAAAAAAIDYIbQCAAAAAABA7BBaAQAAAAAAIHYIrQAAAAAAABA7hFYAAAAAAACIHUIrAAAAAAAAxE57Qqsfyf8fOK1TDUdrcNkAAAAASUVORK5CYII=\" width=\"700\" height=\"299\" /></p>\r\n<p>Заголовок <strong>&lt;h1&gt;</strong> - это всегда название статьи и на странице он должен быть только один. В статьях важные разделы лучше разделяйте заголовками <strong>&lt;h2&gt; </strong>и всегда соблюдайте иерархию вложенности. Не допускайте, чтобы заголовок младшего уровня стоял выше старшего!</p>\r\n<blockquote>\r\n<p>Кстати в системе <strong>OkayCMC</strong> оглавления в статьях строится на заголовках. Вам не нужно их создавать вручную и прописывать им якоря. Оглавление для статьи формируется автоматически с якорями на нужный раздел.</p>\r\n</blockquote>\r\n<p>&nbsp;</p>\r\n<h2><strong>Оформление маркированного и нумированного списков</strong></h2>\r\n<p>Часто в статьях приходиться как то выделить набор отдельных фраз или предложений, которые начинаются с маркера или цифры. В таких случаях лучший способ использовать списки. С их помощью можно упорядочить и систематизировать разные данные и представить их в наглядном и удобном для пользователя виде. В примерах ниже приведены варианты оформлений, как по умолчанию, так и дополнительного вида.</p>\r\n<div>&nbsp;</div>\r\n<h3>Нумированный список по умолчанию:</h3>\r\n<ol>\r\n<li>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Lorem ipsum dolor sit amet, consectetur adipiscing elit.</li>\r\n<li>In eget velit vulputate, aliquam tellus vel, cursus purus.</li>\r\n<li>Curabitur fermentum justo quis sem lacinia, pharetra bibendum purus congue.</li>\r\n<li>Curabitur tempor enim quis lobortis tristique.</li>\r\n<li>Praesent blandit turpis sed odio accumsan, a scelerisque risus ornare.</li>\r\n</ol>\r\n<p>&nbsp;</p>\r\n<h3>Маркированного списка по умолчанию:</h3>\r\n<ul>\r\n<li>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Lorem ipsum dolor sit amet, consectetur adipiscing elit.</li>\r\n<li>In eget velit vulputate, aliquam tellus vel, cursus purus.</li>\r\n<li>Curabitur fermentum justo quis sem lacinia, pharetra bibendum purus congue.</li>\r\n<li>Curabitur tempor enim quis lobortis tristique.</li>\r\n<li>Praesent blandit turpis sed odio accumsan, a scelerisque risus ornare.</li>\r\n</ul>\r\n<p>&nbsp;</p>\r\n<h2 id=\"5\"><strong>Изображения и видео</strong></h2>\r\n<p>Чтобы Ваша статья смотрелась более презентабельной, оформляйте её различными изображениями, иллюстрациями, подходящие по смыслу к абзацу или заголовку . Добавляйте картинки как полным изображением, так и слайдером.</p>\r\n<p><img class=\"fn_img_zoom\" src=\"data:image/png;base64,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\" width=\"700\" height=\"288\" /></p>\r\n<p>В текстовом редакторе для изображений, добавлены несколько классов для их оформления. Если изображению добавить класс <strong>image_zoom</strong>, то по клику на него, откроется модальное окно с увеличенной версией этого изображения.</p>\r\n<p><img class=\"fn_img_zoom\" src=\"data:image/jpeg;base64,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\" width=\"800\" height=\"600\" /></p>\r\n<p>Классы <strong>image_slider</strong> и<strong> image_gallery </strong>формируют карусель из загруженных друг за другом изображений. Главное различие между ними в том, что <strong>image_gallery</strong> формирует карусель из трех слайдов, в <strong>image_slider </strong>из одного.</p>\r\n<p><img class=\"fn_img_gallery\" src=\"data:image/jpeg;base64,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\" width=\"800\" height=\"600\" /></p>\r\n<p><img class=\"fn_img_gallery\" src=\"data:image/jpeg;base64,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\" width=\"800\" height=\"600\" /></p>\r\n<p><img class=\"fn_img_gallery\" src=\"data:image/jpeg;base64,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\" width=\"800\" height=\"600\" /></p>\r\n<p><img class=\"fn_img_gallery\" src=\"data:image/jpeg;base64,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\" width=\"800\" height=\"600\" /></p>'),
(2,	1,	'Основные изменения в OkayCMS 2.0',	'Основные изменения в OkayCMS 2.0',	'Основные изменения в OkayCMS 2.0',	'1.        Административная панель.        Абсолютно новый дизайн, структура и верстка согласно современным подходам. Теперь админ-панель более дружелюбная, понятная и удобная для пользователя. Предусмотрено место для размещения нового функционала, доработок и модулей. Главный козырь новой админки &ndash; ее адаптивность. Вносить корректировки, обрабатывать заказы, отвечать на запросы теперь удобно с любого устройства.    \r\n   2.        Техническая поддержка OkayCMS.        В админ-панель внедрен функционал ',	'<p>1. Административная панель. Абсолютно новый дизайн, структура и верстка согласно современным подходам. Теперь админ-панель более дружелюбная, понятная и удобная для пользователя. Предусмотрено место для размещения нового функционала, доработок и модулей. Главный козырь новой админки &ndash; ее адаптивность. Вносить корректировки, обрабатывать заказы, отвечать на запросы теперь удобно с любого устройства.</p>',	'<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span style=\"color: #000000;\"><span lang=\"ru-RU\">1. </span></span><span style=\"color: #4f81bd;\"><span style=\"font-family: Cambria,serif;\"><span style=\"font-size: medium;\"><strong><span style=\"color: #000000;\">Административная панель. </span></strong></span></span></span><span style=\"color: #000000;\"><span lang=\"ru-RU\">Абсолютно новый дизайн, структура и верстка согласно современным подходам. Теперь админ-панель более дружелюбная, понятная и удобная для пользователя. Предусмотрено место для размещения нового функционала, доработок и модулей. Главный козырь новой админки &ndash; ее адаптивность. Вносить корректировки, обрабатывать заказы, отвечать на запросы теперь удобно с любого устройства. </span></span></p>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span style=\"color: #000000;\"><span lang=\"ru-RU\">2. </span></span><span style=\"color: #4f81bd;\"><span style=\"font-family: Cambria,serif;\"><span style=\"font-size: medium;\"><strong><span style=\"color: #000000;\">Техническая поддержка OkayCMS. </span></strong></span></span></span><span style=\"color: #000000;\"><span lang=\"ru-RU\">В админ-панель внедрен функционал для связи с техподдержкой </span></span><span style=\"color: #000000;\"><span lang=\"en-US\">OkayCMS</span></span><span style=\"color: #000000;\"><span lang=\"ru-RU\">. Теперь вам не нужно звонить, писать на почту или скайп. Задать вопросы, получить консультацию, помощь в установке </span></span><span style=\"color: #000000;\"><span lang=\"en-US\">CMS</span></span><span style=\"color: #000000;\"><span lang=\"ru-RU\">, шаблона или дополнения можно прямо из административной панели, отправив запрос в техподдержку. Это поможет нам быстрее отвечать на ваши вопросы, а история переписок по всем темам всегда будут храниться в одном месте - у вас в админке. <a href=\"https://okay-cms.com/support\">Подробнее о техподдержке</a>. </span></span></p>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span style=\"color: #000000;\"><span lang=\"ru-RU\">В 2.0 пользователь лицензионной </span><span lang=\"en-US\">OkayCMS</span> <span lang=\"en-US\">Pro</span><span lang=\"ru-RU\"> получит 10 часов бесплатной техподдержки, пользователь </span><span lang=\"en-US\">OkayCMS</span> <span lang=\"en-US\">Lite</span><span lang=\"ru-RU\"> &ndash; 30 минут с возможностью докупить часы техподдержки. </span></span></p>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span style=\"color: #000000;\"><span lang=\"ru-RU\">3. </span></span><span style=\"color: #4f81bd;\"><span style=\"font-family: Cambria,serif;\"><span style=\"font-size: medium;\"><strong><span style=\"color: #000000;\">Мультиязычнсть сайта. </span></strong></span></span></span><span style=\"color: #000000;\"><span lang=\"ru-RU\">Переделана мультиязычность клиентской части и добавлена мультиязычность админ-панели. Теперь переводы статических фраз хранятся не в базе данных, а в файлах. Для клиентской части это упрощает установку новых тем и возможность переключения между ними. Для обеих частей (как админки, так и клиентской) это облегчает перевод сайта на другие языки. Теперь сделать сайт для клиента полностью на иностранном языке не составляет проблемы. Для этого необходимо перевести фразы всего в двух файлах. На момент релиза в </span></span><span style=\"color: #000000;\"><span lang=\"en-US\">OkayCMS</span></span><span style=\"color: #000000;\"><span lang=\"ru-RU\"> 2.0 добавлено два языка для административной панели - русский и английский, но в ближайшее время их количество увеличится.</span></span></p>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span style=\"color: #000000;\"><span lang=\"ru-RU\">4. </span></span><span style=\"color: #4f81bd;\"><span style=\"font-family: Cambria,serif;\"><span style=\"font-size: medium;\"><strong><span style=\"color: #000000;\">Новый дефолтный шаблон.</span></strong></span></span></span><span style=\"color: #000000;\"><span lang=\"ru-RU\"> Код шаблона теперь чище и приятнее для разработчиков, детальнее прокомментирован. Сам шаблон теперь позволяет добавлять большое количество категорий.</span></span></p>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span style=\"color: #000000;\"><span lang=\"ru-RU\">5. </span></span><span style=\"color: #4f81bd;\"><span style=\"font-family: Cambria,serif;\"><span style=\"font-size: medium;\"><strong><span style=\"color: #000000;\">PHP 7.</span></strong></span></span></span><span style=\"color: #000000;\"><span lang=\"ru-RU\"> Полная поддержка PHP 7, которая позволит позволит сайтам на OkayCMS работать быстрее.</span></span></p>'),
(2,	2,	'Как работает техподдержка OkayCMS 2.0',	'Как работает техподдержка OkayCMS 2.0',	'Как работает техподдержка OkayCMS 2.0',	'Приобретая лицензию OkayCMS Pro 2.0, вы получаете 10 часов комплексной поддержки и консультаций по работе с OkayCMS. Предлагаем более подробно ознакомиться с видами консультаций и регламентом работы службы поддержки.  \r\n  Специалисты технической поддержки выполняют следующие работы:  \r\n \r\n \r\n  дают консультации о системных требованиях для оптимальной работы системы;  \r\n \r\n \r\n  дают консультации по работе c OkayCMS для администратора магазина;  \r\n \r\n \r\n  предоставляют консультации по внедрению дополнительног',	'<p>Приобретая лицензию OkayCMS Pro 2.0, вы получаете 10 часов комплексной поддержки и консультаций по работе с OkayCMS. Предлагаем более подробно ознакомиться с видами консультаций и регламентом работы службы поддержки.</p>',	'<p><span lang=\"ru-RU\">Приобретая лицензию OkayCMS Pro 2.0, вы получаете 10 часов комплексной поддержки и консультаций по работе с OkayCMS. Предлагаем более подробно ознакомиться с видами консультаций и регламентом работы службы поддержки.</span></p>\r\n<h2 class=\"western\"><span lang=\"ru-RU\">Специалисты технической поддержки выполняют следующие работы:</span></h2>\r\n<ul>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">дают консультации о системных требованиях для оптимальной работы системы;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">дают консультации&nbsp;по работе c OkayCMS для администратора магазина;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">предоставляют консультации по внедрению дополнительного функционала в OkayCMS;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">оказывают помощь в установке OkayCMS на хостинг;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">проводят установку шаблонов и дополнений из</span><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">&nbsp;</span></span></span></span><a href=\"https://okay-cms.com/catalog/dopolneniya\"><span style=\"color: #38c0f3;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">MarketPlace OkayCMS</span></span></span></span></a><span lang=\"ru-RU\">;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">проводят обновление OkayCMS до последней актуальной версии.</span></p>\r\n</li>\r\n</ul>\r\n<h2 class=\"western\"><span lang=\"ru-RU\">Регламент работы:</span></h2>\r\n<ol>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">В административной панели вашего сайта на OkayCMS в разделе \"Техническая поддержка\" создайте новое обращение.</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">Подробно опишите проблему и сформулируйте название обращения. После этого подайте обращение на рассмотрение.&nbsp;</span><strong><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">Внимание! Одно обращение в службу поддержки должно содержать одну проблему, не пишите несколько проблем в одном обращении.</span></span></span></span></strong></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">Следите за </span><span lang=\"en-US\">E</span><span lang=\"ru-RU\">mail-уведомлениями о прогрессе решения вашего вопроса в течении одного рабочего дня. Ответ так же будет отображен в админ-панели вашего сайта.</span></p>\r\n</li>\r\n</ol>\r\n<h2 class=\"western\"><span lang=\"ru-RU\">Что может повлиять на время решения вашего запроса?</span></h2>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">Для ускорения реакции на ваше обращение мы советуем следовать простым правилам:</span></p>\r\n<ul>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">подробно описывайте проблему, шаги к ее воспроизведению;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">укажите реквизиты доступа в административную часть вашего сайта;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">укажите актуальные доступы к FTP и СУБД (PHPMyAdmin), если для решения проблемы необходимо вмешательство в исходный код;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">предоставьте информацию о версии продукта.</span></p>\r\n</li>\r\n</ul>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">Дополнительно службой поддержки может быть затребована информация о настройках ПО, а также информация для доступа к серверу по FTP, SSH или административной панели хостинг-провайдера.</span></p>\r\n<h2 class=\"western\"><span lang=\"ru-RU\">Обработка обращения прекращается в случае:</span></h2>\r\n<ul>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">если пользователь не может дать затребованную агентом поддержки информацию для решения вопроса;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">клиент не может предоставить доступы к сайту (FTP, SSH, панель управления хостингом и т. д.);</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">проблема не может быть воспроизведена;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">обращение содержит несколько связанных между собой проблем;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">хостинг не соответствует системным требованиям;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">вопрос задан неконкретно или диалог ведется в неконструктивной форме;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">вопрос выходит за рамки технической поддержки;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">если в течение 30 календарных дней ответ от пользователя не был получен, обращение считается обработанным автоматически.</span></p>\r\n</li>\r\n</ul>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"color: #767679;\">&nbsp;</span></p>\r\n<h2 class=\"western\"><span lang=\"ru-RU\">Услуги, которые не покрывает поддержка OkayCMS*:</span></h2>\r\n<ul>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">перенос данных с других систем;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">разработка дополнительного функционала;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">услуги по веб-разработке. Для этого обратитесь к нашим партнерам;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">web-дизайн;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">поддержка посторонних решений;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">работы по настройке сервера.&nbsp;</span></p>\r\n</li>\r\n</ul>\r\n<h2 class=\"western\"><span lang=\"ru-RU\">Если часы техподдержки закончились?</span></h2>\r\n<ol>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">Перейдите на сайт </span><span lang=\"en-US\">okay</span><span lang=\"ru-RU\">-</span><span lang=\"en-US\">cms</span><span lang=\"ru-RU\">.</span><span lang=\"en-US\">com</span><span lang=\"ru-RU\">/</span><span lang=\"en-US\">support</span><span lang=\"ru-RU\"> в раздел Техническая поддержка.</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">Приобретите необходимое количество часов техподдержки.</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">Ожидайте обновления техподдержки в админ-панели своего сайта.</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">После обновления отправьте свой запрос в техподдержку.</span></p>\r\n</li>\r\n</ol>'),
(2,	3,	'Как установить OkayCMS 2.0 на сайт',	'Как установить OkayCMS 2.0 на сайт',	'Как установить OkayCMS 2.0 на сайт',	'Шаг 1.    Файлы    для установки OkayCMS  \r\n    \r\n \r\n \r\n  Зайдите на официальный сайт OkayCMS.   \r\n \r\n \r\n  Кликните по кнопке          Скачать CMS в шапке сайта. \r\n \r\n \r\n  Сохраните файл к себе на компьютер. Сохраненный файл-архив имеет вид OkayCMS_1.0.1.zip (цифры в названии файла после слова OkayCMS могут отличаться, это зависит от скачиваемой вами версии).  \r\n \r\n \r\n  Разархивируйте файл OkayCMS_1.0.1.zip. (Кликните правой кнопкой мыши на файле и выберите пункт Извлечь в OkayCMS_1.0.1.)           \r\n \r\n \r\n',	'<p>Шаг 1. Файлы для установки OkayCMS\n    Зайдите на официальный сайт OkayCMS.\n    Кликните по кнопке Скачать CMS в шапке сайта.\n    Сохраните файл к себе на компьютер. Сохраненный файл-архив имеет вид OkayCMS_1.0.1.zip (цифры в названии файла после слова OkayCMS могут отличаться, это зависит от скачиваемой вами версии).</p>',	'<h2 class=\"western\"><strong>Шаг 1. </strong><strong><span lang=\"ru-RU\">Файлы</span></strong><strong> для установки OkayCMS</strong></h2>\r\n<p lang=\"ru-RU\" style=\"margin-bottom: 0.35cm; line-height: 115%;\"><br /><br /></p>\r\n<ol>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">Зайдите на официальный сайт OkayCMS. </span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">Кликните по кнопке</span><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">&nbsp;</span></span></span></span>Скачать CMS в шапке сайта.</p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">Сохраните файл к себе на компьютер. Сохраненный файл-архив имеет вид OkayCMS_1.0.1.zip (цифры в названии файла после слова OkayCMS могут отличаться, это зависит от скачиваемой вами версии).</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">Разархивируйте файл OkayCMS_1.0.1.zip. (Кликните правой кнопкой мыши на файле и выберите пункт Извлечь в OkayCMS_1.0.1.)</span><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">&nbsp;</span></span></span></span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">После распаковки архива появится папка OkayCMS_1.0.1, внутри которой будут 2 файла:&nbsp;install.php&nbsp;и&nbsp;okaycms.zip. Эти файлы необходимо загрузить на сервер вашего хостинг-провайдера в корень вашего сайта.</span></p>\r\n</li>\r\n</ol>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">ВНИМАНИЕ! В корень сайта необходимо поместить 2 файла, которые были извлечены из архива OkayCMS_1.0.1.zip, а не сам архив.</span></p>\r\n<h2 class=\"western\"><strong>Шаг 2. Создание базы данных</strong></h2>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"color: #767679;\">&nbsp;</span></p>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"font-family: Times New Roman,serif;\"><span style=\"font-size: medium;\"><span lang=\"ru-RU\">ВНИМАНИЕ! Далее вы будете работать с панелью управления хостинга. Существует большое количество хостинг-провайдеров. Однако</span><span lang=\"ru-RU\">&nbsp;</span><span lang=\"ru-RU\">принцип проводимых действий везде одинаковый.</span></span></span></p>\r\n<p lang=\"ru-RU\" style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><br /><br /></p>\r\n<ol>\r\n<li>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"font-family: Times New Roman,serif;\"><span style=\"font-size: medium;\"><span lang=\"ru-RU\">Зайдите в панель управления вашего хостинга и выберите пункт</span><span lang=\"ru-RU\">&nbsp;</span><span lang=\"ru-RU\">Базы данных.</span></span></span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"font-family: Times New Roman,serif;\"><span style=\"font-size: medium;\"><span lang=\"ru-RU\">Найдите и кликните</span><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">&nbsp;</span></span></span></span><strong><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">Создать базу данных</span></span></span></span></strong><span lang=\"ru-RU\">. В появившемся окне введите</span><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">&nbsp;</span></span></span></span><strong><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">имя базы данных, используя английскую раскладку</span></span></span></span></strong><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">&nbsp;</span></span></span></span><span lang=\"ru-RU\">клавиатуры. Запишите его, оно вам пригодится далее.</span></span></span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"font-family: Times New Roman,serif;\"><span style=\"font-size: medium;\"><span lang=\"ru-RU\">Выберите кодировку</span><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">&nbsp;</span></span></span></span><strong><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">utf8_general_ci</span></span></span></span></strong><span lang=\"ru-RU\">. (Иногда вместо слова Кодировка может быть слово Сравнение)</span></span></span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"font-family: Times New Roman,serif;\"><span style=\"font-size: medium;\"><span lang=\"ru-RU\">Введите имя пользователя, если оно не сгенерировалось автоматически. Так же запишите это имя, оно будет использоваться далее. </span></span></span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"font-family: Times New Roman,serif;\"><span style=\"font-size: medium;\"><span lang=\"ru-RU\">Кликните кнопку</span><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">&nbsp;</span></span></span></span><strong><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">Создать.</span></span></span></span></strong></span></span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"font-family: Times New Roman,serif;\"><span style=\"font-size: medium;\"><span lang=\"ru-RU\">Появится сообщение: база данных успешно создана.</span></span></span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"font-family: Times New Roman,serif;\"><span style=\"font-size: medium;\"><span lang=\"ru-RU\">Для доступа используйте логин ****** и пароль *******</span></span></span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"font-family: Times New Roman,serif;\"><span style=\"font-size: medium;\"><span lang=\"ru-RU\">Запишите пароль к базе данных.</span></span></span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"font-family: Times New Roman,serif;\"><span style=\"font-size: medium;\"><span lang=\"ru-RU\">Возможно, на некоторых хостингах пароль вам придется придумать самостоятельно.</span></span></span></p>\r\n</li>\r\n</ol>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\">&nbsp;</p>\r\n<h2 class=\"western\"><strong>Шаг 3. Загрузка дистрибутива на хостинг</strong></h2>\r\n<p lang=\"ru-RU\" style=\"margin-bottom: 0.35cm; line-height: 115%;\"><br /><br /></p>\r\n<ol>\r\n<li>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"font-family: Times New Roman,serif;\"><span style=\"font-size: medium;\"><span lang=\"ru-RU\">Для загрузки файлов на хостинг понадобится FTP-менеджер, например</span><span lang=\"ru-RU\">&nbsp;</span><span lang=\"ru-RU\">FileZilla,</span><span lang=\"ru-RU\">&nbsp;</span><span lang=\"ru-RU\">Total Commander. </span></span></span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"font-family: Times New Roman,serif;\"><span style=\"font-size: medium;\"><span lang=\"ru-RU\">Запустите FTP-менеджер FileZilla. Для соединения с сервером введите данные, предоставленные вашим хостинг-провайдером и нажмите кнопку Соединение</span></span></span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"font-family: Times New Roman,serif;\"><span style=\"font-size: medium;\"><span lang=\"ru-RU\">В одной из двух частей окна вашего файл-менеджера найдите папку OkayCMS, которую вы создали в Шаге1, зайдите в нее и закачайте файлы</span><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">&nbsp;</span></span></span></span><strong><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">install.php</span></span></span></span></strong><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">&nbsp;</span></span></span></span><span lang=\"ru-RU\">и</span><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">&nbsp;</span></span></span></span><strong><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">okaycms_source.zip</span></span></span></span></strong><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">&nbsp;</span></span></span></span><span lang=\"ru-RU\">на сервер в корень сайта. (Кликните правой кнопкой мыши на файле и выберите</span><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">&nbsp;</span></span></span></span><strong><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">Закачать на сервер</span></span></span></span></strong><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">&nbsp;</span></span></span></span><span lang=\"ru-RU\">или просто перетащите файлы мышкой с левой в другую часть окна).</span></span></span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"font-family: Times New Roman,serif;\"><span style=\"font-size: medium;\"><span lang=\"ru-RU\">На этом работа с FTP-менеджером FileZilla закончена.</span></span></span></p>\r\n</li>\r\n</ol>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"color: #767679;\">&nbsp;</span></p>\r\n<h2 class=\"western\"><a name=\"_GoBack\"></a><strong><span lang=\"ru-RU\">Шаг 4. Завершающий этап установки</span></strong></h2>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">Далее читайте Инструкцию в <a href=\"https://okay-cms.com/article/kak-ustanovit-okaycms-na-sajt\">блоге OkayCMS</a>.</span></p>'),
(2,	4,	'OkayCMS 2.2.0',	'OkayCMS 2.2.0',	'OkayCMS 2.2.0',	'Почти год мы работали над улучшением OkayCMS. Куда еще лучше? спроосите вы, а вот мы нашли. Технологии все время развиваются, и мы не хотим отставать. Наша цель вести свою систему к простоте и функциональности, своевременно удовлетворять запросы пользователей. Поэтому обновление принесло в OkayCMS новые полезные штуки и унесло неиспользуемый функционал и какие-то недочеты, которые в том числе и вы нам помогали искать. Что же в итоге получилось, узнаете из текста. \r\n     \r\n  Улуч',	'<p>Почти год мы работали над улучшением OkayCMS. Куда еще лучше? спроосите вы, а вот мы нашли. Технологии все время развиваются, и мы не хотим отставать. Наша цель вести свою систему к простоте и функциональности, своевременно удовлетворять запросы пользователей. Поэтому обновление принесло в OkayCMS новые полезные штуки и унесло неиспользуемый функционал и какие-то недочеты, которые в том числе и вы нам помогали искать. Что же в итоге получилось, узнаете из текста.&nbsp;</p>',	'<p><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt; color: #000000;\">Почти год мы работали над улучшением OkayCMS. &laquo;Куда еще лучше?&raquo; &ndash; спроосите вы, а вот мы нашли. Технологии все время развиваются, и мы не хотим отставать. Наша цель &ndash; вести свою систему к простоте и функциональности, своевременно удовлетворять запросы пользователей. Поэтому обновление принесло в OkayCMS новые полезные штуки и унесло неиспользуемый функционал и какие-то недочеты, которые в том числе и вы нам помогали искать. Что же в итоге получилось, узнаете из текста.</span></p>\r\n<p><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">&nbsp;</span></p>\r\n<h2><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt; color: #003366;\">Улучшения SEO в OkayCMS 2.2.0</span></h2>\r\n<ul>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Появились шаблоны описаний для страниц с фильтрами. Можно задавать мета-теги для страниц:</span></li>\r\n</ul>\r\n<ul style=\"list-style-type: circle;\">\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">категория+бренд</span></li>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">категория+свойство</span></li>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">категория+определенное свойство</span></li>\r\n</ul>\r\n<p style=\"text-align: center;\"><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\"><img src=\"../files/uploads/seo-filtr.png\" alt=\"новый seo-фильтр\" width=\"1918\" height=\"908\" /></span></p>\r\n<p><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt; color: #000000;\">Для каждого свойства в новой версии доступны варианты слова (падежи и синонимы), которые позже можно использовать для заполнения метаданных фильтров.</span></p>\r\n<p style=\"text-align: center;\"><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\"><img src=\"../files/uploads/varianty_slova_dlya_seo.png\" alt=\"варианты слов\" width=\"1038\" height=\"602\" /></span></p>\r\n<p><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt; color: #000000;\">В ближайшее время мы напишем подробную статью, посвященную данному функционалу.</span></p>\r\n<ul>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Чтобы перелинковка была более качественной, теперь можно делать свойство в товаре ссылкой на страницу фильтра &lt;категория +это свойство&gt;<img src=\"../files/uploads/svoistvo_ssylkoi.jpg\" alt=\"свойство ссылкой\" width=\"1062\" height=\"655\" /></span></li>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Изменилась работа ЧПУ-фильтра: теперь индексируется категория+одно значение фильтра, остальное &ndash; нет</span></li>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Для страниц, которые создаются через админпанель, появилась возможность задавать отдельный от названия страницы Н1 прямо в админке</span></li>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Sitemap.xml теперь более универсальный и сам создает пагинацию карт сайта, когда количество ссылок в нем превышает 50 000</span></li>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Улучшена микроразметка, добавлена разметка twittercard</span></li>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Настроен 301-й редирект со страниц с \"/page-1\" на основную страницу категории</span></li>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Убрано дублирование текста на страницах фильтров, сортировок и пагинации. Текст категории выводится после обновления только на основной странице категории</span></li>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">В title при пагинации теперь автоматически подставляется номер страницы<img src=\"../files/uploads/schetchik_v_title.jpg\" alt=\"счетчик в title\" width=\"1273\" height=\"140\" /></span></li>\r\n<li></li>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif;\"><span style=\"font-size: 16px;\">Для индексации теперь доступны только страницы фильтрации категория+бренд или категория+1 свойство.</span></span></li>\r\n</ul>\r\n<p><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">&nbsp;</span></p>\r\n<h2><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt; color: #000080;\">Улучшения для посетителей сайта на OkayCMS 2.2.0</span></h2>\r\n<ul>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Переверстана страница thank you page. Она стала более информативной для покупателя и правильной с точки зрения e-commerce</span></li>\r\n</ul>\r\n<p><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\"><img src=\"../files/uploads/thank_you_page.jpg\" alt=\"страница оформленного заказа\" width=\"1366\" height=\"768\" /></span></p>\r\n<ul>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">В категориях появилась возможность отфильтровать по рекомендуемым товарам или товарам со скидкой<img src=\"../files/uploads/filtr_skidki.png\" alt=\"фильтр по скидкам и хитам\" width=\"1174\" height=\"402\" /></span></li>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Слева над фильтром теперь будут подкатегории</span></li>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Переделано отображение страницы ошибки 404</span></li>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Старая цена теперь лучше выделяется за счет того, что она перечеркнута</span></li>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Комментарии администратора также лучше выделяются среди комментариев обычных пользователей</span></li>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Сделано корректное определение варианта в наличии в Safari. Проблема была описана <a href=\"https://forum.okay-cms.com/viewtopic.php?f=7&amp;t=869&amp;sid=8a990552ca19ef5b94b8aa32037ba38f\">в теме на форуме</a></span></li>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Исправлена ошибка, когда в редких случаях после применения фильтра некорректно отображался каталог<img src=\"../files/uploads/oshibka_filtra_po_cene.png\" alt=\"ошибка верстки после фильтрации\" width=\"400\" height=\"326\" /></span></li>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Исправлена верстка корзины для мобильных устройств</span></li>\r\n</ul>\r\n<p><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\"><img src=\"../files/uploads/osibka_mobilnoi_korziny.png\" alt=\"ошибка верстки мобильной корзины\" width=\"439\" height=\"229\" />&nbsp;</span></p>\r\n<p><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">&nbsp;</span></p>\r\n<h2><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt; color: #003366;\">Улучшения в новой версии OkayCMS для администраторов сайта</span></h2>\r\n<ul>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Теперь есть возможность создавать несколько меню и добавлять к пунктам свои ссылки</span></li>\r\n</ul>\r\n<p><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt; color: #000000;\">Можно добавлять и удалять&nbsp; подпункты меню, вставлять ссылки на текущий сайт (при этом они автоматически преобразуются в относительные) и на другие сайты, задать открытие в новой вкладке, просто перетянув ползунок.</span></p>\r\n<p><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\"><img src=\"../files/uploads/svoe_menu.png\" alt=\"кастомное меню\" width=\"1030\" height=\"302\" /></span></p>\r\n<p><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt; color: #000000;\">Собственные меню можно выводить в любом месте шаблона.</span></p>\r\n<ul>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Вставлять скрипты стало проще</span></li>\r\n</ul>\r\n<p><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt; color: #000000;\">Мы переделали раздел SEO: теперь вам нужно только дать название скрипту, выбрать из выпадающего списка, куда его вставлять, добавить код в специальное поле и сохранить. Любой из них можно изменить или удалить.</span></p>\r\n<ul>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Сделан функционал добавления разных цветов к статусам заказа, чтобы легче ориентироваться в списке заказов. Реализовано на основе <a href=\"https://forum.okay-cms.com/viewtopic.php?f=6&amp;t=775&amp;p=3980#p3980\">пожелания с форума</a></span></li>\r\n</ul>\r\n<p><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\"><img src=\"../files/uploads/cveta_statusa_zakaza.png\" alt=\"разноцветные статусы заказа\" width=\"1038\" height=\"606\" /></span></p>\r\n<ul>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Появился экспорт заказов в csv для дальнейшего импорта в сервисы рассылок e-mail, SMS и т.п. Выгружать можно по статусу, по меткам, по дате заказов</span></li>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">В админпанель добавлен фильтр по необработанным комментариям, заказам обратного звонка и обращениям с формы обратной связи</span></li>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Сделана возможность искать информацию в комментариях и обратной связи. Поиск проходит по сообщениям, имени и e-mail<img src=\"../files/uploads/poisk_i_sortirovka.png\" alt=\"поиск по обратной связи\" width=\"1258\" height=\"446\" /></span></li>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Теперь можно выбрать количество отображаемых комментариев и сообщений обратной связи на одной странице</span></li>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Вместо стандартной капчи можно будет использовать reCAPTCHA или reCAPTCHA invisible, активировав нужную в настройках сайта<img src=\"../files/uploads/recaptcha.png\" alt=\"recaptcha\" width=\"1327\" height=\"307\" /></span></li>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Сделана возможность включать и отключать автоматическое одобрение комментариев</span></li>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Теперь добавить карту на страницу контактов можно просто вставкой iframe в специальное поле<img src=\"../files/uploads/vstavka_karty.png\" alt=\"вставка карты в контакты\" width=\"1326\" height=\"195\" /></span></li>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Заблокировано удаление или изменение URL для системных страниц</span></li>\r\n</ul>\r\n<p><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt; color: #000000;\">Это сделано для избежания ошибок, которые возникают вследствие изменения адреса или удаления страниц типа главная, бренды, 404 и т.п. Даже при попытке массового удаления страниц, появится уведомление.</span></p>\r\n<p><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\"><img src=\"../files/uploads/blok_sistemnyh_url.png\" alt=\"блокировка системных URL\" width=\"1903\" height=\"716\" /></span></p>\r\n<ul>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Сделано форматирование сообщений в техподдержке</span></li>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Сделан счетчик символов в meta title и description</span></li>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Добавлено отображение фильтров в админпанели на мобильных устройствах</span></li>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">При экспорте категории для облегчения работы с файлом экспорта теперь выгружаются только свойства этой категории, а не все доступные</span></li>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Исправлены ошибки, возникающие при попытке изменить порядок категорий в товаре: порядок не менялся, не всплывала кнопка &laquo;Применить&raquo;</span></li>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Нельзя было задать порядок фото до сохранения товара. Теперь можно</span></li>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Также при изменении порядка фото не появлялась кнопка &laquo;Применить&raquo;. Уже исправили</span></li>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Убрана в админпанели ненужная часть комментария админа<img src=\"../files/uploads/nenuzhny_komment.png\" alt=\"ненужная часть комментария\" width=\"986\" height=\"607\" /></span></li>\r\n</ul>\r\n<ul>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Удалены редкоиспользуемые разделы \"Яндекс.Метрика для сайта\" и \"Импорт/экспорт переводов\"</span></li>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Поле \"Активность\" в разделе \"Свойства\" теперь называется более понятно &ndash; \"В фильтре\"</span></li>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">При импорте товаров из 1С основное и дополнительные фото теперь обрабатываются более корректно.</span></li>\r\n</ul>\r\n<p><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">&nbsp;</span></p>\r\n<h2><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt; color: #003366;\">Улучшения для разработчиков в OkayCMS 2.2.0</span></h2>\r\n<ul>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Сделана возможность включать отдельную тему для админа</span></li>\r\n</ul>\r\n<p><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt; color: #000000;\">Когда она активирована, все действия в пунктах: &laquo;Файлы шаблонов&raquo;, &laquo;Стили шаблонов&raquo;, &laquo;Скрипты&raquo;, &laquo;Изображения&raquo;, &laquo;Переводы&raquo; &ndash;&nbsp; выполняются в теме для админа.</span></p>\r\n<ul>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Когда активирована тема для админа, в версию всех скриптов и стилей подставляется время. В теме ничего не будет кешироваться, т.к. она нужна для разработки</span></li>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Добавлена возможность сбросить кеш шаблона</span></li>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Для избежания проблем с некорректным наложением водяного знака теперь подключена библиотека обработки изображений gregwar</span></li>\r\n</ul>\r\n<p><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt; color: #000000;\">Новая библиотека gregwar имеет широкие возможности ресайза, обрезки и позиционирования картинок, позволяет обрабатывать изображение одной строкой, управлять кешированием и много новых крутых вещей.</span></p>\r\n<p><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt; color: #000000;\">Например, иногда нужно все картинки сделать одного размера (даже пренебречь небольшой частью изображения). Т.е. широкие и высокие привести к единому форм-фактору, как здесь:</span></p>\r\n<p style=\"text-align: center;\"><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt; color: #000000;\"><img src=\"../files/uploads/podgon-kartinok.png\" alt=\"ресайз картинок\" width=\"839\" height=\"310\" /></span></p>\r\n<p><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt; color: #000000;\">Для этого в параметрах ресайза нужно указать 5-й и 6-й параметры {$c-&gt;image|resize:140:140:false:$config-&gt;resizedcategoriesdir:center:top}:</span></p>\r\n<ul style=\"list-style-type: circle;\">\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">5-й параметр отвечает за положение результирующего изображения, если работали с широкой картинкой. Возможные значения: left, center, right</span></li>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">6-й параметр отвечает за положение результирующего изображения, если работали с высокой картинкой. Возможные значения: top, center, bottom</span></li>\r\n</ul>\r\n<p><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt; color: #000000;\">В отдельной статье мы детально расскажем, как работать с новой библиотекой.</span></p>\r\n<ul>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Сборка PHP библиотек gregwar, smarty, mobiledetect и phpmailer теперь осуществляется через composer</span></li>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Теперь можно задавать ресайз для баннеров</span></li>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Сделана возможность добавлять config/config.local.php, в котором можно переопределить любую директиву из обычного config-а</span></li>\r\n</ul>\r\n<p><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt; color: #000000;\">Это удобно, когда проект на Git, и часть config.php нужно добавить в игнор.</span></p>\r\n<ul>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">В config/config.php сделана директива sql_debug = true, которая включает логирование нерабочих запросов</span></li>\r\n</ul>\r\n<p><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt; color: #000000;\">Она включена по умолчанию, но можно и выключить. Логи собираются в файл log/sql.log. Папка закрыта в htaccess, просматривать можно только по FTP.</span></p>\r\n<ul>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Улучшено определение пути к карте сайта для более легкой настройки действий по крону</span></li>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">В раздел системной информации добавлен IP-адрес, с которого осуществляются curl-запросы</span></li>\r\n</ul>\r\n<p><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt; color: #000000;\">Нужно для корректной работы техподдержки, т.к. некоторые хостинги блокируют обращения с определенных IP. Для разблокировки нужно знать IP, теперь его удобно посмотреть в админке.</span></p>\r\n<ul>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Метод отправки e-mail админу перенесен из Callback.php в Notify.php</span></li>\r\n</ul>\r\n<p><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">&nbsp;</span></p>\r\n<h2><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt; color: #003366;\">Исправление ошибок в новой версии OkayCMS</span></h2>\r\n<ul>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Исправлены проблемы, проявлявшиеся при работе с MySQL версии 5.7</span></li>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Исправлена проблема с сохранением свойств, описанная на форуме в <a href=\"https://forum.okay-cms.com/viewtopic.php?p=4217#p4217\">теме</a></span></li>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Исправлено несколько ошибок, связанных с переключением языка на странице 404</span></li>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Исправлена проблема с отображением каталога на планшетах с большим разрешением (&gt;992px), при которой меню каталога не срабатывало по нажатию.</span></li>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Исправлена ситуация, когда картинка была доступна по разным URL</span></li>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Исправлена 500 ошибка при попытке открыть несуществующее изображение</span></li>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">При редактировании заказа, если поменять способ доставки \"Оплачивается отдельно\" на другой, не считалась стоимость.&nbsp;Сейчас проблему устранили. Описание есть <a href=\"https://forum.okay-cms.com/viewtopic.php?f=7&amp;t=808&amp;p=4170#p4170\">на форуме</a></span></li>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Исправлена ошибка, когда при клике на плюсик в корзине нельзя было добавить больше 50 товаров в заказ</span></li>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">В текущей версии можно удалить изображение в баннере (раньше нужно было только заменять его на другое)</span></li>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Оптимизировано удаление валют из БД при включенной мультиязычности сайта</span></li>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Оптимизирован запрос search_products.php</span></li>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Убраны дублирующиеся элементы в верстке админпанели</span></li>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Исправлена проблема, при которой пароль для базы данных со спецсимволами не принимался системой</span></li>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Исправлена работа сортировки по цене после применения фильтра по цене</span></li>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Убраны ссылки на страницы с 302-м редиректом, которые появлялись при включении более чем одной валюты на сайте</span></li>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Исправлена ошибка при сохранении JS в админке</span></li>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Исправлена работа кнопки \"Печать заказа\". Больше не появляется ошибка 500</span></li>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Раньше к комментариям на странице грузились все ответы на все возможные комментарии</span></li>\r\n</ul>\r\n<p><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt; color: #000000;\">Мы оптимизировали код, и теперь для 20 комментариев на странице загрузятся только их ответы.</span></p>\r\n<ul>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Исправили баг в \"Обратной связи\"</span></li>\r\n</ul>\r\n<p><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt; color: #000000;\">Если одобрить фидбек, но не написать ответ, то его больше нельзя будет написать. Сделали так, что ответов можно писать любое количество.</span></p>\r\n<ul>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Исправили баг в подсчете кол-ва заказов при использовании фильтра по дате</span></li>\r\n</ul>\r\n<p><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt; color: #000000;\">Раньше после фильтрации всегда показывало 0 заказов. Сейчас подсчет корректный.</span></p>\r\n<ul>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Исправлена ситуация, когда на второй странице пагинации в админпанели не отображались ответы на комментарии</span></li>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Исправлено несоответствие название поля в админке с его содержанием<img src=\"../files/uploads/oshibka_nazvania_polya.jpg\" alt=\"неправильное название поля\" width=\"994\" height=\"312\" /></span></li>\r\n</ul>\r\n<p><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">&nbsp;</span></p>\r\n<p><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt; color: #000000;\">Как видите, теперь OkayCMS стала еще красивее с подправленной версткой, глобально изменился SEO-раздел, в системе сделали много новых удобностей и учли ваши замечания. Продолжайте держать с нами обратную связь &ndash; мы уже планируем следующую версию.</span></p>'),
(2,	5,	'OkayCMS 3.0',	'OkayCMS 3.0',	'OkayCMS 3.0',	'OKAY CMS 3 Released \r\n Our team has been working on the new version of OkayCMS 3.0.0 for a long time. The changes included in the new version significantly expanded the functionality. \r\n Many global changes have been implemented with a completely redesigned kernel and completely updated program code. We hope you appreciate our work and new features of the system. \r\n \r\n \r\n \r\n 1. New design \r\n  \r\n The new design is designed to meet all usability requirements for online stores. \r\n \r\n \r\n \r\n 2. Training Section ',	'<p>Our team has been working on the new version of OkayCMS 3.0.0 for a long time. The changes included in the new version significantly expanded the functionality. Many global changes have been implemented with a completely redesigned kernel and completely updated program code. We hope you appreciate our work and new features of the system;</p>',	'<h3 style=\"text-align: center;\">OKAY CMS 3 Released</h3>\r\n<p>Our team has been working on the new version of OkayCMS 3.0.0 for a long time. The changes included in the new version significantly expanded the functionality.</p>\r\n<p>Many global changes have been implemented with a completely redesigned kernel and completely updated program code. We hope you appreciate our work and new features of the system.</p>\r\n<div class=\"table\">\r\n<div class=\"table__row\">\r\n<div class=\"table__cell\">\r\n<h5>1. New design</h5>\r\n<figure><img src=\"../files/uploads/article_okay_design.jpg\" alt=\"\" width=\"800\" height=\"800\" />\r\n<figcaption>The new design is designed to meet all usability requirements for online stores.</figcaption>\r\n</figure>\r\n</div>\r\n<div class=\"table__cell\">\r\n<h5>2. Training Section</h5>\r\n<figure><img src=\"../files/uploads/article_okay_learning%20(1).jpg\" alt=\"Okaycms Learning\" width=\"800\" height=\"800\" />\r\n<figcaption>A new training section, which contains instructions for basic work on the site.</figcaption>\r\n</figure>\r\n</div>\r\n<div class=\"table__cell\">\r\n<h5>2. Modularity</h5>\r\n<figure><img src=\"../files/uploads/article_okay_module.jpg\" alt=\"OkaycmsModules\" width=\"800\" height=\"800\" />\r\n<figcaption>Completely redesigned structure, the appearance of modularity</figcaption>\r\n</figure>\r\n</div>\r\n<div class=\"table__cell\">\r\n<h5>2. Setting site colors</h5>\r\n<figure><img src=\"../files/uploads/article_okay_settings.jpg\" alt=\"Okaycms Settings\" width=\"800\" height=\"799\" />\r\n<figcaption>A new block has appeared in the design settings for setting site colors</figcaption>\r\n</figure>\r\n</div>\r\n</div>\r\n</div>\r\n<h3 style=\"text-align: center;\">Why did we go for such a global change?</h3>\r\n<p><strong>First</strong>. The basis of the first and second versions of OkayCMS was made using the old code. At the time of the creation of our system, in 2015, the code that was used was still relevant, but entering 2020 with what was - is not good.</p>\r\n<p><strong>Second one</strong> Problems with expanding the functionality of the store. Due to the fact that previous versions of the system were not modular, when it was necessary to expand the functionality globally, all changes were made immediately to the kernel and this created complex code. All subsequent improvements to such a project were implemented more and more difficult. Now, with the transition to modularity, this problem will be partially solved.</p>\r\n<p><strong>Third.</strong> System updates. This problem partially arises from the second. When improvements touched the core of the system, updating the modified system was problematic. In some cases, it was more reasonable to refuse updates to a highly modified system. Now that the work will be carried out separately from the kernel, system updates should be faster and more painless.</p>\r\n<p><strong>Fourth.</strong> Convenience for new users. The basis for successful development is a good community around the product. The code of previous versions was simple, convenient, but still specific, not using patterns and made \"in its own way.\" The problem that arose from this, to new programmers who started their education with developers with frameworks like Laravel, the system seemed immediately incomprehensible and they did not really want to undertake to make small improvements on it. The new version of the system is more consistent with the main trends in the programming world and should make a simpler entry threshold for new programmers, new web studios, etc. who decide to use our system in their work.</p>\r\n<h3 style=\"text-align: center;\">How to upgrade from previous versions of OkayCMS to version 3. *?</h3>\r\n<p>OkayCMS 3 is a system with a completely redesigned kernel and completely updated program code, so templates and modules from previous versions are incompatible.</p>\r\n<p>All license holders of the Pro version of OkayCMS can order the transfer of their data to the new version or, in the case of a large number of improvements and individual templates, stay on version 2. * which we will continue to support and for which we will release updates containing fixes for comments about which we will know. Transferring data to version 3. * from previous versions will take 1 hour of technical support.</p>\r\n<p>In the case of transferring data to the new version, we will transfer to version 3. * all your products, categories, brands, pages, blog entries, orders and registered customers. After the transfer, you will receive a site with all the functionality of the OkayCMS version 3. * design of version 3. * and the contents of the database from your site on the previous version of OkayCMS. To order an upgrade to 3.0, write to us at info@okay-cms.com or contact technical support from the admin. panels.</p>'),
(2,	6,	'Инструкция по оформлению статей',	'Инструкция по оформлению статей',	'Инструкция по оформлению статей, Новости',	'Заголовки  \r\n Наличие заголовков  &lt;h1&gt;  &mdash;  &lt;h6&gt;  в статьях важны для SEO оптимизации. Поисковые роботы их сканируют, и на основе ключевой информации в статях, формируют выдачу . Они также отвечают за структуру страницы и ранжируются по приоритету важности. \r\n Заголовок  &lt;h1&gt;  - это всегда название статьи и на странице он должен быть только один. В статьях важные разделы лучше разделяйте заголовками  &lt;h2&gt;  и всегда соблюдайте иерархию вложенности. Не допускайте, чтобы заголовок ',	'',	'<h2><strong>Заголовки</strong></h2>\r\n<p>Наличие заголовков <strong>&lt;h1&gt;</strong> &mdash; <strong>&lt;h6&gt; </strong>в статьях важны для SEO оптимизации. Поисковые роботы их сканируют, и на основе ключевой информации в статях, формируют выдачу . Они также отвечают за структуру страницы и ранжируются по приоритету важности.</p>\r\n<p>Заголовок <strong>&lt;h1&gt;</strong> - это всегда название статьи и на странице он должен быть только один. В статьях важные разделы лучше разделяйте заголовками <strong>&lt;h2&gt; </strong>и всегда соблюдайте иерархию вложенности. Не допускайте, чтобы заголовок младшего уровня стоял выше старшего!</p>\r\n<blockquote>\r\n<p>Кстати в системе <strong>OkayCMC</strong> оглавления в статьях строится на заголовках. Вам не нужно их создавать вручную и прописывать им якоря. Оглавление для статьи формируется автоматически с якорями на нужный раздел.</p>\r\n</blockquote>\r\n<p>&nbsp;</p>\r\n<h2><strong>Оформление маркированного и нумированного списков</strong></h2>\r\n<p>Часто в статьях приходиться как то выделить набор отдельных фраз или предложений, которые начинаются с маркера или цифры. В таких случаях лучший способ использовать списки. С их помощью можно упорядочить и систематизировать разные данные и представить их в наглядном и удобном для пользователя виде. В примерах ниже приведены варианты оформлений, как по умолчанию, так и дополнительного вида.</p>\r\n<div>&nbsp;</div>\r\n<h3>Нумированный список по умолчанию:</h3>\r\n<ol>\r\n<li>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Lorem ipsum dolor sit amet, consectetur adipiscing elit.</li>\r\n<li>In eget velit vulputate, aliquam tellus vel, cursus purus.</li>\r\n<li>Curabitur fermentum justo quis sem lacinia, pharetra bibendum purus congue.</li>\r\n<li>Curabitur tempor enim quis lobortis tristique.</li>\r\n<li>Praesent blandit turpis sed odio accumsan, a scelerisque risus ornare.</li>\r\n</ol>\r\n<p>&nbsp;</p>\r\n<h3>Маркированного списка по умолчанию:</h3>\r\n<ul>\r\n<li>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Lorem ipsum dolor sit amet, consectetur adipiscing elit.</li>\r\n<li>In eget velit vulputate, aliquam tellus vel, cursus purus.</li>\r\n<li>Curabitur fermentum justo quis sem lacinia, pharetra bibendum purus congue.</li>\r\n<li>Curabitur tempor enim quis lobortis tristique.</li>\r\n<li>Praesent blandit turpis sed odio accumsan, a scelerisque risus ornare.</li>\r\n</ul>\r\n<p>&nbsp;</p>\r\n<h2 id=\"5\"><strong>Изображения и видео</strong></h2>\r\n<p>Чтобы Ваша статья смотрелась более презентабельной, оформляйте её различными изображениями, иллюстрациями, подходящие по смыслу к абзацу или заголовку . Добавляйте картинки как полным изображением, так и слайдером.</p>\r\n<p>В текстовом редакторе для изображений, добавлены несколько классов для их оформления. Если изображению добавить класс <strong>image_zoom</strong>, то по клику на него, откроется модальное окно с увеличенной версией этого изображения.</p>\r\n<p>Классы <strong>image_slider</strong> и<strong> image_gallery </strong>формируют карусель из загруженных друг за другом изображений. Главное различие между ними в том, что <strong>image_gallery</strong> формирует карусель из трех слайдов, в <strong>image_slider </strong>из одного.</p>'),
(3,	1,	'Основные изменения в OkayCMS 2.0',	'Основные изменения в OkayCMS 2.0',	'Основные изменения в OkayCMS 2.0',	'1.        Административная панель.        Абсолютно новый дизайн, структура и верстка согласно современным подходам. Теперь админ-панель более дружелюбная, понятная и удобная для пользователя. Предусмотрено место для размещения нового функционала, доработок и модулей. Главный козырь новой админки &ndash; ее адаптивность. Вносить корректировки, обрабатывать заказы, отвечать на запросы теперь удобно с любого устройства.    \r\n   2.        Техническая поддержка OkayCMS.        В админ-панель внедрен функционал ',	'<p>1. Административная панель. Абсолютно новый дизайн, структура и верстка согласно современным подходам. Теперь админ-панель более дружелюбная, понятная и удобная для пользователя. Предусмотрено место для размещения нового функционала, доработок и модулей. Главный козырь новой админки &ndash; ее адаптивность. Вносить корректировки, обрабатывать заказы, отвечать на запросы теперь удобно с любого устройства.</p>',	'<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span style=\"color: #000000;\"><span lang=\"ru-RU\">1. </span></span><span style=\"color: #4f81bd;\"><span style=\"font-family: Cambria,serif;\"><span style=\"font-size: medium;\"><strong><span style=\"color: #000000;\">Административная панель. </span></strong></span></span></span><span style=\"color: #000000;\"><span lang=\"ru-RU\">Абсолютно новый дизайн, структура и верстка согласно современным подходам. Теперь админ-панель более дружелюбная, понятная и удобная для пользователя. Предусмотрено место для размещения нового функционала, доработок и модулей. Главный козырь новой админки &ndash; ее адаптивность. Вносить корректировки, обрабатывать заказы, отвечать на запросы теперь удобно с любого устройства. </span></span></p>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span style=\"color: #000000;\"><span lang=\"ru-RU\">2. </span></span><span style=\"color: #4f81bd;\"><span style=\"font-family: Cambria,serif;\"><span style=\"font-size: medium;\"><strong><span style=\"color: #000000;\">Техническая поддержка OkayCMS. </span></strong></span></span></span><span style=\"color: #000000;\"><span lang=\"ru-RU\">В админ-панель внедрен функционал для связи с техподдержкой </span></span><span style=\"color: #000000;\"><span lang=\"en-US\">OkayCMS</span></span><span style=\"color: #000000;\"><span lang=\"ru-RU\">. Теперь вам не нужно звонить, писать на почту или скайп. Задать вопросы, получить консультацию, помощь в установке </span></span><span style=\"color: #000000;\"><span lang=\"en-US\">CMS</span></span><span style=\"color: #000000;\"><span lang=\"ru-RU\">, шаблона или дополнения можно прямо из административной панели, отправив запрос в техподдержку. Это поможет нам быстрее отвечать на ваши вопросы, а история переписок по всем темам всегда будут храниться в одном месте - у вас в админке. <a href=\"https://okay-cms.com/support\">Подробнее о техподдержке</a>. </span></span></p>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span style=\"color: #000000;\"><span lang=\"ru-RU\">В 2.0 пользователь лицензионной </span><span lang=\"en-US\">OkayCMS</span> <span lang=\"en-US\">Pro</span><span lang=\"ru-RU\"> получит 10 часов бесплатной техподдержки, пользователь </span><span lang=\"en-US\">OkayCMS</span> <span lang=\"en-US\">Lite</span><span lang=\"ru-RU\"> &ndash; 30 минут с возможностью докупить часы техподдержки. </span></span></p>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span style=\"color: #000000;\"><span lang=\"ru-RU\">3. </span></span><span style=\"color: #4f81bd;\"><span style=\"font-family: Cambria,serif;\"><span style=\"font-size: medium;\"><strong><span style=\"color: #000000;\">Мультиязычнсть сайта. </span></strong></span></span></span><span style=\"color: #000000;\"><span lang=\"ru-RU\">Переделана мультиязычность клиентской части и добавлена мультиязычность админ-панели. Теперь переводы статических фраз хранятся не в базе данных, а в файлах. Для клиентской части это упрощает установку новых тем и возможность переключения между ними. Для обеих частей (как админки, так и клиентской) это облегчает перевод сайта на другие языки. Теперь сделать сайт для клиента полностью на иностранном языке не составляет проблемы. Для этого необходимо перевести фразы всего в двух файлах. На момент релиза в </span></span><span style=\"color: #000000;\"><span lang=\"en-US\">OkayCMS</span></span><span style=\"color: #000000;\"><span lang=\"ru-RU\"> 2.0 добавлено два языка для административной панели - русский и английский, но в ближайшее время их количество увеличится.</span></span></p>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span style=\"color: #000000;\"><span lang=\"ru-RU\">4. </span></span><span style=\"color: #4f81bd;\"><span style=\"font-family: Cambria,serif;\"><span style=\"font-size: medium;\"><strong><span style=\"color: #000000;\">Новый дефолтный шаблон.</span></strong></span></span></span><span style=\"color: #000000;\"><span lang=\"ru-RU\"> Код шаблона теперь чище и приятнее для разработчиков, детальнее прокомментирован. Сам шаблон теперь позволяет добавлять большое количество категорий.</span></span></p>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span style=\"color: #000000;\"><span lang=\"ru-RU\">5. </span></span><span style=\"color: #4f81bd;\"><span style=\"font-family: Cambria,serif;\"><span style=\"font-size: medium;\"><strong><span style=\"color: #000000;\">PHP 7.</span></strong></span></span></span><span style=\"color: #000000;\"><span lang=\"ru-RU\"> Полная поддержка PHP 7, которая позволит позволит сайтам на OkayCMS работать быстрее.</span></span></p>'),
(3,	2,	'Как работает техподдержка OkayCMS 2.0',	'Как работает техподдержка OkayCMS 2.0',	'Как работает техподдержка OkayCMS 2.0',	'Приобретая лицензию OkayCMS Pro 2.0, вы получаете 10 часов комплексной поддержки и консультаций по работе с OkayCMS. Предлагаем более подробно ознакомиться с видами консультаций и регламентом работы службы поддержки.  \r\n  Специалисты технической поддержки выполняют следующие работы:  \r\n \r\n \r\n  дают консультации о системных требованиях для оптимальной работы системы;  \r\n \r\n \r\n  дают консультации по работе c OkayCMS для администратора магазина;  \r\n \r\n \r\n  предоставляют консультации по внедрению дополнительног',	'<p>Приобретая лицензию OkayCMS Pro 2.0, вы получаете 10 часов комплексной поддержки и консультаций по работе с OkayCMS. Предлагаем более подробно ознакомиться с видами консультаций и регламентом работы службы поддержки.</p>',	'<p><span lang=\"ru-RU\">Приобретая лицензию OkayCMS Pro 2.0, вы получаете 10 часов комплексной поддержки и консультаций по работе с OkayCMS. Предлагаем более подробно ознакомиться с видами консультаций и регламентом работы службы поддержки.</span></p>\r\n<h2 class=\"western\"><span lang=\"ru-RU\">Специалисты технической поддержки выполняют следующие работы:</span></h2>\r\n<ul>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">дают консультации о системных требованиях для оптимальной работы системы;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">дают консультации&nbsp;по работе c OkayCMS для администратора магазина;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">предоставляют консультации по внедрению дополнительного функционала в OkayCMS;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">оказывают помощь в установке OkayCMS на хостинг;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">проводят установку шаблонов и дополнений из</span><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">&nbsp;</span></span></span></span><a href=\"https://okay-cms.com/catalog/dopolneniya\"><span style=\"color: #38c0f3;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">MarketPlace OkayCMS</span></span></span></span></a><span lang=\"ru-RU\">;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">проводят обновление OkayCMS до последней актуальной версии.</span></p>\r\n</li>\r\n</ul>\r\n<h2 class=\"western\"><span lang=\"ru-RU\">Регламент работы:</span></h2>\r\n<ol>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">В административной панели вашего сайта на OkayCMS в разделе \"Техническая поддержка\" создайте новое обращение.</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">Подробно опишите проблему и сформулируйте название обращения. После этого подайте обращение на рассмотрение.&nbsp;</span><strong><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">Внимание! Одно обращение в службу поддержки должно содержать одну проблему, не пишите несколько проблем в одном обращении.</span></span></span></span></strong></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">Следите за </span><span lang=\"en-US\">E</span><span lang=\"ru-RU\">mail-уведомлениями о прогрессе решения вашего вопроса в течении одного рабочего дня. Ответ так же будет отображен в админ-панели вашего сайта.</span></p>\r\n</li>\r\n</ol>\r\n<h2 class=\"western\"><span lang=\"ru-RU\">Что может повлиять на время решения вашего запроса?</span></h2>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">Для ускорения реакции на ваше обращение мы советуем следовать простым правилам:</span></p>\r\n<ul>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">подробно описывайте проблему, шаги к ее воспроизведению;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">укажите реквизиты доступа в административную часть вашего сайта;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">укажите актуальные доступы к FTP и СУБД (PHPMyAdmin), если для решения проблемы необходимо вмешательство в исходный код;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">предоставьте информацию о версии продукта.</span></p>\r\n</li>\r\n</ul>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">Дополнительно службой поддержки может быть затребована информация о настройках ПО, а также информация для доступа к серверу по FTP, SSH или административной панели хостинг-провайдера.</span></p>\r\n<h2 class=\"western\"><span lang=\"ru-RU\">Обработка обращения прекращается в случае:</span></h2>\r\n<ul>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">если пользователь не может дать затребованную агентом поддержки информацию для решения вопроса;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">клиент не может предоставить доступы к сайту (FTP, SSH, панель управления хостингом и т. д.);</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">проблема не может быть воспроизведена;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">обращение содержит несколько связанных между собой проблем;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">хостинг не соответствует системным требованиям;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">вопрос задан неконкретно или диалог ведется в неконструктивной форме;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">вопрос выходит за рамки технической поддержки;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">если в течение 30 календарных дней ответ от пользователя не был получен, обращение считается обработанным автоматически.</span></p>\r\n</li>\r\n</ul>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"color: #767679;\">&nbsp;</span></p>\r\n<h2 class=\"western\"><span lang=\"ru-RU\">Услуги, которые не покрывает поддержка OkayCMS*:</span></h2>\r\n<ul>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">перенос данных с других систем;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">разработка дополнительного функционала;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">услуги по веб-разработке. Для этого обратитесь к нашим партнерам;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">web-дизайн;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">поддержка посторонних решений;</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">работы по настройке сервера.&nbsp;</span></p>\r\n</li>\r\n</ul>\r\n<h2 class=\"western\"><span lang=\"ru-RU\">Если часы техподдержки закончились?</span></h2>\r\n<ol>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">Перейдите на сайт </span><span lang=\"en-US\">okay</span><span lang=\"ru-RU\">-</span><span lang=\"en-US\">cms</span><span lang=\"ru-RU\">.</span><span lang=\"en-US\">com</span><span lang=\"ru-RU\">/</span><span lang=\"en-US\">support</span><span lang=\"ru-RU\"> в раздел Техническая поддержка.</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">Приобретите необходимое количество часов техподдержки.</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">Ожидайте обновления техподдержки в админ-панели своего сайта.</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">После обновления отправьте свой запрос в техподдержку.</span></p>\r\n</li>\r\n</ol>'),
(3,	3,	'Как установить OkayCMS 2.0 на сайт',	'Как установить OkayCMS 2.0 на сайт',	'Как установить OkayCMS 2.0 на сайт',	'Шаг 1.    Файлы    для установки OkayCMS  \r\n    \r\n \r\n \r\n  Зайдите на официальный сайт OkayCMS.   \r\n \r\n \r\n  Кликните по кнопке          Скачать CMS в шапке сайта. \r\n \r\n \r\n  Сохраните файл к себе на компьютер. Сохраненный файл-архив имеет вид OkayCMS_1.0.1.zip (цифры в названии файла после слова OkayCMS могут отличаться, это зависит от скачиваемой вами версии).  \r\n \r\n \r\n  Разархивируйте файл OkayCMS_1.0.1.zip. (Кликните правой кнопкой мыши на файле и выберите пункт Извлечь в OkayCMS_1.0.1.)           \r\n \r\n \r\n',	'<p>Шаг 1. Файлы для установки OkayCMS\n    Зайдите на официальный сайт OkayCMS.\n    Кликните по кнопке Скачать CMS в шапке сайта.\n    Сохраните файл к себе на компьютер. Сохраненный файл-архив имеет вид OkayCMS_1.0.1.zip (цифры в названии файла после слова OkayCMS могут отличаться, это зависит от скачиваемой вами версии).</p>',	'<h2 class=\"western\"><strong>Шаг 1. </strong><strong><span lang=\"ru-RU\">Файлы</span></strong><strong> для установки OkayCMS</strong></h2>\r\n<p lang=\"ru-RU\" style=\"margin-bottom: 0.35cm; line-height: 115%;\"><br /><br /></p>\r\n<ol>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">Зайдите на официальный сайт OkayCMS. </span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">Кликните по кнопке</span><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">&nbsp;</span></span></span></span>Скачать CMS в шапке сайта.</p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">Сохраните файл к себе на компьютер. Сохраненный файл-архив имеет вид OkayCMS_1.0.1.zip (цифры в названии файла после слова OkayCMS могут отличаться, это зависит от скачиваемой вами версии).</span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">Разархивируйте файл OkayCMS_1.0.1.zip. (Кликните правой кнопкой мыши на файле и выберите пункт Извлечь в OkayCMS_1.0.1.)</span><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">&nbsp;</span></span></span></span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">После распаковки архива появится папка OkayCMS_1.0.1, внутри которой будут 2 файла:&nbsp;install.php&nbsp;и&nbsp;okaycms.zip. Эти файлы необходимо загрузить на сервер вашего хостинг-провайдера в корень вашего сайта.</span></p>\r\n</li>\r\n</ol>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">ВНИМАНИЕ! В корень сайта необходимо поместить 2 файла, которые были извлечены из архива OkayCMS_1.0.1.zip, а не сам архив.</span></p>\r\n<h2 class=\"western\"><strong>Шаг 2. Создание базы данных</strong></h2>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"color: #767679;\">&nbsp;</span></p>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"font-family: Times New Roman,serif;\"><span style=\"font-size: medium;\"><span lang=\"ru-RU\">ВНИМАНИЕ! Далее вы будете работать с панелью управления хостинга. Существует большое количество хостинг-провайдеров. Однако</span><span lang=\"ru-RU\">&nbsp;</span><span lang=\"ru-RU\">принцип проводимых действий везде одинаковый.</span></span></span></p>\r\n<p lang=\"ru-RU\" style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><br /><br /></p>\r\n<ol>\r\n<li>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"font-family: Times New Roman,serif;\"><span style=\"font-size: medium;\"><span lang=\"ru-RU\">Зайдите в панель управления вашего хостинга и выберите пункт</span><span lang=\"ru-RU\">&nbsp;</span><span lang=\"ru-RU\">Базы данных.</span></span></span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"font-family: Times New Roman,serif;\"><span style=\"font-size: medium;\"><span lang=\"ru-RU\">Найдите и кликните</span><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">&nbsp;</span></span></span></span><strong><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">Создать базу данных</span></span></span></span></strong><span lang=\"ru-RU\">. В появившемся окне введите</span><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">&nbsp;</span></span></span></span><strong><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">имя базы данных, используя английскую раскладку</span></span></span></span></strong><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">&nbsp;</span></span></span></span><span lang=\"ru-RU\">клавиатуры. Запишите его, оно вам пригодится далее.</span></span></span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"font-family: Times New Roman,serif;\"><span style=\"font-size: medium;\"><span lang=\"ru-RU\">Выберите кодировку</span><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">&nbsp;</span></span></span></span><strong><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">utf8_general_ci</span></span></span></span></strong><span lang=\"ru-RU\">. (Иногда вместо слова Кодировка может быть слово Сравнение)</span></span></span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"font-family: Times New Roman,serif;\"><span style=\"font-size: medium;\"><span lang=\"ru-RU\">Введите имя пользователя, если оно не сгенерировалось автоматически. Так же запишите это имя, оно будет использоваться далее. </span></span></span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"font-family: Times New Roman,serif;\"><span style=\"font-size: medium;\"><span lang=\"ru-RU\">Кликните кнопку</span><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">&nbsp;</span></span></span></span><strong><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">Создать.</span></span></span></span></strong></span></span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"font-family: Times New Roman,serif;\"><span style=\"font-size: medium;\"><span lang=\"ru-RU\">Появится сообщение: база данных успешно создана.</span></span></span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"font-family: Times New Roman,serif;\"><span style=\"font-size: medium;\"><span lang=\"ru-RU\">Для доступа используйте логин ****** и пароль *******</span></span></span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"font-family: Times New Roman,serif;\"><span style=\"font-size: medium;\"><span lang=\"ru-RU\">Запишите пароль к базе данных.</span></span></span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"font-family: Times New Roman,serif;\"><span style=\"font-size: medium;\"><span lang=\"ru-RU\">Возможно, на некоторых хостингах пароль вам придется придумать самостоятельно.</span></span></span></p>\r\n</li>\r\n</ol>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\">&nbsp;</p>\r\n<h2 class=\"western\"><strong>Шаг 3. Загрузка дистрибутива на хостинг</strong></h2>\r\n<p lang=\"ru-RU\" style=\"margin-bottom: 0.35cm; line-height: 115%;\"><br /><br /></p>\r\n<ol>\r\n<li>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"font-family: Times New Roman,serif;\"><span style=\"font-size: medium;\"><span lang=\"ru-RU\">Для загрузки файлов на хостинг понадобится FTP-менеджер, например</span><span lang=\"ru-RU\">&nbsp;</span><span lang=\"ru-RU\">FileZilla,</span><span lang=\"ru-RU\">&nbsp;</span><span lang=\"ru-RU\">Total Commander. </span></span></span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"font-family: Times New Roman,serif;\"><span style=\"font-size: medium;\"><span lang=\"ru-RU\">Запустите FTP-менеджер FileZilla. Для соединения с сервером введите данные, предоставленные вашим хостинг-провайдером и нажмите кнопку Соединение</span></span></span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"font-family: Times New Roman,serif;\"><span style=\"font-size: medium;\"><span lang=\"ru-RU\">В одной из двух частей окна вашего файл-менеджера найдите папку OkayCMS, которую вы создали в Шаге1, зайдите в нее и закачайте файлы</span><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">&nbsp;</span></span></span></span><strong><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">install.php</span></span></span></span></strong><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">&nbsp;</span></span></span></span><span lang=\"ru-RU\">и</span><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">&nbsp;</span></span></span></span><strong><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">okaycms_source.zip</span></span></span></span></strong><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">&nbsp;</span></span></span></span><span lang=\"ru-RU\">на сервер в корень сайта. (Кликните правой кнопкой мыши на файле и выберите</span><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">&nbsp;</span></span></span></span><strong><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">Закачать на сервер</span></span></span></span></strong><span style=\"color: #767679;\"><span style=\"font-family: Open Sans,serif;\"><span style=\"font-size: small;\"><span lang=\"ru-RU\">&nbsp;</span></span></span></span><span lang=\"ru-RU\">или просто перетащите файлы мышкой с левой в другую часть окна).</span></span></span></p>\r\n</li>\r\n<li>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"font-family: Times New Roman,serif;\"><span style=\"font-size: medium;\"><span lang=\"ru-RU\">На этом работа с FTP-менеджером FileZilla закончена.</span></span></span></p>\r\n</li>\r\n</ol>\r\n<p style=\"margin-top: 0.49cm; margin-bottom: 0.49cm; background: #ffffff; line-height: 115%;\"><span style=\"color: #767679;\">&nbsp;</span></p>\r\n<h2 class=\"western\"><a name=\"_GoBack\"></a><strong><span lang=\"ru-RU\">Шаг 4. Завершающий этап установки</span></strong></h2>\r\n<p style=\"margin-bottom: 0.35cm; line-height: 115%;\"><span lang=\"ru-RU\">Далее читайте Инструкцию в <a href=\"https://okay-cms.com/article/kak-ustanovit-okaycms-na-sajt\">блоге OkayCMS</a>.</span></p>'),
(3,	4,	'OkayCMS 2.2.0',	'OkayCMS 2.2.0',	'OkayCMS 2.2.0',	'Почти год мы работали над улучшением OkayCMS. Куда еще лучше? спроосите вы, а вот мы нашли. Технологии все время развиваются, и мы не хотим отставать. Наша цель вести свою систему к простоте и функциональности, своевременно удовлетворять запросы пользователей. Поэтому обновление принесло в OkayCMS новые полезные штуки и унесло неиспользуемый функционал и какие-то недочеты, которые в том числе и вы нам помогали искать. Что же в итоге получилось, узнаете из текста. \r\n     \r\n  Улуч',	'<p><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt; color: #000000;\">Почти год мы работали над улучшением OkayCMS. &laquo;Куда еще лучше?&raquo; &ndash; спроосите вы, а вот мы нашли. Технологии все время развиваются, и мы не хотим отставать. Наша цель &ndash; вести свою систему к простоте и функциональности, своевременно удовлетворять запросы пользователей. Поэтому обновление принесло в OkayCMS новые полезные штуки и унесло неиспользуемый функционал и какие-то недочеты, которые в том числе и вы нам помогали искать. Что же в итоге получилось, узнаете из текста.</span></p>\r\n<p><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">&nbsp;</span></p>\r\n<h2><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt; color: #003366;\">Улучшения SEO в OkayCMS 2.2.0</span></h2>\r\n<ul>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Появились шаблоны описаний для страниц с фильтрами. Можно задавать мета-теги для страниц:</span></li>\r\n</ul>\r\n<ul style=\"list-style-type: circle;\">\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">категория+бренд</span></li>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">категория+свойство</span></li>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">категория+определенное свойство</span></li>\r\n</ul>\r\n<p style=\"text-align: center;\"><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\"><img src=\"../files/uploads/seo-filtr.png\" alt=\"новый seo-фильтр\" width=\"1918\" height=\"908\" /></span></p>\r\n<p><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt; color: #000000;\">Для каждого свойства в новой версии доступны варианты слова (падежи и синонимы), которые позже можно использовать для заполнения метаданных фильтров.</span></p>\r\n<p style=\"text-align: center;\"><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\"><img src=\"../files/uploads/varianty_slova_dlya_seo.png\" alt=\"варианты слов\" width=\"1038\" height=\"602\" /></span></p>\r\n<p><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt; color: #000000;\">В ближайшее время мы напишем подробную статью, посвященную данному функционалу.</span></p>\r\n<ul>\r\n<li><span style=\"font-family: arial, helvetica, sans-serif; font-size: 12pt;\">Чтобы перелинковка была более качественной, теперь можно делать свойство в товаре ссылкой на страницу фильтра &lt;категория +это свойство&gt;<img src